/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.rpa.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.rpa.model.GtGift;
import com.yqbsoft.laser.service.rpa.model.OcContract;
import com.yqbsoft.laser.service.rpa.model.OcContractGoodsDomain;
import com.yqbsoft.laser.service.rpa.model.OcContractReDomain;
import com.yqbsoft.laser.service.rpa.model.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.rpa.model.SpScontract;
import com.yqbsoft.laser.service.rpa.service.RpaOrderService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RpaOrderServiceImpl
extends BaseServiceImpl
implements RpaOrderService {
    protected String SYS_CODE = "hdbrpa.RpaOrderServiceImpl";

    @Override
    public void exportOrderToHDBXs() {
        this.logger.error(this.SYS_CODE + ".exportOrderToHDBXs", (Object)"\u8fdb\u5165\u5bfc\u51fa\u7ebf\u4e0a\u5546\u57ce\u8ba2\u5355\uff01\uff01\uff01");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", "2020063000000001");
        paramMap.put("contractPmode", "1");
        paramMap.put("dataStatestr", "3");
        paramMap.put("childFlag", "1");
        paramMap.put("contractType", "00,26");
        paramMap.put("goodsProFlag", "0");
        paramMap.put("packFlag", "0");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        try {
            this.exportData(map, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportOrderToHDBXx() {
        this.logger.error(this.SYS_CODE + ".exportOrderToHDBXx", (Object)"\u8fdb\u5165\u5bfc\u51fa\u7ebf\u4e0b\u5546\u57ce\u8ba2\u5355\uff01\uff01\uff01");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", "2020063000000001");
        paramMap.put("contractPmode", "2,0");
        paramMap.put("dataStatestr", "3");
        paramMap.put("childFlag", "1");
        paramMap.put("contractType", "00,26");
        paramMap.put("goodsProFlag", "0");
        paramMap.put("packFlag", "0");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        try {
            this.exportData(map, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String synchronousOrder(String orderJsonStr) {
        if (StringUtils.isBlank((String)orderJsonStr)) {
            throw new ApiException(this.SYS_CODE, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.logger.error("orderJsonStr", (Object)orderJsonStr);
        JSONArray jsonArray = JSONArray.json2array((String)orderJsonStr);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("tenantCode", "2020063000000001");
        HashMap<String, String> dataStateMap = new HashMap<String, String>();
        for (JSONObject jsonObject : jsonArray) {
            String contractBillcode = jsonObject.getString("contractBillcode");
            String contractNbillcode = jsonObject.getString("contractNbillcode");
            if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractNbillcode)) {
                throw new ApiException(this.SYS_CODE, "\u5546\u57ce\u8ba2\u5355\u53f7/\u5916\u90e8\u8ba2\u5355\u53f7\u4e3a\u7a7a\uff01");
            }
            tempMap.put("contractBillcode", contractBillcode);
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(tempMap));
            String orderStr = this.internalInvoke("oc.contract.getContractModelByCodes", paramMap);
            if (StringUtils.isBlank((String)orderStr)) {
                throw new ApiException(this.SYS_CODE, "\u5546\u57ce\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\uff01");
            }
            OcContract contract = (OcContract)JsonUtil.buildNormalBinder().getJsonToObject(orderStr, OcContract.class);
            dataStateMap.put(contract.getContractBillcode(), contract.getContractPmode());
        }
        paramMap.clear();
        paramMap.put("tenantCode", "2020063000000001");
        HashMap<String, String> map = new HashMap<String, String>();
        for (JSONObject jsonObject : jsonArray) {
            paramMap.put("contractBillcode", jsonObject.getString("contractBillcode"));
            paramMap.put("contractNbillcode", jsonObject.getString("contractNbillcode"));
            try {
                this.internalInvoke("oc.contract.updateContractContractNbillcode", paramMap);
                paramMap.remove("contractNbillcode");
                paramMap.put("map", null);
                if (!"0".equals(dataStateMap.get(jsonObject.getString("contractBillcode")))) {
                    this.internalInvoke("oc.contractEngine.sendContractNext", paramMap);
                }
                try {
                    paramMap.put("oldDataState", 1);
                    paramMap.put("dataState", 2);
                    map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
                    this.internalInvoke("oc.contract.updateContractStateByCode", map);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".updateContractStateByCode", (Object)"\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff01");
                }
            }
            catch (Exception e) {
                throw new ApiException(this.SYS_CODE, "\u66f4\u65b0\u5546\u57ce\u8ba2\u5355\u5931\u8d25\uff01");
            }
        }
        return "success";
    }

    @Override
    public void sendSavePayBack(Object dataState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractPaydateQend", new Date());
        map.put("dataState", dataState);
        map.put("dataStatestr", "1,2");
        map.put("contractPmode", "1");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String ocContractJson = this.internalInvoke("oc.contract.queryContractPage", paramMap);
        SupQueryResult queryOcContractJsonResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(ocContractJson, SupQueryResult.class);
        List queryOcContractList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson((Object)queryOcContractJsonResult.getList()), OcContract.class);
        if (null == queryOcContractList || ListUtil.isEmpty((Collection)queryOcContractList)) {
            return;
        }
        for (OcContract ocContract : queryOcContractList) {
            try {
                paramMap.clear();
                paramMap.put("contractBillcode", ocContract.getContractBillcode());
                paramMap.put("tenantCode", ocContract.getTenantCode());
                paramMap.put("map", null);
                this.internalInvoke("oc.contractEngine.sendContractBack", paramMap);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".sendSavePayBack", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportData(Map<String, Object> paramMap, Boolean flag) throws IOException {
        String json = this.internalInvoke("oc.contract.queryContractPageReDomain", paramMap);
        QueryResult contractReDomainQueryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        this.logger.error("exportData.contractReDomainQueryResult", (Object)json);
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)contractReDomainQueryResult.getList()), OcContractReDomain.class);
        if (ListUtil.isNotEmpty((Collection)list)) {
            String tempPath;
            File file;
            List<String> dataList = RpaOrderServiceImpl.assContractMap(list);
            String dataStr = DateUtil.getDateString((Date)new Date(), (String)"yyyyMMddHHmmss");
            String fileName = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2020063000000001-hdb_rpa-hdb_rpa");
            File fileDir = new File(fileName);
            if (!fileDir.exists() && !fileDir.isDirectory()) {
                fileDir.mkdir();
            }
            if (!(file = new File(tempPath = fileName + "Emall-Order_" + dataStr + ".csv")).exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            OutputStreamWriter ow = null;
            try {
                ow = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
                for (String s : dataList) {
                    ow.write(s);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                this.logger.error(this.SYS_CODE + ".exportData.\u6587\u4ef6\u6570\u636e\u5bfc\u51fa\u5931\u8d25\uff01");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logger.error(this.SYS_CODE + ".exportData.\u6587\u4ef6\u6570\u636e\u5bfc\u51fa\u5931\u8d25\uff01");
            }
            finally {
                if (ow != null) {
                    ow.flush();
                    ow.close();
                }
            }
            for (OcContractReDomain ocContractReDomain : list) {
                paramMap.clear();
                ocContractReDomain.setDataStatestr("4");
                paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
                this.internalInvoke("oc.contract.updateContract", paramMap);
            }
        } else {
            this.logger.error("exportData.contractReDomainQueryResult", (Object)"\u5b9a\u65f6\u4efb\u52a1\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff01\uff01\uff01");
        }
    }

    private static List<String> assContractMap(List<OcContractReDomain> list) {
        ArrayList<String> exportDataList = new ArrayList<String>();
        exportDataList.add("\u7ebf\u4e0a\u652f\u4ed8\u4ea4\u6613\u53f7,\u6e20\u9053\u7f16\u53f7,\u8ba2\u5355\u65e5\u671f,\u5ba2\u6237\u540d\u79f0,\u4f01\u4e1a\u7f16\u53f7\uff08\u5ba2\u6237\uff09,\u8ba2\u5355\u7c7b\u578b,\u5408\u540c\u7f16\u53f7\uff08\u975e\u5fc5\u586b\uff09,\u8ba2\u5355\u7f16\u53f7,\u7269\u6599\u7f16\u7801,\u7269\u6599\u540d\u79f0,\u6570\u91cf,\u9500\u552e\u5355\u4ef7\uff08\u8ba2\u5355\u539f\u4ef7\uff09,\u5b9e\u9645\u9500\u552e\u5355\u4ef7,\u4f18\u60e0\u7c7b\u578b,\u5feb\u9012\u8d39,\u5408\u8ba1\u91d1\u989d\uff08\u8ba2\u5355\u884c\uff09,\u652f\u4ed8\u65b9\u5f0f,\u5b9e\u4ed8\u91d1\u989d,\u9500\u552e\u5458\u59d3\u540d,\u9500\u552e\u5458\u7535\u8bdd\r\n");
        for (OcContractReDomain ocContractReDomain : list) {
            StringBuffer temp = new StringBuffer();
            temp.append(StringUtils.isNotBlank((String)ocContractReDomain.getPtradeSeqno()) ? ocContractReDomain.getPtradeSeqno() : "").append(",");
            temp.append(ocContractReDomain.getChannelCode()).append(",");
            temp.append(DateUtil.getDateString((Date)ocContractReDomain.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss")).append(",");
            temp.append(ocContractReDomain.getMemberBname()).append(",");
            temp.append(ocContractReDomain.getGoodsList().get(0).getGoodsSpec4()).append(",");
            if ("1".equals(ocContractReDomain.getGoodsClass())) {
                temp.append("\u96f6\u914d\u4ef6").append(",");
            } else if ("2".equals(ocContractReDomain.getGoodsClass())) {
                temp.append("\u8017\u6750").append(",");
            } else if ("3".equals(ocContractReDomain.getGoodsClass())) {
                temp.append("\u7eaa\u5ff5\u54c1").append(",");
            } else {
                temp.append(",");
            }
            if (StringUtils.isNotBlank((String)ocContractReDomain.getContractObillcode())) {
                temp.append(ocContractReDomain.getContractObillcode()).append(",");
            } else {
                temp.append(",");
            }
            temp.append(ocContractReDomain.getContractBillcode()).append(",");
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                BigDecimal money = StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsProperty5()) ? new BigDecimal(ocContractGoodsDomain.getGoodsProperty5()) : ocContractGoodsDomain.getContractGoodsPrice();
                StringBuffer sb = new StringBuffer();
                sb.append(temp);
                sb.append(ocContractGoodsDomain.getGoodsNo()).append(",");
                sb.append(ocContractGoodsDomain.getGoodsName()).append(",");
                sb.append(ocContractGoodsDomain.getGoodsNum()).append(",");
                sb.append(ocContractGoodsDomain.getContractGoodsMoney()).append(",");
                sb.append(money).append(",");
                if (ocContractReDomain.getDdTypeCurrency() != null && "0022".equals(ocContractReDomain.getDdTypeCurrency()) || ocContractGoodsDomain.getGoodsSpec() != null && "0022".equals(ocContractGoodsDomain.getGoodsSpec())) {
                    sb.append("\u4fc3\u9500").append(",");
                } else if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsSpec5())) {
                    sb.append("\u6743\u76ca").append(",");
                } else {
                    sb.append(",");
                }
                sb.append(ocContractReDomain.getGoodsLogmoney()).append(",");
                sb.append(money.multiply(ocContractGoodsDomain.getGoodsNum())).append(",");
                if ("0".equals(ocContractReDomain.getContractPmode())) {
                    sb.append("\u7ebf\u4e0a").append(",");
                } else if ("1".equals(ocContractReDomain.getContractPmode())) {
                    sb.append("\u7ebf\u4e0b").append(",");
                } else if ("2".equals(ocContractReDomain.getContractPmode())) {
                    sb.append("\u9884\u4ed8\u6b3e").append(",");
                } else {
                    sb.append(",");
                }
                sb.append(ocContractReDomain.getContractMoney()).append(",");
                sb.append(StringUtils.isNotBlank((String)ocContractReDomain.getEmployeeName()) ? ocContractReDomain.getEmployeeName() : "").append(",");
                sb.append(StringUtils.isNotBlank((String)ocContractReDomain.getContractNbbillcode()) ? ocContractReDomain.getContractNbbillcode() : "");
                sb.append("\r\n");
                exportDataList.add(sb.toString());
            }
        }
        return exportDataList;
    }

    @Override
    public void sendCancelOrder(Object dataState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Calendar now = Calendar.getInstance();
        now.add(5, -30);
        String endDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(now.getTime());
        map.put("gmtCreateQend", endDate);
        map.put("dataState", dataState);
        map.put("contractType", "41,39");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String ocContractJson = this.internalInvoke("oc.contract.queryContractPage", paramMap);
        SupQueryResult queryOcContractJsonResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(ocContractJson, SupQueryResult.class);
        List queryOcContractList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson((Object)queryOcContractJsonResult.getList()), OcContract.class);
        if (null == queryOcContractList || ListUtil.isEmpty((Collection)queryOcContractList)) {
            return;
        }
        for (OcContract ocContract : queryOcContractList) {
            try {
                paramMap.clear();
                paramMap.put("contractBillcode", ocContract.getContractBillcode());
                paramMap.put("tenantCode", ocContract.getTenantCode());
                paramMap.put("map", null);
                this.internalInvoke("oc.contractEngine.sendContractBack", paramMap);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".sendSavePayBack", (Throwable)e);
            }
        }
    }

    @Override
    public void sendContractRemoved() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ntoDataState", -1);
        map.put("expiredTime", DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String ocContractJson = this.internalInvoke("gt.gtgift.queryGiftPage", paramMap);
        if (StringUtils.isBlank((String)ocContractJson)) {
            this.logger.info(this.SYS_CODE + ".sendContractRemoved.ocContractJson", (Object)"\u672a\u67e5\u8be2\u5230\u7ebf\u4e0a\u5408\u540c\u6570\u636e\uff01");
            return;
        }
        SupQueryResult queryOcContractJsonResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(ocContractJson, SupQueryResult.class);
        if (ListUtil.isEmpty((Collection)queryOcContractJsonResult.getList())) {
            this.logger.info(this.SYS_CODE + ".sendContractRemoved.queryOcContractJsonResult", (Object)"\u672a\u67e5\u8be2\u5230\u7ebf\u4e0a\u5408\u540c\u6570\u636e\uff01");
            return;
        }
        List queryOcContractList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson((Object)queryOcContractJsonResult.getList()), GtGift.class);
        if (null == queryOcContractList || ListUtil.isEmpty((Collection)queryOcContractList)) {
            return;
        }
        for (GtGift ocContract : queryOcContractList) {
            try {
                HashMap<String, String> map1 = new HashMap<String, String>();
                String tenantCode = ocContract.getTenantCode();
                map1.put("goodsOrigin", "5");
                map1.put("goodsNo", ocContract.getGiftCode());
                map1.put("tenantCode", tenantCode);
                paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map1));
                String rsResourceGoodsReDomainList = this.internalInvoke("rs.resourceGoods.queryResourceGoodsPage", paramMap);
                if (StringUtils.isBlank((String)rsResourceGoodsReDomainList)) {
                    this.logger.info(this.SYS_CODE + ".sendContractRemoved.rsResourceGoodsReDomainList", (Object)"\u672a\u67e5\u8be2\u5230\u5408\u540c\u5546\u54c1\u6570\u636e\uff01");
                    return;
                }
                SupQueryResult rsResourceGoodsListResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsResourceGoodsReDomainList, SupQueryResult.class);
                if (ListUtil.isEmpty((Collection)rsResourceGoodsListResult.getList())) {
                    this.logger.info(this.SYS_CODE + ".sendContractRemoved.rsResourceGoodsListResult", (Object)"\u672a\u67e5\u8be2\u5230\u5408\u540c\u5546\u54c1\u6570\u636e\uff01");
                    return;
                }
                List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsListResult.getList()), RsResourceGoodsReDomain.class);
                if (null == list || ListUtil.isEmpty((Collection)list)) {
                    return;
                }
                ArrayList<Integer> goodsIdStr = new ArrayList<Integer>();
                goodsIdStr.add(((RsResourceGoodsReDomain)list.get(0)).getGoodsId());
                paramMap.clear();
                paramMap.put("goodsIds", goodsIdStr);
                this.internalInvoke("rs.resource.sendUpdateSoldOutGoods", paramMap);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".sendSavePayBack", (Throwable)e);
            }
        }
    }

    @Override
    public void sendOfflineContractRemoved(Object dataState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractPaydateQend", DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        map.put("dataState", dataState);
        map.put("contractInvstate", 0);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String spContractJson = this.internalInvoke("sp.scontract.queryScontractPage", paramMap);
        SupQueryResult querySpContractJsonResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(spContractJson, SupQueryResult.class);
        List querySpContractList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson((Object)querySpContractJsonResult.getList()), SpScontract.class);
        if (null == querySpContractList || ListUtil.isEmpty((Collection)querySpContractList)) {
            return;
        }
        for (SpScontract spScontract : querySpContractList) {
            try {
                paramMap.clear();
                paramMap.put("scontractId", spScontract.getScontractId());
                paramMap.put("oldDataState", 0);
                paramMap.put("map", null);
                paramMap.put("dataState", 1);
                this.internalInvoke("sp.scontract.updateScontractState", paramMap);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".sendSavePayBack", (Throwable)e);
            }
        }
    }
}

