/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jd.store.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisStoreBaseService;
import com.yqbsoft.laser.service.ext.channel.jd.JdConstants;
import com.yqbsoft.laser.service.ext.channel.jd.domain.JdResult;
import com.yqbsoft.laser.service.ext.channel.jd.domain.WebRequestDTO;
import com.yqbsoft.laser.service.ext.channel.jd.utils.HttpUtil;
import com.yqbsoft.laser.service.ext.channel.jd.utils.SignUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DisStoreServiceImpl
extends DisStoreBaseService {
    private String SYS_CODE = "jddj.DisStoreServiceImpl";
    String ctype = "application/json;charset=utf-8";

    protected String getChannelCode() {
        return JdConstants.channelCode;
    }

    public Map<String, Object> buildStoreUpdateParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        UmUserinfo umUserinfo;
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        if (null == (umUserinfo = (UmUserinfo)param.get("umUserinfo"))) {
            return null;
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), memberCode));
        HashMap<String, Object> metasmap = new HashMap<String, Object>();
        metasmap.put("app_key", configMap.get("key"));
        metasmap.put("timestamp", new Date().getTime() / 1000L);
        sendParam.put("metas", metasmap);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("addressText", umUserinfo.getCompanyAddress());
        properties.put("geo", umUserinfo.getUserinfoMap());
        properties.put("description", umUserinfo.getUserinfoRemark());
        properties.put("name", umUserinfo.getUserinfoCompname());
        properties.put("phone", umUserinfo.getUserinfoPhone());
        properties.put("openId", umUserinfo.getUserinfoCode());
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("shopId", Long.valueOf((String)sendParam.remove("shopId")));
        params.put("properties", properties);
        sendParam.put("params", params);
        return sendParam;
    }

    public Map<String, Object> buildStoreStartParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }

    public Map<String, Object> buildStoreEndParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }

    private Map<String, Object> buildStoreComParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), memberCode));
        HashMap properties = new HashMap();
        sendParam.remove("sign");
        sendParam.remove("v");
        sendParam.remove("format");
        sendParam.remove("timestamp");
        sendParam.remove("app_key");
        return sendParam;
    }

    public String sendStoreStartParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    public String sendStoreEndParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    public String sendStoreUpdateParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.sendStoreComParam(disChannel, sendhttpParam, configMap, param);
    }

    private String sendStoreComParam(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        String token = (String)sendhttpParam.get("token");
        String format = configMap.get("format");
        String v = configMap.get("v");
        String timestamp = DateUtil.parseDateTime((Date)new Date());
        HashMap<String, String> mapSend = new HashMap<String, String>();
        for (String key : sendhttpParam.keySet()) {
            if ("token".equals(key)) continue;
            mapSend.put(key, (String)sendhttpParam.get(key));
        }
        String jd_param_json = JsonUtil.buildNormalBinder().toJson(mapSend);
        String urlSend = configMap.get("serviceUrl") + configMap.get("action");
        WebRequestDTO webReqeustDTO = new WebRequestDTO();
        webReqeustDTO.setApp_key(appKey);
        webReqeustDTO.setFormat(format);
        webReqeustDTO.setJd_param_json(jd_param_json);
        webReqeustDTO.setTimestamp(timestamp);
        webReqeustDTO.setToken(token);
        webReqeustDTO.setV(v);
        String sign = null;
        try {
            sign = SignUtils.getSignByMD5(webReqeustDTO, appSecret);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, Object> paramSend = new HashMap<String, Object>();
        paramSend.put("token", token);
        paramSend.put("app_key", appKey);
        paramSend.put("timestamp", timestamp);
        paramSend.put("sign", sign);
        paramSend.put("format", format);
        paramSend.put("v", v);
        paramSend.put("jd_param_json", jd_param_json);
        try {
            json = HttpUtil.sendSimplePostRequest(urlSend, paramSend);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.e", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        JdResult jdResult = this.make(json);
        if (null == jdResult) {
            return json;
        }
        if (!"0".equals(jdResult.getCode())) {
            return jdResult.getMsg();
        }
        return "SUCCESS";
    }

    public UmUserinfo sendGetStore(DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return null;
        }
        String url = configMap.get(JdConstants.serviceUrl);
        if (StringUtils.isBlank((String)url)) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.url", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        String token = (String)sendhttpParam.get("token");
        String format = configMap.get("format");
        String v = configMap.get("v");
        String timestamp = DateUtil.parseDateTime((Date)new Date());
        HashMap<String, String> mapSend = new HashMap<String, String>();
        for (String key : sendhttpParam.keySet()) {
            if ("token".equals(key)) continue;
            mapSend.put(key, (String)sendhttpParam.get(key));
        }
        String jd_param_json = JsonUtil.buildNormalBinder().toJson(mapSend);
        String urlSend = configMap.get("serviceUrl") + configMap.get("action");
        WebRequestDTO webReqeustDTO = new WebRequestDTO();
        webReqeustDTO.setApp_key(appKey);
        webReqeustDTO.setFormat(format);
        webReqeustDTO.setJd_param_json(jd_param_json);
        webReqeustDTO.setTimestamp(timestamp);
        webReqeustDTO.setToken(token);
        webReqeustDTO.setV(v);
        String sign = null;
        try {
            sign = SignUtils.getSignByMD5(webReqeustDTO, appSecret);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, Object> paramSend = new HashMap<String, Object>();
        paramSend.put("token", token);
        paramSend.put("app_key", appKey);
        paramSend.put("timestamp", timestamp);
        paramSend.put("sign", sign);
        paramSend.put("format", format);
        paramSend.put("v", v);
        paramSend.put("jd_param_json", jd_param_json);
        try {
            json = HttpUtil.sendSimplePostRequest(urlSend, paramSend);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.e", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendGetStore.json", (Object)(url + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return null;
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (!"0".equals(jsonToMap.get("code")) || 0 == jsonToMap.size()) {
            this.logger.error(this.SYS_CODE, (Object)".sendGetStore is error!");
            return null;
        }
        String data = (String)jsonToMap.get("data");
        Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
        Map resultaMap = (Map)dataMap.get("result");
        UmUserinfo umUserinfo = new UmUserinfo();
        umUserinfo.setCompanyAddress((String)resultaMap.get("coordinateAddress"));
        umUserinfo.setCompanyAddress((String)resultaMap.get("coordinateAddress"));
        umUserinfo.setUserinfoMap((String)resultaMap.get("coordinate"));
        umUserinfo.setUserinfoCompname((String)resultaMap.get("stationName"));
        umUserinfo.setUserinfoPhone((String)resultaMap.get("phone"));
        umUserinfo.setDataState(Integer.valueOf(-1));
        if ("0".equals(resultaMap.get("yn"))) {
            umUserinfo.setDataState(Integer.valueOf(0));
        }
        return umUserinfo;
    }

    private JdResult make(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".make.json");
            return null;
        }
        JdResult jdResult = (JdResult)JsonUtil.buildNormalBinder().getJsonToObject(json, JdResult.class);
        if (null == jdResult) {
            return null;
        }
        return jdResult;
    }

    public Map<String, Object> buildGetStoreParam(DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return this.buildStoreComParam(disChannel, sendParam, configMap, param);
    }
}

