/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jd.goods.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisGoodsBaseService;
import com.yqbsoft.laser.service.ext.channel.jd.JdConstants;
import com.yqbsoft.laser.service.ext.channel.jd.domain.JdResult;
import com.yqbsoft.laser.service.ext.channel.jd.domain.JdResultObject;
import com.yqbsoft.laser.service.ext.channel.jd.domain.OItemCreateProperty;
import com.yqbsoft.laser.service.ext.channel.jd.domain.OMaterial;
import com.yqbsoft.laser.service.ext.channel.jd.domain.OSpec;
import com.yqbsoft.laser.service.ext.channel.jd.domain.WebRequestDTO;
import com.yqbsoft.laser.service.ext.channel.jd.utils.HttpUtil;
import com.yqbsoft.laser.service.ext.channel.jd.utils.SignUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DisGoodsServiceImpl
extends DisGoodsBaseService {
    private String SYS_CODE = "jddj.DisGoodsServiceImpl";

    protected String getChannelCode() {
        return JdConstants.channelCode;
    }

    public Map<String, Object> buildComGoodsClassParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        List apiparamList;
        String classDictionaryBvalue;
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        RsGoodsClassDomain rs = (RsGoodsClassDomain)param.get("rsGoodsClassDomain");
        if (null != rs && ("-1".equals(rs.getGoodsClassParentcode()) || null == rs.getGoodsClassParentcode())) {
            sendParam.put("pid", "0");
        }
        if (null != (classDictionaryBvalue = this.getClassDictionaryBvalue("RsGoodsClass", (String)param.get("channelCode"), "goodsClassCode", (String)sendParam.get("pid"), (String)param.get("tenantCode")))) {
            sendParam.put("pid", classDictionaryBvalue);
        }
        if (ListUtil.isEmpty((Collection)(apiparamList = (List)param.get("apiparamList")))) {
            return sendParam;
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()));
        HashMap properties = new HashMap();
        sendParam.remove("sign");
        sendParam.remove("v");
        sendParam.remove("format");
        sendParam.remove("timestamp");
        sendParam.remove("app_key");
        return sendParam;
    }

    public String sendComSaveGoodsClass(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        String token = (String)sendhttpParam.get("token");
        String format = configMap.get("format");
        String v = configMap.get("v");
        String timestamp = DateUtil.parseDateTime((Date)new Date());
        HashMap<String, String> mapSend = new HashMap<String, String>();
        for (String key : sendhttpParam.keySet()) {
            if ("token".equals(key)) continue;
            mapSend.put(key, (String)sendhttpParam.get(key));
        }
        String jd_param_json = JsonUtil.buildNormalBinder().toJson(mapSend);
        String urlSend = configMap.get("serviceUrl") + configMap.get("action");
        WebRequestDTO webReqeustDTO = new WebRequestDTO();
        webReqeustDTO.setApp_key(appKey);
        webReqeustDTO.setFormat(format);
        webReqeustDTO.setJd_param_json(jd_param_json);
        webReqeustDTO.setTimestamp(timestamp);
        webReqeustDTO.setToken(token);
        webReqeustDTO.setV(v);
        String sign = null;
        try {
            sign = SignUtils.getSignByMD5(webReqeustDTO, appSecret);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, Object> paramSend = new HashMap<String, Object>();
        paramSend.put("token", token);
        paramSend.put("app_key", appKey);
        paramSend.put("timestamp", timestamp);
        paramSend.put("sign", sign);
        paramSend.put("format", format);
        paramSend.put("v", v);
        paramSend.put("jd_param_json", jd_param_json);
        try {
            json = HttpUtil.sendSimplePostRequest(urlSend, paramSend);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (!"0".equals(jsonToMap.get("code")) || 0 == jsonToMap.size()) {
            return (String)jsonToMap.get("msg");
        }
        String data = (String)jsonToMap.get("data");
        Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
        Map resultaMap = (Map)dataMap.get("result");
        if (null == resultaMap) {
            return (String)dataMap.get("msg");
        }
        if ("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode)) {
            String id = (String)resultaMap.get("id");
            this.saveClassDictionary(disChannel, (String)param.get("memberCode"), ((RsGoodsClassDomain)param.get("rsGoodsClassDomain")).getGoodsClassCode(), id, (String)param.get("tenantCode"));
        }
        return json;
    }

    private JdResultObject makeObject(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".makeObject.json");
            return null;
        }
        JdResultObject jdResult = (JdResultObject)JsonUtil.buildNormalBinder().getJsonToObject(json, JdResultObject.class);
        if (null == jdResult) {
            return null;
        }
        return jdResult;
    }

    private JdResult make(String json) {
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".make.json");
            return null;
        }
        JdResult jdResult = (JdResult)JsonUtil.buildNormalBinder().getJsonToObject(json, JdResult.class);
        if (null == jdResult) {
            return null;
        }
        return jdResult;
    }

    private void makeSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, Map<OItemCreateProperty, Object> properties) {
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty((Collection)rsResourceGoodsReDomain.getRsSkuDomainList()) || MapUtil.isEmpty(properties)) {
            return;
        }
        ArrayList<OSpec> oSpecs = new ArrayList<OSpec>();
        for (RsSkuDomain rsSkuDomain : rsResourceGoodsReDomain.getRsSkuDomainList()) {
            OSpec oSpec = new OSpec();
            oSpec.setSpecId(Long.valueOf(rsSkuDomain.getSkuCode()));
            oSpec.setName(rsSkuDomain.getSkuName());
            oSpec.setPrice(rsSkuDomain.getPricesetNprice());
            oSpec.setStock(null == rsSkuDomain.getGoodsSupplynum() ? 0 : rsSkuDomain.getGoodsSupplynum().intValue());
            oSpec.setMaxStock(999);
            oSpec.setStockStatus(0);
            oSpec.setOnShelf(1);
            oSpec.setExtendCode(rsSkuDomain.getSkuNo());
            oSpec.setBarCode(rsSkuDomain.getSkuBarcode());
            oSpec.setWeight(rsSkuDomain.getGoodsSupplyweight().intValue());
            oSpec.setActivityLevel(0);
            oSpec.setPid(null == rsSkuDomain.getSkuOldcode() ? null : Long.valueOf(rsSkuDomain.getSkuOldcode()));
            oSpecs.add(oSpec);
        }
        properties.put(OItemCreateProperty.specs, oSpecs);
    }

    private List<String> createImageList(DisChannel disChannel, List<RsGoodsFileDomain> rsGoodsFileDomainList) {
        if (ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return null;
        }
        ArrayList<String> imageList = new ArrayList<String>();
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            imageList.add(this.getFileOcode(disChannel, rsGoodsFileDomain.getGoodsFileName(), this.getChannelCode(), rsGoodsFileDomain.getTenantCode()));
        }
        return imageList;
    }

    private Map<OItemCreateProperty, Object> createGoods(DisChannel disChannel, RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == disChannel || null == rsResourceGoodsReDomain) {
            return null;
        }
        HashMap<OItemCreateProperty, Object> properties = new HashMap<OItemCreateProperty, Object>();
        properties.put(OItemCreateProperty.name, rsResourceGoodsReDomain.getGoodsName());
        properties.put(OItemCreateProperty.description, rsResourceGoodsReDomain.getGoodsProperty());
        properties.put(OItemCreateProperty.imageHash, this.getFileOcode(disChannel, rsResourceGoodsReDomain.getDataPicpath(), this.getChannelCode(), rsResourceGoodsReDomain.getTenantCode()));
        this.makeSku(rsResourceGoodsReDomain, properties);
        properties.put(OItemCreateProperty.minPurchaseQuantity, null == rsResourceGoodsReDomain.getGoodsMinnum() ? 1 : rsResourceGoodsReDomain.getGoodsMinnum().intValue());
        properties.put(OItemCreateProperty.unit, rsResourceGoodsReDomain.getPartsnameNumunit());
        properties.put(OItemCreateProperty.setMeal, 1);
        List<String> imageList = this.createImageList(disChannel, rsResourceGoodsReDomain.getRsGoodsFileDomainList());
        properties.put(OItemCreateProperty.imageHashs, imageList);
        List<OMaterial> oMaterials = this.createOmaterial(rsResourceGoodsReDomain);
        properties.put(OItemCreateProperty.materials, oMaterials);
        return properties;
    }

    private List<OMaterial> createOmaterial(RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        ArrayList<OMaterial> oMaterialList = new ArrayList<OMaterial>();
        if (ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsGoodsRelDomainList())) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                OMaterial oMaterial = new OMaterial();
                String code = (String)(StringUtils.isBlank((String)rsGoodsRelDomain.getGoodsRelGcode()) ? Integer.valueOf(1) : rsGoodsRelDomain.getGoodsRelGcode());
                oMaterial.setId(Long.valueOf(code));
                oMaterial.setName(rsGoodsRelDomain.getSkuName());
                oMaterialList.add(oMaterial);
            }
        } else {
            for (RsSkuDomain rsSkuDomain : rsResourceGoodsReDomain.getRsSkuDomainList()) {
                OMaterial oMaterial = new OMaterial();
                oMaterial.setId(Long.valueOf(rsSkuDomain.getSkuCode()));
                oMaterial.setName(rsSkuDomain.getSkuName());
                oMaterialList.add(oMaterial);
            }
        }
        return oMaterialList;
    }

    public Map<String, Object> buildComGoodsParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        Object goodsSupplynum1;
        String skuEocode;
        Object pricesetNprice;
        RsResourceGoodsReDomain rsResource;
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        if (null != (rsResource = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain"))) {
            BigDecimal pricesetNprice2;
            List rsList = rsResource.getRsSkuDomainList();
            RsSkuDomain rs = (RsSkuDomain)rsList.get(0);
            if (null != rs.getSkuCode()) {
                sendParam.put("outSkuId", rs.getSkuCode());
            }
            if (null != rs.getGoodsWeight()) {
                sendParam.put("weight", rs.getGoodsWeight());
            }
            if (null != rs.getSkuName()) {
                sendParam.put("skuName", rs.getSkuName());
            }
            if (null != rs.getSkuBarcode()) {
                sendParam.put("brandId", 35247);
            }
            if (null != (pricesetNprice2 = rs.getPricesetNprice())) {
                sendParam.put("skuPrice", pricesetNprice2.multiply(new BigDecimal(100)));
            }
            sendParam.put("categoryId", "20311");
        }
        if (null != (pricesetNprice = param.get("pricesetNprice"))) {
            String pri = pricesetNprice.toString();
            sendParam.put("price", Long.parseLong(pri));
        }
        if (null != (skuEocode = (String)param.get("skuEocode"))) {
            sendParam.put("outSkuId", Long.parseLong(skuEocode));
        }
        if ("cmc.disGoods.updateSendSkuPrice".equals(channelApiCode)) {
            UUID uuid = UUID.randomUUID();
            sendParam.put("serviceNo", uuid);
        }
        String goodsEocode = (String)param.get("goodsEocode");
        if ("cmc.disGoods.updateSendSkuNum".equals(channelApiCode)) {
            sendParam.put("skuId", Long.parseLong(goodsEocode));
        }
        if (null != (goodsSupplynum1 = param.get("goodsSupplynum"))) {
            String goodsSupplynum = param.get("goodsSupplynum").toString();
            sendParam.put("currentQty", Integer.parseInt(goodsSupplynum));
        }
        HashMap properties = new HashMap();
        if ("cmc.disGoods.saveSendGoods".equals(channelApiCode)) {
            sendParam.put("traceld", UUID.randomUUID().toString());
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()));
        sendParam.remove("sign");
        sendParam.remove("v");
        sendParam.remove("format");
        sendParam.remove("timestamp");
        sendParam.remove("app_key");
        return sendParam;
    }

    public String sendComSaveGoods(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        String token = (String)sendhttpParam.get("token");
        String format = configMap.get("format");
        String v = configMap.get("v");
        String timestamp = DateUtil.parseDateTime((Date)new Date());
        HashMap<String, String> mapSend = new HashMap<String, String>();
        for (String key : sendhttpParam.keySet()) {
            if ("token".equals(key)) continue;
            Object o = sendhttpParam.get(key);
            if (o instanceof List) {
                String skuStockList = JsonUtil.buildNormalBinder().toJson(sendhttpParam.get("skuStockList"));
                mapSend.put(key, skuStockList);
                continue;
            }
            if (o == null) continue;
            String a = o.toString();
            mapSend.put(key, a);
        }
        String jd_param_json = JsonUtil.buildNormalBinder().toJson(mapSend);
        String urlSend = configMap.get("serviceUrl") + configMap.get("action");
        WebRequestDTO webReqeustDTO = new WebRequestDTO();
        webReqeustDTO.setApp_key(appKey);
        webReqeustDTO.setFormat(format);
        webReqeustDTO.setJd_param_json(jd_param_json);
        webReqeustDTO.setTimestamp(timestamp);
        webReqeustDTO.setToken(token);
        webReqeustDTO.setV(v);
        String sign = null;
        try {
            sign = SignUtils.getSignByMD5(webReqeustDTO, appSecret);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, Object> paramSend = new HashMap<String, Object>();
        paramSend.put("token", token);
        paramSend.put("app_key", appKey);
        paramSend.put("timestamp", timestamp);
        paramSend.put("sign", sign);
        paramSend.put("format", format);
        paramSend.put("v", v);
        paramSend.put("jd_param_json", jd_param_json);
        try {
            json = HttpUtil.sendSimplePostRequest(urlSend, paramSend);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map jdOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jdOrderMap)) {
            return null;
        }
        if (!"0".equals(jdOrderMap.get("code"))) {
            throw new ApiException(this.SYS_CODE + ".sendComOrder.jdResultListOrder", (String)jdOrderMap.get("msg"));
        }
        if (null == jdOrderMap.get("data")) {
            return (String)jdOrderMap.get("msg");
        }
        return (String)jdOrderMap.get("data");
    }
}

