/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jd.goods.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisGoodsBaseService;
import com.yqbsoft.laser.service.ext.channel.jd.JdConstants;
import com.yqbsoft.laser.service.ext.channel.jd.domain.QueryStockRequest;
import com.yqbsoft.laser.service.ext.channel.jd.domain.WebRequestDTO;
import com.yqbsoft.laser.service.ext.channel.jd.utils.HttpUtil;
import com.yqbsoft.laser.service.ext.channel.jd.utils.SignUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DisGoodsServiceImpl
extends DisGoodsBaseService {
    private String SYS_CODE = "jddj.DisGoodsServiceImpl";

    protected String getChannelCode() {
        return JdConstants.channelCode;
    }

    public Map<String, Object> buildComGoodsClassParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        List apiparamList;
        String classDictionaryBvalue;
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            return null;
        }
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        String memberCode = (String)param.get("memberCode");
        RsGoodsClassDomain rs = (RsGoodsClassDomain)param.get("rsGoodsClassDomain");
        if (null != rs && ("-1".equals(rs.getGoodsClassParentcode()) || null == rs.getGoodsClassParentcode())) {
            sendParam.put("pid", "0");
        }
        if (null != (classDictionaryBvalue = this.getClassDictionaryBvalue("RsGoodsClass", (String)param.get("channelCode"), "goodsClassCode", (String)sendParam.get("pid"), (String)param.get("tenantCode")))) {
            sendParam.put("pid", classDictionaryBvalue);
        }
        if (ListUtil.isEmpty((Collection)(apiparamList = (List)param.get("apiparamList")))) {
            return sendParam;
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()));
        sendParam.remove("sign");
        sendParam.remove("v");
        sendParam.remove("format");
        sendParam.remove("timestamp");
        sendParam.remove("app_key");
        return sendParam;
    }

    public String sendComSaveGoodsClass(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        String token = (String)sendhttpParam.get("token");
        String format = configMap.get("format");
        String v = configMap.get("v");
        String timestamp = DateUtil.parseDateTime((Date)new Date());
        HashMap<String, String> mapSend = new HashMap<String, String>();
        for (String key : sendhttpParam.keySet()) {
            Object o;
            if ("token".equals(key) || (o = sendhttpParam.get(key)) == null) continue;
            String a = o.toString();
            mapSend.put(key, a);
        }
        String jd_param_json = JsonUtil.buildNormalBinder().toJson(mapSend);
        String urlSend = configMap.get("serviceUrl") + configMap.get("action");
        WebRequestDTO webReqeustDTO = new WebRequestDTO();
        webReqeustDTO.setApp_key(appKey);
        webReqeustDTO.setFormat(format);
        webReqeustDTO.setJd_param_json(jd_param_json);
        webReqeustDTO.setTimestamp(timestamp);
        webReqeustDTO.setToken(token);
        webReqeustDTO.setV(v);
        String sign = null;
        try {
            sign = SignUtils.getSignByMD5(webReqeustDTO, appSecret);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, Object> paramSend = new HashMap<String, Object>();
        paramSend.put("token", token);
        paramSend.put("app_key", appKey);
        paramSend.put("timestamp", timestamp);
        paramSend.put("sign", sign);
        paramSend.put("format", format);
        paramSend.put("v", v);
        paramSend.put("jd_param_json", jd_param_json);
        try {
            json = HttpUtil.sendSimplePostRequest(urlSend, paramSend);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (!"0".equals(jsonToMap.get("code")) || 0 == jsonToMap.size()) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.jsonMap's Code not 0" + sendhttpParam.toString() + "==" + configMap.toString() + "===" + urlSend + "=====" + json);
            return "ERROR";
        }
        if ("cmc.disGoods.saveSendGoodsClass".equals(channelApiCode)) {
            String data = (String)jsonToMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            Map resultaMap = (Map)dataMap.get("result");
            if (null == resultaMap) {
                this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.resultaMap is null" + sendhttpParam.toString() + "==" + configMap.toString() + "===" + urlSend + "=====" + json);
                return "ERROR";
            }
            String id = (String)resultaMap.get("id");
            this.saveClassDictionary(disChannel, (String)param.get("memberCode"), ((RsGoodsClassDomain)param.get("rsGoodsClassDomain")).getGoodsClassCode(), id, (String)param.get("tenantCode"));
        }
        return "SUCCESS";
    }

    public Map<String, Object> buildComGoodsParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        Object goodsSupplynum1;
        String skuEocode;
        Object pricesetNprice;
        RsResourceGoodsReDomain rsResource;
        if ("cmc.disGoods.updateSendGoodsCentDow".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsCentUp".equals(channelApiCode)) {
            this.logger.error(this.SYS_CODE + ".CentDownOrUp", (Object)("=========================" + configMap.toString() + "====" + sendParam.toString() + "====" + param.toString()));
        }
        String uuid = UUID.randomUUID().toString();
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        if (null != (rsResource = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain"))) {
            if (null == rsResource.getDataOpbillstate() || 0 == rsResource.getDataOpbillstate()) {
                sendParam.put("fixedStatus", 2);
            } else {
                sendParam.put("fixedStatus", 1);
            }
        }
        if (null != rsResource) {
            List skuDomains = rsResource.getRsSkuDomainList();
            if (null != rsResource && ListUtil.isNotEmpty((Collection)skuDomains)) {
                sendParam.put("skuList", skuDomains);
                sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()));
                sendParam.remove("sign");
                sendParam.remove("v");
                sendParam.remove("format");
                sendParam.remove("timestamp");
                sendParam.remove("app_key");
                this.logger.error(this.SYS_CODE, (Object)("buildComGoodsParam===" + sendParam.toString() + "=======" + configMap.toString() + "=====" + channelApiCode));
                return sendParam;
            }
        }
        if (null != rsResource) {
            BigDecimal pricesetNprice2;
            List rsList = rsResource.getRsSkuDomainList();
            RsSkuDomain rs = (RsSkuDomain)rsList.get(0);
            if (null != rs.getGoodsCode()) {
                sendParam.put("outSkuId", rs.getGoodsCode());
            }
            if (null != rs.getGoodsOneweight()) {
                BigDecimal goodsOneweight = rs.getGoodsOneweight();
                if (new BigDecimal(0.0) == goodsOneweight) {
                    goodsOneweight = new BigDecimal(1.0);
                }
                float v = goodsOneweight.floatValue();
                DecimalFormat df = new DecimalFormat("#.##");
                String format = df.format(v);
                sendParam.put("weight", format);
            }
            if (0 == rsResource.getDataOpbillstate() || null == rsResource.getDataOpbillstate()) {
                sendParam.put("fixedStatus", 2);
            } else {
                sendParam.put("fixedStatus", 1);
            }
            if (null != rs.getSkuName()) {
                sendParam.put("skuName", rs.getGoodsName());
            }
            if ("cmc.disGoods.saveSendGoods".equals(channelApiCode)) {
                sendParam.put("brandId", "35247");
                sendParam.put("traceId", UUID.randomUUID().toString());
            }
            if (null != (pricesetNprice2 = rs.getPricesetNprice())) {
                BigDecimal rsl = pricesetNprice2.multiply(new BigDecimal(100));
                long aLong = rsl.longValue();
                sendParam.put("skuPrice", aLong);
            }
            sendParam.put("categoryId", "20311");
        }
        if (null != (pricesetNprice = param.get("pricesetNprice"))) {
            String pri = pricesetNprice.toString();
            BigDecimal price = new BigDecimal(pri);
            BigDecimal rsl = price.multiply(new BigDecimal(100));
            long aLong = rsl.longValue();
            sendParam.put("price", aLong);
        }
        if (null != (skuEocode = (String)param.get("skuEocode"))) {
            sendParam.put("outSkuId", Long.parseLong(skuEocode));
        }
        if ("cmc.disGoods.updateSendSkuPrice".equals(channelApiCode)) {
            sendParam.put("serviceNo", uuid);
            sendParam.put("stationNo", "11828768");
        }
        String goodsEocode = (String)param.get("goodsEocode");
        if ("cmc.disGoods.updateSendSkuNum".equals(channelApiCode)) {
            sendParam.put("skuId", Long.parseLong(goodsEocode));
        }
        if (null != (goodsSupplynum1 = param.get("goodsSupplynum"))) {
            String goodsSupplynum = param.get("goodsSupplynum").toString();
            sendParam.put("currentQty", Integer.parseInt(goodsSupplynum));
        }
        if ("cmc.disGoods.delSendGoods".equals(channelApiCode)) {
            sendParam.put("outSkuId", (String)param.get("goodsEocode"));
            sendParam.put("traceId", uuid);
        }
        if ("cmc.disGoods.updateSendGoods".equals(channelApiCode)) {
            sendParam.put("traceId", UUID.randomUUID().toString());
        }
        if ("cmc.disGoods.updateSendGoodsUp".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsDow".equals(channelApiCode)) {
            ArrayList<QueryStockRequest> stockList = new ArrayList<QueryStockRequest>();
            QueryStockRequest queryStockRequest = new QueryStockRequest();
            queryStockRequest.setDoSale(Integer.parseInt((String)sendParam.get("doSale")));
            queryStockRequest.setSkuId(Long.valueOf((String)sendParam.get("skuId")));
            queryStockRequest.setStationNo((String)sendParam.get("stationNo"));
            sendParam.remove("doSale");
            sendParam.remove("skuId");
            stockList.add(queryStockRequest);
            sendParam.put("listBaseStockCenterRequest", stockList);
        }
        if ("cmc.disGoods.updateSendGoodsCentDow".equals(channelApiCode) || "cmc.disGoods.updateSendGoodsCentUp".equals(channelApiCode)) {
            sendParam.put("traceId", uuid);
            List skuListCode = (List)param.get("skuCodeList");
            if (ListUtil.isNotEmpty((Collection)skuListCode)) {
                String sku = (String)skuListCode.get(0);
                sendParam.put("outSkuId", sku);
            }
            this.logger.error(this.SYS_CODE + ".buildComGoodsParam.CentDowOrUp param=====", (Object)(configMap.toString() + "====" + sendParam.toString() + "===" + param.toString()));
            if ("cmc.disGoods.updateSendGoodsCentDow".equals(channelApiCode)) {
                sendParam.put("fixedStatus", 2);
            } else {
                sendParam.put("fixedStatus", 1);
            }
            sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()));
            sendParam.remove("sign");
            sendParam.remove("v");
            sendParam.remove("format");
            sendParam.remove("timestamp");
            sendParam.remove("app_key");
            this.logger.error(this.SYS_CODE, (Object)("buildComGoodsParam===" + sendParam.toString() + "=======" + configMap.toString() + "=====" + channelApiCode));
            return sendParam;
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()));
        sendParam.remove("sign");
        sendParam.remove("v");
        sendParam.remove("format");
        sendParam.remove("timestamp");
        sendParam.remove("app_key");
        this.logger.error(this.SYS_CODE, (Object)("buildComGoodsParam===" + sendParam.toString() + "=======" + configMap.toString() + "=====" + channelApiCode));
        return sendParam;
    }

    public String sendComSaveGoods(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            this.logger.error(this.SYS_CODE, (Object)"sendComSaveGoods param is null!");
            return "ERROR";
        }
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        String token = (String)sendhttpParam.get("token");
        String format = configMap.get("format");
        String v = configMap.get("v");
        String timestamp = DateUtil.parseDateTime((Date)new Date());
        HashMap<String, String> mapSend = new HashMap<String, String>();
        if (null != sendhttpParam.get("skuList")) {
            List skuList = (List)sendhttpParam.get("skuList");
            if (ListUtil.isEmpty((Collection)skuList)) {
                return null;
            }
            for (RsSkuDomain rsSkuDomain : skuList) {
                String json2;
                if (null == rsSkuDomain.getSkuCode()) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoods.rsSkuDomain.getSkuCode is null", (Object)("====" + sendhttpParam.toString()));
                    return "ERROR";
                }
                sendhttpParam.put("outSkuId", rsSkuDomain.getSkuCode());
                sendhttpParam.put("brandId", "35247");
                sendhttpParam.put("categoryId", "20311");
                sendhttpParam.put("traceId", UUID.randomUUID().toString());
                if (null == rsSkuDomain.getGoodsName()) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoods.rsSkuDomain.getGoodsName is null", (Object)("====" + sendhttpParam.toString()));
                    return "ERROR";
                }
                sendhttpParam.put("skuName", rsSkuDomain.getGoodsName());
                if (null == rsSkuDomain.getPricesetNprice()) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoods.rsSkuDomain.getPricesetNprice is null", (Object)("====" + sendhttpParam.toString()));
                    return "ERROR";
                }
                BigDecimal rsl = rsSkuDomain.getPricesetNprice().multiply(new BigDecimal(100));
                long aLong = rsl.longValue();
                sendhttpParam.put("skuPrice", aLong);
                if (null != rsSkuDomain.getDataPic()) {
                    sendhttpParam.put("images", rsSkuDomain.getDataPic());
                }
                if (null == rsSkuDomain.getGoodsWeight()) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoods.rsSkuDomain.getGoodsWeight is null", (Object)("====" + sendhttpParam.toString()));
                    return "ERROR";
                }
                BigDecimal goodsOneweight = rsSkuDomain.getGoodsWeight();
                if (goodsOneweight.compareTo(BigDecimal.ZERO) <= 0) {
                    goodsOneweight = new BigDecimal(1.0);
                }
                float vList = goodsOneweight.floatValue();
                DecimalFormat df = new DecimalFormat("#.##");
                String formatList = df.format(vList);
                sendhttpParam.put("weight", formatList);
                if (null != rsSkuDomain.getBrandCode()) {
                    sendhttpParam.put("upc", StringUtils.isBlank((String)rsSkuDomain.getSkuBarcode()) ? rsSkuDomain.getSkuNo() : rsSkuDomain.getSkuBarcode());
                }
                if (0 == (null == rsSkuDomain.getDataOpbillstate() ? 0 : rsSkuDomain.getDataOpbillstate())) {
                    sendhttpParam.put("fixedStatus", 2);
                } else {
                    sendhttpParam.put("fixedStatus", 1);
                }
                for (String key : sendhttpParam.keySet()) {
                    if ("token".equals(key)) continue;
                    Object o = sendhttpParam.get(key);
                    if (o instanceof List) {
                        String skuStockList = JsonUtil.buildNormalBinder().toJson(sendhttpParam.get("listBaseStockCenterRequest"));
                        mapSend.put(key, skuStockList);
                        continue;
                    }
                    if ("skuList".equals(key)) continue;
                    if (o != null) {
                        String a = o.toString();
                        mapSend.put(key, a);
                        continue;
                    }
                    if (!"traceId".equals(sendhttpParam.get(key))) continue;
                    UUID uuid = UUID.randomUUID();
                    mapSend.put(key, uuid.toString());
                }
                String jd_param_json = JsonUtil.buildNormalBinder().toJson(mapSend);
                String urlSend = configMap.get("serviceUrl") + configMap.get("action");
                WebRequestDTO webReqeustDTO = new WebRequestDTO();
                webReqeustDTO.setApp_key(appKey);
                webReqeustDTO.setFormat(format);
                webReqeustDTO.setJd_param_json(jd_param_json);
                webReqeustDTO.setTimestamp(timestamp);
                webReqeustDTO.setToken(token);
                webReqeustDTO.setV(v);
                String sign = null;
                try {
                    sign = SignUtils.getSignByMD5(webReqeustDTO, appSecret);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HashMap<String, Object> paramSend = new HashMap<String, Object>();
                paramSend.put("token", token);
                paramSend.put("app_key", appKey);
                paramSend.put("timestamp", timestamp);
                paramSend.put("sign", sign);
                paramSend.put("format", format);
                paramSend.put("v", v);
                paramSend.put("jd_param_json", jd_param_json);
                try {
                    json2 = HttpUtil.sendSimplePostRequest(urlSend, paramSend);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".batch.sendComSaveGoodsClass.e", (Object)("===" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
                    return "ERROR";
                }
                if (StringUtils.isBlank((String)json2)) {
                    this.logger.error(this.SYS_CODE + ".batch.sendStoreEndParam.json", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json2, String.class, Object.class);
                if (!"0".equals(jsonToMap.get("code")) || 0 == jsonToMap.size()) {
                    this.logger.error(this.SYS_CODE + ".batch.sendStoreEndParam.jsonToMap", (Object)(json2 + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                String data = (String)jsonToMap.get("data");
                if (StringUtils.isBlank((String)data)) {
                    this.logger.error(this.SYS_CODE + ".batch.sendComSaveGoods's data is null!", (Object)(json2 + "====" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                if (!"cmc.disGoods.saveSendGoods".equals(channelApiCode)) continue;
                Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
                if (MapUtil.isEmpty((Map)dataMap)) {
                    this.logger.error(this.SYS_CODE, (Object)(".batch.  cmc.disGoods.saveSendGoods 's  dataMap is emptm!===" + json2 + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                Map resultaMap = (Map)dataMap.get("result");
                if (MapUtil.isEmpty((Map)resultaMap)) {
                    this.logger.error(this.SYS_CODE, (Object)(".batch.sendComSaveGoods's resultaMap is null===" + json2 + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(this.SYS_CODE + ".batch.sendComSaveGoodsClass.rsResourceGoodsReDomain", (Object)(json2 + "====" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                    return "ERROR";
                }
                this.logger.error(this.SYS_CODE + ".batch.sendStoreEndParam.saveGoods", (Object)(String.valueOf(resultaMap.get("skuId")) + "=" + json2 + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                this.saveGoods(disChannel, rsResourceGoodsReDomain.getGoodsNo(), rsResourceGoodsReDomain.getGoodsCode(), String.valueOf(resultaMap.get("skuId")), rsResourceGoodsReDomain.getTenantCode());
            }
            return "SUCCESS";
        }
        for (String key : sendhttpParam.keySet()) {
            if ("token".equals(key)) continue;
            Object o = sendhttpParam.get(key);
            if (o instanceof List) {
                String skuStockList = JsonUtil.buildNormalBinder().toJson(sendhttpParam.get("listBaseStockCenterRequest"));
                mapSend.put(key, skuStockList);
                continue;
            }
            if (o != null) {
                String a = o.toString();
                mapSend.put(key, a);
                continue;
            }
            if (!"traceId".equals(sendhttpParam.get(key))) continue;
            UUID uuid = UUID.randomUUID();
            mapSend.put(key, uuid.toString());
        }
        String jd_param_json = JsonUtil.buildNormalBinder().toJson(mapSend);
        String urlSend = configMap.get("serviceUrl") + configMap.get("action");
        WebRequestDTO webReqeustDTO = new WebRequestDTO();
        webReqeustDTO.setApp_key(appKey);
        webReqeustDTO.setFormat(format);
        webReqeustDTO.setJd_param_json(jd_param_json);
        webReqeustDTO.setTimestamp(timestamp);
        webReqeustDTO.setToken(token);
        webReqeustDTO.setV(v);
        String sign = null;
        try {
            sign = SignUtils.getSignByMD5(webReqeustDTO, appSecret);
        }
        catch (Exception aLong) {
            // empty catch block
        }
        HashMap<String, Object> paramSend = new HashMap<String, Object>();
        paramSend.put("token", token);
        paramSend.put("app_key", appKey);
        paramSend.put("timestamp", timestamp);
        paramSend.put("sign", sign);
        paramSend.put("format", format);
        paramSend.put("v", v);
        paramSend.put("jd_param_json", jd_param_json);
        try {
            json = HttpUtil.sendSimplePostRequest(urlSend, paramSend);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)("===" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.json", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (!"0".equals(jsonToMap.get("code")) || 0 == jsonToMap.size()) {
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.jsonToMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        String data = (String)jsonToMap.get("data");
        if (StringUtils.isBlank((String)data)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoods's data is null!", (Object)(json + "====" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disGoods.saveSendGoods".equals(channelApiCode)) {
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE, (Object)("cmc.disGoods.saveSendGoods 's  dataMap is emptm!===" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            Map resultaMap = (Map)dataMap.get("result");
            if (MapUtil.isEmpty((Map)resultaMap)) {
                this.logger.error(this.SYS_CODE, (Object)("sendComSaveGoods's resultaMap is null===" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)param.get("rsResourceGoodsReDomain");
            if (null == rsResourceGoodsReDomain) {
                this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.rsResourceGoodsReDomain", (Object)(json + "====" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            this.logger.error(this.SYS_CODE + ".sendStoreEndParam.saveGoods", (Object)(String.valueOf(resultaMap.get("skuId")) + "=" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            this.saveGoods(disChannel, rsResourceGoodsReDomain.getGoodsNo(), rsResourceGoodsReDomain.getGoodsCode(), String.valueOf(resultaMap.get("skuId")), rsResourceGoodsReDomain.getTenantCode());
        }
        return "SUCCESS";
    }
}

