/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jd.order.service;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.channel.discom.api.DisRefundService;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContract;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisContractproDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisPackageDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisRefundReDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisStatementContract;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisStatementContractDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResChannelsendDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResEvaluateGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.ResEvaluateReplyDomain;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisOrderBaseService;
import com.yqbsoft.laser.service.ext.channel.jd.JdConstants;
import com.yqbsoft.laser.service.ext.channel.jd.utils.HttpUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisOrderServiceImpl
extends DisOrderBaseService {
    private String SYS_CODE = "jddj.DisOrderServiceImpl";
    DisRefundService disRefundService;

    public void setDisRefundService(DisRefundService disRefundService) {
        this.disRefundService = disRefundService;
    }

    protected String getChannelCode() {
        return JdConstants.channelCode;
    }

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildComOrderParam", (Object)("====" + channelApiCode + "===" + sendParam.toString() + "====" + configMap.toString() + "====" + param.toString()));
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        List apiparamList = (List)param.get("apiparamList");
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            params.put(disChannelApiparam.getChannelApiparamKey(), sendParam.remove(disChannelApiparam.getChannelApiparamKey()));
        }
        String memberCode = (String)param.get("memberCode");
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = disChannel.getMemberCode();
        }
        sendParam.put("token", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCode()));
        sendParam.remove("sign");
        sendParam.remove("v");
        sendParam.remove("format");
        sendParam.remove("timestamp");
        sendParam.remove("app_key");
        String appKey = configMap.get("key");
        String format = configMap.get("format");
        String v = configMap.get("v");
        sendParam.put("app_key", appKey);
        String timestamp = DateUtil.parseDateTime((Date)new Date());
        sendParam.put("timestamp", timestamp);
        sendParam.put("format", format);
        sendParam.put("v", v);
        if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.queryTimeOrder".equals(channelApiCode)) {
            params.put("orderStartTime_begin", (String)param.get("start_time"));
            params.put("orderStartTime_end", (String)param.get("end_time"));
        }
        if ("cmc.disOrder.updateSendOrderPrint".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.updateSendOrderUserCanelAccept".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("isAgreed", "false");
            params.put("operator", (String)param.get("operator"));
            if (null == param.get("operator")) {
                params.put("operator", "\u4e2d\u53f0");
            }
        }
        if ("cmc.disOrder.updateSendOrderUserNoAccept".equals(channelApiCode) && (null == params.get("remark") || StringUtils.isBlank((String)params.get("remark").toString()))) {
            params.put("remark", "\u4e2d\u53f0\u53d1\u8d77\u53d6\u6d88");
        }
        if ("cmc.disOrder.updateSendOrderPickCode".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("selfPickCode", (String)param.get("selfPickCode"));
            params.put("operPin", (String)param.get("operPin"));
        }
        if ("cmc.disOrder.updateSendOrderOK".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operPin", (String)param.get("operPin"));
            params.put("operTime", (String)param.get("operTime"));
        }
        if ("cmc.disOrder.updateSendOrderAddTips".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("tips", (String)param.get("tips"));
            params.put("operator", (String)param.get("operator"));
        }
        if ("cmc.disOrder.updateSendOrderUserCanelAccept".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operateTime", (String)param.get("operateTime"));
        }
        if ("cmc.disOrder.updateSendOrderReceiveAccept".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("isAgreed", "true");
            params.put("operator", (String)param.get("operator"));
            params.put("remark", (String)param.get("remark"));
        }
        if ("cmc.disOrder.updateSendOrderReceiveNoAccept".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("isAgreed", "false");
            params.put("operator", (String)param.get("operator"));
            params.put("remark", (String)param.get("remark"));
        }
        if ("cmc.disOrder.updateSendOrderPlatDelivery".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operator", (String)param.get("operator"));
        }
        if ("cmc.disOrder.getSendOrderLog".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.updateSendOrderAdjust".equals(channelApiCode)) {
            ArrayList oaosAdjustDTOList = new ArrayList();
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operPin", (String)param.get("operPin"));
            params.put("remark", (String)param.get("remark"));
            HashMap<String, String> oaosAdjustDTOMap = new HashMap<String, String>();
            oaosAdjustDTOMap.put("outSkuId", "688555");
            oaosAdjustDTOMap.put("skuCount", "1");
            oaosAdjustDTOList.add(oaosAdjustDTOMap);
            params.put("oaosAdjustDTOList", oaosAdjustDTOList);
        }
        if ("cmc.disOrder.getHandleReportRecord".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.urgeDispatching".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("updatePin", (String)param.get("updatePin"));
        }
        if ("cmc.disOrder.getOrderSettlement".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.updateOrderSerllerDelivery".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operator", (String)param.get("operator"));
        }
        if ("cmc.disOrder.updateOrderModifySellerDelivery".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("updatePin", (String)param.get("updatePin"));
        }
        if ("cmc.disOrder.updateOrderSelfMention".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("operator", (String)param.get("operator"));
        }
        if ("cmc.disOrder.sendOrderHandleReport".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
            params.put("imgs", (String)param.get("imgs"));
        }
        if ("cmc.disOrder.getHandleReportRecord".equals(channelApiCode)) {
            params.put("orderId", (String)param.get("contractNbillcode"));
        }
        if ("cmc.disOrder.queryReconciliation".equals(channelApiCode)) {
            params.put("orderStartTime_begin", param.get("start_time"));
            params.put("orderStartTime_end", param.get("end_time"));
            params.put("deliveryStationNo", param.get("shoppingId"));
        }
        if ("cmc.disOrder.saveStoreNotice".equals(channelApiCode)) {
            params.put("stationNo", param.get("shoppingId"));
            params.put("storeNotice", param.get("noticeContext"));
            params.put("operator", "\u4e2d\u53f0");
        }
        if ("cmc.disOrder.getBalanceBillList".equals(channelApiCode)) {
            params.put("orderIds", param.get("orderIds"));
            params.put("orderStartTime", param.get("startTime"));
            params.put("orderEndTime", param.get("endTime"));
        }
        sendParam.put("jd_param_json", JsonUtil.buildNormalBinder().toJson(params));
        this.logger.error(this.SYS_CODE + "." + channelApiCode, (Object)("=:= " + configMap + "=:= " + param + "=:= " + sendParam));
        return sendParam;
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String json;
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String urlSend = configMap.get("serviceUrl") + configMap.get("action");
        try {
            json = HttpUtil.sendSimplePostRequest(urlSend, sendhttpParam);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.e", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()), (Throwable)e);
            return "ERROR";
        }
        if (StringUtils.isBlank((String)json)) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoodsClass.json", (Object)(urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        Map jdOrderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jdOrderMap)) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        this.logger.error(this.SYS_CODE + " code : ", (Object)(channelApiCode + " ; " + json));
        if (!"0".equals(jdOrderMap.get("code")) && !channelApiCode.equals("cmc.disOrder.getSendOrder")) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.code", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return (String)jdOrderMap.get("msg");
        }
        if (null == jdOrderMap.get("data")) {
            this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.data", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return (String)jdOrderMap.get("msg");
        }
        if ("cmc.disOrder.queryOrder".equals(channelApiCode) || "cmc.disOrder.queryTimeOrder".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.dataMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return (String)dataMap.get("msg");
            }
            String result1 = (String)dataMap.get("result");
            Map resultMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result1, String.class, Object.class);
            if (MapUtil.isEmpty((Map)resultMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resultMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return (String)dataMap.get("msg");
            }
            if ("0".equals((String)resultMap.get("totalCount"))) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.totalCount is 0", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return (String)dataMap.get("msg");
            }
            List listMap = (List)resultMap.get("resultList");
            if (ListUtil.isEmpty((Collection)listMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.listMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            return this.createListOrder(listMap, disChannel);
        }
        if ("cmc.disOrder.getSendOrder".equals(channelApiCode)) {
            String dataString = (String)jdOrderMap.get("data");
            if (StringUtils.isBlank((String)dataString)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.dataString", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(dataString, String.class, Object.class);
            if (MapUtil.isEmpty((Map)map)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.map", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            String resultMap = (String)map.get("result");
            if (StringUtils.isEmpty((String)resultMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resultMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            Map resMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultMap, String.class, Object.class);
            if (MapUtil.isEmpty((Map)resMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            List resultList = (List)resMap.get("resultList");
            if (ListUtil.isEmpty((Collection)resultList)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.resultList", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            Map endMap = (Map)resultList.get(0);
            if (MapUtil.isEmpty((Map)endMap)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.jdOrderMap.endMap", (Object)("=====" + json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return null;
            }
            DisContractDomain disContractDomain = this.createOrder(endMap, disChannel);
            return disContractDomain;
        }
        if ("cmc.disOrder.updateSendOrderPrint".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderPrint.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderPrint.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderCanRefund".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderCanRefund.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderCanRefund.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderAccept".equals(channelApiCode) || "cmc.disOrder.updateSendOrderUserCanelAccept".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderAccept.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderAccept.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderUserAccept".equals(channelApiCode) || "cmc.disOrder.updateSendOrderUserNoAccept".equals(channelApiCode)) {
            String code;
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderUserAccept.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String state = "32";
            if ("cmc.disOrder.updateSendOrderUserNoAccept".equals(channelApiCode)) {
                state = "33";
            }
            if ((code = dataMap.get("code").toString()).equals("0")) {
                Map ocRefundDomain = (Map)param.get("ocRefundDomain");
                this.logger.error(this.SYS_CODE + ".Accept", (Object)(ocRefundDomain + " =:= " + param));
                if (MapUtil.isNotEmpty((Map)ocRefundDomain)) {
                    this.updateExtrinsicStateByRefundCode(ocRefundDomain.get("refundCode").toString(), state, disChannel.getTenantCode());
                }
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderUserAccept.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderPickCode".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderPickCode.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderPickCode.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderOK".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderOK.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderOK.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderAddTips".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderAddTips.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderAddTips.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderUserCanelAccept".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderUserCanelAccept.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderUserCanelAccept.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderReceiveAccept".equals(channelApiCode) || "cmc.disOrder.updateSendOrderReceiveNoAccept".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderReceiveAccept.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderReceiveAccept.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.updateSendOrderPlatDelivery".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".updateSendOrderPlatDelivery.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".updateSendOrderPlatDelivery.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.getSendOrderLog".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            return data;
        }
        if ("cmc.disOrder.updateSendOrderAdjust".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            return data;
        }
        if ("cmc.disOrder.getHandleReportRecord".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            return data;
        }
        if ("cmc.disOrder.commentReply".equals(channelApiCode)) {
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".commentReply.dataMap", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
                return "ERROR";
            }
            String code = dataMap.get("code").toString();
            if (code.equals("0")) {
                return "SUCCESS";
            }
            this.logger.error(this.SYS_CODE + ".commentReply.json", (Object)(json + "=" + urlSend + ":" + sendhttpParam.toString() + ":" + configMap.toString()));
            return "ERROR";
        }
        if ("cmc.disOrder.queryComment".equals(channelApiCode)) {
            String memberCname;
            this.logger.error(this.SYS_CODE, (Object)(".sendComOrder.queryComment." + json));
            String data = (String)jdOrderMap.get("data");
            Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error(this.SYS_CODE + ".queryComment.json.dataMap", (Object)("=:=" + json + "=:=" + sendhttpParam.toString() + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            if (null == dataMap.get("result") || StringUtils.isBlank((String)dataMap.get("result").toString())) {
                this.logger.error(this.SYS_CODE + ".queryComment.json.dataMap.result", (Object)("=:=" + json + "=:=" + sendhttpParam.toString() + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            Map dataResult = (Map)dataMap.get("result");
            if (MapUtil.isEmpty((Map)dataResult)) {
                this.logger.error(this.SYS_CODE + ".sendComOrder.json.dataResult", (Object)("=:=" + json + "=:=" + sendhttpParam + "=:=" + channelApiCode + "=:=" + urlSend));
                return null;
            }
            String memberCcode = null == param.get("memberCcode") ? "" : param.get("memberCcode").toString();
            List<ResChannelsendDomain> resChannelsendDomainList = this.buildResChannelsend(dataResult, disChannel, memberCcode, memberCname = null == param.get("memberCname") ? "" : param.get("memberCname").toString());
            if (ListUtil.isEmpty(resChannelsendDomainList)) {
                this.logger.error(this.SYS_CODE + ".resChannelsendDomainList ", (Object)dataResult);
                return null;
            }
            this.saveChannelsendBatch(resChannelsendDomainList);
        } else if ("cmc.disOrder.partrefundApply".equals(channelApiCode) || "cmc.disOrder.updateSendOrderUserAccept".equals(channelApiCode)) {
            Map ocRefundDomain = (Map)param.get("ocRefundDomain");
            this.logger.error(this.SYS_CODE + ".ocRefundDomain." + channelApiCode, (Object)(ocRefundDomain + " =:= " + param));
            if (MapUtil.isEmpty((Map)ocRefundDomain)) {
                this.logger.error(this.SYS_CODE + channelApiCode + ".ocRefundDomain ", param);
            }
            this.updateExtrinsicStateByRefundCode(ocRefundDomain.get("refundCode").toString(), "60", disChannel.getTenantCode());
        } else if ("cmc.disOrder.updateSendOrderUserNoAccept".equals(channelApiCode)) {
            Map ocRefundDomain = (Map)param.get("ocRefundDomain");
            if (MapUtil.isEmpty((Map)ocRefundDomain)) {
                this.logger.error(this.SYS_CODE + ".cmc.disOrder.updateSendOrderUserNoAccept.ocRefundDomain1 ", param);
            }
            this.updateExtrinsicStateByRefundCode(ocRefundDomain.get("refundCode").toString(), "50", disChannel.getTenantCode());
        } else {
            if ("cmc.disOrder.queryReconciliation".equals(channelApiCode)) {
                Map resultMap;
                List resultList;
                this.logger.error(this.SYS_CODE + ".queryReconciliation", (Object)(JsonUtil.buildNonDefaultBinder().toJson(sendhttpParam) + "json=======" + json));
                String tenantCode = String.valueOf(param.get("tenantCode"));
                String memberCode = String.valueOf(param.get("memberCode"));
                String startDate = null;
                String endDate = null;
                List disStatementContracts = this.queryStatementContractPage(disChannel.getChannelCode(), memberCode, startDate, endDate, tenantCode);
                this.logger.error(this.SYS_CODE + ".disStatementContracts", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)disStatementContracts));
                if (ListUtil.isNotEmpty((Collection)disStatementContracts)) {
                    for (DisStatementContract disStatementContract : disStatementContracts) {
                        DisContractDomain sendOrder = this.getSendOrder(disStatementContract.getStatementContractCode(), memberCode, tenantCode);
                        if (null == sendOrder) {
                            this.updateStatementContractStateByCode(disStatementContract.getTenantCode(), disStatementContract.getStatementContractCode(), 2, 0);
                            continue;
                        }
                        Integer dataS = Integer.valueOf(sendOrder.getDataStatestr());
                        if (90000 == dataS || 20020 == dataS || 20040 == dataS || 20060 == dataS) {
                            DisContract disContract;
                            if (90000 == dataS) {
                                sendOrder.setDataState(Integer.valueOf(33060));
                                sendOrder.setDataStatestr("33060");
                            }
                            if (null == (disContract = this.getContractByCode(disStatementContract.getStatementContractCode(), tenantCode, this.getChannelCode()))) {
                                this.logger.error(this.SYS_CODE + ".updateStatementContractStateByCode", (Object)"===================22222222222");
                                this.updateStatementContractStateByCode(disStatementContract.getTenantCode(), disStatementContract.getStatementContractCode(), 2, 0);
                                continue;
                            }
                            if (sendOrder.getDataStatestr().equals(disContract.getDataStatestr())) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("dataStatestr", sendOrder.getDataStatestr());
                                this.updateOrder(disChannel.getTenantCode(), disStatementContract.getStatementContractCode(), Integer.valueOf(sendOrder.getDataStatestr()), null, map, disChannel);
                            }
                        }
                        HashMap<String, Object> pMap = new HashMap<String, Object>();
                        ArrayList orderIds = new ArrayList();
                        pMap.put("orderIds", orderIds);
                        pMap.put("startTime", "20200402");
                        pMap.put("endTime", "20200520");
                        DisStatementContract balanceBillList = this.getBalanceBillList(pMap, memberCode, tenantCode);
                        if (null == balanceBillList) {
                            this.logger.error(this.SYS_CODE + ".updateStatementContractStateByCode", (Object)"===================333333333");
                            this.updateStatementContractStateByCode(disStatementContract.getTenantCode(), disStatementContract.getStatementContractCode(), 2, 0);
                            continue;
                        }
                        disStatementContract.setGoodsPmoney(balanceBillList.getGoodsPmoney());
                        disStatementContract.setContractInmoney(balanceBillList.getContractInmoney());
                        disStatementContract.setContractMoney(balanceBillList.getContractMoney());
                        disStatementContract.setDataBmoney(balanceBillList.getDataBmoney());
                        disStatementContract.setStatementContractSmoney(balanceBillList.getStatementContractSmoney());
                        disStatementContract.setContractPaygmoney(balanceBillList.getContractPaygmoney());
                        disStatementContract.setContractGmoney(balanceBillList.getContractGmoney());
                        DisStatementContractDomain disStatementContractDomain = new DisStatementContractDomain();
                        try {
                            BeanUtils.copyAllPropertys((Object)disStatementContractDomain, (Object)disStatementContract);
                        }
                        catch (Exception e) {
                            this.logger.error(this.SYS_CODE + ".disStatementContractDomain.e", (Throwable)e);
                        }
                        this.updateStatementContract(disStatementContractDomain);
                        this.updateStatementContractStateByCode(disStatementContract.getTenantCode(), disStatementContract.getStatementContractCode(), 1, 0);
                    }
                }
                ArrayList<DisStatementContractDomain> disStatementContractDomainList = new ArrayList<DisStatementContractDomain>();
                Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(jdOrderMap.get("data").toString(), String.class, Object.class);
                if ("0".equals(dataMap.get("code")) && ListUtil.isNotEmpty((Collection)(resultList = (List)(resultMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(dataMap.get("result").toString(), String.class, Object.class)).get("resultList")))) {
                    for (Map orderMap : resultList) {
                        DisStatementContractDomain disStatementContractDomain;
                        DisContractDomain sendOrder;
                        Boolean existence = false;
                        String orderId = String.valueOf(orderMap.get("orderId"));
                        DisContract disContract = this.getContractByCode(orderId, tenantCode, this.getChannelCode());
                        if (null == disContract) {
                            ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
                            sendOrder = this.getSendOrder(orderId, memberCode, tenantCode);
                            disContractDomainList.add(sendOrder);
                            this.saveOrder(disContractDomainList, disChannel);
                            existence = true;
                        }
                        if (null != (disStatementContractDomain = this.getStatementContractByCode(orderId, tenantCode))) continue;
                        sendOrder = this.getSendOrder(orderId, memberCode, tenantCode);
                        if (null == sendOrder) {
                            this.logger.error(this.SYS_CODE + ".sendComOrder.queryReconciliation", (Object)orderId);
                            continue;
                        }
                        DisStatementContractDomain newDisStatementContractDomain = new DisStatementContractDomain();
                        newDisStatementContractDomain.setStatementContractCode(sendOrder.getContractNbillcode());
                        if (existence.booleanValue()) {
                            newDisStatementContractDomain.setStatementSstate(JdConstants.DISOC_DATA_STATE_3);
                        } else {
                            newDisStatementContractDomain.setStatementSstate(JdConstants.DISOC_DATA_STATE_0);
                        }
                        newDisStatementContractDomain.setTenantCode(tenantCode);
                        newDisStatementContractDomain.setStatementTcode(sendOrder.getContractNbillcode());
                        newDisStatementContractDomain.setStatementDate(null);
                        newDisStatementContractDomain.setChannelCode(this.getChannelCode());
                        newDisStatementContractDomain.setChannelName("\u4eac\u4e1c\u5230\u5bb6");
                        newDisStatementContractDomain.setContractMoney(sendOrder.getGoodsMoney());
                        newDisStatementContractDomain.setMemberCname(sendOrder.getMemberCname());
                        newDisStatementContractDomain.setMemberCcode(memberCode);
                        if (null != disContract) {
                            newDisStatementContractDomain.setStatementCreate(disContract.getContractValidate());
                            newDisStatementContractDomain.setStatementOkdate(disContract.getContractValidate());
                        } else {
                            newDisStatementContractDomain.setStatementCreate(new Date());
                            newDisStatementContractDomain.setStatementOkdate(new Date());
                        }
                        if (null != disContract) {
                            newDisStatementContractDomain.setStatementCode(disContract.getContractBillcode());
                        } else {
                            newDisStatementContractDomain.setStatementCode(sendOrder.getContractBillcode());
                        }
                        newDisStatementContractDomain.setStatementDiscode(sendOrder.getContractNbillcode());
                        disStatementContractDomainList.add(newDisStatementContractDomain);
                    }
                    QueryResult queryResult = new QueryResult();
                    if (ListUtil.isNotEmpty(disStatementContractDomainList)) {
                        queryResult.setList(disStatementContractDomainList);
                        return JsonUtil.buildNonDefaultBinder().toJson((Object)queryResult);
                    }
                }
                return null;
            }
            if ("cmc.disOrder.getBalanceBillList".equals(channelApiCode)) {
                Map dataMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdOrderMap.get("data").toString(), String.class, Object.class);
                if (MapUtil.isEmpty((Map)dataMap)) {
                    this.logger.error(this.SYS_CODE + ".getBalanceBillList", (Object)"===============4444444");
                    return null;
                }
                Map contentMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson(dataMap.get("content")), String.class, Object.class);
                if (MapUtil.isEmpty((Map)contentMap)) {
                    this.logger.error(this.SYS_CODE + ".getBalanceBillList", (Object)"===============5555555");
                    return null;
                }
                Map billListMap = (Map)contentMap.get("billList");
                List resultList = (List)billListMap.get("result");
                BigDecimal sumOriginalAmount = new BigDecimal(0);
                BigDecimal sumSubsidy = new BigDecimal(0);
                BigDecimal sumStoreSubsidy = new BigDecimal(0);
                BigDecimal sumPickupAmount = new BigDecimal(0);
                BigDecimal sumCommission = new BigDecimal(0);
                BigDecimal currentDueAmount = new BigDecimal(String.valueOf(contentMap.get("currentDueAmount")));
                for (Map resultMap : resultList) {
                    sumOriginalAmount = sumOriginalAmount.add(new BigDecimal(String.valueOf(resultMap.get("originalAmount"))));
                    sumSubsidy = sumSubsidy.add(new BigDecimal(String.valueOf(resultMap.get("subsidy"))));
                    sumStoreSubsidy = sumStoreSubsidy.add(new BigDecimal(String.valueOf(resultMap.get("storeSubsidy"))));
                    sumPickupAmount = sumPickupAmount.add(new BigDecimal(String.valueOf(resultMap.get("storeSubsidy"))));
                    sumCommission = sumCommission.add(new BigDecimal(String.valueOf(resultMap.get("commission"))));
                }
                DisStatementContract disStatementContract = new DisStatementContract();
                disStatementContract.setGoodsPmoney(sumSubsidy);
                disStatementContract.setContractInmoney(sumOriginalAmount);
                disStatementContract.setContractMoney(sumOriginalAmount);
                disStatementContract.setDataBmoney(currentDueAmount);
                disStatementContract.setStatementContractSmoney(sumCommission);
                disStatementContract.setContractPaygmoney(sumSubsidy.subtract(sumStoreSubsidy));
                disStatementContract.setContractGmoney(sumStoreSubsidy);
                this.logger.error(this.SYS_CODE + ".getBalanceBillList", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)disStatementContract));
                return disStatementContract;
            }
        }
        return null;
    }

    private List<ResChannelsendDomain> buildResChannelsend(Map<String, Object> map, DisChannel disChannel, String memberCcode, String memberCname) {
        Date date;
        if (MapUtil.isEmpty(map) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildResChannelsend ", (Object)"param is null");
            return null;
        }
        ArrayList<ResChannelsendDomain> resChannelsendDomainList = new ArrayList<ResChannelsendDomain>();
        Map<String, String> templateMap = this.fetchTemplate();
        String score3Con = null == map.get("score3Content") ? "" : (StringUtils.isNotBlank((String)map.get("score3Content").toString()) ? map.get("score3Content").toString() + ";" : "");
        String score4Con = null == map.get("score4Content") ? "" : map.get("score4Content").toString();
        ResEvaluateGoodsDomain resEvaluateGoodsDomain = new ResEvaluateGoodsDomain();
        resEvaluateGoodsDomain.setEvaluateGoodsContent(score3Con + score4Con);
        resEvaluateGoodsDomain.setEvaluateGoodsOcode(map.get("orderId").toString());
        resEvaluateGoodsDomain.setContractNbillcode(map.get("orderId").toString());
        resEvaluateGoodsDomain.setEvaluateGoodsType("order");
        this.defaultEvaluateGoods(resEvaluateGoodsDomain, disChannel, memberCcode, memberCname);
        ArrayList resEvaluateScopeDomains = new ArrayList();
        Integer score3 = null == map.get("score3") ? null : (Integer)map.get("score3");
        Integer score4 = null == map.get("score4") ? null : (Integer)map.get("score4");
        Long createTime = null == map.get("createTime") ? null : (Long)map.get("createTime");
        Date date2 = date = null == createTime ? null : new Date(createTime);
        if (null != date) {
            resEvaluateGoodsDomain.setEvaluateGoodsDate(date);
        }
        this.defaultEvaluateScope(resEvaluateScopeDomains, disChannel, score3, "score3", templateMap.get("score3"), "order");
        this.defaultEvaluateScope(resEvaluateScopeDomains, disChannel, score4, "score4", templateMap.get("score4"), "order");
        Object orgCommentContent = map.get("orgCommentContent");
        if (null != orgCommentContent && StringUtils.isNotBlank((String)((String)orgCommentContent))) {
            ArrayList<ResEvaluateReplyDomain> resEvaluateReplyDomains = new ArrayList<ResEvaluateReplyDomain>();
            Long orgCommentTime = null == map.get("orgCommentTime") ? null : (Long)map.get("orgCommentTime");
            Date orgCommentdate = null == orgCommentTime ? null : new Date(orgCommentTime);
            resEvaluateReplyDomains.add(this.defaultEvaluateReply(resEvaluateGoodsDomain, disChannel, String.valueOf(orgCommentContent), map.get("orderId").toString(), orgCommentdate));
            resEvaluateGoodsDomain.setEvaluateReplyDomainList(resEvaluateReplyDomains);
        }
        resEvaluateGoodsDomain.setEvaluateScopeList(resEvaluateScopeDomains);
        resChannelsendDomainList.add(this.makeResChannelsend(resEvaluateGoodsDomain, "add"));
        return resChannelsendDomainList;
    }

    private Map<String, String> fetchTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("score3", "\u914d\u9001\u8bc4\u5206");
        map.put("score4", "\u5546\u54c1\u670d\u52a1\u8bc4\u5206");
        return map;
    }

    private List<DisContractDomain> createListOrder(List<Map<String, Object>> list, DisChannel disChannel) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
        for (Map<String, Object> map : list) {
            String tenantCode;
            String memberCode;
            if (null == map.get("jd_param_json")) continue;
            String jdParamList = this.decodeParam((String)map.get("jd_param_json"));
            Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdParamList, String.class, Object.class);
            String billId = (String)jsonToMap.get("billId");
            DisContractDomain disContractDomain = this.getSendOrder(billId, memberCode = (String)jsonToMap.get("memberCode"), tenantCode = (String)jsonToMap.get("tenantCode"));
            if (null == disContractDomain) {
                return null;
            }
            disContractDomainList.add(disContractDomain);
        }
        return disContractDomainList;
    }

    private DisContractDomain createOrder(Map<String, Object> param, DisChannel disChannel) {
        if (MapUtil.isEmpty(param)) {
            return null;
        }
        return this.makeOrder(param, disChannel);
    }

    private DisRefundDomain createRefundJddj2(DisContractDomain disContractDomain, DisChannel disChannel, Map<String, Object> map) {
        if (null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundJddj2", map);
            return null;
        }
        return this.bulidRefundJddj2(disContractDomain, disChannel, map);
    }

    private DisRefundDomain bulidRefundJddj2(DisContractDomain disContractDomain, DisChannel disChannel, Map<String, Object> map) {
        this.logger.error(this.SYS_CODE + ".bulidRefundJddj2", (Object)(JsonUtil.buildNormalBinder().toJson((Object)disContractDomain) + " =:= " + map));
        if (null == disContractDomain) {
            this.logger.info(this.SYS_CODE + ".bulidRefundJddj2.disContractDomain", map);
            return null;
        }
        DisRefundDomain disRefundDomain = new DisRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRefundDomain, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".bulidRefundJddj2.copyAllPropertys", (Throwable)e);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String ctimeStr = (String)map.get("timestamp");
        try {
            disRefundDomain.setRefundDate(sdf.parse(ctimeStr));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        disRefundDomain.setRefundCreate(disContractDomain.getContractValidate());
        String refundAuditTime = this.getRefundAuditTime(disChannel.getTenantCode(), disChannel.getChannelCode());
        if (null != refundAuditTime && StringUtils.isNotBlank((String)refundAuditTime)) {
            disRefundDomain.setRefundInvstate(Integer.valueOf(Integer.parseInt(refundAuditTime)));
        }
        String res_reason = null == map.get("remark") ? null : map.get("remark").toString();
        disRefundDomain.setRefundEx(res_reason);
        disRefundDomain.setRefundUsertype("0");
        disRefundDomain.setRefundMeo(res_reason);
        disRefundDomain.setDataStatestr(String.valueOf(map.get("statusId")));
        disRefundDomain.setRefundType("jddj2");
        disRefundDomain.setRefundMoney(disContractDomain.getDataBmoney());
        disRefundDomain.setOcRefundGoodsDomainList(this.createRefundGoods(disContractDomain, disRefundDomain));
        return disRefundDomain;
    }

    private DisRefundGoodsDomain create(DisContractGoodsDomain disContractGoodsDomain) {
        if (null == disContractGoodsDomain) {
            this.logger.error(this.SYS_CODE + ".create.", (Object)"param is null");
            return null;
        }
        DisRefundGoodsDomain disRefundGoodsDomain = new DisRefundGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRefundGoodsDomain, (Object)disContractGoodsDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BigDecimal refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
        BigDecimal allowNum = disContractGoodsDomain.getGoodsCamount().subtract(refnum);
        disRefundGoodsDomain.setRefundGoodsNum(allowNum);
        disRefundGoodsDomain.setRefundGoodsAmt(disContractGoodsDomain.getContractGoodsMoney());
        disRefundGoodsDomain.setRefundGoodsWeight(disContractGoodsDomain.getGoodsCweight());
        disRefundGoodsDomain.setRefundGoodsPrice(disContractGoodsDomain.getPricesetNprice());
        return disRefundGoodsDomain;
    }

    private List<DisRefundGoodsDomain> createRefundGoods(DisContractDomain disContractDomain, DisRefundDomain disRefundDomain) {
        if (null == disRefundDomain || null == disContractDomain) {
            this.logger.error(this.SYS_CODE + ".createRefundGoods.", (Object)(disContractDomain + "=:=" + disRefundDomain));
            return null;
        }
        BigDecimal refundMoney = BigDecimal.ZERO;
        Map map = this.getMap(disContractDomain);
        if (MapUtil.isEmpty((Map)map)) {
            return null;
        }
        ArrayList<DisRefundGoodsDomain> refundGoodsList = new ArrayList<DisRefundGoodsDomain>();
        for (String key : map.keySet()) {
            BigDecimal refnum;
            DisContractGoodsDomain disContractGoodsDomain = (DisContractGoodsDomain)map.remove(key);
            if (null == disContractGoodsDomain) {
                return null;
            }
            BigDecimal bigDecimal = refnum = null == disContractGoodsDomain.getContractGoodsRefnum() ? BigDecimal.ZERO : disContractGoodsDomain.getContractGoodsRefnum();
            if (disContractGoodsDomain.getGoodsCamount().compareTo(refnum) == 0) {
                refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsMoney());
                continue;
            }
            disRefundDomain.setPackageCode(disContractGoodsDomain.getPackageCode());
            DisRefundGoodsDomain disRefundGoodsDomain = this.create(disContractGoodsDomain);
            refundGoodsList.add(disRefundGoodsDomain);
            refundMoney = refundMoney.add(disContractGoodsDomain.getContractGoodsPrice().multiply(refnum));
        }
        disRefundDomain.setRefundMoney(disRefundDomain.getRefundMoney().subtract(refundMoney));
        return refundGoodsList;
    }

    private DisContractDomain makeOrder(Map<String, Object> map, DisChannel disChannel) {
        Map orderInvoiceMap;
        String refundStatus;
        String dataState;
        String phone;
        String businessTag;
        if (null == map || null == disChannel) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DisContractDomain disContractDomain = new DisContractDomain();
        disContractDomain.setGoodsReceiptArrdess((String)map.get("buyerFullAddress"));
        disContractDomain.setChannelCode(disChannel.getChannelCode());
        disContractDomain.setChannelName(disChannel.getChannelName());
        disContractDomain.setTenantCode(disChannel.getTenantCode());
        String activeAt = (String)map.get("orderStartTime");
        String deliverTime = (String)map.get("orderPreEndDeliveryTime");
        String confirmCookingTime = (String)map.get("pickDeadline");
        disContractDomain.setPackageBillno((String)map.get("deliveryBillNo"));
        disContractDomain.setFchannelCode(String.valueOf((Integer)map.get("payChannel")));
        if (null != map.get("payChannel")) {
            disContractDomain.setFaccountName(this.payType((Integer)map.get("payChannel")));
        }
        try {
            disContractDomain.setContractValidate(StringUtils.isNotBlank((String)activeAt) ? sdf.parse(activeAt) : null);
            disContractDomain.setContractEffectivedate(StringUtils.isNotBlank((String)deliverTime) ? sdf.parse(deliverTime) : null);
            disContractDomain.setGmtVaild(StringUtils.isNotBlank((String)confirmCookingTime) ? sdf.parse(confirmCookingTime) : null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (null != map.get("orderFreightMoney")) {
            disContractDomain.setGoodsLogmoney(BigDecimal.valueOf(((Integer)map.get("orderFreightMoney")).intValue()).divide(new BigDecimal(100)));
        }
        if (null != map.get("orderBuyerRemark")) {
            disContractDomain.setContractRemark((String)map.get("orderBuyerRemark"));
        }
        List list = (List)map.get("product");
        disContractDomain.setContractPumode("9999".equals((String)map.get("deliveryCarrierNo")) ? "1" : "0");
        disContractDomain.setContractTypepro("00");
        String string = businessTag = null == map.get("businessTag") ? null : (String)map.get("businessTag");
        if (StringUtils.isNotBlank((String)businessTag) && businessTag.contains("one_dingshida")) {
            disContractDomain.setContractTypepro("01");
            disContractDomain.setContractPumode("2");
        }
        disContractDomain.setContractType("21");
        disContractDomain.setContractPmode("1");
        if (null != map.get("orderPayType") && 1 == (Integer)map.get("orderPayType")) {
            disContractDomain.setContractPmode("0");
        }
        if (null != map.get("orderId")) {
            disContractDomain.setContractNbillcode(String.valueOf(map.get("orderId")));
        }
        String string2 = phone = null == map.get("buyerMobile") ? null : map.get("buyerMobile").toString();
        if (StringUtils.isNotBlank((String)phone)) {
            if (phone.contains(",")) {
                phone = phone.replace(",", "\u8f6c");
            }
            disContractDomain.setGoodsReceiptPhone(phone);
        }
        String memberCcode = this.getMemberCode(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf(map.get("deliveryStationNo")));
        disContractDomain.setMemberCode(disChannel.getMemberCode());
        disContractDomain.setMemberName(disChannel.getMemberName());
        disContractDomain.setMemberCcode(memberCcode);
        if (null != map.get("deliveryStationName")) {
            disContractDomain.setMemberCname((String)map.get("deliveryStationName"));
        }
        this.setContractPro(disContractDomain, "daySn", String.valueOf(map.get("orderNum")), "\u5f53\u5929\u95e8\u5e97\u8ba2\u5355\u5e8f\u53f7");
        disContractDomain.setContractDelcode(String.valueOf(map.get("orderNum")));
        String time = this.getOrderPickingTime(disContractDomain.getTenantCode(), disContractDomain.getChannelCode());
        if (null != time && StringUtils.isNotBlank((String)time)) {
            this.setContractPro(disContractDomain, "pickingTime", time, "\u62e3\u8d27\u65f6\u957f");
        } else {
            this.logger.error(".getOrderPickingTime ", (Object)("\u62e3\u8d27\u65f6\u957f\u4e3a\u7a7a\uff1a" + disContractDomain.getContractNbillcode() + "=:=" + disContractDomain.getTenantCode() + "=:=" + disContractDomain.getChannelCode()));
        }
        if (null != map.get("orderStatus")) {
            disContractDomain.setDataStatestr(String.valueOf(map.get("orderStatus")));
        }
        if (null != (dataState = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), String.valueOf(map.get("orderStatus"))))) {
            disContractDomain.setDataState(Integer.valueOf(Integer.parseInt(dataState)));
        }
        if (("20020".equals(String.valueOf(map.get("orderStatus"))) || "20030".equals(String.valueOf(map.get("orderStatus"))) || "20040".equals(String.valueOf(map.get("orderStatus"))) || "20060".equals(String.valueOf(map.get("orderStatus")))) && null != (refundStatus = this.getRefundFlag(disChannel.getTenantCode(), disChannel.getChannelCode(), (String)map.get("refundStatus")))) {
            disContractDomain.setRefundFlag(Integer.valueOf(Integer.parseInt(refundStatus)));
        }
        if (null != map.get("orderBuyerPayableMoney")) {
            disContractDomain.setDataBmoney(BigDecimal.valueOf(((Integer)map.get("orderBuyerPayableMoney")).intValue()).divide(new BigDecimal(100), 2, 4));
            disContractDomain.setContractMoney(disContractDomain.getDataBmoney());
        }
        if (null != map.get("orderTotalMoney")) {
            disContractDomain.setContractInmoney(BigDecimal.valueOf(((Integer)map.get("orderTotalMoney")).intValue()).divide(new BigDecimal(100), 2, 4));
        }
        if (null != map.get("orderDiscountMoney")) {
            disContractDomain.setGoodsPmoney(BigDecimal.valueOf(((Integer)map.get("orderDiscountMoney")).intValue()).divide(new BigDecimal(100), 2, 4));
        }
        if (null != map.get("buyerFullName")) {
            disContractDomain.setGoodsReceiptMem((String)map.get("buyerFullName"));
        }
        BigDecimal sumskuNum = BigDecimal.ZERO;
        BigDecimal sumskuWeight = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty((Collection)list)) {
            for (Map OrderProductDTO2 : list) {
                Object skuWeight;
                if (null != OrderProductDTO2.get("skuCount")) {
                    sumskuNum = sumskuNum.add(BigDecimal.valueOf(((Integer)OrderProductDTO2.get("skuCount")).intValue()));
                }
                if (null == (skuWeight = OrderProductDTO2.get("skuWeight"))) continue;
                sumskuWeight = sumskuWeight.add(new BigDecimal(String.valueOf(skuWeight)));
            }
        }
        disContractDomain.setGoodsWeight(sumskuWeight);
        disContractDomain.setDataBweight(sumskuWeight);
        disContractDomain.setGoodsNum(sumskuNum);
        disContractDomain.setDataBnum(sumskuNum);
        this.setContractPro(disContractDomain, "carrierNo", (String)map.get("deliveryCarrierNo"), "\u627f\u8fd0\u5546\u7f16\u53f7");
        this.setContractPro(disContractDomain, "carrierName", (String)map.get("deliveryCarrierName"), "\u627f\u8fd0\u5546\u540d\u79f0");
        if (null != map.get("merchantPaymentDistanceFreightMoney")) {
            this.setContractPro(disContractDomain, "freightMoney", BigDecimal.valueOf(((Integer)map.get("merchantPaymentDistanceFreightMoney")).intValue()).divide(new BigDecimal(100)).toString(), "\u5546\u5bb6\u652f\u4ed8\u8fdc\u8ddd\u79bb\u8fd0\u8d39");
        }
        if (null != map.get("orderReceivableFreight")) {
            this.setContractPro(disContractDomain, "orderReceivableFreight", BigDecimal.valueOf(((Integer)map.get("orderReceivableFreight")).intValue()).divide(new BigDecimal(100)).toString(), "\u8ba2\u5355\u5e94\u6536\u8fd0\u8d39");
        }
        if (null != map.get("platformPointsDeductionMoney")) {
            this.setContractPro(disContractDomain, "deductionMoney", BigDecimal.valueOf(((Integer)map.get("platformPointsDeductionMoney")).intValue()).divide(new BigDecimal(100)).toString(), "\u7528\u6237\u79ef\u5206\u62b5\u6263\u91d1\u989d");
        }
        if (null != map.get("packagingMoney")) {
            BigDecimal bd = BigDecimal.valueOf(((Integer)map.get("packagingMoney")).intValue()).divide(new BigDecimal(100));
            this.setContractPro(disContractDomain, "packagingMoney", bd.toString(), "\u5305\u88c5\u91d1\u989d");
            disContractDomain.setContractPaymoney(bd);
        }
        if (null != map.get("tips")) {
            this.setContractPro(disContractDomain, "tips", BigDecimal.valueOf(((Integer)map.get("tips")).intValue()).divide(new BigDecimal(100)).toString(), "\u5546\u5bb6\u7ed9\u914d\u9001\u5458\u52a0\u7684\u5c0f\u8d39");
        }
        if (null != map.get("buyerLng")) {
            this.setContractPro(disContractDomain, "buyerLng", BigDecimal.valueOf((Double)map.get("buyerLng")).divide(new BigDecimal(100)).toString(), "\u6536\u8d27\u4eba\u5730\u5740\u817e\u8baf\u5750\u6807\u7ecf\u5ea6");
        }
        if (null != map.get("buyerLat")) {
            this.setContractPro(disContractDomain, "buyerLat", BigDecimal.valueOf((Double)map.get("buyerLat")).divide(new BigDecimal(100)).toString(), "\u6536\u8d27\u4eba\u5730\u5740\u817e\u8baf\u5750\u6807\u7eac\u5ea6");
        }
        if (null != map.get("buyerCityName")) {
            this.setContractPro(disContractDomain, "buyerCityName", (String)map.get("buyerCityName"), "\u6536\u8d27\u4eba\u5e02\u540d\u79f0");
        }
        if (null != map.get("buyerCountryName")) {
            this.setContractPro(disContractDomain, "buyerCountryName", (String)map.get("buyerCountryName"), "\u6536\u8d27\u4eba\u53bf(\u533a)\u540d\u79f0");
        }
        if (null != map.get("orderBuyerRemark")) {
            this.setContractPro(disContractDomain, "buyerRemark", (String)map.get("orderBuyerRemark"), "\u8ba2\u5355\u4e70\u5bb6\u5907\u6ce8");
        }
        if (null != map.get("businessTag")) {
            this.setContractPro(disContractDomain, "businessTag", (String)map.get("businessTag"), "\u4e1a\u52a1\u6807\u8bc6");
        }
        if (null != map.get("equipmentId")) {
            this.setContractPro(disContractDomain, "equipmentId", (String)map.get("equipmentId"), "\u8bbe\u5907id");
        }
        if (null != map.get("buyerPoi")) {
            this.setContractPro(disContractDomain, "buyerPoi", (String)map.get("buyerPoi"), "\u6536\u8d27\u4ebaPOI\u4fe1\u606f");
        }
        if (null != map.get("orderNum")) {
            this.setContractPro(disContractDomain, "orderNum", String.valueOf((Integer)map.get("orderNum")), "\u5f53\u5929\u95e8\u5e97\u8ba2\u5355\u5e8f\u53f7");
        }
        if (null != map.get("userTip")) {
            this.setContractPro(disContractDomain, "userTip", String.valueOf((Integer)map.get("userTip")), "\u7528\u6237\u5c0f\u8d39");
        }
        if (null != map.get("businessType")) {
            this.setContractPro(disContractDomain, "businessType", String.valueOf((Integer)map.get("businessType")), "\u8ba2\u5355\u4e1a\u52a1\u7c7b\u578b");
        }
        if (MapUtil.isNotEmpty((Map)(orderInvoiceMap = (Map)map.get("orderInvoice")))) {
            String invoiceTitle = null == orderInvoiceMap.get("invoiceTitle") ? null : (String)orderInvoiceMap.get("invoiceTitle");
            String invoiceDutyNo = null == orderInvoiceMap.get("invoiceDutyNo") ? null : (String)orderInvoiceMap.get("invoiceDutyNo");
            String invoiceMoneyDetail = null == orderInvoiceMap.get("invoiceMoneyDetail") ? null : (String)orderInvoiceMap.get("invoiceMoneyDetail");
            String money = StringUtils.isNotBlank((String)invoiceMoneyDetail) ? invoiceMoneyDetail : String.valueOf(disContractDomain.getDataBmoney());
            disContractDomain.setContractInvoice(invoiceTitle + " ; " + invoiceDutyNo + " ; " + money);
            String orderType = "";
            while (0 == Integer.parseInt((String)orderInvoiceMap.get("invoiceType"))) {
                orderType = "\u4e2a\u4eba";
            }
            while (1 == Integer.parseInt((String)orderInvoiceMap.get("invoiceType"))) {
                orderType = "\u4f01\u4e1a\u666e\u7968";
            }
            while (2 == Integer.parseInt((String)orderInvoiceMap.get("invoiceType"))) {
                orderType = "\u4f01\u4e1a\u4e13\u7968";
            }
            String str = "{  \"invoiceType\":" + orderType + ",\"invoiceTitle\":" + invoiceTitle + ",\"taxerId\":" + invoiceDutyNo + "}";
            disContractDomain.setContractInvoicestr(str);
        }
        if ("20020".equals(String.valueOf(map.get("orderStatus"))) || "20030".equals(String.valueOf(map.get("orderStatus"))) || "20040".equals(String.valueOf(map.get("orderStatus"))) || "20060".equals(String.valueOf(map.get("orderStatus")))) {
            if (null != map.get("orderStatus")) {
                this.setContractPro(disContractDomain, "cancelOrderDescription", String.valueOf(map.get("orderStatus")), "\u7528\u6237\u53d6\u6d88\u539f\u56e0");
            }
            if (null != map.get("orderCancelTime")) {
                this.setContractPro(disContractDomain, "cancelOrderCreatedAt", map.get("orderCancelTime").toString(), "\u7528\u6237\u7533\u8bf7\u53d6\u6d88\u65f6\u95f4");
            }
        }
        disContractDomain.setContractProperty("0");
        if (null != map.get("isGroupon") && ((Boolean)map.get("isGroupon")).booleanValue()) {
            disContractDomain.setContractProperty("1");
        }
        if (!"0".equals(String.valueOf(map.get("orderStatus")))) {
            disContractDomain.setContractProperty("2");
        }
        List<DisPackageDomain> disPackageDomains = this.makeDisPackageDomain(list, disContractDomain);
        disContractDomain.setPackageList(disPackageDomains);
        return disContractDomain;
    }

    private List<DisPackageDomain> makeDisPackageDomain(List<Map<String, Object>> goodGroup, DisContractDomain disContractDomain) {
        if (ListUtil.isEmpty(goodGroup)) {
            return null;
        }
        ArrayList<DisPackageDomain> rePagList = new ArrayList<DisPackageDomain>();
        DisPackageDomain pag = new DisPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pag, (Object)disContractDomain);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".makeDisPackageDomain.e", (Throwable)e);
        }
        List<DisContractGoodsDomain> goodsList = this.makeDisContractGoodsDomain(goodGroup, pag, disContractDomain);
        pag.setContractGoodsList(goodsList);
        disContractDomain.setGoodsMoney(pag.getGoodsInmoney());
        disContractDomain.setGoodsNum(pag.getGoodsNum());
        disContractDomain.setDataBnum(pag.getGoodsNum());
        disContractDomain.setGoodsWeight(pag.getGoodsWeight());
        disContractDomain.setDataBweight(pag.getGoodsWeight());
        rePagList.add(pag);
        return rePagList;
    }

    private List<DisContractGoodsDomain> makeDisContractGoodsDomain(List<Map<String, Object>> items, DisPackageDomain disPackageDomain, DisContractDomain disContractDomain) {
        if (ListUtil.isEmpty(items)) {
            return null;
        }
        ArrayList<DisContractGoodsDomain> goodsDomainList = new ArrayList<DisContractGoodsDomain>();
        DisContractGoodsDomain disContractGoodsDomain = null;
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal goodsInmoney = BigDecimal.ZERO;
        BigDecimal goodsPef = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        for (Map<String, Object> oGoodsItem : items) {
            disContractGoodsDomain = new DisContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)disPackageDomain);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".makeDisContractGoodsDomain.e", (Throwable)e);
            }
            GoodsBean goodsBean = this.getResourceBySkuNo((String)oGoodsItem.get("skuIdIsv"), disContractDomain.getMemberCode(), disContractDomain.getMemberCcode(), disContractDomain.getChannelCode(), disContractDomain.getTenantCode());
            if (null != goodsBean && null != goodsBean.getRsSku()) {
                disContractGoodsDomain.setSkuCode(goodsBean.getRsSku().getSkuCode());
            }
            disContractGoodsDomain.setSkuNo((String)oGoodsItem.get("skuIdIsv"));
            disContractGoodsDomain.setSkuEocode(String.valueOf(oGoodsItem.get("skuId")));
            disContractGoodsDomain.setGoodsEocode(String.valueOf(oGoodsItem.get("skuIdIsv")));
            disContractGoodsDomain.setSkuName((String)oGoodsItem.get("skuName"));
            disContractGoodsDomain.setGoodsName((String)oGoodsItem.get("skuName"));
            disContractGoodsDomain.setContractGoodsGtype("0");
            disContractGoodsDomain.setPricesetNprice(BigDecimal.valueOf(((Integer)oGoodsItem.get("skuStorePrice")).intValue()).divide(new BigDecimal(100)));
            disContractGoodsDomain.setContractGoodsPrice(BigDecimal.valueOf(((Integer)oGoodsItem.get("skuJdPrice")).intValue()).divide(new BigDecimal(100)));
            if (null == disContractGoodsDomain.getContractGoodsPrice() || disContractGoodsDomain.getContractGoodsPrice().compareTo(BigDecimal.ZERO) <= 0) {
                disContractGoodsDomain.setContractGoodsPrice(disContractGoodsDomain.getPricesetNprice());
            }
            BigDecimal goodsNum = BigDecimal.valueOf(((Integer)oGoodsItem.get("skuCount")).intValue());
            Object skuWeight = oGoodsItem.get("skuWeight");
            BigDecimal goodsWeight = new BigDecimal(String.valueOf(skuWeight));
            disContractGoodsDomain.setGoodsCamount(goodsNum);
            disContractGoodsDomain.setGoodsNum(goodsNum);
            disContractGoodsDomain.setGoodsCweight(goodsWeight);
            disContractGoodsDomain.setGoodsWeight(goodsWeight);
            disContractGoodsDomain.setContractGoodsInmoney(disContractGoodsDomain.getPricesetNprice().multiply(goodsNum));
            disContractGoodsDomain.setContractGoodsMoney(disContractGoodsDomain.getContractGoodsPrice().multiply(goodsNum));
            disContractGoodsDomain.setGoodsSpecs((String)oGoodsItem.get("skuCostumeProperty"));
            if (null == disContractGoodsDomain.getGoodsNum()) {
                disContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            packageGoodsNum = packageGoodsNum.add(disContractGoodsDomain.getGoodsNum());
            if (null == disContractGoodsDomain.getContractGoodsInmoney()) {
                disContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            goodsInmoney = goodsInmoney.add(disContractGoodsDomain.getContractGoodsInmoney());
            if (null == disContractGoodsDomain.getContractGoodsMoney()) {
                disContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            goodsMoney = goodsMoney.add(disContractGoodsDomain.getContractGoodsMoney());
            if (null == disContractGoodsDomain.getContractGoodsPefinmoney()) {
                disContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            goodsPef = goodsPef.add(disContractGoodsDomain.getContractGoodsPefinmoney());
            if (null == disContractGoodsDomain.getGoodsWeight()) {
                disContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            packageGoodsWeight = packageGoodsWeight.add(disContractGoodsDomain.getGoodsWeight());
            goodsDomainList.add(disContractGoodsDomain);
        }
        disPackageDomain.setGoodsWeight(packageGoodsWeight);
        disPackageDomain.setGoodsNum(packageGoodsNum);
        disPackageDomain.setMemberBcode(disContractDomain.getMemberBcode());
        disPackageDomain.setMemberBname(disContractDomain.getMemberBname());
        disPackageDomain.setGoodsMoney(goodsInmoney);
        disPackageDomain.setPricesetRefrice(goodsPef);
        disPackageDomain.setGoodsPmoney(goodsMoney);
        disPackageDomain.setGoodsInmoney(goodsMoney);
        return goodsDomainList;
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName, String contractproValue1) {
        if (null == disContractDomain || StringUtils.isBlank((String)contractproKey) || StringUtils.isBlank((String)contractproValue) || StringUtils.isBlank((String)contractproName)) {
            return;
        }
        DisContractproDomain contractproDomain = new DisContractproDomain();
        contractproDomain.setContractproKey(contractproKey);
        contractproDomain.setContractproValue(contractproValue);
        contractproDomain.setContractproName(contractproName);
        contractproDomain.setContractproValue1(contractproValue1);
        this.setContractPro(disContractDomain, contractproDomain);
    }

    private void setContractPro(DisContractDomain disContractDomain, String contractproKey, String contractproValue, String contractproName) {
        this.setContractPro(disContractDomain, contractproKey, contractproValue, contractproName, null);
    }

    private void setContractPro(DisContractDomain disContractDomain, DisContractproDomain disContractproDomain) {
        if (null == disContractDomain || null == disContractproDomain) {
            return;
        }
        ArrayList<DisContractproDomain> disContractproDomainList = disContractDomain.getOcContractproDomainList();
        if (null == disContractproDomainList) {
            disContractproDomainList = new ArrayList<DisContractproDomain>();
            disContractDomain.setOcContractproDomainList(disContractproDomainList);
        }
        disContractproDomainList.add(disContractproDomain);
    }

    public Map<String, Object> buildOrderParam(Map<String, Object> map) {
        return map;
    }

    private String decodeParam(String detail) {
        if (StringUtils.isBlank((String)detail)) {
            return null;
        }
        try {
            detail = new String(detail.getBytes("ISO-8859-1"), "utf-8");
            detail = URLDecoder.decode(detail, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".decodeParam", (Object)("=======" + e));
        }
        return detail;
    }

    public String saveOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        this.logger.error(this.SYS_CODE + "saveOrderParam.come====", (Object)sendhttpParam.toString());
        if (null == sendhttpParam || null == sendhttpParam.get("jd_param_json")) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jd_param_json is null!", (Object)sendhttpParam.toString());
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        String jdParamList = this.decodeParam((String)sendhttpParam.get("jd_param_json"));
        if (StringUtils.isBlank((String)jdParamList)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jd_param_json", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jd_param_json");
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jdParamList, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            this.logger.error(this.SYS_CODE + "saveOrderParam.jsonToMap", (Object)sendhttpParam.toString());
            return this.resultReturn("-1", "ERROR", "jsonToMap");
        }
        String methodType = (String)sendhttpParam.get("methodType");
        if ("afterSaleBillStatus".equals(methodType) || "newAfterSaleBill".equals(methodType) || "newApplyAfterSaleBill".equals(methodType) || "updateApplyAfterSaleBill".equals(methodType)) {
            this.logger.error(this.SYS_CODE, (Object)("come!!!" + jsonToMap + "=:=" + methodType));
            String str = this.disRefundService.saveSendRefundState(sendhttpParam);
            this.logger.error(this.SYS_CODE, (Object)("come =:=" + str + "=:=" + methodType));
            return str;
        }
        String memberCode = (String)sendhttpParam.get("memberCode");
        String tenantCode = (String)sendhttpParam.get("tenantCode");
        if (null == jsonToMap.get("billId") && null == jsonToMap.get("statusId") && null == jsonToMap.get("timestamp")) {
            if (null == jsonToMap.get("orderId")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.orderId is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String orderId = (String)jsonToMap.get("orderId");
            if (null == jsonToMap.get("deliveryStatus")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryStatus is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String deliveryStatus = (String)jsonToMap.get("deliveryStatus");
            if (null == jsonToMap.get("deliveryStatusTime")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryStatusTime is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("deliveryCarrierNo")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryCarrierNo is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("deliveryCarrierName")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.deliveryCarrierName is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("createPin")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.createPin is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == jsonToMap.get("opTime")) {
                this.logger.error(this.SYS_CODE + "saveOrderParam.saveSendOrderState.opTime is null!", (Object)("====" + sendhttpParam.toString() + "####" + jsonToMap.toString()));
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (null == this.getContractByNbCode(disChannel.getTenantCode(), orderId, disChannel)) {
                DisContractDomain disContractDomain = this.getSendOrder(orderId, memberCode, tenantCode);
                ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                if (null != disContractDomain) {
                    disContractList.add(disContractDomain);
                }
                try {
                    this.saveOrder(disContractList, disChannel);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".saveOrderParam1111.saveOrder");
                }
            }
            if ("32000".equals(deliveryStatus)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), deliveryStatus);
            if ("33060".equals(dataStateStr) || "20020".equals(dataStateStr)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
                dataStateStr = String.valueOf(deliveryStatus);
            }
            Integer dataState = Integer.valueOf(dataStateStr);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataStatestr", deliveryStatus);
            try {
                this.updateOrder(disChannel.getTenantCode(), orderId, dataState, null, map, disChannel);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".updateOrder000 result is error");
            }
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        if (null != jsonToMap.get("billId") && null != jsonToMap.get("statusId") && null != jsonToMap.get("timestamp")) {
            String billId = (String)jsonToMap.get("billId");
            String statusId = (String)jsonToMap.get("statusId");
            if (null == this.getContractByNbCode(disChannel.getTenantCode(), billId, disChannel)) {
                DisContractDomain disContractDomain = this.getSendOrder(billId, memberCode, tenantCode);
                ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
                if (null != disContractDomain) {
                    disContractList.add(disContractDomain);
                }
                try {
                    this.saveOrder(disContractList, disChannel);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".saveOrderParam1111.saveOrder");
                }
            }
            if ("pickFinishOrder".equals(methodType) && "2".equals(statusId)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            if ("applyCancelOrder".equals(methodType)) {
                if (StringUtils.isBlank((String)billId) || StringUtils.isBlank((String)statusId)) {
                    this.logger.error(this.SYS_CODE + ".applyCancelOrder:", (Object)("billId:" + billId + ";statusId:" + statusId + "=:=" + jsonToMap));
                    return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
                }
                if ("20030".equals(statusId)) {
                    return this.buildRefund(disChannel, billId, statusId, memberCode, tenantCode, jsonToMap);
                }
            }
            if ("32000".equals(statusId)) {
                return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
            }
            String dataStateStr = this.getOrderState(disChannel.getTenantCode(), disChannel.getChannelCode(), statusId);
            if (StringUtils.isBlank((String)dataStateStr) || "null".equals(dataStateStr)) {
                dataStateStr = String.valueOf(statusId);
            }
            Integer dataState = Integer.valueOf(dataStateStr);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dataStatestr", statusId);
            try {
                this.updateOrder(disChannel.getTenantCode(), billId, dataState, null, map, disChannel);
            }
            catch (Exception e) {
                // empty catch block
            }
            if ("20032".equals(statusId) || "20020".equals(statusId)) {
                DisRefundReDomain disRefundReDomain = this.getRefundByNbillcode(disChannel.getTenantCode(), billId, disChannel);
                if (null != disRefundReDomain) {
                    HashMap<String, String> mapP = new HashMap<String, String>();
                    mapP.put("dataStatestr", statusId);
                    this.sendUpdateRefundStateByCode(disChannel.getTenantCode(), disRefundReDomain.getRefundCode(), disChannel.getChannelCode(), Integer.parseInt(statusId), disRefundReDomain.getDataState(), mapP);
                } else {
                    return this.buildRefund(disChannel, billId, statusId, memberCode, tenantCode, jsonToMap);
                }
            }
            return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
        }
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private String buildRefund(DisChannel disChannel, String billId, String statusId, String memberCode, String tenantCode, Map<String, Object> jsonToMap) {
        DisContractDomain disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), billId, disChannel);
        if (null == disContractDomain) {
            disContractDomain = this.getSendOrder(billId, memberCode, tenantCode);
            if (null == disContractDomain) {
                this.logger.error(this.SYS_CODE + ".applyCancelOrder.disContractDomain is null", (Object)billId);
                return this.resultReturn("-1", "ERROR", "jd_param_json");
            }
            ArrayList<DisContractDomain> disContractList = new ArrayList<DisContractDomain>();
            disContractList.add(disContractDomain);
            this.saveOrder(disContractList, disChannel);
            disContractDomain = this.getContractByNbCode(disChannel.getTenantCode(), billId, disChannel);
        }
        if (null == (disContractDomain = this.getContractDomainByCode(disChannel.getTenantCode(), disContractDomain.getContractBillcode(), disChannel))) {
            this.logger.error(this.SYS_CODE + ".applyCancelOrder.disContractDomain is null", (Object)(billId + "=:=" + disContractDomain.getContractBillcode()));
            return null;
        }
        DisRefundDomain disRefundDomain = this.createRefundJddj2(disContractDomain, disChannel, this.getQueryParamMap("billId,statusId,remark,timestamp", new Object[]{billId, statusId, jsonToMap.get("remark"), jsonToMap.get("timestamp")}));
        ArrayList<DisRefundDomain> disRefundDomainList = new ArrayList<DisRefundDomain>();
        disRefundDomainList.add(disRefundDomain);
        this.logger.error(this.SYS_CODE + " disRefundDomainList jddj2 : ", (Object)(disRefundDomainList.size() + " =:= " + disRefundDomainList));
        this.saveRefund(disRefundDomainList, disChannel);
        return this.resultReturn("0", "SUCCESS", "\u64cd\u4f5c\u6210\u529f");
    }

    private String resultReturn(String code, String msg, String data) {
        String result = "{\"code\":\"" + code + '\"' + ",\"msg\":" + '\"' + msg + '\"' + ",\"data\":\"" + data + "\"}";
        return result;
    }

    private String payType(Integer payChannel) {
        if (null == payChannel) {
            this.logger.error(this.SYS_CODE + ".payType", (Object)"param is null");
            return null;
        }
        String faccountName = "";
        switch (payChannel) {
            case 8001: {
                faccountName = "\u5fae\u4fe1\u652f\u4ed8";
                break;
            }
            case 8002: {
                faccountName = "\u5fae\u4fe1\u514d\u5bc6\u4ee3\u6263";
                break;
            }
            case 8003: {
                faccountName = "\u5fae\u4fe1\u627e\u4eba\u4ee3\u4ed8";
                break;
            }
            case 9000: {
                faccountName = "\u4eac\u4e1c\u652f\u4ed8";
                break;
            }
            case 9002: {
                faccountName = "\u4eac\u4e1c\u94f6\u884c\u5361\u652f\u4ed8";
                break;
            }
            case 9004: {
                faccountName = "\u4eac\u4e1c\u767d\u6761\u652f\u4ed8";
                break;
            }
            case 9012: {
                faccountName = "\u4eac\u4e1c\u4f59\u989d\u652f\u4ed8";
                break;
            }
            case 9022: {
                faccountName = "\u4eac\u4e1c\u5c0f\u91d1\u5e93\u652f\u4ed8";
                break;
            }
            default: {
                faccountName = "\u5176\u4ed6\u65b9\u5f0f\u652f\u4ed8";
            }
        }
        return faccountName;
    }

    private void creatOrder(DisChannel disChannel, Map<String, Object> sendhttpParam) {
        DisContractDomain disContractDomain = this.createOrder(sendhttpParam, disChannel);
        if (null == disContractDomain) {
            return;
        }
        ArrayList<DisContractDomain> disContractDomainList = new ArrayList<DisContractDomain>();
        disContractDomainList.add(disContractDomain);
        try {
            this.saveOrder(disContractDomainList, disChannel);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".creatOrder", (Object)("====" + disChannel.toString() + "#########" + disContractDomain.toString() + "@@@@@@@@@" + sendhttpParam.toString() + "----------"));
        }
    }
}

