/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdvop.goods.service;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.GetSkuPoolInfoGoodsResp;
import com.jd.open.api.sdk.domain.vopsp.SkuPoolGoodsProvider.response.getSkuPoolInfo.GetSkuPoolInfoItemGoodsResp;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.JdResponseMessageContentDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.PoolSkubean;
import com.yqbsoft.laser.service.ext.channel.jdvop.es.SendDataPutThread;
import com.yqbsoft.laser.service.ext.channel.jdvop.goods.EsGoodsService;
import com.yqbsoft.laser.service.ext.channel.jdvop.goods.service.DisGoodsServiceImpl;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.JdBeanUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EsGoodsServiceImpl
extends DisGoodsServiceImpl
implements EsGoodsService {
    private String SYS_CODE = "jdvop.EsGoodsServiceImpl";
    private static final String RESOURCEGOODS_GETNO_API_CODE = "rs.resourceGoods.getResourceBySkuNo";
    private static final String RESOURCEGOODS_DEL_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SOLD_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SHELVE_CODE = "rs.resource.sendUpdateShelveBatchSku";

    @Override
    public void saveGoodsPool(PoolSkubean poolSkubean) {
        if (null == poolSkubean) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.poolSkubean", (Object)"===>parm is null");
            return;
        }
        GetSkuPoolInfoItemGoodsResp poolInfo = poolSkubean.getPoolInfo();
        if (null == poolInfo) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.poolInfo", (Object)"===>parm is null");
            return;
        }
        DisChannel disChannel = poolSkubean.getDisChannel();
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.poolInfo", (Object)"===>parm is null");
            return;
        }
        String tenantCode = disChannel.getTenantCode();
        JdClient client = poolSkubean.getClient();
        if (null == client) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.client", (Object)"===>parm is null");
            return;
        }
        this.saveGoodsPool(poolInfo, disChannel, tenantCode, client, poolSkubean);
    }

    @Override
    public void saveGoodsPrice(PoolSkubean poolSkubean) {
        if (null == poolSkubean) {
            return;
        }
        GetSkuPoolInfoItemGoodsResp poolInfo = poolSkubean.getPoolInfo();
        DisChannel disChannel = poolSkubean.getDisChannel();
        JdClient client = poolSkubean.getClient();
        try {
            this.synJdVopPrice(disChannel, client, poolInfo, poolSkubean);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPrice.e", (Throwable)e);
        }
    }

    @Override
    public boolean saveVopJdSkuIds(PoolSkubean poolSkubean) {
        this.logger.error(this.SYS_CODE + ".saveVopJdSkuIds.e", (Object)JsonUtil.buildNormalBinder().toJson((Object)poolSkubean));
        return this.saveGoodsSkuStr(poolSkubean.getPoolInfo(), poolSkubean.getDisChannel(), poolSkubean.getTenantCode(), poolSkubean.getClient(), poolSkubean.getItems(), poolSkubean);
    }

    @Override
    public void updateGoodsInfo(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        this.logger.error(this.SYS_CODE + ".updateGoodsInfo.e", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            this.logger.error(this.SYS_CODE + ".contentMap>>>>>>>>>>>>>>>>" + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".updateGoodsInfo \u901a\u8fc7skuId\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0cskuId = " + skuId);
                return;
            }
            ArrayList<Long> addGoodsVopIds = new ArrayList<Long>();
            RsResourceGoodsDomain rsResourceGoods = goodsBean.getRsResourceGoods();
            addGoodsVopIds.add(Long.parseLong(rsResourceGoods.getGoodsNo()));
            JdClient client = this.getJdClient(jdResponseMessageContentDomain);
            this.updateGoodsSku(client, addGoodsVopIds, jdResponseMessageContentDomain.getDisChannel(), jdResponseMessageContentDomain.getDisChannel().getTenantCode());
        }
    }

    @Override
    public void putOrOffGoods(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        this.logger.error(this.SYS_CODE + ".putOrOffGoods.e", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        String state = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            this.logger.error(this.SYS_CODE + ".contentMap>>>>>>>>>>>>>>>>" + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            ArrayList<String> goodsIds = new ArrayList<String>();
            goodsIds.add(skuId);
            state = JsonUtil.buildNormalBinder().toJson(contentMap.get("state"));
            this.soldOrShelveGoodsByGoodsIds(goodsIds, state, jdResponseMessageContentDomain.getDisChannel().getTenantCode(), jdResponseMessageContentDomain.getDisChannel());
        }
    }

    @Override
    public void addOrRemoveGoods(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        String pageNum = null;
        if (!MapUtil.isNotEmpty(contentMap)) {
            this.logger.error(this.SYS_CODE + ".addOrRemoveGoods \u4eac\u4e1c\u8fd4\u56de\u6d88\u606f\u5185\u5bb9\u9519\u8bef\uff0ccontent= " + content);
            return;
        }
        skuId = contentMap.get("skuId").toString();
        pageNum = contentMap.get("page_num").toString();
        GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        if (goodsBean != null) {
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
        }
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoods contentMap= " + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
        if ("1".equals(contentMap.get("state").toString())) {
            if (null != goodsBean) {
                this.logger.error(this.SYS_CODE + ".addGoods \u83b7\u53d6goodsBean \u5931\u8d25\uff0cskuId= " + skuId);
                return;
            }
        } else if ("2".equals(contentMap.get("state").toString())) {
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".RemoveGoods \u83b7\u53d6goodsBean \u5931\u8d25\uff0cskuId= " + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".RemoveGoods goodsIds= ", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsIds));
            this.delGoodsByGoodsIds(goodsIds);
        }
    }

    private void delGoodsByGoodsIds(List<Integer> goodsIds) {
        this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", goodsIds);
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        HashMap<String, List<Integer>> params = new HashMap<String, List<Integer>>();
        try {
            params.put("goodsIds", goodsIds);
            this.logger.error(this.SYS_CODE + ".deletePromotioneToGoods.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u5220\u9664\u5931\u8d25", (Object)e.getMessage());
            throw new ApiException(this.SYS_CODE + ".delGoodsByGoodsIds.ex", (Throwable)e);
        }
    }

    private void addGoodsBySkuId(Long skuId, String pageNum, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        PoolSkubean poolSkubean = new PoolSkubean();
        GetSkuPoolInfoItemGoodsResp poolInfo = new GetSkuPoolInfoItemGoodsResp();
        ArrayList<PoolSkubean> poolSkubeanList = new ArrayList<PoolSkubean>();
        DisChannel disChannel = jdResponseMessageContentDomain.getDisChannel();
        String tenantCode = disChannel.getTenantCode();
        JdClient client = this.getJdClient(jdResponseMessageContentDomain);
        poolSkubean.setDisChannel(disChannel);
        poolSkubean.setPoolInfo(poolInfo);
        poolSkubean.setTenantCode(tenantCode);
        poolSkubean.setClient(client);
        poolSkubean.setKeymap(jdResponseMessageContentDomain.getKeyMap());
        ArrayList<Long> items = new ArrayList<Long>();
        items.add(skuId);
        poolSkubean.setItems(items);
        this.logger.error(this.SYS_CODE + ".addGoodsBySkuId poolSkubean", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)poolSkubean));
        poolSkubeanList.add(poolSkubean);
        this.logger.error(this.SYS_CODE + ".addGoodsBySkuId poolSkubeanList", (Object)JsonUtil.buildNonDefaultBinder().toJson(poolSkubeanList));
        EsGoodsServiceImpl.getSendDataService().addPutPool(new SendDataPutThread(EsGoodsServiceImpl.getSendDataService(), poolSkubeanList));
    }

    private void soldOrShelveGoodsByGoodsIds(List<String> skuId, String type, String tenantCode, DisChannel disChannel) {
        if (ListUtil.isEmpty(skuId) || StringUtils.isBlank((String)type)) {
            this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", (Object)(skuId + "===" + type));
            return;
        }
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        for (String list : skuId) {
            GoodsBean goodsBean = this.getGoodsBySkuNo(list, disChannel);
            RsSkuDomain rsSku = goodsBean.getRsSku();
            if (rsSku == null) {
                this.logger.error(this.SYS_CODE + ".contentMap---------------" + JsonUtil.buildNonEmptyBinder().toJson((Object)goodsBean));
            }
            goodsIds.add(rsSku.getSkuId());
            this.logger.error(this.SYS_CODE + ".contentMap==========>" + JsonUtil.buildNonEmptyBinder().toJson(goodsIds));
            if (!ListUtil.isNotEmpty(goodsIds)) continue;
            HashMap<String, ArrayList<Integer>> params = new HashMap<String, ArrayList<Integer>>();
            try {
                params.put("skuIdList", goodsIds);
                this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
                if ("0".equals(type)) {
                    this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
                    continue;
                }
                if (!"1".equals(type)) continue;
                this.getInternalRouter().inInvoke(RESOURCEGOODS_SHELVE_CODE, params);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u4e0a/\u4e0b\u67b6\u5931\u8d25", (Object)e.getMessage());
                throw new ApiException(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.ex", (Throwable)e);
            }
        }
    }

    @Override
    public String updateGoodsSku(JdClient client, List<Long> skuId, DisChannel disChannel, String tenantCode) {
        for (Long skuids : skuId) {
            GetSkuPoolInfoGoodsResp jdVopGoodsInfo = null;
            try {
                jdVopGoodsInfo = this.getSkuPoolInfoGoodsResp(client, skuids);
            }
            catch (Exception e1) {
                this.logger.error(this.SYS_CODE + ".saveGoods.jdVopGoodsInfo.e1", (Throwable)e1);
                return "SUCCESS";
            }
            if (null == jdVopGoodsInfo) {
                this.logger.error(this.SYS_CODE + ".saveGoods.jdVopGoodsInfo.null", skuId);
                return "SUCCESS";
            }
            String pntreeCode = EsGoodsServiceImpl.getPntreeCode(tenantCode);
            if (StringUtils.isBlank((String)pntreeCode)) {
                this.logger.error(this.SYS_CODE + ".saveGoodsPool.pntreeCode", (Object)"=====>pntreeCode");
                return "ERROR";
            }
            this.updateInformation(client, jdVopGoodsInfo, disChannel, tenantCode, brandMap, inClasstreeCode, pntreeCode, String.valueOf(skuids));
        }
        return "SUCCESS";
    }

    private GoodsBean getGoodsBySkuNo(String skuNo, DisChannel disChannel) {
        if (StringUtils.isBlank((String)skuNo) || null == disChannel) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", disChannel.getMemberCcode());
        params.put("memberCcode", disChannel.getMemberCcode());
        params.put("channelCode", null);
        params.put("tenantCode", disChannel.getTenantCode());
        this.logger.error(this.SYS_CODE + ".getGoodsBySkuNo" + JsonUtil.buildNonEmptyBinder().toJson(params));
        return (GoodsBean)this.getForObject(RESOURCEGOODS_GETNO_API_CODE, GoodsBean.class, params);
    }

    private JdClient getJdClient(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String tenantCode = jdResponseMessageContentDomain.getDisChannel().getTenantCode();
        String channelCode = jdResponseMessageContentDomain.getDisChannel().getChannelCode();
        String memberCode = jdResponseMessageContentDomain.getDisChannel().getMemberCcode();
        String accessToken = this.getToken(tenantCode, channelCode, memberCode);
        String serverUrl = (String)jdResponseMessageContentDomain.getKeyMap().get("serverUrl");
        String appKey = (String)jdResponseMessageContentDomain.getKeyMap().get("appKey");
        String appSecret = (String)jdResponseMessageContentDomain.getKeyMap().get("appSecret");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        return client;
    }
}

