/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdvop.util;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.vopsh.QueryAfterSaleOpenProvider.response.getAfsOutline.OpenPagingResult;
import com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.checkSkuSaleList.CheckSkuSaleGoodsResp;
import com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.checkSkuSaleList.OpenRpcResult;
import com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSellPrice.GetSellPriceGoodsResp;
import com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.queryTransByVopNormal.VopBizTransMessage;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.vopsh.VopAfsGetAfsOutlineRequest;
import com.jd.open.api.sdk.request.vopsp.VopGoodsCheckSkuSaleListRequest;
import com.jd.open.api.sdk.request.vopsp.VopGoodsGetSellPriceRequest;
import com.jd.open.api.sdk.request.vopsp.VopGoodsGetSkuDetailInfoRequest;
import com.jd.open.api.sdk.request.vopxx.VopMessageDeleteClientMsgByIdListRequest;
import com.jd.open.api.sdk.request.vopxx.VopMessageQueryTransByVopNormalRequest;
import com.jd.open.api.sdk.response.vopsh.VopAfsGetAfsOutlineResponse;
import com.jd.open.api.sdk.response.vopsp.VopGoodsCheckSkuSaleListResponse;
import com.jd.open.api.sdk.response.vopsp.VopGoodsGetSellPriceResponse;
import com.jd.open.api.sdk.response.vopsp.VopGoodsGetSkuDetailInfoResponse;
import com.jd.open.api.sdk.response.vopxx.VopMessageDeleteClientMsgByIdListResponse;
import com.jd.open.api.sdk.response.vopxx.VopMessageQueryTransByVopNormalResponse;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.JdResponseMessageContentDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.enums.ResultCode;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.UtilResultBean;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdInterfaceUtil {
    private static final String SYS_CODE = "JdInterfaceUtil";
    private Logger logger = LoggerFactory.getLogger(JdInterfaceUtil.class);

    public static JdClient getJdClient(JdResponseMessageContentDomain jdResponseMessageContentDomain, String accessToken) {
        Map<String, Object> keyMap = jdResponseMessageContentDomain.getKeyMap();
        String serverUrl = keyMap.get("serverUrl").toString();
        String appKey = (String)keyMap.get("key");
        String appSecret = (String)keyMap.get("secret");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        return client;
    }

    public static UtilResultBean<List<String>> checkSkuSaleGoodsReq(JdClient client, String skuIds, int type) {
        if (1 != type || 2 != type) {
            return UtilResultBean.errorResult("type \u7c7b\u578b\u9519\u8bef");
        }
        UtilResultBean result = UtilResultBean.successResult(null);
        UtilResultBean<OpenRpcResult> openRpcResultUtilResultBean = JdInterfaceUtil.queryCheckSaleGoods(client, skuIds);
        if (ResultCode.ERROR.getCode().equals(openRpcResultUtilResultBean.getCode())) {
            result = UtilResultBean.copyProperties(openRpcResultUtilResultBean, result);
            return result;
        }
        OpenRpcResult openRpcResult = openRpcResultUtilResultBean.getData();
        ArrayList<String> goodsStateOffList = new ArrayList<String>();
        ArrayList<String> goodsStatePutList = new ArrayList<String>();
        List checkSkuSaleGoodsRespList = null;
        if ("2004".equals(openRpcResult.getResultCode())) {
            String message = openRpcResult.getResultMessage();
            StringBuffer messageBuffer = new StringBuffer(message);
            messageBuffer.delete(messageBuffer.indexOf("\u4e0d\u5728"), messageBuffer.length());
            String[] skuIdsError = messageBuffer.toString().split(",");
            StringBuffer skuIdsTow = new StringBuffer();
            for (int i = 0; i < skuIdsError.length; ++i) {
                goodsStateOffList.add(skuIdsError[i]);
            }
            for (String skuId : skuIds.split(",")) {
                if (!messageBuffer.toString().contains(skuId)) continue;
                skuIdsTow.append(skuId).append(",");
            }
            skuIdsTow.delete(skuIdsTow.lastIndexOf(","), skuIdsTow.length());
            UtilResultBean<OpenRpcResult> openRpcResultUtilResultBeanTow = JdInterfaceUtil.queryCheckSaleGoods(client, skuIdsTow.toString());
            if (openRpcResult.getSuccess()) {
                checkSkuSaleGoodsRespList = openRpcResultUtilResultBeanTow.getData().getResult();
            }
        }
        if (openRpcResult.getSuccess()) {
            checkSkuSaleGoodsRespList = openRpcResult.getResult();
        }
        if (ListUtil.isEmpty(checkSkuSaleGoodsRespList)) {
            return UtilResultBean.errorResult("JdInterfaceUtil.queryCheckSaleGoods \u4eac\u4e1c\u8fd4\u56de\u53ef\u552e\u6027skuId \u4e3a\u7a7a");
        }
        for (CheckSkuSaleGoodsResp checkSkuSaleGoodsResp : checkSkuSaleGoodsRespList) {
            String skuId = String.valueOf(checkSkuSaleGoodsResp.getSkuId());
            if (1 == checkSkuSaleGoodsResp.getSaleState()) {
                UtilResultBean<Boolean> checkGoodsStatePutResult = JdInterfaceUtil.checkGoodsStatePut(client, skuId);
                if (ResultCode.ERROR.getCode().equals(checkGoodsStatePutResult.getCode())) {
                    return UtilResultBean.copyProperties(checkGoodsStatePutResult, result);
                }
                if (checkGoodsStatePutResult.getData().booleanValue()) {
                    goodsStatePutList.add(skuId);
                    continue;
                }
                goodsStateOffList.add(skuId);
                continue;
            }
            if (2 != checkSkuSaleGoodsResp.getSaleState() && (null == checkSkuSaleGoodsResp.getBanCause() || !checkSkuSaleGoodsResp.getBanCause().contains("\u4e0b\u67b6"))) continue;
            goodsStateOffList.add(skuId);
        }
        if (1 == type) {
            result.setData(goodsStatePutList);
        } else if (2 == type) {
            result.setData(goodsStateOffList);
        }
        return result;
    }

    public static UtilResultBean<Boolean> checkGoodsStatePut(JdClient client, String skuId) {
        UtilResultBean<com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.OpenRpcResult> openRpcResultUtilResultBean = JdInterfaceUtil.jdvopGoodsDetailInfo(client, skuId);
        if (ResultCode.ERROR.getCode().equals(openRpcResultUtilResultBean.getCode())) {
            return UtilResultBean.errorResult(openRpcResultUtilResultBean.getMessage());
        }
        com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.OpenRpcResult openRpcResult = openRpcResultUtilResultBean.getData();
        if (1 == openRpcResult.getResult().getSkuState()) {
            return UtilResultBean.successResult(true);
        }
        if (2 == openRpcResult.getResult().getSkuState()) {
            return UtilResultBean.successResult(false);
        }
        return UtilResultBean.errorResult("JdInterfaceUtil.checkGoodsStatePut \u4eac\u4e1c\u8fd4\u56de\u4e3b\u7ad9\u4e0a\u4e0b\u67b6\u72b6\u6001\uff1a" + JsonUtil.buildNonEmptyBinder().toJson((Object)openRpcResult.getResult()));
    }

    public static UtilResultBean<com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.OpenRpcResult> jdvopGoodsDetailInfo(JdClient client, String skuId) {
        if (null == client) {
            return UtilResultBean.errorResult("JdInterfaceUtil.jdvopGoodsDetailInfo \u4eac\u4e1c\u8bf7\u6c42\u5ba2\u6237\u7aef\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)skuId)) {
            return UtilResultBean.errorResult("JdInterfaceUtilqueryJdvopGoodsDetailInfo skuId \u53c2\u6570\u4e3a\u7a7a");
        }
        VopGoodsGetSkuDetailInfoRequest request = new VopGoodsGetSkuDetailInfoRequest();
        request.setSkuId(Long.valueOf(skuId).longValue());
        try {
            VopGoodsGetSkuDetailInfoResponse response = (VopGoodsGetSkuDetailInfoResponse)client.execute((JdRequest)request);
            if (null == response) {
                return UtilResultBean.errorResult("JdInterfaceUtilJdInterfaceUtilqueryJdvopGoodsDetailInfo \u67e5\u8be2\u4eac\u4e1cvop\u5546\u54c1\u8be6\u60c5\u63a5\u53e3\u9519\u8bef " + JsonUtil.buildNonEmptyBinder().toJson((Object)response));
            }
            com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.OpenRpcResult openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult || !openRpcResult.getSuccess()) {
                return UtilResultBean.errorResult("JdInterfaceUtilqueryJdvopGoodsDetailInfo \u67e5\u8be2\u4eac\u4e1cvop\u5546\u54c1\u8be6\u60c5\u63a5\u53e3\u9519\u8bef " + JsonUtil.buildNonDefaultBinder().toJson((Object)openRpcResult));
            }
            return UtilResultBean.successResult(openRpcResult);
        }
        catch (Exception e) {
            return UtilResultBean.exceptionResult("JdInterfaceUtilqueryJdvopGoodsDetailInfo ", e);
        }
    }

    public static UtilResultBean<OpenRpcResult> queryCheckSaleGoods(JdClient client, String skuIds) {
        if (null == client) {
            return UtilResultBean.errorResult("JdInterfaceUtil.queryCheckSaleGoods.client.null");
        }
        if (StringUtils.isBlank((String)skuIds)) {
            return UtilResultBean.errorResult("JdInterfaceUtil.queryCheckSaleGoods.skuIds.null");
        }
        VopGoodsCheckSkuSaleListRequest request = new VopGoodsCheckSkuSaleListRequest();
        request.setSkuId(skuIds);
        try {
            VopGoodsCheckSkuSaleListResponse response = (VopGoodsCheckSkuSaleListResponse)client.execute((JdRequest)request);
            if (null == response) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryCheckSaleGoods.response.null");
            }
            OpenRpcResult openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult || !openRpcResult.getSuccess()) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryCheckSaleGoods.openRpcResult.null");
            }
            return UtilResultBean.successResult(openRpcResult);
        }
        catch (Exception e) {
            return UtilResultBean.exceptionResult("JdInterfaceUtilqueryCheckSaleGoods.exception", e);
        }
    }

    public static UtilResultBean<List<GetSellPriceGoodsResp>> queryGoodsPrice(String skuId, JdClient client) {
        VopGoodsGetSellPriceRequest request = new VopGoodsGetSellPriceRequest();
        request.setSkuId(skuId);
        try {
            VopGoodsGetSellPriceResponse response = (VopGoodsGetSellPriceResponse)client.execute((JdRequest)request);
            if (null == response) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryGoodsPrice.response is null");
            }
            com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSellPrice.OpenRpcResult openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult || !openRpcResult.getSuccess()) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryGoodsPrice.openRpcResult is null");
            }
            List getSellPriceGoodsResps = openRpcResult.getResult();
            return UtilResultBean.successResult(getSellPriceGoodsResps);
        }
        catch (Exception exception) {
            return UtilResultBean.exceptionResult("JdInterfaceUtil.queryGoodsPrice exception", exception);
        }
    }

    public static UtilResultBean<OpenPagingResult> queryJdRefundDetail(JdClient jdClient, String thirdApplyId, Long orderId) {
        int pageSize = 20;
        int pageIndex = 1;
        VopAfsGetAfsOutlineRequest request = new VopAfsGetAfsOutlineRequest();
        request.setThirdApplyId(thirdApplyId);
        request.setPageSize(pageSize);
        request.setOrderId(orderId);
        request.setPageIndex(pageIndex);
        try {
            VopAfsGetAfsOutlineResponse response = (VopAfsGetAfsOutlineResponse)jdClient.execute((JdRequest)request);
            if (null == response) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryJdRefundDetail.response.null");
            }
            com.jd.open.api.sdk.domain.vopsh.QueryAfterSaleOpenProvider.response.getAfsOutline.OpenRpcResult openRpcResult = response.getOpenRpcResult();
            if (null == openRpcResult || !openRpcResult.getSuccess()) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryJdRefundDetail.openRpcResult.null");
            }
            OpenPagingResult openPagingResult = openRpcResult.getResult();
            if (null == openPagingResult) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryJdRefundDetail.openRpcResult.null");
            }
            return UtilResultBean.successResult(openPagingResult);
        }
        catch (Exception exception) {
            return UtilResultBean.exceptionResult("JdInterfaceUtil.queryJdRefundDetail.exception", exception);
        }
    }

    public static UtilResultBean<com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.queryTransByVopNormal.OpenRpcResult> queryJdMessage(String type, JdClient client) {
        com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.queryTransByVopNormal.OpenRpcResult openRpcResult = null;
        try {
            VopMessageQueryTransByVopNormalRequest request = new VopMessageQueryTransByVopNormalRequest();
            request.setType(type);
            VopMessageQueryTransByVopNormalResponse response = (VopMessageQueryTransByVopNormalResponse)client.execute((JdRequest)request);
            if (null == response.getOpenRpcResult()) {
                return UtilResultBean.errorResult("JdInterfaceUtil.queryVopMsg.response.getOpenRpcResult() " + response.getMsg());
            }
            openRpcResult = response.getOpenRpcResult();
            return UtilResultBean.successResult(openRpcResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            return UtilResultBean.exceptionResult("\u8bf7\u6c42\u4eac\u4e1c\u6d88\u606f\u63a5\u53e3\u5f02\u5e38 ", e);
        }
    }

    public static boolean deleteVopMsgById(JdClient client, String msgIds) {
        com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.deleteClientMsgByIdList.OpenRpcResult vopOrderRpcResult = null;
        try {
            VopMessageDeleteClientMsgByIdListRequest request = new VopMessageDeleteClientMsgByIdListRequest();
            request.setId(msgIds);
            VopMessageDeleteClientMsgByIdListResponse response = (VopMessageDeleteClientMsgByIdListResponse)client.execute((JdRequest)request);
            if (null == response.getVopOrderRpcResult()) {
                return false;
            }
            vopOrderRpcResult = response.getVopOrderRpcResult();
            return vopOrderRpcResult.getSuccess();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean deleteVopMsgByIds(List<VopBizTransMessage> vopBizTransMessageList, JdClient client) {
        StringBuffer messageIds = new StringBuffer();
        for (VopBizTransMessage vopBizTransMessage : vopBizTransMessageList) {
            messageIds.append(vopBizTransMessage.getId()).append(",");
        }
        if (messageIds.length() == 0) {
            return false;
        }
        String messageId = messageIds.delete(messageIds.lastIndexOf(","), messageIds.length()).toString();
        JdInterfaceUtil.deleteVopMsgById(client, messageId);
        return true;
    }

    public static void main(String[] args) {
        String serverUrl = "https://api.jd.com/routerjson";
        String accessToken = "d859546677254d8b93da026d117db38c0njy";
        String appKey = "116655B15B84711F2F24F7F417205CCC";
        String appSecret = "f87590a8068b4535b1d61369c8bf35f7";
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        String type = "104";
        UtilResultBean<com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.queryTransByVopNormal.OpenRpcResult> openRpcResultUtilResultBean = JdInterfaceUtil.queryJdMessage(type, (JdClient)client);
        System.out.println(JsonUtil.buildNormalBinder().toJson(openRpcResultUtilResultBean));
    }
}

