/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdvop.message.service;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.queryTransByVopNormal.OpenRpcResult;
import com.jd.open.api.sdk.domain.vopxx.MsgRecordProvider.response.queryTransByVopNormal.VopBizTransMessage;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisJdVopMessageBaseService;
import com.yqbsoft.laser.service.ext.channel.jdvop.JdVopConstants;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.JdResponseMessageContentDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.enums.JdMessageType;
import com.yqbsoft.laser.service.ext.channel.jdvop.enums.ResultCode;
import com.yqbsoft.laser.service.ext.channel.jdvop.es.SendOrderStatusPollThread;
import com.yqbsoft.laser.service.ext.channel.jdvop.es.SendOrderStatusPutThread;
import com.yqbsoft.laser.service.ext.channel.jdvop.es.SendOrderStatusService;
import com.yqbsoft.laser.service.ext.channel.jdvop.order.EsOrderRefundService;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.JdInterfaceUtil;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.UtilResultBean;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DisMessageServiceImpl
extends DisJdVopMessageBaseService {
    private String SYS_CODE = "jdvop.DisMessageServiceImpl";
    private static Object eslockDate = new Object();
    private static SendOrderStatusService sendOrderStatusService;
    private static Object sendOrderStatusLock;

    protected String getChannelCode() {
        return JdVopConstants.channelCode;
    }

    public Map<String, Object> buildComJdVopMessageParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        if (MapUtil.isEmpty(sendParam) || MapUtil.isEmpty(configMap) || null == disChannel) {
            this.logger.error(this.SYS_CODE + ".buildComJdVopMessageParam", (Object)("====" + channelApiCode + "===" + sendParam.toString() + "====" + configMap.toString() + "====" + param.toString()));
            return null;
        }
        sendParam.put("serverUrl", configMap.get("ophost"));
        sendParam.put("accessToken", this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode()));
        sendParam.put("appKey", configMap.get("key"));
        sendParam.put("appSecret", configMap.get("secret"));
        this.logger.error(this.SYS_CODE + ".buildComJdVopMessageParam", (Object)(channelApiCode + "=:= " + configMap + "=:= " + param + "=:= " + sendParam));
        return sendParam;
    }

    public Object sendComJdVopMessage(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        if (null == disChannel || null == sendhttpParam || null == configMap) {
            return "ERROR";
        }
        String serverUrl = configMap.get("ophost");
        String accessToken = this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode());
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        String tenantCode = (String)param.get("tenantCode");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        if ("cmc.disVop.jdVopMessageProcess".equals(channelApiCode)) {
            Map<String, Object> keyMap = JdInterfaceUtil.setKeyMap(serverUrl, appKey, appSecret);
            String type = param.get("type").toString();
            return this.jdVopMessageProcess(type, (JdClient)client, keyMap, disChannel);
        }
        return "SUCCESS";
    }

    public String jdVopMessageProcess(String type, JdClient jdClient, Map<String, Object> keyMap, DisChannel disChannel) {
        UtilResultBean<OpenRpcResult> openRpcResultUtilResultBean = JdInterfaceUtil.queryJdMessage(type, jdClient);
        if (ResultCode.ERROR.getCode().equals(openRpcResultUtilResultBean.getCode())) {
            this.logger.error(this.SYS_CODE + ".jdVopMessageProcess.openRpcResultUtilResultBean", (Object)JsonUtil.buildNonDefaultBinder().toJson(openRpcResultUtilResultBean));
            return "ERROR";
        }
        OpenRpcResult openRpcResult = openRpcResultUtilResultBean.getData();
        List vopBizTransMessageList = openRpcResult.getResult();
        if (ListUtil.isEmpty((Collection)vopBizTransMessageList)) {
            this.logger.error(this.SYS_CODE + ".jdVopMessageProcess.vopBizTransMessageList", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)vopBizTransMessageList));
            return "ERROR";
        }
        for (VopBizTransMessage vopBizTransMessage : vopBizTransMessageList) {
            if (JdMessageType.deliveryOrderSuccess.getType() != vopBizTransMessage.getType()) continue;
            JdResponseMessageContentDomain jdResponseMessageContentDomain = this.setJdResponseMessageContentDomain(vopBizTransMessage, keyMap, disChannel);
            DisMessageServiceImpl.getSendOrderStatusService().addPutPool(new SendOrderStatusPutThread(DisMessageServiceImpl.getSendOrderStatusService(), jdResponseMessageContentDomain));
        }
        return "SUCCESS";
    }

    public JdResponseMessageContentDomain setJdResponseMessageContentDomain(VopBizTransMessage vopBizTransMessage, Map<String, Object> keyMap, DisChannel disChannel) {
        JdResponseMessageContentDomain jdResponseMessageContentDomain = new JdResponseMessageContentDomain();
        String content = vopBizTransMessage.getContent();
        jdResponseMessageContentDomain.setType(vopBizTransMessage.getType());
        jdResponseMessageContentDomain.setContent(vopBizTransMessage.getContent());
        jdResponseMessageContentDomain.setKeyMap(keyMap);
        jdResponseMessageContentDomain.setDisChannel(disChannel);
        jdResponseMessageContentDomain.setContent(content);
        jdResponseMessageContentDomain.setId(vopBizTransMessage.getId());
        return jdResponseMessageContentDomain;
    }

    public JdClient getJdClient(DisChannel disChannel, Map<String, String> configMap, Map<String, Object> param) {
        String serverUrl = configMap.get("ophost");
        String accessToken = this.getToken(disChannel.getTenantCode(), disChannel.getChannelCode(), disChannel.getMemberCcode());
        String appKey = configMap.get("key");
        String appSecret = configMap.get("secret");
        String tenantCode = (String)param.get("tenantCode");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendOrderStatusService getSendOrderStatusService() {
        Object object = sendOrderStatusLock;
        synchronized (object) {
            if (null == sendOrderStatusService) {
                sendOrderStatusService = new SendOrderStatusService((EsOrderRefundService)SpringApplicationContextUtil.getBean((String)"esOrderRefundService"));
                for (int i = 0; i < 200; ++i) {
                    sendOrderStatusService.addPollPool(new SendOrderStatusPollThread(sendOrderStatusService));
                }
            }
            return sendOrderStatusService;
        }
    }

    static {
        sendOrderStatusLock = new Object();
    }
}

