/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.jindie.util;

import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpUtil {
    private static final int CONN_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 30000;
    private static RestTemplate restTemplate = null;

    private static HttpHeaders initHeader() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "application/json");
        headers.add("Accpet-Encoding", "gzip");
        headers.add("Content-Encoding", "UTF-8");
        headers.add("Content-Type", "application/json; charset=UTF-8");
        return headers;
    }

    private static void setHeaderParam(HttpHeaders httpHeaders, Map<String, Object> headers) {
        if (!CollectionUtils.isEmpty(headers)) {
            Set<String> keys = headers.keySet();
            for (String key : keys) {
                httpHeaders.add(key, headers.get(key).toString());
            }
        }
    }

    private static MultiValueMap<String, Object> setParam(Map<String, Object> param) {
        LinkedMultiValueMap valueMap = new LinkedMultiValueMap();
        if (CollectionUtils.isEmpty(param)) {
            return valueMap;
        }
        Set<String> paramKeys = param.keySet();
        for (String key : paramKeys) {
            valueMap.add((Object)key, (Object)param.get(key).toString());
        }
        return valueMap;
    }

    public static String httpGet(String url, Map<String, Object> headers) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        HttpUtil.setHeaderParam(httpHeaders, headers);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    public static String httpGet(String url, Map<String, Object> headers, Map<String, Object> param) {
        if (CollectionUtils.isEmpty(param)) {
            return HttpUtil.httpGet(url, headers);
        }
        Set<String> keys = param.keySet();
        StringBuilder builder = new StringBuilder();
        builder.append("?");
        for (String key : keys) {
            builder.append(key).append("=").append(param.get(key)).append("&");
        }
        builder.deleteCharAt(builder.lastIndexOf("&"));
        url = url + builder.toString();
        return HttpUtil.httpGet(url, headers);
    }

    public static String httpPost(String url, Map<String, Object> param) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        MultiValueMap<String, Object> valueMap = HttpUtil.setParam(param);
        return HttpUtil.toPost(url, httpHeaders, valueMap);
    }

    public static ResponseEntity<String> httpPost(String url, String json) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        return HttpUtil.toPost(url, httpHeaders, json);
    }

    public static String httpPost(String url, Map<String, Object> header, String json) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        HttpUtil.setHeaderParam(httpHeaders, header);
        return (String)HttpUtil.toPost(url, httpHeaders, json).getBody();
    }

    public static String httpPost(String url, Map<String, Object> headers, Map<String, Object> param) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        HttpUtil.setHeaderParam(httpHeaders, headers);
        MultiValueMap<String, Object> valueMap = HttpUtil.setParam(param);
        return HttpUtil.toPost(url, httpHeaders, valueMap);
    }

    private static String toPost(String url, HttpHeaders httpHeaders, MultiValueMap<String, Object> valueMap) {
        HttpEntity httpEntity = new HttpEntity(valueMap, (MultiValueMap)httpHeaders);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    private static ResponseEntity<String> toPost(String url, HttpHeaders httpHeaders, String json) {
        HttpEntity httpEntity = new HttpEntity((Object)json, (MultiValueMap)httpHeaders);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        return responseEntity;
    }

    static {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(30000);
        requestFactory.setReadTimeout(30000);
        restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }
}

