/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.jindie.util.tongshangyun;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.yqbsoft.laser.service.jindie.model.AsynNotiyRequest;
import com.yqbsoft.laser.service.jindie.model.BizParameter;
import com.yqbsoft.laser.service.jindie.model.OpenResponse;
import com.yqbsoft.laser.service.jindie.model.OpenServiceRequest;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.OpTrustManager;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.OpenConfig;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.OpenRequest;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.OpenUtils;
import com.yqbsoft.laser.service.jindie.util.tongshangyun.SecretUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenClient {
    private static final String CHARSET = "utf-8";
    private final OpenConfig config;
    private final RSAPrivateKey privateKey;
    private final PublicKey tlPublicKey;
    private final Logger logger = LoggerFactory.getLogger(OpenClient.class);
    private static final String TRACE_ID_HEADER = "x-traceId-header";

    public OpenClient(OpenConfig config) throws Exception {
        config.validate();
        this.config = config;
        this.privateKey = (RSAPrivateKey)SecretUtils.loadPrivateKey(null, config.getCertPath(), config.getCertPwd());
        this.tlPublicKey = SecretUtils.loadTLPublicKey(config.getTlCertPath());
    }

    public OpenResponse execute(String method, BizParameter param) throws Exception {
        OpenRequest request = this.assembleRequest(method, param);
        this.logger.info("request:{}", (Object)request);
        String paramStr = this.encodeOnce((Map<String, Object>)((JSONObject)JSON.toJSON((Object)request)));
        Map<String, String> respMap = this.post(paramStr);
        String body = respMap.get("body");
        OpenResponse resp = this.verify(body);
        resp.setTraceId(respMap.get("traceId"));
        return resp;
    }

    public void asynNotifyForServer(String notifyType, BizParameter param, String notifyUrl, String clientAppId) throws Exception {
        AsynNotiyRequest request = this.assembleAsynRequest(notifyType, param, notifyUrl, clientAppId);
        this.post(this.encodeOnce((Map<String, Object>)((JSONObject)JSON.toJSON((Object)request))));
    }

    public String concatUrlParams(String method, BizParameter param) throws Exception {
        OpenRequest request = this.assembleRequest(method, param);
        return this.config.getUrl() + "?" + this.encodeOnce((Map<String, Object>)((JSONObject)JSON.toJSON((Object)request)));
    }

    public String concatUrlForServer(String method, BizParameter param, String jumpUrl, String clientAppId) throws Exception {
        OpenRequest request = this.assembleServiceRequest(method, param, jumpUrl, clientAppId);
        return this.config.getUrl() + "?" + this.encodeOnce((Map<String, Object>)((JSONObject)JSON.toJSON((Object)request)));
    }

    public String encrypt(String content) {
        return SecretUtils.encryptAES(content, this.config.getSecretKey());
    }

    public String decrypt(String content) {
        return SecretUtils.decryptAES(content, this.config.getSecretKey());
    }

    public boolean checkSign(String signedValue, String sign) throws Exception {
        return SecretUtils.verify(this.tlPublicKey, signedValue, sign);
    }

    private OpenResponse verify(String resp) throws Exception {
        JSONObject map = JSON.parseObject((String)resp);
        String sign = map.getString("sign");
        map.remove((Object)"sign");
        String signedValue = JSON.toJSONString((Object)map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        if (!SecretUtils.verify(this.tlPublicKey, signedValue, sign)) {
            throw new Exception("verify sign error");
        }
        return (OpenResponse)JSON.parseObject((String)resp, OpenResponse.class);
    }

    private OpenRequest assembleServiceRequest(String method, BizParameter param, String jumpUrl, String clientAppId) throws Exception {
        OpenUtils.assertNotNull(param, "param must not be null");
        OpenServiceRequest request = new OpenServiceRequest();
        request.setAppId(this.config.getAppId());
        request.setClientAppId(clientAppId);
        request.setJumpUrl(jumpUrl);
        request.setMethod(method);
        request.setFormat(this.config.getFormat());
        request.setCharset(this.config.getCharset());
        request.setTimestamp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        request.setVersion(this.config.getVersion());
        request.setNotifyUrl(this.config.getNotifyUrl());
        request.setBizContent(param.toString());
        String signedValue = this.getSignedValue((Map<String, Object>)((JSONObject)JSON.toJSON((Object)request)));
        this.logger.debug("\u5f85\u7b7e\u540d\u6e90\u4e32\uff1a" + signedValue);
        String sign = SecretUtils.sign(this.privateKey, signedValue, this.config.getSignType());
        request.setSignType(this.config.getSignType());
        request.setSign(sign);
        return request;
    }

    private AsynNotiyRequest assembleAsynRequest(String noticeType, BizParameter param, String notifyUrl, String clientAppId) throws Exception {
        OpenUtils.assertNotNull(param, "param must not be null");
        AsynNotiyRequest request = new AsynNotiyRequest();
        request.setAppId(this.config.getAppId());
        request.setClientAppId(clientAppId);
        request.setNotifyUrl(notifyUrl);
        request.setNotifyType(noticeType);
        request.setCharset(this.config.getCharset());
        request.setNotifyTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        request.setVersion(this.config.getVersion());
        request.setNotifyUrl(this.config.getNotifyUrl());
        request.setBizContent(param.toString());
        String signedValue = this.getSignedValue((Map<String, Object>)((JSONObject)JSON.toJSON((Object)request)));
        this.logger.debug("\u5f85\u7b7e\u540d\u6e90\u4e32\uff1a" + signedValue);
        String sign = SecretUtils.sign(this.privateKey, signedValue, this.config.getSignType());
        request.setSignType(this.config.getSignType());
        request.setSign(sign);
        return request;
    }

    private OpenRequest assembleRequest(String method, BizParameter param) throws Exception {
        OpenUtils.assertNotNull(param, "param must not be null");
        OpenRequest request = new OpenRequest();
        request.setAppId(this.config.getAppId());
        request.setMethod(method);
        request.setFormat(this.config.getFormat());
        request.setCharset(this.config.getCharset());
        request.setTimestamp(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        request.setVersion(this.config.getVersion());
        request.setNotifyUrl(this.config.getNotifyUrl());
        request.setBizContent(param.toString());
        String signedValue = this.getSignedValue((Map<String, Object>)((JSONObject)JSON.toJSON((Object)request)));
        String sign = SecretUtils.sign(this.privateKey, signedValue, this.config.getSignType());
        request.setSignType(this.config.getSignType());
        request.setSign(sign);
        return request;
    }

    private String getSignedValue(Map<String, Object> reqMap) {
        TreeMap<String, String> copy = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : reqMap.entrySet()) {
            if (entry.getValue() == null) continue;
            copy.put(entry.getKey(), entry.getValue().toString());
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : copy.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> post(String param) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        StringBuilder result = new StringBuilder();
        BufferedWriter writer = null;
        BufferedReader reader = null;
        String traceId = "";
        try {
            URL httpUrl = new URL(this.config.getUrl());
            HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(OpTrustManager.instance().getSSLSocketFactory());
            }
            connection.setRequestProperty("Connection", "keep-alive");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), CHARSET));
            writer.write(param);
            writer.flush();
            Map<String, List<String>> headerFields = connection.getHeaderFields();
            Iterator<Map.Entry<String, List<String>>> var10 = headerFields.entrySet().iterator();
            while (true) {
                if (!var10.hasNext()) {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), CHARSET));
                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                    }
                    break;
                }
                Map.Entry<String, List<String>> entry = var10.next();
                if (!TRACE_ID_HEADER.equalsIgnoreCase(entry.getKey())) continue;
                traceId = entry.getValue() != null && !entry.getValue().isEmpty() ? entry.getValue().get(0) : "";
            }
        }
        catch (Exception var20) {
            this.logger.error(var20.getMessage(), (Throwable)var20);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException var19) {
                this.logger.error(var19.getMessage(), (Throwable)var19);
            }
        }
        resultMap.put("body", result.toString());
        resultMap.put("traceId", traceId);
        return resultMap;
    }

    private String encodeOnce(Map<String, Object> jo) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, Object> entry : jo.entrySet()) {
                String value = entry.getValue() == null ? "" : (String)entry.getValue();
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(value, CHARSET)).append("&");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

