/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.util;

import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.CommunicationDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.ServiceMessageHeaderDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.SignDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.IdUtil;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.UtilDate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class PayBuilder {
    private static volatile String URL = "";
    private static volatile boolean IS_INIT = false;
    private static volatile long LAST_SIGN_IN = 0L;
    private static final long DAY_TIME = 86400000L;
    private static final RestTemplate restTemplate = new RestTemplate();

    public static void setURL(String URL) {
        PayBuilder.URL = URL;
    }

    public static String getURL() {
        return URL;
    }

    public static String send(String func, String thridLogNo, String content) {
        if (System.currentTimeMillis() - LAST_SIGN_IN > 86400000L) {
            LAST_SIGN_IN = System.currentTimeMillis();
            IS_INIT = false;
        }
        if (IS_INIT) {
            PayBuilder.signIn();
            IS_INIT = true;
        }
        String param = PayBuilder.buildRquestMessage(func, thridLogNo, content);
        ResponseEntity response = restTemplate.postForEntity(URL, (Object)param, String.class, new Object[0]);
        return (String)response.getBody();
    }

    public static String signIn() {
        return PayBuilder.userSign("1");
    }

    public static String signOut() {
        return PayBuilder.userSign("2");
    }

    public static String userSign(String flag) {
        SignDomain signDomain = new SignDomain();
        signDomain.setFuncFlag(flag);
        signDomain.setTxDate(UtilDate.getDate());
        String content = PayBuilder.toFormatString(signDomain);
        String func = "1330";
        String id = IdUtil.getPinganId(func, signDomain.getFuncFlag(), "1");
        PayBuilder.send(func, id, content);
        return PayBuilder.send(func, id, content);
    }

    public static String buildRquestMessage(String func, String thridLogNo, String content) {
        return PayBuilder.buildMessage(func, "01", thridLogNo, content);
    }

    public static String buildResponseMessage(String func, String thridLogNo, String content) {
        return PayBuilder.buildMessage(func, "02", thridLogNo, content);
    }

    public static String buildMessage(String func, String serverType, String thridLogNo, String content) {
        CommunicationDomain communicationDomain = new CommunicationDomain();
        Date date = new Date();
        date.setSeconds(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HHmmss");
        String time = sdf.format(date);
        String tranDate = time.substring(0, 8);
        String tranTime = time.substring(9);
        communicationDomain.setTranDate(tranDate);
        communicationDomain.setTranTime(tranTime);
        communicationDomain.setCode("9264                ");
        communicationDomain.setOpterator("86301");
        communicationDomain.setServerType(serverType);
        communicationDomain.setThridLogNo(thridLogNo);
        ServiceMessageHeaderDomain serviceMessageHeaderDomain = new ServiceMessageHeaderDomain();
        serviceMessageHeaderDomain.setTranFunc(func);
        serviceMessageHeaderDomain.setServType(serverType);
        serviceMessageHeaderDomain.setMacCode("                ");
        serviceMessageHeaderDomain.setTranDate(tranDate);
        serviceMessageHeaderDomain.setTranTime(tranTime);
        if ("01".equals(serverType)) {
            serviceMessageHeaderDomain.setRspCode("999999");
        } else {
            serviceMessageHeaderDomain.setRspCode("000000");
        }
        serviceMessageHeaderDomain.setRspMsg("                                          ");
        serviceMessageHeaderDomain.setConFlag("0");
        serviceMessageHeaderDomain.setCounterId("EB001");
        serviceMessageHeaderDomain.setThirdLogNo(communicationDomain.getThridLogNo());
        serviceMessageHeaderDomain.setQydm("9264");
        serviceMessageHeaderDomain.setLength(String.format("%08d", content.length()));
        communicationDomain.setContentLenth(String.format("%010d", 122 + content.length()));
        String communicationMessage = communicationDomain.toString();
        String serviceHeader = serviceMessageHeaderDomain.toString();
        String param = communicationMessage + serviceHeader + content;
        return param;
    }

    public static String toFormatString(Object obj) {
        Field[] fields;
        StringBuffer buffer = new StringBuffer();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            Object value = PayBuilder.getFieldValueByName(field.getName(), obj);
            buffer.append(value != null ? value : "");
            buffer.append("&");
        }
        return buffer.toString();
    }

    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("GBK")));
    }
}

