/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.service;

import com.yqbsoft.laser.service.ext.channel.com.api.ChannelTransactionService;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRlRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.UmUserDomain;
import com.yqbsoft.laser.service.ext.channel.com.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelTransactionBaseService;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.CallBackBean;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.MemberDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.util.StringUtils;
import com.yqbsoft.laser.service.ext.channel.pinganbank.util.PingBankUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ChannelTransactionServiceImpl
extends ChannelTransactionBaseService
implements ChannelTransactionService {
    private static final String SYS_CODE = "ChannelTransactionServiceImpl.";
    private static String requestUrl = "";
    private static String requestParam = "";

    protected ChannelRlRequest send(ChannelRlRequest channelRequest, Map<String, Object> map) {
        if (null == channelRequest) {
            this.logger.error("ChannelTransactionServiceImpl.send.channelRequest", (Object)channelRequest);
            return ChannelRlRequest.makeMsg((ChannelRlRequest)channelRequest, (String)CallBackBean.returnMsg(CallBackBean.FALSE, "channelRequest is null", ""));
        }
        String channelApiCode = channelRequest.getChannelApiCode();
        MemberDomain member = null;
        if (null != map.get("memberCode")) {
            member = this.getMemberDomain(map);
        }
        Map requestData = channelRequest.getRequestData();
        String content = PingBankUtils.toFormatString(this.makeContent(member, map, requestData, channelApiCode));
        String requestParam = PingBankUtils.buildMessage((String)requestData.get("func"), (String)requestData.get("serverType"), System.currentTimeMillis() + "", content);
        if (StringUtils.isBlank(requestParam)) {
            this.logger.error("ChannelTransactionServiceImpl.send.channelRequest", (Object)(channelApiCode + " =:= " + channelRequest));
            return ChannelRlRequest.makeMsg((ChannelRlRequest)channelRequest, (String)CallBackBean.returnMsg(CallBackBean.FALSE, "requestParam is null! " + content + "=:=" + requestData, ""));
        }
        HashMap<String, String> reMap = new HashMap<String, String>();
        reMap.put("requestData", requestParam);
        channelRequest.setRequestData(reMap);
        return channelRequest;
    }

    protected Object retrunParam(ChannelRlRequest channelRequest, Map<String, Object> map) {
        if (null == channelRequest) {
            this.logger.error("ChannelTransactionServiceImpl.retrunParam.channelRequest", (Object)channelRequest);
            return CallBackBean.returnMsg(CallBackBean.FALSE, "channelRequest is null! ", "");
        }
        if (null != channelRequest.getConfigMap() && StringUtils.isNotBlank((String)channelRequest.getConfigMap().get("url"))) {
            requestUrl = (String)channelRequest.getConfigMap().get("url");
        }
        if (null != channelRequest.getRequestData() && null != channelRequest.getRequestData().get("requestData")) {
            requestParam = channelRequest.getRequestData().get("requestData").toString();
        }
        if (StringUtils.isBlank(requestUrl) || StringUtils.isBlank(requestParam)) {
            this.logger.error("ChannelTransactionServiceImpl.retrunParam.request", (Object)(requestParam + " =:= " + requestUrl));
            return CallBackBean.returnMsg(CallBackBean.FALSE, "requestUrl or requestParam is null! ", "");
        }
        String response = null;
        try {
            response = PingBankUtils.httpPost(requestUrl, requestParam);
            if (StringUtils.isBlank(response)) {
                this.logger.error("ChannelTransactionServiceImpl.retrunParam.response", (Object)response);
                return CallBackBean.returnMsg(CallBackBean.FALSE, "responseis null!  " + requestParam + " =:= " + requestUrl, "");
            }
        }
        catch (Exception e) {
            this.logger.error("ChannelTransactionServiceImpl.retrunParam.request.e", (Object)(requestParam + " =:= " + requestUrl), (Throwable)e);
            return CallBackBean.returnMsg(CallBackBean.FALSE, "request is Exception!  " + requestParam + " =:= " + requestUrl, "");
        }
        String str = response.substring(222, 344);
        Map<String, Object> responseMap = PingBankUtils.makeResponseParamToMap(str, "tranFunc", "servType", "macCode", "tranTime", "rspCode", "rspMsg", "conFlag", "length", "counterId", "thirdLogNo", "qydm");
        if (MapUtil.isEmpty(responseMap)) {
            this.logger.error("ChannelTransactionServiceImpl..retrunParam.responseMap", (Object)response);
            return CallBackBean.returnMsg(CallBackBean.FALSE, "", response);
        }
        if (null != responseMap.get("RspCode") && !"000000".equals(responseMap.get("RspCode"))) {
            this.logger.error("ChannelTransactionServiceImpl..retrunParam.error", responseMap);
            return CallBackBean.returnMsg(CallBackBean.FALSE, "", JsonUtil.buildNormalBinder().toJson(responseMap) + " =:= " + response);
        }
        String channelApiCode = channelRequest.getChannelApiCode();
        Map<String, Object> newMap = this.makeResponse(response, channelApiCode);
        return CallBackBean.returnMsg(CallBackBean.SUCCESS, "", JsonUtil.buildNormalBinder().toJson(newMap));
    }

    public Map<String, Object> makeContent(MemberDomain member, Map<String, Object> map, Map<String, Object> requestData, String channelApiCode) {
        LinkedHashMap<String, Object> makeParamMap = new LinkedHashMap<String, Object>();
        if ("cmc.channelTransaction.channelTransactionSignIn".equals(channelApiCode) || "cmc.channelTransaction.channelTransactionSignOut".equals(channelApiCode)) {
            makeParamMap.put("funcFlag", requestData.get("funcFlag"));
            makeParamMap.put("txDate", PingBankUtils.getDate());
            makeParamMap.put("reserve", "");
        } else if ("cmc.channelTransaction.channelQueryTraReconciliationPlan".equals(channelApiCode)) {
            makeParamMap.put("funcFlag", requestData.get("funcFlag"));
            makeParamMap.put("beginDate", map.get("beginDate"));
            makeParamMap.put("endDate", map.get("endDate"));
            makeParamMap.put("supAcctId", member.getSupAcctId());
            makeParamMap.put("reserve", "");
        } else if (!"cmc.channelTransaction.channelTraFileNotice".equals(channelApiCode)) {
            if ("cmc.channelTransaction.channelQueryTraDataMatching".equals(channelApiCode)) {
                makeParamMap.put("funcFlag", map.get("funcFlag"));
                makeParamMap.put("supAcctId", member.getSupAcctId());
                makeParamMap.put("beginDate", map.get("beginDate"));
                makeParamMap.put("endDate", map.get("endDate"));
                makeParamMap.put("reserve", "");
            } else if ("cmc.channelTransaction.channelTriggerTraDataMatching".equals(channelApiCode)) {
                makeParamMap.put("funcFlag", requestData.get("funcFlag"));
                makeParamMap.put("fileName", map.get("fileName"));
                makeParamMap.put("fileSize", map.get("fileSize"));
                makeParamMap.put("supAcctId", member.getSupAcctId());
                makeParamMap.put("qsZcAmount", map.get("qsZcAmount"));
                makeParamMap.put("freezeAmount", map.get("freezeAmount"));
                makeParamMap.put("unfreezeAmount", map.get("unfreezeAmount"));
                makeParamMap.put("syZcAmount", map.get("syZcAmount"));
                makeParamMap.put("reserve", map.get("reserve"));
            }
        }
        return makeParamMap;
    }

    public Map<String, Object> makeResponse(String response, String channelApiCode) {
        Map<Object, Object> map = new LinkedHashMap();
        if ("cmc.channelTransaction.channelTransactionSignIn".equals(channelApiCode) || "cmc.channelTransaction.channelTransactionSignOut".equals(channelApiCode)) {
            response = response.substring(344);
            map = PingBankUtils.makeResponseParamToMap(response, "frontLogNo");
        } else if ("cmc.channelTransaction.channelQueryTraReconciliationPlan".equals(channelApiCode)) {
            String dataHead = response.substring(323);
            map = PingBankUtils.makeResponseParamToMap(dataHead, "recordCount", "resultFlag");
            Object recordNum = map.get("recordCount");
            String arrayData = dataHead.substring(21);
            List<Map<String, Object>> mapList = PingBankUtils.makeResponseParamToMapList(arrayData, Integer.valueOf(recordNum.toString()), "failFilesName", "tranDate", "tranTime", "batFileName", "failMsg", "totalCount", "sucTotal", "failTotal", "failFilesName");
            map.put("arrayData", JsonUtil.buildNormalBinder().toJson(mapList));
        } else if (!"cmc.channelTransaction.channelTraFileNotice".equals(channelApiCode)) {
            if ("cmc.channelTransaction.channelQueryTraDataMatching".equals(channelApiCode)) {
                response = response.substring(344);
                map = PingBankUtils.makeResponseParamToMap(response, "fileName");
            } else if ("cmc.channelTransaction.channelTriggerTraDataMatching".equals(channelApiCode)) {
                response = response.substring(344);
                map = PingBankUtils.makeResponseParamToMap(response, "frontLogNo");
            }
        }
        return map;
    }

    public MemberDomain getMemberDomain(Map<String, Object> map) {
        UmUserDomain umUser = this.getUmUserByPcode(map.get("tenantCode").toString(), map.get("memberCode").toString());
        if (null == umUser) {
            this.logger.error("ChannelTransactionServiceImpl.send.getUmUserByPcode", (Object)(umUser + " =:= " + map));
            return null;
        }
        UmUserinfoQuaDomain umUserinfoQuaDomain = this.getUmUserInfoQuaByOcode(umUser.getTenantCode(), umUser.getUserOcode());
        if (null == umUserinfoQuaDomain) {
            this.logger.error("ChannelTransactionServiceImpl.send.getUmUserByPcode", (Object)(umUser + " =:= " + umUser.getUserOcode() + "-" + umUser.getTenantCode()));
            return null;
        }
        return PingBankUtils.getMember(umUserinfoQuaDomain.getUserinfoQuaUrl());
    }

    public String getFchannelCode() {
        return "pingan";
    }
}

