/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.pinganbank.util;

import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.CommunicationDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.MemberDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.ServiceMessageHeaderDomain;
import com.yqbsoft.laser.service.ext.channel.pinganbank.domain.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class PingBankUtils {
    private static RestTemplate restTemplate;
    public static final String dtShort = "yyyyMMdd";

    public static String httpPost(String url, String param) {
        ResponseEntity response = restTemplate.postForEntity(url, (Object)param, String.class, new Object[0]);
        return (String)response.getBody();
    }

    public static String buildMessage(String func, String serverType, String frontLogNo, String content) {
        if (StringUtils.isBlank(func) || StringUtils.isBlank(serverType) || StringUtils.isBlank(content)) {
            return null;
        }
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HHmmss");
        String time = sdf.format(date);
        String tranDate = time.substring(0, 8);
        String tranTime = time.substring(9);
        CommunicationDomain communicationDomain = new CommunicationDomain();
        communicationDomain.setTranDate(tranDate);
        communicationDomain.setTranTime(tranTime);
        communicationDomain.setCode("9264                ");
        communicationDomain.setOpterator("86301");
        communicationDomain.setServerType(serverType);
        communicationDomain.setThridLogNo(frontLogNo);
        ServiceMessageHeaderDomain serviceMessageHeaderDomain = new ServiceMessageHeaderDomain();
        serviceMessageHeaderDomain.setTranFunc(func);
        serviceMessageHeaderDomain.setServType(serverType);
        serviceMessageHeaderDomain.setMacCode("                ");
        serviceMessageHeaderDomain.setTranDate(tranDate);
        serviceMessageHeaderDomain.setTranTime(tranTime);
        if ("01".equals(serverType)) {
            serviceMessageHeaderDomain.setRspCode("999999");
        } else {
            serviceMessageHeaderDomain.setRspCode("000000");
        }
        serviceMessageHeaderDomain.setRspMsg("                                          ");
        serviceMessageHeaderDomain.setConFlag("0");
        serviceMessageHeaderDomain.setCounterId("EB001");
        serviceMessageHeaderDomain.setThirdLogNo(communicationDomain.getThridLogNo());
        serviceMessageHeaderDomain.setQydm("9264");
        serviceMessageHeaderDomain.setLength(String.format("%08d", content.length()));
        communicationDomain.setContentLenth(String.format("%010d", 122 + content.length()));
        String communicationMessage = communicationDomain.toString();
        String serviceHeader = serviceMessageHeaderDomain.toString();
        String param = communicationMessage + serviceHeader + content;
        return param;
    }

    public static String getPinganLogNo(String func) {
        StringBuffer buffer = new StringBuffer(System.currentTimeMillis() + "");
        if (StringUtils.isNotBlank(func)) {
            buffer.append(func);
        }
        return buffer.toString();
    }

    public static MemberDomain getMember(String Str) {
        return MemberDomain.format(Str);
    }

    public static Map<String, Object> makeResponseParamToMap(String response, String ... property) {
        if (StringUtils.isBlank(response) || ArrayUtils.isEmpty((Object[])property)) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String[] values = response.split("&");
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (i == property.length) break;
            String key = property[i];
            map.put(key, value);
        }
        return map;
    }

    public static List<Map<String, Object>> makeResponseParamToMapList(String response, Integer n, String endProperty, String ... property) {
        if (StringUtils.isBlank(response) || null == n || StringUtils.isBlank(endProperty) || ArrayUtils.isEmpty((Object[])property)) {
            return null;
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String[] values = response.split("&");
        int tempNum = 1;
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            String key = property[i - (tempNum - 1) * property.length];
            if (endProperty.equals(key)) {
                ++tempNum;
                mapList.add(map);
            }
            map.put(key, value);
            if (tempNum > n) break;
        }
        return mapList;
    }

    public static void main(String[] args) {
        String res = "92579158292642&1&1&2&15000131807985&1&1&\u6df1\u5733\u5e02\u4f17\u7ba1\u8054\u4f9b\u5e94\u94fe\u6709\u9650\u516c\u53f8&0800&\u5e73\u5b89\u94f6\u884c\u603b\u884c\u8425\u4e1a\u90e8&1&20200528&15000131807985&2&1&\u6df1\u5733\u5e02\u4f17\u7ba1\u8054\u4f9b\u5e94\u94fe\u6709\u9650\u516c\u53f8&0800&\u5e73\u5b89\u94f6\u884c\u603b\u884c\u8425\u4e1a\u90e8&1&20200528&&";
        String head = res.substring(0, 21);
        Map<String, Object> headMap = PingBankUtils.makeResponseParamToMap(head, "totalCount", "beginNum", "lastPage", "recordNum");
        Object recordNum = headMap.get("recordNum");
        String substring = res.substring(21);
        List<Map<String, Object>> mapList = PingBankUtils.makeResponseParamToMapList(substring, Integer.valueOf(recordNum.toString()), "tranDate", "custAcctId", "acctFlag", "tranType", "acctName", "bankCode", "bankName", "address", "tranDate");
        headMap.put("arrayData", JsonUtil.buildNormalBinder().toJson(mapList));
        System.out.println(JsonUtil.buildNonDefaultBinder().toJson(headMap));
    }

    public static String toFormatString(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        StringBuffer content = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if ("func".equals(entry.getKey()) || "serverType".equals(entry.getKey())) continue;
            Object value = entry.getValue();
            content.append(value != null ? value : "");
            content.append("&");
        }
        return content.toString();
    }

    public static String getDate() {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat(dtShort);
        return df.format(date);
    }

    static {
        ArrayList<StringHttpMessageConverter> messageConverters = new ArrayList<StringHttpMessageConverter>();
        messageConverters.add(new StringHttpMessageConverter(Charset.forName("GBK")));
        restTemplate = new RestTemplate(messageConverters);
    }
}

