/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.wechatmini.service;

import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannelApiparam;
import com.yqbsoft.laser.service.ext.channel.discom.service.DisSettingBaseService;
import com.yqbsoft.laser.service.ext.channel.wechatmini.WeChatPayMiniConstants;
import com.yqbsoft.laser.service.ext.channel.wechatmini.util.HttpRequestUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class DisSettingServiceImpl
extends DisSettingBaseService {
    private static final String SYS_CODE = "cmc.DisSettingServiceImpl";

    protected String getChannelCode() {
        return WeChatPayMiniConstants.channelCode;
    }

    public Map<String, Object> buildComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        List apiparamList = (List)param.get("apiparamList");
        if (ListUtil.isEmpty((Collection)apiparamList)) {
            return sendParam;
        }
        for (DisChannelApiparam disChannelApiparam : apiparamList) {
            body.put(disChannelApiparam.getChannelApiparamKey(), sendParam.get(disChannelApiparam.getChannelApiparamKey()));
        }
        if ("cmc.disGoods.uploadImage".equals(channelApiCode)) {
            String images = Base64.encodeBase64String((byte[])((byte[])body.get("data")));
            try {
                images = URLDecoder.decode(images, "utf-8");
            }
            catch (Exception e) {
                this.logger.error("cmc.DisSettingServiceImpl.buildComGoodsParam.uploadImage.images", (Throwable)e);
                return null;
            }
            body.put("media", images);
        }
        return body;
    }

    public Object sendComParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        String url = configMap.get("serviceUrl");
        String result = "";
        String accessToken = this.getAccessToken(configMap.get("appid"), configMap.get("secret"), false);
        if (StringUtils.isBlank((String)accessToken)) {
            return this.resultMap(-1, "error", result, "\u64cd\u4f5c\u5931\u8d25");
        }
        result = this.sendPost(sendhttpParam, url + accessToken);
        Map<String, Object> resultMap = this.getResultMap(result);
        if (MapUtils.isNotEmpty(resultMap) && "41001".equals(resultMap.get("errcode").toString())) {
            this.logger.error("cmc.DisSettingServiceImpl.sendPost.resultMap.errcode=40001", (Object)JsonUtil.buildNormalBinder().toJson(resultMap));
            accessToken = this.getAccessToken(configMap.get("appid"), configMap.get("secret"), true);
            if (StringUtils.isBlank((String)accessToken)) {
                return this.resultMap(-1, "error", result, "\u64cd\u4f5c\u5931\u8d25");
            }
            result = this.sendPost(sendhttpParam, url + accessToken);
            resultMap = this.getResultMap(result);
        }
        if (MapUtils.isNotEmpty(resultMap) && "0".equals(resultMap.get("errcode").toString())) {
            return this.resultMap(1, "success", result, "\u64cd\u4f5c\u6210\u529f");
        }
        return this.resultMap(-1, "error", result, "\u64cd\u4f5c\u5931\u8d25");
    }

    public Object sendComOrder(String channelApiCode, DisChannel disChannel, Map<String, Object> sendhttpParam, Map<String, String> configMap, Map<String, Object> param) {
        return null;
    }

    public Map<String, Object> buildComOrderParam(String channelApiCode, DisChannel disChannel, Map<String, Object> sendParam, Map<String, String> configMap, Map<String, Object> param) {
        return null;
    }

    private Map<String, Object> getResultMap(String result) {
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
    }

    private Map<String, Object> resultMap(int code, String state, String dataObj, String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", code);
        resultMap.put("state", state);
        resultMap.put("dataObj", dataObj);
        resultMap.put("msg", msg);
        this.logger.error("cmc.DisSettingServiceImpl.resultMap", (Object)JsonUtil.buildNormalBinder().toJson(resultMap));
        return resultMap;
    }

    private String sendPost(Map<String, Object> params, String url) {
        String result = "";
        result = HttpRequestUtil.sendPost(url, params);
        if (StringUtils.isBlank((String)result)) {
            this.logger.error("cmc.DisSettingServiceImpl.login:result", (Object)(result + "+(result\u4e3a\u7a7a)"));
            return null;
        }
        return result;
    }

    public String getAccessToken(String appid, String secret, boolean ifUpdate) {
        String key = appid + "-" + secret;
        String accessToken = SupDisUtil.getRemot((String)key);
        if (StringUtils.isBlank((String)accessToken) || ifUpdate) {
            String result = this.updateAccessToken(appid, secret);
            Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
            if (MapUtils.isEmpty((Map)jsonToMap) || null == jsonToMap.get("access_token")) {
                this.logger.error("cmc.DisSettingServiceImpl.getAccessToken:result", (Object)result);
                return null;
            }
            accessToken = (String)jsonToMap.get("access_token");
            SupDisUtil.set((String)key, (String)accessToken, (int)7200);
        }
        this.logger.error("cmc.DisSettingServiceImpl.getAccessToken:accessToken", (Object)accessToken);
        return accessToken;
    }

    private String updateAccessToken(String appid, String secret) {
        HashMap<String, String> invoiceMap = new HashMap<String, String>();
        invoiceMap.put("appid", appid);
        invoiceMap.put("secret", secret);
        invoiceMap.put("grant_type", "client_credential");
        String result = "";
        try {
            result = WebUtils.doGet((String)"https://api.weixin.qq.com/cgi-bin/token", invoiceMap, null);
            if (StringUtils.isBlank((String)result)) {
                this.logger.error("cmc.DisSettingServiceImpl.updateAccessToken:result", (Object)(result + "+(result\u4e3a\u7a7a)"));
                return null;
            }
        }
        catch (IOException e) {
            this.logger.error("cmc.DisSettingServiceImpl.updateAccessToken:result", (Object)result, (Throwable)e);
            return null;
        }
        return result;
    }
}

