/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.wechatmini.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.api.ChannelTokenService;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRlRequest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelInfuencerBaseService;
import com.yqbsoft.laser.service.ext.channel.wechatmini.WeChatPayMiniConstants;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ChannelInfuencerServiceImpl
extends ChannelInfuencerBaseService {
    public static final String DATETIMESHOWFORMAT = "yyyy-MM-dd HH:mm:ss";
    ChannelTokenService channelTokenService;

    public void setChannelTokenService(ChannelTokenService channelTokenService) {
        this.channelTokenService = channelTokenService;
    }

    protected Object retrunParam(ChannelRlRequest channelRequest, Map<String, Object> map) {
        if (StringUtils.isBlank((String)channelRequest.getCmFchannelApi().getAppapiCode()) || StringUtils.isBlank((String)channelRequest.getChannelApiCode())) {
            throw new ApiException("cmc.ChannelInfuencerBaseService.send.apicode", channelRequest.getCmFchannelApi().getFchannelApiCode());
        }
        HashMap<String, Object> param = new HashMap();
        if ("cmc.channelInfuencer.channelInfuencer".equals(channelRequest.getChannelApiCode())) {
            param = this.addInfuencerParams(map);
        } else if ("cmc.channelInfuencer.getInfuencerList".equals(channelRequest.getChannelApiCode())) {
            param = this.getlistRetrunParams(map);
        } else if ("cmc.channelInfuencer.getInfuencerRplyList".equals(channelRequest.getChannelApiCode())) {
            param = this.getRplyListRetrunParams(map);
        } else if ("cmc.channelInfuencer.addGoodsToInfuencer".equals(channelRequest.getChannelApiCode())) {
            param = this.addGoodsRetrunParams(map);
        } else if ("cmc.channelInfuencer.getCode".equals(channelRequest.getChannelApiCode())) {
            param = this.getCodeParams(map);
            return this.sendGetCodePost(channelRequest, param, map);
        }
        return this.makeSendReturn(channelRequest, param, map);
    }

    private Map<String, Object> resultMap(int code, String state, String dataObj, String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", code);
        resultMap.put("state", state);
        resultMap.put("dataObj", dataObj);
        resultMap.put("msg", msg);
        this.logger.error("cmc.ChannelInfuencerBaseService.resultMap", (Object)JsonUtil.buildNormalBinder().toJson(resultMap));
        return resultMap;
    }

    public String getFchannelCode() {
        return WeChatPayMiniConstants.channelCode;
    }

    protected ChannelRlRequest send(ChannelRlRequest channelRequest, Map<String, Object> param) {
        this.logger.error("cmc.ChannelInfuencerBaseService.send", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelRequest));
        return channelRequest;
    }

    private Map<String, Object> addInfuencerParams(Map<String, Object> map) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", map.get("infuencerName"));
        params.put("coverImg", map.get("infuencerUrlid"));
        params.put("startTime", this.getDataToLong(map.get("infuencerStart")));
        params.put("endTime", this.getDataToLong(map.get("infuencerEnd")));
        params.put("anchorName", map.get("infuencerInfname"));
        params.put("anchorWechat", map.get("infuencerInfid"));
        params.put("shareImg", map.get("infuencerUrlid1"));
        params.put("type", map.get("infuencerEtype"));
        params.put("screenType", map.get("infuencerSctype"));
        params.put("closeLike", map.get("infuencerCloselike"));
        params.put("closeGoods", map.get("infuencerClosegoods"));
        params.put("closeComment", map.get("infuencerClosecomment"));
        return params;
    }

    private Map<String, Object> getlistRetrunParams(Map<String, Object> map) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("start", map.get("start"));
        params.put("limit", map.get("limit"));
        return params;
    }

    private Map<String, Object> getRplyListRetrunParams(Map<String, Object> map) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("start", map.get("start"));
        params.put("limit", map.get("limit"));
        params.put("action", "get_replay");
        params.put("room_id", map.get("roomId"));
        return params;
    }

    private Map<String, Object> addGoodsRetrunParams(Map<String, Object> map) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", map.get("ids"));
        params.put("roomId", map.get("roomId"));
        return params;
    }

    private Map<String, Object> getCodeParams(Map<String, Object> map) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("path", map.get("path"));
        if (null != map.get("width")) {
            params.put("width", map.get("width"));
        }
        if (null != map.get("autoColor")) {
            params.put("auto_color", map.get("autoColor"));
        }
        if (null != map.get("lineColor")) {
            params.put("line_color", map.get("lineColor"));
        }
        if (null != map.get("isHyaline")) {
            params.put("is_hyaline", map.get("isHyaline"));
        }
        return params;
    }

    private String sendGetCodePost(ChannelRlRequest channelRequest, Map<String, Object> params, Map<String, Object> map) {
        String result = "";
        String url = channelRequest.getCmFchannelApi().getAppapiCode();
        String accessToken = this.accessToken(map, false);
        if (StringUtils.isBlank((String)accessToken)) {
            return "error";
        }
        this.logger.error("cmc.ChannelInfuencerBaseService.sendPost.params", (Object)JsonUtil.buildNormalBinder().toJson(params));
        result = this.sendCodePost(params, url + accessToken);
        return result;
    }

    private Map<String, Object> makeSendReturn(ChannelRlRequest channelRequest, Map<String, Object> params, Map<String, Object> map) {
        String result = "";
        String url = channelRequest.getCmFchannelApi().getAppapiCode();
        String accessToken = this.accessToken(map, false);
        if (StringUtils.isBlank((String)accessToken)) {
            return this.resultMap(-1, "error", "accessToken is null", "\u64cd\u4f5c\u5931\u8d25");
        }
        this.logger.error("cmc.ChannelInfuencerBaseService.sendPost.params", (Object)JsonUtil.buildNormalBinder().toJson(params));
        result = this.sendPost(params, url + accessToken);
        Map<String, Object> resultMap = this.getResultMap(result);
        if (MapUtils.isNotEmpty(resultMap) && "41001".equals(resultMap.get("errcode").toString())) {
            this.logger.error("cmc.ChannelInfuencerBaseService.sendPost.resultMap.errcode=40001", (Object)JsonUtil.buildNormalBinder().toJson(resultMap));
            accessToken = this.accessToken(map, true);
            if (StringUtils.isBlank((String)accessToken)) {
                return this.resultMap(-1, "error", result, "\u64cd\u4f5c\u5931\u8d25");
            }
            result = this.sendPost(params, url + accessToken);
            resultMap = this.getResultMap(result);
        }
        if (MapUtils.isNotEmpty(resultMap) && "0".equals(resultMap.get("errcode").toString())) {
            return this.resultMap(1, "success", result, "\u64cd\u4f5c\u6210\u529f");
        }
        return this.resultMap(-1, "error", result, "\u64cd\u4f5c\u5931\u8d25");
    }

    private long getDataToLong(Object object) {
        return DateUtil.getDateToString((String)((String)object), (String)DATETIMESHOWFORMAT).getTime() / 1000L;
    }

    private Map<String, Object> getResultMap(String result) {
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
    }

    private String accessToken(Map<String, Object> params, boolean ifUpdate) {
        params.put("ifUpdate", ifUpdate);
        this.logger.error("cmc.ChannelInfuencerBaseServiceaccessToken.params", (Object)JsonUtil.buildNormalBinder().toJson(params));
        Object token = this.channelTokenService.channelToken(params);
        this.logger.error("cmc.ChannelInfuencerBaseServiceaccessToken", token);
        return (String)token;
    }

    private String sendPost(Map<String, Object> params, String url) {
        String result = "";
        try {
            result = WebUtils.doPostJson((String)url, params, (int)100000, (int)100000);
            if (StringUtils.isBlank((String)result)) {
                this.logger.error("cmc.ChannelInfuencerBaseService.login:result", (Object)(result + "+(result\u4e3a\u7a7a)"));
                return null;
            }
        }
        catch (IOException e) {
            this.logger.error("cmc.ChannelInfuencerBaseService.login:result", (Object)result, (Throwable)e);
            return null;
        }
        return result;
    }

    private String sendCodePost(Map<String, Object> params, String url) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
        RestTemplate rest = new RestTemplate();
        ResponseEntity entity = rest.exchange(url, HttpMethod.POST, requestEntity, byte[].class, new Object[0]);
        String s = JsonUtil.buildNormalBinder().toJson(entity.getBody());
        return s.replace("\"", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        String access_token = "41_mubWGQI-RUaGjBnOSqtSJTmUzQqVVZyDUdJsqVdC6n_bu3pjcMvY3ivmIh2Z_R_15epQP9zf8j3gRMZBKUP5ezIXCeXX-PWS7BygO0i_Nh1NSG3SNE33zkCHsfUZb5NneSjEs1sd13hIUcOIAWZhAHAQMP";
        String url = "https://api.weixin.qq.com/wxa/business/getliveinfo?access_token=";
        HashMap params = new HashMap();
        String result = "";
        try {
            result = WebUtils.doPostJson((String)(url + access_token), params, (int)100000, (int)100000);
            if (!StringUtils.isBlank((String)result)) {
                // empty if block
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println(new Date());
        System.out.println(access_token);
        System.out.println(result);
    }
}

