/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.wechatpaypc.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.ext.channel.wechatpaypc.util.WeChatPayConfig;
import com.yqbsoft.laser.service.ext.channel.wechatpaypc.util.WeChatPayNotify;
import com.yqbsoft.laser.service.ext.channel.wechatpaypc.util.WeChatPaySubmit;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import com.yqbsoft.laser.service.tool.util.XmlUtil;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";

    public void sign(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null", "");
        }
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42config\uff1a" + channelRequest.getConfigMap()));
        this.makeSubmch(channelRequest.getConfigMap(), channelRequest.getRequestData());
        Map<String, String> params = WeChatPaySubmit.buildRequestPara(channelRequest.getRequestData());
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\uff1a" + params));
        String resXml = "";
        try {
            resXml = WebUtils.doPost((String)channelRequest.getCmFchannelApi().getAppapiCode(), (String)"text/html;charset=utf-8", (byte[])XmlUtil.callMapToXML(params).getBytes("utf-8"), (int)5000, (int)5000);
        }
        catch (IOException e) {
            this.logger.error("wechatpc", (Throwable)e);
        }
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\uff1a" + resXml));
        CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        HashMap<String, String> res = new HashMap<String, String>();
        Map resMap = XmlUtil.getMapFromXML((String)resXml);
        if (null != resMap && !resMap.isEmpty()) {
            res.putAll(resMap);
        }
        res.put("out_trade_no", cmChannelClear.getChannelClearSeqno());
        res.put("fchannelCode", cmChannelClear.getFchannelCode());
        res.put("tenantCode", cmChannelClear.getTenantCode());
        res.put("fchannelPmode", cmChannelClear.getFchannelPmodeCode());
        res.put("total_fee", cmChannelClear.getOrderAmount().setScale(2, RoundingMode.HALF_UP).toString());
        channelRequest.setRequestData(res);
    }

    private void makeSubmch(Map<String, String> configMap, Map<String, String> requestMap) {
        if (configMap != null && configMap.containsKey("sub_mch_id")) {
            requestMap.put("sub_mch_id", configMap.get("sub_mch_id"));
        }
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.null", "");
        }
        Map res = bankRequest.getRequestData();
        if (bankRequest.isSing()) {
            res = XmlUtil.getMapFromXML((String)((String)bankRequest.getRequestData().get("resStream")));
            res.put(WeChatPayConfig.pay_key, bankRequest.getConfigMap().get(WeChatPayConfig.pay_key));
            if (!WeChatPayNotify.verify(res)) {
                throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.verify", "");
            }
        }
        if (res.containsKey("res")) {
            String resJson = (String)res.get("res");
            Map resMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resJson, String.class, String.class);
            res.putAll(resMap);
        }
        bankRequest.setRequestData(res);
        return this.buildApiCallParam(bankRequest);
    }

    public static void main(String[] args) {
        String as = "<xml><appid><![CDATA[wx44ecf8aa3d0c1fc4]]></appid><bank_type><![CDATA[CFT]]></bank_type><cash_fee><![CDATA[1]]></cash_fee><fee_type><![CDATA[CNY]]></fee_type><is_subscribe><![CDATA[N]]></is_subscribe><mch_id><![CDATA[1489225562]]></mch_id><nonce_str><![CDATA[e7e7e9c8dddd479c9f11a6fd1fe66e46]]></nonce_str><openid><![CDATA[oXCzm0rRnStJVdWxnRCtzXC1uNuU]]></openid><out_trade_no><![CDATA[4a2790c91cab4e0d86306ee012df455e]]></out_trade_no><result_code><![CDATA[SUCCESS]]></result_code><return_code><![CDATA[SUCCESS]]></return_code><sign><![CDATA[43BD59F997CA8843BEAF4EF9689FDECC]]></sign><sub_appid><![CDATA[wxaa8f237bb41f272d]]></sub_appid><sub_is_subscribe><![CDATA[Y]]></sub_is_subscribe><sub_mch_id><![CDATA[1490664922]]></sub_mch_id><sub_openid><![CDATA[ow7ps06rtZd4iJjFfNJgrHdDLE0o]]></sub_openid><time_end><![CDATA[20171027111952]]></time_end><total_fee>1</total_fee><trade_type><![CDATA[MWEB]]></trade_type><transaction_id><![CDATA[4200000026201710270582133208]]></transaction_id></xml>";
        Map res = XmlUtil.getMapFromXML((String)as);
        res.put("pay_key", "69f049122e4d459e822a37df62669337");
        System.out.println(WeChatPayNotify.verify(res));
    }
}

