/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.wechatpaypc.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ExtFmFile;
import com.yqbsoft.laser.service.ext.channel.com.domain.ExtPtfchannel;
import com.yqbsoft.laser.service.ext.channel.com.enumc.FchannelTypeEnum;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelDownloadBaseService;
import com.yqbsoft.laser.service.ext.channel.wechatpaypc.WeChatPayPcConstants;
import com.yqbsoft.laser.service.ext.channel.wechatpaypc.util.WeChatPayConfig;
import com.yqbsoft.laser.service.ext.channel.wechatpaypc.util.WeChatPaySubmit;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import com.yqbsoft.laser.service.tool.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ChannelDownloadServiceImpl
extends ChannelDownloadBaseService {
    public String getFchannelCode() {
        return WeChatPayPcConstants.CHANNEL_CODE;
    }

    public ChannelRest channelSDownload(ExtPtfchannel ptePtfchannel) {
        String res;
        if (!FchannelTypeEnum.WECHAT.getCode().equals(ptePtfchannel.getFchannelType())) {
            throw new ApiException("cmc.wechatpc.channelIn.channelSDownload.error", "only wechat pay can be used");
        }
        Map requestMap = this.channelReuestParam(ptePtfchannel);
        if (null == requestMap || !requestMap.containsKey(WeChatPayConfig.pay_key)) {
            throw new ApiException("cmc.wechatpc.channelIn.channelSDownload.error", "merchants message Illegal");
        }
        Date orderDate = this.getOrderDate(ptePtfchannel.getMemo(), ptePtfchannel.getGmtCreate());
        try {
            res = this.downloadBill(requestMap, orderDate);
        }
        catch (IOException e) {
            throw new ApiException("cmc.wechatpc.channelIn.channelSDownload.error", "downloadbill fail Msg:" + e.getMessage());
        }
        return this.processBill(res, ptePtfchannel, DateUtils.addDays((Date)orderDate, (int)1));
    }

    private ChannelRest processBill(String billStr, ExtPtfchannel ptePtfchannel, Date billDate) {
        ChannelRest result = new ChannelRest();
        if (billStr.contains("return_code")) {
            Map resMap = XmlUtil.getMapFromXML((String)billStr);
            this.logger.error("ChannelDownloadService.channelSDownload.error", resMap.get("return_msg"));
            result.setDataState(Integer.valueOf(-1));
            result.setRestMemo((String)resMap.get("return_msg"));
            return result;
        }
        this.saveOriginBillAsCSV(billStr, ptePtfchannel.getTenantCode(), billDate);
        ExtFmFile ff = this.getExtFmFile(ptePtfchannel, billStr, billDate);
        if (null == ff) {
            result.setDataState(Integer.valueOf(3));
            return result;
        }
        result.setChannelSubStr(JsonUtil.buildNormalBinder().toJson((Object)ff));
        return result;
    }

    private void saveOriginBillAsCSV(String res, String tenantCode, Date billDate) {
        String date = DateUtil.getDateString((Date)billDate, (String)"yyyy-MM-dd");
        String fileName = "original-WECHAT-".concat(tenantCode + "-").concat(date).concat(".csv");
        String fileStructure = File.separator + DateUtil.getDateString((Date)billDate, (String)"yyyy-MM-dd");
        this.saveFile(res.getBytes(StandardCharsets.UTF_8), fileName, tenantCode, "FILE_07", fileStructure);
    }

    private ExtFmFile getExtFmFile(ExtPtfchannel ptePtfchannel, String res, Date billDate) {
        String date = DateUtil.getDateString((Date)billDate, (String)"yyyy-MM-dd");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("res", res);
        map.put("fchanelType", ptePtfchannel.getFchannelType());
        map.put("tenantCode", ptePtfchannel.getTenantCode());
        map.put("date", date);
        return this.parse(map);
    }

    private Map<String, String> getRequestMap(Map<String, String> requestMap, Date billDate) {
        HashMap<String, String> signMap = new HashMap<String, String>();
        signMap.put("appid", requestMap.get("appid"));
        signMap.put("mch_id", requestMap.get("mch_id"));
        signMap.put("nonce_str", this.createUUIDString());
        signMap.put(WeChatPayConfig.pay_key, requestMap.get(WeChatPayConfig.pay_key));
        signMap.put("bill_date", DateUtil.getDateString((Date)billDate, (String)"yyyyMMdd"));
        signMap.put("bill_type", "ALL");
        if (requestMap != null && requestMap.containsKey("sub_mch_id")) {
            signMap.put("sub_mch_id", requestMap.get("sub_mch_id"));
        }
        String mysign = WeChatPaySubmit.buildRequestMysign(signMap);
        signMap.put("sign", mysign);
        return signMap;
    }

    private String downloadBill(Map<String, String> requestMap, Date billDate) throws IOException {
        Map<String, String> signMap = this.getRequestMap(requestMap, billDate);
        return WebUtils.doPost((String)WeChatPayConfig.downloadbillUrl, (String)"text/html;charset=utf-8", (byte[])XmlUtil.callMapToXML(signMap).getBytes("utf-8"), (int)5000, (int)5000);
    }

    public static void parseRes() {
        String[] lines;
        String res = "\ufeff\u4ea4\u6613\u65f6\u95f4,\u516c\u4f17\u8d26\u53f7ID,\u5546\u6237\u53f7,\u5b50\u5546\u6237\u53f7,\u8bbe\u5907\u53f7,\u5fae\u4fe1\u8ba2\u5355\u53f7,\u5546\u6237\u8ba2\u5355\u53f7,\u7528\u6237\u6807\u8bc6,\u4ea4\u6613\u7c7b\u578b,\u4ea4\u6613\u72b6\u6001,\u4ed8\u6b3e\u94f6\u884c,\u8d27\u5e01\u79cd\u7c7b,\u603b\u91d1\u989d,\u4f01\u4e1a\u7ea2\u5305\u91d1\u989d,\u5fae\u4fe1\u9000\u6b3e\u5355\u53f7,\u5546\u6237\u9000\u6b3e\u5355\u53f7,\u9000\u6b3e\u91d1\u989d,\u4f01\u4e1a\u7ea2\u5305\u9000\u6b3e\u91d1\u989d,\u9000\u6b3e\u7c7b\u578b,\u9000\u6b3e\u72b6\u6001,\u5546\u54c1\u540d\u79f0,\u5546\u6237\u6570\u636e\u5305,\u624b\u7eed\u8d39,\u8d39\u7387`2017-01-04 14:22:39,`wxd83aab5d20209f66,`1386231002,`0,`,`4005002001201701045153295539,`82de73ecb41e4ba8b9e27e935de86122,`oI5Qcw2UJJmfYmtROJGyfaX6clR0,`NATIVE,`SUCCESS,`CMB_CREDIT,`CNY,`0.10,`0.00,`0,`0,`0.00,`0.00,`,`,`\u8d1d\uff0b\u4e91\u94b1\u5305,`,`0.00000,`1.00%`2017-01-04 09:17:11,`wxd83aab5d20209f66,`1386231002,`0,`,`4006162001201701045111830849,`f5917f888c4c4c7f8a122d0d01101b5d,`oI5Qcw7fnVFY9ZJ6cnpLl6mYotMc,`NATIVE,`SUCCESS,`CFT,`CNY,`0.10,`0.00,`0,`0,`0.00,`0.00,`,`,`\u8d1d\uff0b\u4e91\u94b1\u5305,`,`0.00000,`1.00%`2017-01-04 12:01:04,`wxd83aab5d20209f66,`1386231002,`0,`,`4006162001201701045132563234,`a105ff7b3b7e4e4fb653b0729f9bba6b,`oI5Qcw7fnVFY9ZJ6cnpLl6mYotMc,`NATIVE,`SUCCESS,`CFT,`CNY,`0.10,`0.00,`0,`0,`0.00,`0.00,`,`,`\u8d1d\uff0b\u4e91\u94b1\u5305,`,`0.00000,`1.00%`2017-01-04 19:46:07,`wxd83aab5d20209f66,`1386231002,`0,`,`4006162001201701045191982509,`3ee614f4f3284ad9af9ba873173b5e25,`oI5Qcw7fnVFY9ZJ6cnpLl6mYotMc,`JSAPI,`SUCCESS,`CFT,`CNY,`0.10,`0.00,`0,`0,`0.00,`0.00,`,`,`\u8d1d\uff0b\u4e91\u94b1\u5305,`,`0.00000,`1.00%`2017-01-04 18:19:12,`wxd83aab5d20209f66,`1386231002,`0,`,`4006702001201701045180874136,`c75c60ee0ce6483da3e0501afb58dc27,`oI5QcwylDm36HW2QJTnsfBh2Mc3g,`NATIVE,`SUCCESS,`CFT,`CNY,`0.10,`0.00,`0,`0,`0.00,`0.00,`,`,`\u8d1d\uff0b\u4e91\u94b1\u5305,`,`0.00000,`1.00%`2017-01-04 18:28:21,`wxd83aab5d20209f66,`1386231002,`0,`,`4006702001201701045181525651,`b24b44fbe1ec48bd9832f3eae829b089,`oI5QcwylDm36HW2QJTnsfBh2Mc3g,`JSAPI,`SUCCESS,`CFT,`CNY,`0.10,`0.00,`0,`0,`0.00,`0.00,`,`,`\u8d1d\uff0b\u4e91\u94b1\u5305,`,`0.00000,`1.00%`2017-01-04 18:20:56,`wxd83aab5d20209f66,`1386231002,`0,`,`4006702001201701045182464645,`f802dff771a44e3f86a831c32bcdd3ae,`oI5QcwylDm36HW2QJTnsfBh2Mc3g,`JSAPI,`SUCCESS,`CFT,`CNY,`0.10,`0.00,`0,`0,`0.00,`0.00,`,`,`\u8d1d\uff0b\u4e91\u94b1\u5305,`,`0.00000,`1.00%`2017-01-04 18:26:00,`wxd83aab5d20209f66,`1386231002,`0,`,`4006702001201701045182793296,`a69e84ea9bbd433984a56105c9d2fcab,`oI5QcwylDm36HW2QJTnsfBh2Mc3g,`JSAPI,`SUCCESS,`CFT,`CNY,`0.10,`0.00,`0,`0,`0.00,`0.00,`,`,`\u8d1d\uff0b\u4e91\u94b1\u5305,`,`0.00000,`1.01%\u603b\u4ea4\u6613\u5355\u6570,\u603b\u4ea4\u6613\u989d,\u603b\u9000\u6b3e\u91d1\u989d,\u603b\u4f01\u4e1a\u7ea2\u5305\u9000\u6b3e\u91d1\u989d,\u624b\u7eed\u8d39\u603b\u91d1\u989d`8,`0.80,`0.00,`0.00,`0.00000";
        String a = res.substring(res.indexOf("\u8d39\u7387") + 2, res.indexOf("\u603b\u4ea4\u6613\u5355\u6570"));
        for (String line : lines = a.split("\r\n")) {
            String[] d = line.replace("`", "").split(",");
            String localOrder = d[6];
            System.out.println(localOrder);
        }
    }
}

