/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.yl.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;

public class Util {
    public static String makeSign(String md5Key, Map<String, String> params) {
        String preStr = Util.buildSignString(params);
        String text = preStr + md5Key;
        return DigestUtils.sha256Hex((byte[])Util.getContentBytes(text));
    }

    private static String buildSignString(Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return "";
        }
        ArrayList<String> keys = new ArrayList<String>(params.size());
        for (String key : params.keySet()) {
            if ("sign".equals(key) || StringUtils.isEmpty((CharSequence)params.get(key))) continue;
            keys.add(key);
        }
        Collections.sort(keys);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                buf.append(key + "=" + value);
                continue;
            }
            buf.append(key + "=" + value + "&");
        }
        return buf.toString();
    }

    private static byte[] getContentBytes(String content) {
        try {
            return content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef");
        }
    }

    public static String genMerOrderId(String msgId) {
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
        String rand = RandomStringUtils.randomNumeric((int)7);
        return msgId + date + rand;
    }
}

