/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.request.thirdpay;

import com.google.common.base.Preconditions;
import com.yqbsoft.laser.service.ext.data.cyy.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.request.BaseApiRequest;
import java.util.HashMap;
import java.util.Map;

public class ThirdPayMockRequest
extends BaseApiRequest {
    private String action;
    private String amount;
    private Long tradeNo;
    private String payFlowId;
    private Map<String, Object> extInfoMap;

    public static ThirdPayMockRequest mockPay(String amount, Map<String, Object> extInfoMap) {
        Preconditions.checkArgument((extInfoMap != null && extInfoMap.size() > 0 ? 1 : 0) != 0, (Object)"extInfoMap\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ThirdPayMockRequest request = new ThirdPayMockRequest();
        request.setAction("create");
        request.setAmount(amount);
        request.setExtInfoMap(extInfoMap);
        return request;
    }

    public static ThirdPayMockRequest mockRefund(String amount, Long tradeNo) {
        ThirdPayMockRequest request = new ThirdPayMockRequest();
        request.setAction("refund");
        request.setAmount(amount);
        request.setTradeNo(tradeNo);
        request.setPayFlowId(tradeNo.toString());
        return request;
    }

    public static ThirdPayMockRequest mockPayQuery(Long tradeNo) {
        ThirdPayMockRequest request = new ThirdPayMockRequest();
        request.setAction("query");
        request.setTradeNo(tradeNo);
        request.setPayFlowId(tradeNo.toString());
        return request;
    }

    public static void main(String[] args) {
        HashMap<String, Object> extInfoMap = new HashMap<String, Object>();
        extInfoMap.put("staffId", 12L);
        extInfoMap.put("staffEmail", "chenzhenfeng");
        ThirdPayMockRequest request = ThirdPayMockRequest.mockPay("1.0", extInfoMap);
        String str = JsonUtil.object2Json(request);
        System.out.println(str);
        ThirdPayMockRequest request2 = JsonUtil.json2Object(str, ThirdPayMockRequest.class);
        System.out.println(str);
    }

    public String getAction() {
        return this.action;
    }

    public String getAmount() {
        return this.amount;
    }

    public Long getTradeNo() {
        return this.tradeNo;
    }

    public String getPayFlowId() {
        return this.payFlowId;
    }

    public Map<String, Object> getExtInfoMap() {
        return this.extInfoMap;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setTradeNo(Long tradeNo) {
        this.tradeNo = tradeNo;
    }

    public void setPayFlowId(String payFlowId) {
        this.payFlowId = payFlowId;
    }

    public void setExtInfoMap(Map<String, Object> extInfoMap) {
        this.extInfoMap = extInfoMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThirdPayMockRequest)) {
            return false;
        }
        ThirdPayMockRequest other = (ThirdPayMockRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        Long this$tradeNo = this.getTradeNo();
        Long other$tradeNo = other.getTradeNo();
        if (this$tradeNo == null ? other$tradeNo != null : !((Object)this$tradeNo).equals(other$tradeNo)) {
            return false;
        }
        String this$payFlowId = this.getPayFlowId();
        String other$payFlowId = other.getPayFlowId();
        if (this$payFlowId == null ? other$payFlowId != null : !this$payFlowId.equals(other$payFlowId)) {
            return false;
        }
        Map<String, Object> this$extInfoMap = this.getExtInfoMap();
        Map<String, Object> other$extInfoMap = other.getExtInfoMap();
        return !(this$extInfoMap == null ? other$extInfoMap != null : !((Object)this$extInfoMap).equals(other$extInfoMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThirdPayMockRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        Long $tradeNo = this.getTradeNo();
        result = result * 59 + ($tradeNo == null ? 43 : ((Object)$tradeNo).hashCode());
        String $payFlowId = this.getPayFlowId();
        result = result * 59 + ($payFlowId == null ? 43 : $payFlowId.hashCode());
        Map<String, Object> $extInfoMap = this.getExtInfoMap();
        result = result * 59 + ($extInfoMap == null ? 43 : ((Object)$extInfoMap).hashCode());
        return result;
    }

    public String toString() {
        return "ThirdPayMockRequest(action=" + this.getAction() + ", amount=" + this.getAmount() + ", tradeNo=" + this.getTradeNo() + ", payFlowId=" + this.getPayFlowId() + ", extInfoMap=" + this.getExtInfoMap() + ")";
    }
}

