/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.Util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);
    public static final String DATE_AND_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_AND_TIME_NUMBER_PATTERN = "yyyyMMddHHmmss";
    public static final String DATE_STRING_PATTERN = "yyyy-MM-dd";
    public static final String DATE_INTEGER_PATTERN = "yyyyMMdd";
    public static final String DATE_SERIAL_NUMBER_PATTERN = "yyyyMMddHHmmssS";
    public static final String DATE_HOUR_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final int DAYS = 31;

    public static Date getDateByString(String dateStr, String pattern) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = DATE_AND_TIME_PATTERN;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
            return sdf.parse(dateStr);
        }
        catch (Exception var3) {
            LOGGER.error("Transfer date error, dateStr={}, pattern={}", new Object[]{dateStr, pattern, var3});
            return null;
        }
    }

    public static String getStringByDate(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = DATE_AND_TIME_PATTERN;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
            return sdf.format(date);
        }
        catch (Exception var3) {
            LOGGER.error("Transfer date error, pattern={}", (Object)pattern, (Object)var3);
            return null;
        }
    }

    public static Date getDateByInteger(Integer dateInteger) {
        if (dateInteger >= 10000000 && dateInteger <= 99999999) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_INTEGER_PATTERN, Locale.US);
                return sdf.parse(String.valueOf(dateInteger));
            }
            catch (Exception var2) {
                LOGGER.error("Transfer date error, dateInteger={}", (Object)dateInteger, (Object)var2);
                return null;
            }
        }
        LOGGER.warn("Transfer date error, dateInteger={}", (Object)dateInteger);
        return null;
    }

    public static Integer getIntegerByDate(Date date) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_INTEGER_PATTERN, Locale.US);
            return Integer.valueOf(sdf.format(date));
        }
        catch (Exception var2) {
            LOGGER.error("Transfer date error", (Throwable)var2);
            return null;
        }
    }

    public static Integer getIntegerByString(String dateStr, String pattern) {
        Date date = DateUtil.getDateByString(dateStr, pattern);
        return date != null ? DateUtil.getIntegerByDate(date) : -1;
    }

    public static Long getTimeStamp(String dateStr, String pattern) {
        Date date = DateUtil.getDateByString(dateStr, pattern);
        return date != null ? date.getTime() : -1L;
    }

    public static Date getDateFromTimeStamp(Long timeStamp) {
        if (timeStamp != null && timeStamp != 0L) {
            try {
                Date date = new Date(timeStamp);
                return date;
            }
            catch (Exception var2) {
                LOGGER.error("Transfer date error", (Throwable)var2);
                return null;
            }
        }
        return null;
    }

    public static String getStringFromTimeStamp(Long timeStamp, String pattern) {
        Date date = DateUtil.getDateFromTimeStamp(timeStamp);
        return DateUtil.getStringByDate(date, pattern);
    }

    public static Date getDateBefore(Date date, int daysBefore) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, daysBefore * -1);
        return cal.getTime();
    }

    public static Date getDateBeforeBySeconds(Date date, int secondsBefore) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, secondsBefore * -1);
        return cal.getTime();
    }

    public static Date getDateBeforeByYears(Date date, int yearsBefore) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, yearsBefore * -1);
        return cal.getTime();
    }

    public static String getDateSerialNumber() {
        String dateStr = DateUtil.getStringByDate(new Date(), DATE_SERIAL_NUMBER_PATTERN);
        return dateStr != null && dateStr.length() > 16 ? dateStr.substring(0, 16) : dateStr;
    }

    public static int minutesBetween(Date end, Date start) {
        return end != null && start != null ? (int)(end.getTime() - start.getTime()) / 60000 : 0;
    }

    public static long absSecondsDifference(Date date1, Date date2) {
        return date1 != null && date2 != null ? Math.abs((date1.getTime() - date2.getTime()) / 1000L) : 0L;
    }

    public static Date getStartTime(Date date) {
        Calendar dateStart = Calendar.getInstance();
        dateStart.setTime(date);
        dateStart.set(11, 0);
        dateStart.set(12, 0);
        dateStart.set(13, 0);
        return dateStart.getTime();
    }

    public static Date getEndTime(Date date) {
        Calendar dateEnd = Calendar.getInstance();
        dateEnd.setTime(date);
        dateEnd.set(11, 23);
        dateEnd.set(12, 59);
        dateEnd.set(13, 59);
        return dateEnd.getTime();
    }

    public static int calcDays(Date begin, Date end) {
        return begin != null && end != null ? (int)((end.getTime() - begin.getTime()) / 86400000L) : 0;
    }
}

