/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.Util;

import com.yqbsoft.laser.service.ext.data.cyy.service.Util.RsaUtil;
import com.yqbsoft.laser.service.ext.data.service.DateBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.net.URLEncoder;
import java.security.interfaces.RSAPrivateKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.RandomStringUtils;

public class SqtH5Access
extends DateBaseService {
    private static final String SYS_CODE = "SqtH5Access";
    private static final SupperLogUtil logger = new SupperLogUtil(SqtH5Access.class);

    public static String getH5AccessUrl(String url, String privateKey, String appkey, Integer entId, String productType, String staffNo) {
        try {
            String params = "appKey=" + appkey + "&entId=" + entId + "&nounce=" + SqtH5Access.getNounce() + "&productType=" + productType + "&requestTime=" + SqtH5Access.getRequestTime() + "&staffNo=" + staffNo;
            logger.error("SqtH5Access.getH5AccessUrl.params", (Object)params);
            RSAPrivateKey rsaPrivateKey = RsaUtil.loadPrivateKey(privateKey);
            String signature = RsaUtil.sign(params.getBytes(), rsaPrivateKey);
            String h5AccessUrl = url + "?" + params + "&signature=" + URLEncoder.encode(signature, "utf-8");
            logger.error("SqtH5Access.getH5AccessUrl.h5AccessUrl", (Object)h5AccessUrl);
            return h5AccessUrl;
        }
        catch (Exception e) {
            logger.error("SqtH5Access\u83b7\u53d6h5AccessUrl\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static String getRequestTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Date now = new Date(System.currentTimeMillis());
        return formatter.format(now);
    }

    private static String getNounce() {
        return RandomStringUtils.random((int)36, (boolean)true, (boolean)true);
    }

    public static void main(String[] args) {
        String url = "https://m-sqt.meituan.com/open/commonaccess/access";
        String appkey = null;
        String privateKey = null;
        Integer entId = null;
        String productType = null;
        String staffNo = null;
        String h5AccessUrl = SqtH5Access.getH5AccessUrl(url, privateKey, appkey, entId, productType, staffNo);
        System.out.println(h5AccessUrl);
    }
}

