/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.cyy.service.h5Access;

import com.yqbsoft.laser.service.ext.data.cyy.service.h5Access.ProductTypeSortMap;
import com.yqbsoft.laser.service.ext.data.cyy.service.h5Access.RsaUtil;
import com.yqbsoft.laser.service.ext.data.cyy.service.h5model.H5Params;
import com.yqbsoft.laser.service.ext.data.cyy.service.h5model.MtWaimai;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.URLEncoder;
import java.security.interfaces.RSAPrivateKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqtH5Access {
    private static Logger logger = LoggerFactory.getLogger(SqtH5Access.class);

    public static String getH5AccessUrl(String url, String privateKey, String appkey, Integer entId, String productType, String staffNo) {
        try {
            String params = "appKey=" + appkey + "&entId=" + entId + "&nounce=" + SqtH5Access.getNounce() + "&productType=" + productType + "&requestTime=" + SqtH5Access.getRequestTime() + "&staffNo=" + staffNo;
            RSAPrivateKey rsaPrivateKey = RsaUtil.loadPrivateKey(privateKey);
            String signature = RsaUtil.sign(params.getBytes(), rsaPrivateKey);
            String h5AccessUrl = url + "?" + params + "&signature=" + URLEncoder.encode(signature, "utf-8");
            return h5AccessUrl;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6h5AccessUrl\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static String getRequestTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Date now = new Date(System.currentTimeMillis());
        return formatter.format(now);
    }

    private static String getNounce() {
        return RandomStringUtils.random((int)36, (boolean)true, (boolean)true);
    }

    private static String mtWaimai(String appkey, Integer entid, String staffNo) {
        MtWaimai mtWaimai = new MtWaimai();
        mtWaimai.setAppKey(appkey);
        mtWaimai.setEntId(entid);
        mtWaimai.setNounce(SqtH5Access.getNounce());
        mtWaimai.setProductType("mt_waimai");
        mtWaimai.setRequestTime(Long.valueOf(SqtH5Access.getRequestTime()));
        mtWaimai.setStaffNo(staffNo);
        mtWaimai.setStaffPhoneNo("");
        mtWaimai.setLongitude("");
        mtWaimai.setLatitude("");
        mtWaimai.setGeotype("");
        mtWaimai.setAddress("");
        mtWaimai.setSceneType(1);
        mtWaimai.setSsoUser("");
        mtWaimai.setSqtOrderId("");
        return ProductTypeSortMap.mtWaimaiSortMap(mtWaimai);
    }

    public static String h5Params(String staffNo, String productType) {
        String appkey = SqtH5Access.getDdFalgSetting("00000000", "meituan", "appkey", "");
        String entid = SqtH5Access.getDdFalgSetting("00000000", "meituan", "entid", "");
        H5Params h5Params = new H5Params();
        h5Params.setAppKey(appkey);
        h5Params.setEntId(Integer.parseInt(entid));
        h5Params.setNounce(SqtH5Access.getNounce());
        h5Params.setRequestTime(Long.valueOf(SqtH5Access.getRequestTime()));
        h5Params.setProductType(StringUtils.isBlank((String)productType) ? "mt_waimai" : productType);
        h5Params.setStaffNo(staffNo);
        h5Params.setStaffPhoneNo("");
        h5Params.setStaffName("");
        h5Params.setEntToken("");
        h5Params.setTargetUrl("");
        h5Params.setThirdOrderId("");
        h5Params.setChannelType(-1);
        h5Params.setLongitude("");
        h5Params.setLatitude("");
        h5Params.setGeotype("");
        h5Params.setAddress("");
        h5Params.setWmExtraJson("");
        h5Params.setSceneType(4);
        h5Params.setBudgetKey("");
        h5Params.setRestaurantType(null);
        h5Params.setRestaurantId(null);
        h5Params.setActivityRuleId("");
        h5Params.setLockCityType(null);
        h5Params.setDeptExtraJson("");
        h5Params.setInvoiceExtraJson("");
        h5Params.setTmcTripExtraJson("");
        h5Params.setRepastApplyExtraJson("");
        h5Params.setSsoUser("");
        h5Params.setSqtOrderId("");
        return ProductTypeSortMap.h5ParamsSortMap(h5Params);
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        return value;
    }
}

