/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.dangao.service.xuankua.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.util.CollectionUtils;

public class HttpUtil {
    private static Log logger = LogFactory.getLog(HttpClientUtils.class);
    private static PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpClient = null;
    private static final int DEFAULT_MAX_TOTAL_CONNECTION = 1024;
    private static final int DEFAULT_MAX_PER_ROUTE = 300;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String CONTENT_TYPE_TEXT_XML = "application/xml";
    private static final String APPLICATION_XML = "text/xml";
    private static final int DEFAULT_CONNECTION_TIME_OUT = 60000;
    private static final int DEFAULT_READ_TIME_OUT = 200000;
    public static JSONObject custRespHeader = new JSONObject();

    private HttpUtil() {
    }

    public static String invokeGet(String url, Map<String, String> params, String encode, int connectTimeout, int readTimeout) {
        String requestUrl;
        if (connectTimeout <= 0) {
            return null;
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).build();
        try {
            requestUrl = HttpUtil.buildRequestUrl(url, params);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("encode http get params error, params is " + params), (Throwable)e);
            return "";
        }
        HttpPost httpGet = new HttpPost(requestUrl);
        httpGet.setHeader("Connection", "close");
        httpGet.setConfig(requestConfig);
        String responseString = HttpUtil.doRequest((HttpRequestBase)httpGet, encode);
        return responseString;
    }

    public static void main(String[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("order_no", "3063498203868");
        String s = HttpUtil.invokePost("https://dev.dangaoss.cn/dsapi/order/order_detail?channel_no=rencaiyouxuan&sign=d2d487cbec8f32e1ac6c4c61f86d07dc&timestamp=1694855747930", params);
        System.out.println(s);
    }

    public static String invokePost(String requestUrl, Map<String, Object> params) {
        return HttpUtil.invokePost(requestUrl, params, null, null, DEFAULT_ENCODING, 60000, 200000);
    }

    public static String invokePost(String requestUrl, Map<String, Object> params, Map<String, String> requestHeader) {
        return HttpUtil.invokePost(requestUrl, params, requestHeader, null, DEFAULT_ENCODING, 60000, 200000);
    }

    public static String invokePost(String requestUrl, Map<String, String> requestHeader, String requestBody) {
        return HttpUtil.invokePost(requestUrl, null, requestHeader, requestBody, DEFAULT_ENCODING, 60000, 200000);
    }

    public static String invokePost(String requestUrl, Map<String, Object> params, Map<String, String> requestHeader, String requestBody, String encode, int connectTimeout, int readTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).build();
        HttpPost httpPost = new HttpPost(requestUrl);
        httpPost.setConfig(requestConfig);
        if (MapUtils.isNotEmpty(requestHeader)) {
            for (Map.Entry<String, String> entry : requestHeader.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        HttpUtil.buildPostParams(httpPost, params, requestBody, encode);
        String responseString = HttpUtil.doRequest((HttpRequestBase)httpPost, encode);
        return responseString;
    }

    private static void buildPostParams(HttpPost httpPost, Map<String, Object> params, String requestBody, String encode) {
        try {
            if (MapUtils.isNotEmpty(params)) {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String value = null;
                    value = entry.getValue() instanceof String ? (String)entry.getValue() : JSON.toJSONString((Object)entry.getValue());
                    nameValuePairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, encode));
            }
            if (StringUtils.isNotBlank((String)requestBody)) {
                httpPost.setEntity((HttpEntity)new StringEntity(requestBody, encode));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("HttpClientUtils.buildPostParams error, params = " + params), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doRequest(HttpRequestBase httpRequestBase, String encode) {
        String responseString = null;
        try {
            long start = System.currentTimeMillis();
            logger.info((Object)("HttpClientUtils Begin Invoke: " + httpRequestBase.getURI() + ", cost time " + (System.currentTimeMillis() - start) + " ms"));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequestBase);){
                Header[] headers = response.getHeaders("isLogin");
                if (headers != null && headers.length > 0) {
                    custRespHeader.put(headers[0].getName(), (Object)headers[0].getValue());
                }
                HttpEntity entity = response.getEntity();
                try {
                    if (entity != null) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)encode);
                    }
                }
                finally {
                    if (entity != null) {
                        entity.getContent().close();
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpRequestBase.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get error, url:%s", httpRequestBase.getURI()), (Throwable)e);
            responseString = "";
        }
        finally {
            httpRequestBase.releaseConnection();
        }
        logger.info((Object)("HttpClientUtils response : " + responseString));
        return responseString;
    }

    private static String buildRequestUrl(String url, Map<String, String> params) throws UnsupportedEncodingException {
        if (CollectionUtils.isEmpty(params)) {
            return url;
        }
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(url);
        int i = 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (i == 0) {
                requestUrl.append("?");
            }
            requestUrl.append(entry.getKey());
            requestUrl.append("=");
            String value = entry.getValue();
            requestUrl.append(URLEncoder.encode(value, DEFAULT_ENCODING));
            requestUrl.append("&");
            ++i;
        }
        requestUrl.deleteCharAt(requestUrl.length() - 1);
        return requestUrl.toString();
    }

    public static void setStringParams(HttpPost httpost, Map<String, String> params) {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            nvps.add(new BasicNameValuePair(key, params.get(key).toString()));
        }
        try {
            httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static String sendRequest(HttpRequestBase httpRequest, HttpEntity entity) {
        httpRequest.setHeader("User-Agent", "okHttp");
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(entity);
        }
        SSLContext sslContext = SSLContexts.createDefault();
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sslContext.init(null, new TrustManager[]{tm}, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AllowAllHostnameVerifier hostnameVerifier = new AllowAllHostnameVerifier();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)hostnameVerifier);
        Registry r = RegistryBuilder.create().register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(r);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        CloseableHttpResponse response = null;
        String resString = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpRequest);
            HttpEntity resEntity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            resString = EntityUtils.toString((HttpEntity)resEntity, (String)DEFAULT_ENCODING);
            System.err.println(statusCode);
            if (statusCode != 200) {
                System.out.println("\u54cd\u5e94\u7801\u72b6\u6001\u4e0d\u662f200");
            }
            String string = resString;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(resString, e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpRequest != null) {
                    httpRequest.releaseConnection();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        poolingHttpClientConnectionManager.setMaxTotal(1024);
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(300);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).build();
    }
}

