/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.dangao.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataDangaoService;
import com.yqbsoft.laser.service.ext.data.dangao.service.domain.OrgEmployee;
import com.yqbsoft.laser.service.ext.data.dangao.service.domain.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.data.dangao.service.xuankua.http.HttpResult;
import com.yqbsoft.laser.service.ext.data.dangao.service.xuankua.http.HttpUtils;
import com.yqbsoft.laser.service.ext.data.dangao.service.xuankua.sec.ApiSign;
import com.yqbsoft.laser.service.ext.data.dangao.service.xuankua.support.ResultCode;
import com.yqbsoft.laser.service.ext.data.dangao.service.xuankua.vo.DanGaoOrder;
import com.yqbsoft.laser.service.ext.data.dangao.service.xuankua.vo.DanGaoProduct;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcPackageDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataDangaoServiceImpl
extends BaseServiceImpl
implements DataDangaoService {
    private static final String SYS_CODE = "DataDangaoServiceImpl";
    private static Map<String, String> orderStatusMap = new ConcurrentHashMap<String, String>();

    private ResultCode getRes(Map<String, Object> params, String jumpPage) {
        String channel_no = this.getDdFalgSetting("00000000", "dangao", "channel_no", "");
        String privatekey = this.getDdFalgSetting("00000000", "dangao", "privatekey", "");
        String jumpUrl = this.getDdFalgSetting("00000000", "dangao", "jumpUrl", "");
        params.put("channel_no", channel_no);
        String curFullTimestampStr = String.valueOf(System.currentTimeMillis());
        params.put("timestamp", curFullTimestampStr);
        String sign = "";
        try {
            sign = ApiSign.signMD5_Dangao(channel_no, curFullTimestampStr, privatekey);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        params.put("sign", sign);
        this.logger.error("DataDangaoServiceImpl\u8bf7\u6c42\u53c2\u6570\uff1a.getRes.params", (Object)JSON.toJSONString(params));
        String result = null;
        try {
            HttpResult result1 = HttpUtils.postUrlAsString(jumpUrl + jumpPage, params);
            result = result1.getResponse();
            this.logger.error("DataDangaoServiceImpl\u54cd\u5e94\u53c2\u6570\uff1a.getRes.result", (Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (ResultCode)JSON.parseObject(result, ResultCode.class);
    }

    public String getDangaoShopUrl(String userinfoCode, String tenantCode, String url) {
        String jumpPage = this.getDdFalgSetting("00000000", "dangao", "jumpPage", "");
        return this.getJumpUrl(userinfoCode, tenantCode, url, jumpPage);
    }

    private String getJumpUrl(String userinfoCode, String tenantCode, String url, String jumpPage) {
        String jumpUrl = this.getDdFalgSetting("00000000", "dangao", "jumpUrl", "");
        String channel_no = this.getDdFalgSetting("00000000", "dangao", "channel_no", "");
        String privatekey = this.getDdFalgSetting("00000000", "dangao", "privatekey", "");
        HashMap<String, String> params = new HashMap<String, String>();
        String curFullTimestampStr = String.valueOf(System.currentTimeMillis());
        params.put("channel_no", channel_no);
        params.put("timestamp", curFullTimestampStr);
        params.put("uid", userinfoCode);
        String sign = ApiSign.signMD5(params, privatekey);
        url = "https://" + url + "/paas/cyy-mini/index.html#/pages/homePage/homePage";
        try {
            url = URLEncoder.encode(url, "GBK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jumpUrl + jumpPage + "?" + "channel_no=" + channel_no + "&timestamp=" + curFullTimestampStr + "&uid=" + userinfoCode + "&custom=" + url + "&validation=" + sign.toLowerCase();
    }

    public String getDangaoShopUrlJumpPage(String userinfoCode, String tenantCode, String url, String jumpPage) {
        return this.getJumpUrl(userinfoCode, tenantCode, url, jumpPage);
    }

    public static void main(String[] args) {
        String channel_no = "rencaiyouxuan";
        String privatekey = "grpRhfKIw5fMSKFXn7pbe6mLAOhZIb4B";
        String jumpUrl = "https://www.dangaoss.com";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("order_no", "3687916735632");
        params.put("channel_no", channel_no);
        String curFullTimestampStr = String.valueOf(System.currentTimeMillis());
        params.put("timestamp", curFullTimestampStr);
        String sign = "";
        try {
            sign = ApiSign.signMD5_Dangao(channel_no, curFullTimestampStr, privatekey);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        params.put("sign", sign);
        String result = null;
        try {
            HttpResult result1 = HttpUtils.postUrlAsString(jumpUrl + "/dsapi/order/order_detail", params);
            result = result1.getResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(JSON.toJSONString((Object)JSON.parseObject(result, ResultCode.class)));
    }

    public String saveDangaoContract(String tradeno, String tenantCode, String userinfoCode) {
        this.logger.error("DataDangaoServiceImpl.saveDangaoContract.tradeno\uff1a" + tradeno + ",tenantCode\uff1a" + tenantCode + ",userinfoCode\uff1a" + userinfoCode);
        ResultCode result = this.getOrderDetail(tradeno);
        DanGaoOrder danGaoOrder = new DanGaoOrder();
        if (result.isSuccess()) {
            danGaoOrder = (DanGaoOrder)JSON.parseObject((String)JSON.toJSONString((Object)result.getData()), DanGaoOrder.class);
        }
        this.logger.error("DataDangaoServiceImpl.saveDangaoContract.orderDetail\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)danGaoOrder));
        this.logger.error("DataDangaoServiceImpl.saveDangaoContract.orderDetail.getOrder_no", (Object)danGaoOrder.getOrder_no());
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode", new Object[]{danGaoOrder.getOrder_no(), tenantCode}));
        if (ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            return ((OcContractReDomain)queryResult.getList().get(0)).getContractBillcode();
        }
        UmUserinfoReDomain userinfoByCode = null;
        OrgEmployee employee = null;
        if (StringUtils.isNotBlank((String)userinfoCode)) {
            userinfoByCode = this.getUserinfoByCode(userinfoCode, tenantCode);
            QueryResult<OrgEmployee> queryEmployeePage = this.queryEmployeePage(userinfoCode, tenantCode);
            if (null == queryEmployeePage || ListUtil.isEmpty((Collection)queryEmployeePage.getList())) {
                this.logger.error("DataDangaoServiceImpl.queryEmployeePage is null\uff0ctradeno\uff1a" + userinfoCode);
                return "error";
            }
            employee = (OrgEmployee)queryEmployeePage.getList().get(0);
        }
        if (null == userinfoByCode) {
            QueryResult<UmUserinfoReDomain> qlist = this.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{userinfoCode, tenantCode}));
            if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
                this.logger.error("DataDangaoServiceImpl.userinfoByCode is null\uff0ctradeno\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)tradeno));
                return "error";
            }
            userinfoByCode = (UmUserinfoReDomain)qlist.getList().get(0);
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        try {
            OcContractDomain ocContractDomain = new OcContractDomain();
            if (employee != null) {
                ocContractDomain.setCompanyCode(employee.getCompanyCode());
                ocContractDomain.setCompanyShortname(employee.getCompanyShortname());
                ocContractDomain.setChannelName(employee.getCompanyShortname());
            }
            ocContractDomain.setTenantCode(tenantCode);
            ocContractDomain.setAppmanageIcode("031");
            ocContractDomain.setUserCode(userinfoByCode.getUserCode());
            ocContractDomain.setUserName(userinfoByCode.getUserinfoPhone());
            ocContractDomain.setMemberBcode(userinfoByCode.getUserinfoCode());
            ocContractDomain.setMemberBname(userinfoByCode.getUserinfoCompname());
            ocContractDomain.setMemberCode(memberCode);
            ocContractDomain.setMemberName("\u798f\u5229\u5e73\u53f0");
            ocContractDomain.setMemberCcode(memberCode);
            ocContractDomain.setMemberCname("\u798f\u5229\u5e73\u53f0");
            ocContractDomain.setContractType("44");
            if (StringUtils.isNotBlank((String)danGaoOrder.getOrder_type()) && "8".equals(danGaoOrder.getOrder_type())) {
                ocContractDomain.setContractType("47");
            }
            ocContractDomain.setContractNbillcode(danGaoOrder.getOrder_no());
            ocContractDomain.setContractInmoney(new BigDecimal(danGaoOrder.getFinal_amount()));
            ocContractDomain.setContractMoney(new BigDecimal(danGaoOrder.getFinal_amount()));
            ocContractDomain.setDataBmoney(new BigDecimal(danGaoOrder.getFinal_amount()));
            ocContractDomain.setGoodsReceiptMem(danGaoOrder.getName());
            ocContractDomain.setGoodsReceiptPhone(danGaoOrder.getPhone());
            ocContractDomain.setGoodsReceiptArrdess(danGaoOrder.getProvince() + danGaoOrder.getCity() + danGaoOrder.getArea() + danGaoOrder.getAddr());
            ocContractDomain.setContractPumode(this.getShipName(danGaoOrder));
            String dataStr = danGaoOrder.getShip_date() + " " + danGaoOrder.getShip_time_text();
            if ("0000-00-00".equals(danGaoOrder.getShip_date())) {
                dataStr = danGaoOrder.getShip_time_text();
            }
            ocContractDomain.setGoodsSupplierName(dataStr);
            ocContractDomain.setDataStatestr("\u672a\u652f\u4ed8");
            ocContractDomain.setGoodsLogmoney(StringUtils.isEmpty((String)danGaoOrder.getShip_amount()) ? BigDecimal.ZERO : new BigDecimal(danGaoOrder.getShip_amount()));
            ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
            OcPackageDomain ocPackageDomain = new OcPackageDomain();
            ocPackageDomain.setGoodsReceiptMem(danGaoOrder.getName());
            ocPackageDomain.setGoodsReceiptPhone(danGaoOrder.getPhone());
            ocPackageDomain.setGoodsReceiptArrdess(danGaoOrder.getAddr());
            List<OcContractGoodsDomain> contractGoodsList = this.getOcContractGoodsDomains(tenantCode, danGaoOrder, userinfoByCode);
            ocPackageDomain.setContractGoodsList(contractGoodsList);
            packageList.add(ocPackageDomain);
            ocContractDomain.setPackageList(packageList);
            String msg = this.saveOrder(ocContractDomain);
            this.logger.error("DataDangaoServiceImpl.saveDangaoContract.msg", (Object)msg);
            return msg;
        }
        catch (Exception e) {
            this.logger.error("DataDangaoServiceImpl.saveDangaoContract.Exception" + JsonUtil.buildNormalBinder().toJson((Object)e));
            return "error";
        }
    }

    private String getShipName(DanGaoOrder danGaoOrder) {
        String ship_Name = danGaoOrder.getShip_type();
        switch (danGaoOrder.getShip_type()) {
            case "delivery": {
                ship_Name = "\u5546\u5bb6\u914d\u9001";
                break;
            }
            case "shop": {
                ship_Name = "\u95e8\u5e97\u81ea\u63d0";
                break;
            }
            case "same": {
                ship_Name = "\u5feb\u9012";
                break;
            }
        }
        return ship_Name;
    }

    private List<OcContractGoodsDomain> getOcContractGoodsDomains(String tenantCode, DanGaoOrder danGaoOrder, UmUserinfoReDomain userinfoByCode) {
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        List<DanGaoProduct> product = danGaoOrder.getProduct();
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        for (int i = 0; i < product.size(); ++i) {
            DanGaoProduct gaoProduct = product.get(i);
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            ocContractGoodsDomain.setGoodsType("44");
            if (StringUtils.isNotBlank((String)danGaoOrder.getOrder_type()) && "8".equals(danGaoOrder.getOrder_type())) {
                ocContractGoodsDomain.setGoodsType("47");
            }
            ocContractGoodsDomain.setPricesetNprice(new BigDecimal(gaoProduct.getPrice()));
            ocContractGoodsDomain.setPricesetAsprice(new BigDecimal(gaoProduct.getPrice()));
            ocContractGoodsDomain.setContractGoodsGtype("2");
            ocContractGoodsDomain.setGoodsCode(gaoProduct.getProduct_id());
            ocContractGoodsDomain.setGoodsName(gaoProduct.getProduct_name());
            ocContractGoodsDomain.setSkuName(gaoProduct.getSpec_name());
            ocContractGoodsDomain.setDataPic(gaoProduct.getImage_path());
            ocContractGoodsDomain.setDataPicpath(gaoProduct.getImage_path());
            ocContractGoodsDomain.setGoodsNum(new BigDecimal(gaoProduct.getQuantity()));
            ocContractGoodsDomain.setTenantCode(tenantCode);
            ocContractGoodsDomain.setMemberCode(memberCode);
            ocContractGoodsDomain.setMemberName("\u798f\u5229\u5e73\u53f0");
            ocContractGoodsDomain.setMemberCcode(memberCode);
            ocContractGoodsDomain.setMemberCname("\u798f\u5229\u5e73\u53f0");
            ocContractGoodsDomain.setMemberBcode(userinfoByCode.getUserinfoCode());
            ocContractGoodsDomain.setMemberBname(userinfoByCode.getUserinfoCompname());
            contractGoodsList.add(ocContractGoodsDomain);
        }
        return contractGoodsList;
    }

    protected QueryResult<UmUserinfoReDomain> queryUserinfoPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmUserinfoReDomain.class);
    }

    protected QueryResult<OcContractReDomain> queryOrderPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("DataDangaoServiceImpl.queryOrderPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractPageReDomain";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
    }

    protected UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    protected QueryResult<OrgEmployee> queryEmployeePage(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "org.employee.queryEmployeePage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return this.sendReSupObject(apiCode, param, OrgEmployee.class);
    }

    public String sendDangaoContract(OcContractReDomain ocContractDomain) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("result_status", "2");
        params.put("order_sn", ocContractDomain.getContractNbillcode());
        params.put("out_order_sn", ocContractDomain.getContractBillcode());
        params.put("order_price", String.valueOf(ocContractDomain.getDataBmoney()));
        params.put("transaction_sn", ocContractDomain.getContractBillcode());
        ResultCode res = this.getRes(params, "/dsapi/order/order_pay_result");
        if (res.isSuccess()) {
            this.updateOrderState("3", ocContractDomain);
            return "success";
        }
        return "error";
    }

    public String receivedOrderStatus(String tenantCode, String resStream) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)resStream)) {
            this.logger.error("DataDangaoServiceImpl.saveRefund.queryOrderPage resStream is null = " + resStream);
            resultMap.put("code", 100);
            resultMap.put("message", "\u53c2\u6570\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(resultMap);
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resStream, String.class, String.class);
        if (jsonToMap.get("order_no") == null) {
            this.logger.error("DataDangaoServiceImpl.saveRefund.queryOrderPage order_no is null = " + resStream);
            resultMap.put("code", 100);
            resultMap.put("message", "\u53c2\u6570\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(resultMap);
        }
        String order_no = jsonToMap.get("order_no").toString();
        if (jsonToMap.get("out_order_no") == null) {
            this.logger.error("DataDangaoServiceImpl.saveRefund.queryOrderPage out_order_no is null = " + resStream);
            resultMap.put("code", 100);
            resultMap.put("message", "\u53c2\u6570\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(resultMap);
        }
        if (jsonToMap.get("status") == null) {
            this.logger.error("DataDangaoServiceImpl.saveRefund.queryOrderPage status is null = " + resStream);
            resultMap.put("code", 100);
            resultMap.put("message", "\u53c2\u6570\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(resultMap);
        }
        String out_order_no = jsonToMap.get("out_order_no").toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractNbillcode", order_no);
        map.put("contractBillcode", out_order_no);
        map.put("contractType", "44,47");
        map.put("colName0", "DATA_STATE");
        map.put("colValue0", "2,3,4,5");
        map.put("childFlag", true);
        this.logger.error("DataDangaoServiceImpl.saveRefund.param map = " + JsonUtil.buildNormalBinder().toJson(map));
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(map);
        if (ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("DataDangaoServiceImpl.saveRefund.queryOrderPage no find order map = " + JsonUtil.buildNormalBinder().toJson(map));
            resultMap.put("code", 100);
            resultMap.put("message", "\u627e\u4e0d\u5230\u8ba2\u5355");
            return JsonUtil.buildNormalBinder().toJson(resultMap);
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
        if (ocContractReDomain == null) {
            this.logger.error("DataDangaoServiceImpl.saveRefund.ocContractReDomain no find ocContractReDomain map = " + JsonUtil.buildNormalBinder().toJson(map));
            resultMap.put("code", 100);
            resultMap.put("message", "\u627e\u4e0d\u5230\u8ba2\u5355");
            return JsonUtil.buildNormalBinder().toJson(resultMap);
        }
        List goodsList = ocContractReDomain.getGoodsList();
        this.updateOrderState(jsonToMap.get("status").toString(), ocContractReDomain);
        ocContractReDomain.setGoodsList(goodsList);
        if (!"4".equals(jsonToMap.get("status"))) {
            this.logger.error("DataDangaoServiceImpl.saveRefund.queryOrderPage status is = " + resStream);
            resultMap.put("code", 100);
            resultMap.put("message", "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
            return JsonUtil.buildNormalBinder().toJson(resultMap);
        }
        List<OcRefundDomain> refundDomainList = this.queryRefundPage(order_no, out_order_no, tenantCode);
        if (ListUtil.isNotEmpty(refundDomainList)) {
            this.logger.error("DataDangaoServiceImpl.saveRefund.queryRefundPage Repeated Refund map = " + JsonUtil.buildNormalBinder().toJson(map));
            resultMap.put("code", 100);
            resultMap.put("message", "\u8be5\u8ba2\u5355\u5df2\u9000\u6b3e");
            return JsonUtil.buildNormalBinder().toJson(resultMap);
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ocRefundDomain.setRefundType("MTB01");
        ocRefundDomain.setRefundUsertype("1");
        ocRefundDomain.setContractState(ocContractReDomain.getDataState());
        ocRefundDomain.setRefundMoney(ocContractReDomain.getDataBmoney());
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
            OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocRefundGoodsDomain.setRefundGoodsAmt(ocContractReDomain.getDataBmoney());
            ocRefundGoodsDomain.setRefundGoodsNum(ocContractGoodsDomain.getGoodsCamount());
            ocRefundGoodsDomain.setGoodsCamount(ocContractGoodsDomain.getGoodsNum());
            ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
        }
        ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
        String refundCode = this.sendSaveRefund(ocRefundDomain);
        this.logger.error("DataDangaoServiceImpl.saveRefund.refundCode" + refundCode);
        resultMap.put("code", 200);
        resultMap.put("message", "success");
        return JsonUtil.buildNormalBinder().toJson(resultMap);
    }

    private void updateOrderState(String status, OcContractReDomain ocContractReDomain) {
        this.makeDataStateStr(status, ocContractReDomain);
        ocContractReDomain.setGoodsList(null);
        this.updateContractReById(ocContractReDomain);
    }

    private void makeDataStateStr(String orderStatus, OcContractReDomain ocContractReDomain) {
        Integer dataState = ocContractReDomain.getDataState();
        String dataStateStr = null;
        switch (orderStatus) {
            case "1": {
                dataStateStr = "\u5df2\u5206\u914d\u5230\u5546\u5bb6";
                dataState = 3;
                break;
            }
            case "2": {
                dataStateStr = "\u5df2\u914d\u9001\u5b8c\u6210";
                dataState = 4;
                break;
            }
            case "4": {
                dataStateStr = "\u8ba2\u5355\u9000\u6b3e\u4e14\u5df2\u53d6\u6d88";
                dataState = -1;
                break;
            }
            case "3": {
                dataStateStr = "\u5df2\u652f\u4ed8";
                break;
            }
        }
        ocContractReDomain.setDataState(dataState);
        ocContractReDomain.setDataStatestr(dataStateStr);
        this.logger.error("DataDangaoServiceImpl.makeDataStateStr.orderStatus:{}, dataStateStr:{}", (Object)(orderStatus + "---" + dataStateStr));
    }

    protected String updateContractReById(OcContractReDomain ocContractReDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.contract.updateContractReById";
        param.put("ocContractReDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
        return this.internalInvoke(apiCode, param);
    }

    protected String sendSaveRefund(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.refundEngine.sendSaveRefund";
        param.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        return this.internalInvoke(apiCode, param);
    }

    protected List<OcRefundDomain> queryRefundPage(String contractNbillcode, String contractBillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(4);
        String apiCode = "oc.refund.queryRefundPage";
        param.put("contractNbillcode", contractNbillcode);
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataDangaoServiceImpl.queryRefundPage.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult refundQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List refundDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)refundQuery.getList()), OcRefundDomain.class);
        return refundDomainList;
    }

    private String saveOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error("DataDangaoServiceImpl.saveOrder.ocContractDomain");
            return null;
        }
        String apiCode = "oc.shopping.sendContractByDel";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    public ResultCode getOrderDetail(String order_no) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("order_no", order_no);
        return this.getRes(params, "/dsapi/order/order_detail");
    }

    public ResultCode<String> sendPaySuccessToDangao(String xkTradeno, String partnerTradeno) {
        return null;
    }

    public String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        return value;
    }

    static {
        orderStatusMap.put("N", "\u5f85\u652f\u4ed8");
        orderStatusMap.put("C", "\u5df2\u53d6\u6d88");
        orderStatusMap.put("E", "\u8ba2\u5355\u6709\u6548\u671f\u8fc7\u540e,\u6ca1\u6709\u6536\u5230\u4ed8\u6b3e\u901a\u77e5");
        orderStatusMap.put("P", "\u5df2\u4ed8\u6b3e");
        orderStatusMap.put("T", "\u901a\u77e5\u5904\u7406\u4e2d");
        orderStatusMap.put("S", "\u51fa\u7968\u6210\u529f");
        orderStatusMap.put("R", "\u9000\u6b3e\u5b8c\u6210");
    }
}

