/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.pingan.service.Impl;

import com.alibaba.fastjson.JSON;
import com.hbis.infmgr.common.sign.SignUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataInDataPingan;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractproDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.data.pingan.service.Util.AesUtil;
import com.yqbsoft.laser.service.ext.data.pingan.service.Util.BaseUtils;
import com.yqbsoft.laser.service.ext.data.pingan.service.Util.BusBaseService;
import com.yqbsoft.laser.service.ext.data.pingan.service.Util.HttpUtils;
import com.yqbsoft.laser.service.ext.data.pingan.service.Util.SslUtil;
import com.yqbsoft.laser.service.ext.data.pingan.service.config.RequestConfiguration;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.BalanceList;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.OrgEmployee;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.OrgEmployeeDomain;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.PayDateList;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.PayDateVo;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.PayInfoVo;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.PayList;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.PayOrderInfoVo;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.Records;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.ResultDateVo;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.UmUserReDomainBean;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.data.pingan.service.domain.UserInfoVo;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;

@Service(value="dataInDataPinganServiceImpl")
public class DataInDataPinganServiceImpl
extends BusBaseService
implements DataInDataPingan {
    private static final String SYS_CODE = "dataInDataContractServiceImpl";
    private static String url = null;

    public String queryPaymentStatus(String contractBillcode, String tenantCode) {
        this.logger.error("dataInDataContractServiceImpl.queryPaymentStatus.param:" + contractBillcode + "-" + tenantCode);
        HashMap<String, String> ocParam = new HashMap<String, String>();
        ocParam.put("requestId", BaseUtils.getLockNo());
        ocParam.put("outerBatchNo", contractBillcode);
        try {
            String urlPrefix = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "hGurlPrefix", "hGurlPrefix");
            String benefitbatchpayresult = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "benefitbatchpayresult", "benefitbatchpayresult");
            String doPost = HttpUtils.doPostJSON(urlPrefix + benefitbatchpayresult, JSON.toJSONString(ocParam), tenantCode);
            if (StringUtils.isBlank((String)doPost)) {
                return null;
            }
            Map map = (Map)JSON.parseObject((String)doPost, Map.class);
            if (MapUtil.isNotEmpty((Map)map)) {
                System.out.println(JSON.toJSONString((Object)map));
                map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("Data")), Map.class);
            }
            if ("000000".equals(map.get("code").toString())) {
                map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("data")), Map.class);
                String toJSONString = JSON.toJSONString((Object)map);
                HashMap<String, Object> param = new HashMap<String, Object>();
                PayInfoVo payInfoVo = (PayInfoVo)JSON.parseObject((String)toJSONString, PayInfoVo.class);
                for (PayList payList : payInfoVo.getPayList()) {
                    param.put("contractproKey", "PAY_PINGAN");
                    param.put("contractproBillcode", payList.getOuterBusinessId());
                    QueryResult<OcContractproDomain> queryResult = this.querycontractproPage(param);
                    if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) continue;
                    for (OcContractproDomain ocContractproDomain : queryResult.getList()) {
                        if (!payList.getOuterBusinessId().equals(ocContractproDomain.getContractproBillcode())) continue;
                        ocContractproDomain.setContractproType(payList.getBusinessStatus());
                        ocContractproDomain.setContractproValue(payList.getBusinessId());
                        this.updatecontractpro(ocContractproDomain);
                    }
                }
                return toJSONString;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("dataInDataContractServiceImpl.payDataContract.error", (Object)e.getMessage());
            return null;
        }
        return null;
    }

    public String queryBenefitBalance(Map<String, Object> map) {
        String outerUserId;
        if (MapUtil.isEmpty(map)) {
            this.logger.error("dataInDataContractServiceImpl.queryBenefitBalance map is null");
            return null;
        }
        String tenantCode = map.get("tenantCode") != null ? map.get("tenantCode").toString() : null;
        String string = outerUserId = map.get("outerUserId") != null ? map.get("outerUserId").toString() : null;
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)outerUserId)) {
            this.logger.error("dataInDataContractServiceImpl.queryBenefitBalance map tenantCode || outerUserId is null", (Object)(tenantCode + "-" + outerUserId));
            return null;
        }
        HashMap<String, String> amountParam = new HashMap<String, String>();
        amountParam.put("requestId", BaseUtils.getLockNo());
        amountParam.put("outerUserId", outerUserId);
        try {
            String urlPrefix = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "hGurlPrefix", "hGurlPrefix");
            String benefitbalance = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "benefitbalance", "benefitbalance");
            String doPost = HttpUtils.doPostJSON(urlPrefix + benefitbalance, JSON.toJSONString(amountParam), tenantCode);
            if (StringUtils.isBlank((String)doPost)) {
                this.logger.error("dataInDataContractServiceImpl.queryBenefitBalance.doPost is null");
                return null;
            }
            this.logger.error("dataInDataContractServiceImpl.queryBenefitBalance.doPost:" + doPost);
            Map rsMap = (Map)JSON.parseObject((String)doPost, Map.class);
            if (MapUtil.isNotEmpty((Map)rsMap)) {
                rsMap = (Map)JSON.parseObject((String)JSON.toJSONString(rsMap.get("Data")), Map.class);
            }
            if (MapUtil.isNotEmpty((Map)rsMap) && "000000".equals(rsMap.get("code").toString())) {
                rsMap = (Map)JSON.parseObject((String)JSON.toJSONString(rsMap.get("data")), Map.class);
                List balanceList = JSON.parseArray((String)JSON.toJSONString(rsMap.get("balanceList")), BalanceList.class);
                for (BalanceList balance : balanceList) {
                    if (!"0".equals(balance.getCreditType())) continue;
                    return balance.getBalance();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("dataInDataContractServiceImpl.queryBenefitBalance.error", (Object)e.getMessage());
            return null;
        }
        return null;
    }

    public String WSIntegralOrderFacade(OcContractDomain ocContractDomain) {
        UmUserinfoReDomain userinfoByCode;
        this.logger.error("dataInDataContractServiceImpl.WSIntegralOrderFacade.ocContractDomain:" + JSON.toJSONString((Object)ocContractDomain));
        if (ocContractDomain == null) {
            this.logger.error("dataInDataContractServiceImpl.WSIntegralOrderFacade.ocContractDomain param is null");
            return "fail";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractBillcode,tenantCode,fuzzy", new Object[]{ocContractDomain.getContractBillcode(), tenantCode, false}));
        OcContractReDomain contractReDomain = null;
        if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            contractReDomain = (OcContractReDomain)queryResult.getList().get(0);
        }
        if ((userinfoByCode = this.getUserinfoByCode(ocContractDomain.getMemberBcode(), tenantCode)) == null) {
            return "fail";
        }
        UmUserReDomainBean userByCode = this.getUserByCode(userinfoByCode.getUserinfoCode(), tenantCode);
        contractReDomain.setMemberBcode(userByCode.getUserOcode());
        String data = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:log=\"http://login.webservice.bos.kingdee.com\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <log:login soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n         <userName xsi:type=\"xsd:string\">" + UserInfoVo.USERNAME + "</userName>\n" + "         <password xsi:type=\"xsd:string\">" + UserInfoVo.PASSWORD + "</password>\n" + "         <slnName xsi:type=\"xsd:string\">" + UserInfoVo.SLNNAME + "</slnName>\n" + "         <dcName xsi:type=\"xsd:string\">" + UserInfoVo.HGDCNAME + "</dcName>\n" + "         <language xsi:type=\"xsd:string\">" + UserInfoVo.LANGUAGE + "</language>\n" + "         <dbType xsi:type=\"xsd:int\">" + UserInfoVo.DBTYPE + "</dbType>\n" + "      </log:login>\n" + "   </soapenv:Body>\n" + "</soapenv:Envelope>";
        try {
            String urlPrefix = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "hGurlPrefix", "hGurlPrefix");
            String EASLogin = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "EASLogin", "EASLogin");
            String WSIntegralOrderFacade = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "WSIntegralOrderFacade", "WSIntegralOrderFacade");
            String doPost = HttpUtils.doPostJSONSOAP(urlPrefix + EASLogin, data, tenantCode);
            if (StringUtils.isBlank((String)doPost)) {
                this.logger.error("dataInDataContractServiceImpl.WSIntegralOrderFacade.doPost is null");
                return null;
            }
            this.logger.error("dataInDataContractServiceImpl.WSIntegralOrderFacade.doPost:" + doPost);
            String sessionId = HttpUtils.getSessionId(doPost);
            this.logger.error("dataInDataContractServiceImpl.WSIntegralOrderFacade.sessionId:" + sessionId);
            PayOrderInfoVo payOrderInfoVo = this.makePayOrderInfoVo(contractReDomain, userByCode, userinfoByCode);
            List<PayOrderInfoVo> payOrderInfoVos = Arrays.asList(payOrderInfoVo);
            this.logger.error("dataInDataContractServiceImpl.WSIntegralOrderFacade.payOrderInfoVos:" + JSON.toJSONString(payOrderInfoVos));
            if (StringUtils.isNotBlank((String)sessionId)) {
                data = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:web=\"http://webservice.integralorder_ty.custom.eas.kingdee.com\">\n    <soapenv:Header namespace=\"http://login.webservice.bos.kingdee.com\"><SessionId>" + sessionId + "</SessionId></soapenv:Header>\n" + "    <soapenv:Body>\n" + "        <web:add soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n" + "            <params xsi:type=\"xsd:string\">\n" + JSON.toJSONString(payOrderInfoVos) + "            </params>\n" + "        </web:add>\n" + "    </soapenv:Body>\n" + "</soapenv:Envelope>";
                doPost = HttpUtils.doPostJSONSOAP(urlPrefix + WSIntegralOrderFacade, data, tenantCode);
                this.logger.error("dataInDataContractServiceImpl.WSIntegralOrderFacade.doPost:" + doPost);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("dataInDataContractServiceImpl.WSIntegralOrderFacade.error", (Object)e.getMessage());
            return "fail";
        }
        return "fail";
    }

    private PayOrderInfoVo makePayOrderInfoVo(OcContractReDomain contractReDomain, UmUserReDomainBean userByCode, UmUserinfoReDomain userinfoByCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        OcContractproDomain ocContractproDomain = null;
        param.put("contractproKey", "PAY_PINGAN");
        param.put("contractproBillcode", contractReDomain.getContractBillcode());
        QueryResult<OcContractproDomain> queryResult = this.querycontractproPage(param);
        if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            ocContractproDomain = (OcContractproDomain)queryResult.getList().get(0);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PayOrderInfoVo payOrderInfoVo = new PayOrderInfoVo();
        payOrderInfoVo.setTransactionNo(ocContractproDomain.getContractproValue());
        payOrderInfoVo.setTransactionNo(contractReDomain.getContractBillcode());
        payOrderInfoVo.setSourcePlatform("\u5546\u57ce");
        payOrderInfoVo.setBizTime(sdf.format(contractReDomain.getGmtCreate()));
        payOrderInfoVo.setName(userinfoByCode.getUserinfoCompname());
        payOrderInfoVo.setSupplierNo(UserInfoVo.SUPPLIERNO);
        payOrderInfoVo.setSupplierName(UserInfoVo.SUPPLIERNAME);
        payOrderInfoVo.setPersonID(userByCode.getUserUnionid());
        payOrderInfoVo.setMobilePhone(userByCode.getUserPhone());
        payOrderInfoVo.setStatus("\u5b8c\u6210");
        payOrderInfoVo.setCompleTime(sdf.format(contractReDomain.getGmtModified()));
        payOrderInfoVo.setTotalAmount(contractReDomain.getDataBmoney().setScale(2, 4).toString());
        return payOrderInfoVo;
    }

    public void paymentReport(OcContractDomain ocContractDomain) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("startDate", DataInDataPinganServiceImpl.getDay() + " 00:00:00");
        param.put("endDate", DataInDataPinganServiceImpl.getDay() + " 23:59:59");
        param.put("contractproKey", "PAY_PINGAN,PAYOUT_PINGAN");
        param.put("dataState", 0);
        this.logger.error("dataInDataContractServiceImpl.paymentReport.param", (Object)JSON.toJSONString(param));
        QueryResult<OcContractproDomain> queryResult = this.querycontractproPage(param);
        if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            this.logger.error("dataInDataContractServiceImpl.paymentReport.queryResult.size:", (Object)queryResult.getList().size());
            param.clear();
            for (OcContractproDomain ocContractproDomain : queryResult.getList()) {
                param.put("requestId", BaseUtils.getLockNo());
                param.put("pageNo", "1");
                param.put("pageSize", "100");
                param.put("outerBusinessId", ocContractproDomain.getContractproBillcode());
                param.put("payOuterUserId", ocContractproDomain.getAppmanageIcode());
                param.put("businessId", ocContractproDomain.getContractproValue());
                try {
                    String doPost = HttpUtils.doPostJSON(RequestConfiguration.BENEFITTRANSHISTORY, JSON.toJSONString(param), ocContractproDomain.getTenantCode());
                    ResultDateVo resultDataVo = (ResultDateVo)JSON.parseObject((String)doPost, ResultDateVo.class);
                    if (resultDataVo == null || resultDataVo.getData() == null || !"000000".equals(resultDataVo.getData().getCode()) || Integer.valueOf(resultDataVo.getData().getData().getTotal()) == 0) continue;
                    for (Records record : resultDataVo.getData().getData().getRecords()) {
                        this.logger.error("dataInDataContractServiceImpl.paymentReport.record", (Object)JSON.toJSONString((Object)record));
                        this.logger.error("dataInDataContractServiceImpl.paymentReport.amount1", (Object)record.getAmount());
                        this.logger.error("dataInDataContractServiceImpl.paymentReport.amount2", (Object)ocContractproDomain.getContractproRefrice1().toString());
                        if (record.getBusinessId().equals(ocContractproDomain.getContractproValue()) && record.getAmount().equals(ocContractproDomain.getContractproRefrice1().toString())) {
                            String updatecontractproState;
                            if ("PAY_PINGAN".equals(ocContractproDomain.getContractproKey())) {
                                updatecontractproState = this.updatecontractproState(ocContractproDomain.getContractproId(), 2, 0, null);
                                this.logger.error("updatecontractproState=====>" + updatecontractproState);
                                continue;
                            }
                            if (!"PAYOUT_PINGAN".equals(ocContractproDomain.getContractproKey()) || !"1".equals(record.getRefundFlag())) continue;
                            updatecontractproState = this.updatecontractproState(ocContractproDomain.getContractproId(), 2, 0, null);
                            this.logger.error("updatecontractproState=====>" + updatecontractproState);
                            continue;
                        }
                        String string = this.updatecontractproState(ocContractproDomain.getContractproId(), 1, 0, null);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public String payPingAnContract(List<OcContractDomain> ocContractDomainList) {
        this.logger.error("dataInDataContractServiceImpl.payDataContract.ocContractDomainList:" + JSON.toJSONString(ocContractDomainList));
        if (ListUtil.isEmpty(ocContractDomainList)) {
            this.logger.error("dataInDataContractServiceImpl.payDataContract.ocContractDomain param is null");
            return "fail";
        }
        String tenantCode = ocContractDomainList.get(0).getTenantCode();
        String lockNo = BaseUtils.getLockNo();
        ArrayList<OcContractproDomain> ocContractproDomains = new ArrayList<OcContractproDomain>();
        PayDateVo payDateVo = new PayDateVo();
        payDateVo.setRequestId(lockNo);
        payDateVo.setOuterBatchNo(ocContractDomainList.get(0).getContractBbillcode());
        payDateVo.setPayList(this.makeParam(ocContractDomainList));
        for (OcContractDomain ocContractDomain : ocContractDomainList) {
            OcContractproDomain ocContractproDomain = new OcContractproDomain();
            ocContractproDomain.setContractBillcode(lockNo);
            ocContractproDomain.setContractBbillcode(ocContractDomain.getContractBillcode());
            ocContractproDomain.setContractproRefrice1(ocContractDomain.getDataBmoney());
            ocContractproDomain.setContractproBillcode(ocContractDomain.getContractBillcode());
            ocContractproDomain.setContractNbbillcode(String.valueOf(System.currentTimeMillis()));
            ocContractproDomain.setContractproKey("PAY_PINGAN");
            ocContractproDomain.setAppmanageIcode(ocContractDomain.getMemberBcode());
            ocContractproDomain.setTenantCode(ocContractDomain.getTenantCode());
            ocContractproDomains.add(ocContractproDomain);
        }
        try {
            String urlPrefix = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "hGurlPrefix", "hGurlPrefix");
            String benefitbatchpay = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "benefitbatchpay", "benefitbatchpay");
            String doPost = HttpUtils.doPostJSON(urlPrefix + benefitbatchpay, JSON.toJSONString((Object)payDateVo), tenantCode);
            if (StringUtils.isBlank((String)doPost)) {
                return "fail";
            }
            this.logger.error("dataInDataContractServiceImpl.payDataContract.doPost:" + doPost);
            Map map = (Map)JSON.parseObject((String)doPost, Map.class);
            if (MapUtil.isNotEmpty((Map)map)) {
                map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("Data")), Map.class);
            }
            if (MapUtil.isNotEmpty((Map)map) && "000000".equals(map.get("code").toString())) {
                map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("data")), Map.class);
                for (OcContractproDomain ocContractproDomain : ocContractproDomains) {
                    ocContractproDomain.setContractNbillcode(map.get("outerBatchNo").toString());
                    String savecontractpro = this.savecontractpro(ocContractproDomain);
                    this.logger.error("dataInDataContractServiceImpl.payPingAnContract.savecontractpro\uff1a", (Object)savecontractpro);
                }
                return "success";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("dataInDataContractServiceImpl.payDataContract.error", (Object)e.getMessage());
            return "fail";
        }
        for (OcContractproDomain ocContractproDomain : ocContractproDomains) {
            String savecontractpro = this.savecontractpro(ocContractproDomain);
            this.logger.error("dataInDataContractServiceImpl.payPingAnContract.savecontractpro\uff1a", (Object)savecontractpro);
        }
        return "fail";
    }

    public String payOutDataContract(OcRefundDomain ocRefundDomain) {
        OcContractproDomain ocContractproDomain = new OcContractproDomain();
        this.logger.error("dataInDataContractServiceImpl.payOutDataContract.ocRefundDomain:" + JSON.toJSONString((Object)ocRefundDomain));
        if (ocRefundDomain == null) {
            this.logger.error("dataInDataContractServiceImpl.payOutDataContract.ocRefundDomain param is null");
            return "fail";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        HashMap<String, String> rfParam = new HashMap<String, String>();
        String lockNo = BaseUtils.getLockNo();
        rfParam.put("requestId", lockNo);
        rfParam.put("outerBusinessId", lockNo);
        rfParam.put("amount", ocRefundDomain.getRefundMoney().setScale(2, RoundingMode.HALF_UP).toString());
        rfParam.put("originalOuterBusinessId", ocRefundDomain.getContractBillcode());
        String empNo = null;
        UmUserReDomainBean userByCode = this.getUserByCode(ocRefundDomain.getMemberBcode(), tenantCode);
        if (userByCode != null) {
            empNo = userByCode.getUserOcode();
        }
        ocContractproDomain.setTenantCode(tenantCode);
        ocContractproDomain.setContractproBillcode(ocRefundDomain.getRefundCode());
        ocContractproDomain.setContractBillcode(lockNo);
        ocContractproDomain.setContractproRefrice1(ocRefundDomain.getRefundMoney());
        ocContractproDomain.setContractNbbillcode(String.valueOf(System.currentTimeMillis()));
        ocContractproDomain.setContractproKey("PAYOUT_PINGAN");
        ocContractproDomain.setAppmanageIcode(empNo);
        this.savecontractpro(ocContractproDomain);
        ocRefundDomain.setExtendedField2("0");
        this.updateRefund(ocRefundDomain);
        try {
            String urlPrefix = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "hGurlPrefix", "hGurlPrefix");
            String benefitrefund = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "benefitrefund", "benefitrefund");
            String doPost = HttpUtils.doPostJSON(urlPrefix + benefitrefund, JSON.toJSONString(rfParam), tenantCode);
            if (StringUtils.isBlank((String)doPost)) {
                return "fail";
            }
            this.logger.error("dataInDataContractServiceImpl.payOutDataContract.doPost:" + doPost);
            Map map = (Map)JSON.parseObject((String)doPost, Map.class);
            if (MapUtil.isNotEmpty((Map)map)) {
                map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("Data")), Map.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("dataInDataContractServiceImpl.payOutDataContract.error", (Object)e.getMessage());
            return "fail";
        }
        return "success";
    }

    public String getBySessioninfo(String ticket, String tenantCode) {
        this.logger.error("dataInDataContractServiceImpl.getBySessioninfo.param", (Object)(ticket + "-" + tenantCode));
        if (StringUtils.isBlank((String)ticket) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("dataInDataContractServiceImpl.getBySessioninfo param is null");
            return null;
        }
        String accesstoken = this.getAccesstoken(ticket, tenantCode);
        if (StringUtils.isBlank((String)accesstoken)) {
            this.logger.error("dataInDataContractServiceImpl.getBySessioninfo.accesstoken is null");
            return null;
        }
        HashMap<String, String> usMap = new HashMap<String, String>();
        usMap.put("requestId", BaseUtils.getLockNo());
        usMap.put("accessToken", accesstoken);
        try {
            String urlPrefix = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "hGurlPrefix", "hGurlPrefix");
            String sessioninfo = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "sessioninfo", "sessioninfo");
            String doPost = HttpUtils.doPostJSON(urlPrefix + sessioninfo, JSON.toJSONString(usMap), tenantCode);
            if (StringUtils.isBlank((String)doPost)) {
                return null;
            }
            this.logger.error("dataInDataContractServiceImpl.getBySessioninfo.doPost", (Object)doPost);
            Map map = (Map)JSON.parseObject((String)doPost, Map.class);
            if (MapUtil.isNotEmpty((Map)map)) {
                map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("Data")), Map.class);
            }
            if ("000000".equals(map.get("code").toString()) && MapUtil.isNotEmpty((Map)(map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("data")), Map.class)))) {
                return JSON.toJSONString((Object)map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("dataInDataContractServiceImpl.getBySessioninfo.error", (Object)e.getMessage());
            return null;
        }
        return null;
    }

    private synchronized String getAccesstoken(String ticket, String tenantCode) {
        String urlPrefix = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "hGurlPrefix", "hGurlPrefix");
        String getaccesstoken = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "getaccesstoken", "getaccesstoken");
        HashMap<String, String> asParam = new HashMap<String, String>();
        asParam.put("requestId", BaseUtils.getLockNo());
        asParam.put("redirectUri", "1");
        asParam.put("ticket", ticket);
        try {
            String doPost = HttpUtils.doPostJSON(urlPrefix + getaccesstoken, JSON.toJSONString(asParam), tenantCode);
            if (StringUtils.isBlank((String)doPost)) {
                return null;
            }
            this.logger.error("dataInDataContractServiceImpl.getAccesstoken.doPost", (Object)doPost);
            Map map = (Map)JSON.parseObject((String)doPost, Map.class);
            if (MapUtil.isNotEmpty((Map)map)) {
                map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("Data")), Map.class);
            }
            if ("000000".equals(map.get("code").toString()) && MapUtil.isNotEmpty((Map)(map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("data")), Map.class))) && map.get("accessToken") != null && StringUtils.isNotBlank((String)map.get("accessToken").toString())) {
                return map.get("accessToken").toString();
            }
        }
        catch (Exception e) {
            this.logger.error("dataInDataContractServiceImpl.getAccesstoken.error", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return null;
    }

    private List<PayDateList> makeParam(List<OcContractDomain> ocContractDomainList) {
        ArrayList<PayDateList> payDateLists = new ArrayList<PayDateList>();
        for (OcContractDomain ocContractDomain : ocContractDomainList) {
            PayDateList payDateList = new PayDateList();
            payDateList.setOuterBusinessId(ocContractDomain.getContractBillcode());
            payDateList.setAmount(ocContractDomain.getDataBmoney().toString());
            payDateList.setPayOuterUserId(ocContractDomain.getMemberBcode());
            payDateList.setPayChannel("101");
            payDateList.setCltFullName("\u4eba\u624d\u4f18\u9009\uff08\u6df1\u5733\uff09\u79d1\u6280\u6709\u9650\u516c\u53f8");
            payDateLists.add(payDateList);
        }
        return payDateLists;
    }

    public Boolean getByfState(OcRefundReDomain ocRefundReDomain) {
        String tenantCode = ocRefundReDomain.getTenantCode();
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractBillcode,tenantCode,fuzzy", new Object[]{ocRefundReDomain.getContractBillcode(), tenantCode, false}));
        OcContractReDomain ocContractReDomain = null;
        if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
        }
        OcContractproDomain ocContractpro = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractproKey", "PAYOUT_PINGAN");
        param.put("contractproBillcode", ocRefundReDomain.getRefundCode());
        QueryResult<OcContractproDomain> result = this.querycontractproPage(param);
        if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
            ocContractpro = (OcContractproDomain)result.getList().get(0);
        }
        if (ocContractpro == null) {
            return false;
        }
        HashMap<String, String> usMap = new HashMap<String, String>();
        usMap.put("requestId", BaseUtils.getLockNo());
        usMap.put("outerBusinessId", ocContractpro.getContractBillcode());
        try {
            String urlPrefix = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "hGurlPrefix", "hGurlPrefix");
            String benefitbatchrefundresult = DataInDataPinganServiceImpl.getDdFlag(tenantCode, "benefitbatchrefundresult", "benefitbatchrefundresult");
            String doPost = HttpUtils.doPostJSON(urlPrefix + benefitbatchrefundresult, JSON.toJSONString(usMap), ocRefundReDomain.getTenantCode());
            if (StringUtils.isBlank((String)doPost)) {
                return false;
            }
            this.logger.error("dataInDataContractServiceImpl.getByfState.doPost", (Object)doPost);
            Map map = (Map)JSON.parseObject((String)doPost, Map.class);
            if (MapUtil.isNotEmpty((Map)map)) {
                map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("Data")), Map.class);
            }
            if ("000000".equals(map.get("code").toString())) {
                map = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("data")), Map.class);
                ocContractReDomain.setExtendedField6(map.get("businessStatus").toString());
                ocContractReDomain.setExtendedField7(map.get("outerBusinessId").toString());
                this.updateContractReById(ocContractReDomain);
                ocContractpro.setContractproType(map.get("businessStatus").toString());
                ocContractpro.setContractproValue(map.get("outerBusinessId").toString());
                this.updatecontractpro(ocContractpro);
                if ("12".equals(map.get("businessStatus").toString())) {
                    Thread.sleep(100L);
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("payDataState", "5");
                    this.sendRefundNext(ocRefundReDomain.getRefundCode(), tenantCode, paramMap);
                    ocRefundReDomain.setExtendedField2("1");
                    this.updateRefund((OcRefundDomain)ocRefundReDomain);
                } else if ("11".equals(map.get("businessStatus").toString())) {
                    this.logger.error("dataInDataContractServiceImpl.getByfState.businessStatus.\u9000\u6b3e\u5931\u8d25", (Object)JSON.toJSONString((Object)map));
                } else if ("10".equals(map.get("businessStatus").toString())) {
                    this.logger.error("dataInDataContractServiceImpl.getByfState.businessStatus.\u9000\u6b3e\u4e2d");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("dataInDataContractServiceImpl.getByfState.error", (Object)e.getMessage());
            return false;
        }
        return false;
    }

    public void benefitbatchrefundresult(Map<String, Object> map) {
        List<OcRefundReDomain> ocRefundReDomains = this.queryRefundPage();
        if (ListUtil.isNotEmpty(ocRefundReDomains)) {
            this.logger.error("ocRefundReDomains.size" + ocRefundReDomains.size());
            for (OcRefundReDomain ocRefundReDomain : ocRefundReDomains) {
                this.getByfState(ocRefundReDomain);
            }
        }
    }

    private String savecontractpro(OcContractproDomain ocContractproDomain) {
        if (null == ocContractproDomain) {
            return null;
        }
        String apiCode = "oc.contractpro.savecontractpro";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractproDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractproDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    private QueryResult<OcContractproDomain> querycontractproPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("dataInDataContractServiceImpl.querycontractproPage.map");
            return null;
        }
        String apiCode = "oc.contractpro.querycontractproPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractproDomain.class);
    }

    private String updatecontractproState(Integer contractproId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        String apiCode = "oc.contractpro.updatecontractproState";
        HashMap<String, Integer> pmap = new HashMap<String, Integer>();
        pmap.put("contractproId", contractproId);
        pmap.put("dataState", dataState);
        pmap.put("oldDataState", oldDataState);
        return this.internalInvoke(apiCode, pmap);
    }

    private String updatecontractpro(OcContractproDomain ocContractproDomain) {
        String apiCode = "oc.contractpro.updatecontractpro";
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("ocContractproDomain", JSON.toJSONString((Object)ocContractproDomain));
        return this.internalInvoke(apiCode, pmap);
    }

    private QueryResult<UmUserinfoReDomain> queryUserinfoPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmUserinfoReDomain.class);
    }

    private QueryResult<OcContractReDomain> queryOrderPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("dataInDataContractServiceImpl.queryOrderPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractPageReDomain";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
    }

    private String updateUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) {
        if (null == umUserinfoDomainBean) {
            this.logger.error("dataInDataContractServiceImpl.queryOrderPage.updateUserinfo", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
            return null;
        }
        String apiCode = "um.user.sendUpdateUserinfo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        return this.internalInvoke(apiCode, paramMap);
    }

    private String updateEmployee(OrgEmployeeDomain orgEmployeeDomain) {
        if (null == orgEmployeeDomain) {
            this.logger.error("dataInDataContractServiceImpl.queryOrderPage.updateEmployee", (Object)JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeDomain));
            return null;
        }
        String apiCode = "org.ChannelsendBase.sendUpdateEmployee";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orgEmployeeDomain", JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    private UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    private String updateRefundStateByCode(Integer refundId, Integer dataState, Integer oldDataState) {
        String apiCode = "oc.refund.updateRefundState";
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("refundId", refundId);
        paramMap.put("refundId", dataState);
        paramMap.put("refundId", oldDataState);
        return this.internalInvoke(apiCode, paramMap);
    }

    private String updateRefundState(Integer refundId, Integer dataState, Integer oldDataState) {
        String apiCode = "oc.refund.updateRefundState";
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("refundId", refundId);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        return this.internalInvoke(apiCode, paramMap);
    }

    private String sendRefundNext(String refundCode, String tenantCode, Map<String, Object> map) {
        this.logger.error("dataInDataContractServiceImpl.sendRefundNext.refundCode" + refundCode);
        String apiCode = "oc.refundEngine.sendRefundNext";
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        paramMap.put("refundCode", refundCode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("map", JSON.toJSONString(map));
        return this.internalInvoke(apiCode, paramMap);
    }

    private UmUserReDomainBean getUserByCode(String userPcode, String tenantCode) {
        if (StringUtils.isBlank((String)userPcode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserByUserCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userPcode", userPcode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserReDomainBean)this.getForObject(apiCode, UmUserReDomainBean.class, paramMap);
    }

    private QueryResult<OrgEmployee> queryEmployeePage(String userinfoCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userinfoCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "org.employee.queryEmployeePage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return this.sendReSupObject(apiCode, param, OrgEmployee.class);
    }

    private QueryResult<OrgEmployee> queryEmployeeOnePage(String userCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "org.employee.queryEmployeePage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userCode", userCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return this.sendReSupObject(apiCode, param, OrgEmployee.class);
    }

    private String updateRefund(OcRefundDomain ocRefundDomain) {
        String apiCode = "oc.refund.updateRefund";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    private String updateContractReById(OcContractReDomain ocContractReDomain) {
        String apiCode = "oc.contract.updateContractReById";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractReDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    private String updateContractById(OcContractDomain ocContractDomain) {
        String apiCode = "oc.contract.updateContractReById";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractReDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    private String updateContractState(Integer contractSubId, Integer dataState, Integer oldDataState) {
        String apiCode = "oc.contract.updateContractState";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractSubId", String.valueOf(contractSubId));
        paramMap.put("dataState", String.valueOf(dataState));
        paramMap.put("oldDataState", String.valueOf(oldDataState));
        return this.internalInvoke(apiCode, paramMap);
    }

    public static String getDay() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int dayOfMonth = calendar.get(5);
        String dateMsg = year + "-" + month + "-" + dayOfMonth;
        System.out.println(dateMsg);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = dateFormat.parse(dateMsg);
            calendar.setTime(date);
            calendar.add(5, -1);
            dateMsg = dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateMsg;
    }

    public static void main(String[] args) {
        String path = "https://webinf.hbisscm.com/inf/internal/mdm/manage/supplier/add";
        String bodys = "  {\n    \"sysCode\": \"TG\",\n    \"srcCode\": \"10010\",\n    \"mdmType\": \"SUPPLIER\",\n    \"opType\": \"add\",\n    \"fieldList\": [],\n    \"featureList\": [],\n    \"extDefList\": [],\n    \"data\": {\n        \"basic\": {\n            \"supplierName\": \"\u5929\u6d25\u5e02\u767e\u5229\u5efa\u8bbe\u5de5\u7a0b\u6709\u9650\u516c\u53f8\",\n            \"accountGroup\": \"BP03\",\n            \"busiLicenceNo\": \"91120116103760352Q\",\n            \"englishName\":\"xxxCompany\"\n        },\n        \"feature\": null,\n        \"extObj\": {\n            \"mdm_partner_bank\": [\n                {\n                    \"bankAccount\": \"02250801040000828\",\n                    \"bankName\": \"\u4e2d\u56fd\u519c\u4e1a\u94f6\u884c\u5929\u6d25\u822a\u7a7a\u57ce\u652f\u884c\"\n                }\n            ],\n            \"mdm_partner_contact\": [\n                {\n                    \"contactAddress\": \"\u5929\u6d25\u81ea\u8d38\u8bd5\u9a8c\u533a\uff08\u7a7a\u6e2f\u7ecf\u6d4e\u533a\uff09\u897f\u4e94\u905335\u53f71\u53f7\u697c301\",\n                    \"contactMobile\": \"022-84910006\"\n                }\n            ],\n            \"mdm_partner_purchase\": [\n                {\n                    \"companyCode\": \"80020400\",\n                    \"companyName\": \"\u5929\u6d25\u6cb3\u94a2\u534e\u5317\u8d38\u6613\u6709\u9650\u516c\u53f8\"\n                }\n            ]\n        }\n    },\n    \"opTime\": \"20210604 09:37:37\",\n    \"taskId\": \"60b983b23a89506d6d091c74\",\n    \"operator\": \"tom\"\n}";
        try {
            String doPostJSON = DataInDataPinganServiceImpl.doPostJSON(path, bodys, null);
            System.out.println(doPostJSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String doPostJSON(String path, String bodys, String tenantCode) throws Exception {
        long timestamp = System.currentTimeMillis();
        String privateKey = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANI7lWWLVmpk6zGSAPHR0i0agj49tQXr6WKy25y3fl/2plXwkSFPlkwRaWSxPyQeQhQgHmAHDlfm26uMyGWYrGSQQu+6/KM6/mJ1YDSNmJb58rDJgxm4OdGan3rOqlp3ygEMdKH64ELiyT5U5fEHn0E3jWmGbx3rt18ZtihVzSXJAgMBAAECgYAstgNV70ZXplLm3fhZdZhPg13Dwvfm5H9kQEm4kMXNvvUtPdZ/0R9T2jgh9BhLpCvFf/c10QpZ431AhNZx1QCEl/l0H8Tpa9i+9voPg2wS4+lNivXvjJbFtWZ9M6UReQXmJQiM4qPlDKzRPmBZxI0i510KdfS1Kkp20zp5qWmuoQJBAO7ZjT6CFzgdYGqmIz6yz8s+Sie+bI2m4RR/Zqa5TOq585PRmGYqvj8nC89gbM+UUlJA8R0oP1gnoGFNBA30gqUCQQDhVADvSl3b+XU+wp4emYyOGYDRiD1NIocYB5DnEHCocO+Nc8yBxtNZlH88uNTVboeESPJ12uyNw6qh59JBZKFVAkAVArQnDICIYiUqHIU7LbWTtl4Fkv2vlD92cyKPhftbJpJjrWtPiXEE0yV5z4yi0fRP4gCTxQeVdJ7qEEFMDPc1AkAe1IaYNx2mhnhTUP+fgjToEHc+tBxnHG1NjWN3KhmwAlvUh96YdyLd4+KQ5V1BorDqGa0LERxCvV3wby6mgeVNAkBtdk1GyNrFTZn79W9aSiNgoFdx8D8kXFJN6m9tEi7VOmfmNXb76O4iGsn2Me1HT5AQOocus/PYkGowLuPkkY13";
        CloseableHttpClient httpClient = HttpUtils.createSSLClientTrustAll();
        HttpPost request = new HttpPost(path);
        request.addHeader("haccid", "261");
        request.addHeader("hacckey", "d31b8de9185144caad076ed2a5c08b4e");
        request.addHeader("hacctimestamp", String.valueOf(timestamp));
        bodys = bodys + "&inf_timestamp=" + timestamp;
        System.out.println(bodys);
        String sign = SignUtil.sign((String)bodys, (String)privateKey, (long)timestamp);
        System.out.println(sign);
        request.addHeader("haccsign", sign);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("data", AesUtil.encryptToBase64(bodys, "BUSINESS"));
        System.out.println(JSON.toJSONString(param));
        if (bodys != null) {
            request.setEntity((HttpEntity)new StringEntity(bodys));
        }
        SslUtil.ignoreSsl();
        String result = EntityUtils.toString((HttpEntity)httpClient.execute((HttpUriRequest)request).getEntity());
        return result;
    }
}

