/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.vipvop.service.Util;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RsaUtil {
    public static final String ENCRYPT_ALGORTHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static void genKey() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ENCRYPT_ALGORTHM);
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        String publicKeyStr = new String(Base64.encodeBase64((byte[])publicKey.getEncoded()));
        String privateKeyStr = new String(Base64.encodeBase64((byte[])privateKey.getEncoded()));
        System.out.println("\u516c\u94a5\uff0c\u53d1\u9001\u7ed9\u5546\u4f01\u901a\uff1a" + publicKeyStr);
        System.out.println("\u79c1\u94a5\uff0c\u4f01\u4e1a\u4fdd\u5b58\uff1a" + privateKeyStr);
    }

    public static RSAPublicKey loadPublicKey(String publicKeyStr) throws Exception {
        try {
            byte[] buffer = Base64.decodeBase64((String)publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance(ENCRYPT_ALGORTHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5", e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u516c\u94a5\u975e\u6cd5", e);
        }
        catch (NullPointerException e) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u4e3a\u7a7a", e);
        }
    }

    public static RSAPrivateKey loadPrivateKey(String privateKeyStr) throws Exception {
        try {
            byte[] buffer = Base64.decodeBase64((String)privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance(ENCRYPT_ALGORTHM);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5", e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u79c1\u94a5\u975e\u6cd5", e);
        }
        catch (NullPointerException e) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u4e3a\u7a7a", e);
        }
    }

    public static String sign(byte[] data, RSAPrivateKey privateKey) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateKey);
        signature.update(data);
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static boolean validate(byte[] data, RSAPublicKey publicKey, String sign) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicKey);
        signature.update(data);
        return signature.verify(Base64.decodeBase64((String)sign));
    }

    public static boolean validate(byte[] data, String publicKey, String sign) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(RsaUtil.loadPublicKey(publicKey));
        signature.update(data);
        return signature.verify(Base64.decodeBase64((String)sign));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decryptByPrivateKey(String encryptedString, RSAPrivateKey privateKey) throws Exception {
        byte[] decryptedData;
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGORTHM);
        cipher.init(2, privateKey);
        byte[] encryptedData = Base64.decodeBase64((String)encryptedString);
        int inputLen = encryptedData.length;
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            decryptedData = out.toByteArray();
        }
        return new String(decryptedData, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decryptByPublicKey(String encryptedString, RSAPublicKey publicKey) throws Exception {
        byte[] decryptedData;
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGORTHM);
        cipher.init(2, publicKey);
        byte[] encryptedData = Base64.decodeBase64((String)encryptedString);
        int inputLen = encryptedData.length;
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            decryptedData = out.toByteArray();
        }
        return new String(decryptedData, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encryptByPublicKey(String plainText, RSAPublicKey publicKey) throws Exception {
        byte[] encryptedData;
        byte[] data = plainText.getBytes("UTF-8");
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGORTHM);
        cipher.init(1, publicKey);
        int inputLen = data.length;
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            encryptedData = out.toByteArray();
        }
        return Base64.encodeBase64String((byte[])encryptedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encryptByPrivateKey(String plainText, RSAPrivateKey privateKey) throws Exception {
        byte[] encryptedData;
        byte[] data = plainText.getBytes("UTF-8");
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGORTHM);
        cipher.init(1, privateKey);
        int inputLen = data.length;
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            encryptedData = out.toByteArray();
        }
        return Base64.encodeBase64String((byte[])encryptedData);
    }

    public static void main(String[] args) throws Exception {
        RsaUtil.genKey();
    }
}

