/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.vipvop.service.service.impl;

import com.vip.cup.supply.vop.structs.order.CupSupplyCreateCancelOrderRequest;
import com.vip.cup.supply.vop.structs.order.CupSupplyCreateCancelOrderResponse;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderDetailResponse;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderInfoData;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderInfoRequest;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.ClientUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.service.DataVipVopRefundApiService;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataVipVopRefundApiServiceImpl
extends BaseServiceImpl
implements DataVipVopRefundApiService {
    private static final String SYS_CODE = "DataVipVopRefundApiServiceImpl";

    @Override
    public String createCancelOrder(OcRefundReDomain ocRefundDomain) {
        if (ocRefundDomain == null || ocRefundDomain.getTenantCode() == null || !"41".equals(ocRefundDomain.getContractType())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.preHoldForOrderBySku.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocRefundDomain));
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        String contractNbillcode = ocRefundDomain.getContractNbillcode();
        CupSupplyCreateCancelOrderRequest request = new CupSupplyCreateCancelOrderRequest();
        request.setExtOrderSn(ocRefundDomain.getContractBillcode());
        request.setApplyId(ocRefundDomain.getRefundCode());
        request.setVipOrderSn(contractNbillcode);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyOrderService", "createCancelOrder", JsonUtil.object2Json(request), tenantCode);
        CupSupplyCreateCancelOrderResponse response = client.doRequest(CupSupplyCreateCancelOrderResponse.class);
        if (response == null || response.getCode() != 0) {
            return "error";
        }
        HashMap<String, String> sgMap = new HashMap<String, String>(4);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        sgMap.put("contractBillcode", ocRefundDomain.getContractBillcode());
        sgMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.object2Json(sgMap));
        List<SgSendgoodsReDomain> sgSendgoodsReDomainList = this.inInvokeToQuery("sg.sendgoods.querySendgoodsPage", map, SgSendgoodsReDomain.class);
        if (ListUtil.isNotEmpty(sgSendgoodsReDomainList)) {
            SgSendgoodsDomain sendgoodsReDomain = null;
            for (SgSendgoodsReDomain sgSendgoodsReDomain : sgSendgoodsReDomainList) {
                if (!sgSendgoodsReDomain.getContractNbillcode().equals(contractNbillcode)) continue;
                sendgoodsReDomain = sgSendgoodsReDomain;
            }
            if (sendgoodsReDomain == null) {
                this.logger.error("DataVipVopRefundApiServiceImpl.createCancelOrder.\u5b50\u5355\u4e0d\u5b58\u5728", (Object)contractNbillcode);
                return "error";
            }
            sendgoodsReDomain.setDataOpnextbillstate(-1);
            this.updateSendgoodsState((SgSendgoodsReDomain)sendgoodsReDomain);
            return "success";
        }
        return "success";
    }

    @Override
    public String checkOrderCancel(OcRefundReDomain ocRefundDomain) {
        String contractBillcode;
        if (ocRefundDomain == null || ocRefundDomain.getTenantCode() == null || !"41".equals(ocRefundDomain.getContractType())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.preHoldForOrderBySku.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocRefundDomain));
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        if (this.checkSendgoods(tenantCode, contractBillcode = ocRefundDomain.getContractBillcode(), -1).booleanValue()) {
            this.backOrder(tenantCode, contractBillcode);
        }
        return "success";
    }

    @Override
    public String checkOrderNext(OcRefundReDomain ocRefundDomain) {
        String contractBillcode;
        if (ocRefundDomain == null || ocRefundDomain.getTenantCode() == null || !"41".equals(ocRefundDomain.getContractType())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.preHoldForOrderBySku.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocRefundDomain));
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        if (this.checkSendgoods(tenantCode, contractBillcode = ocRefundDomain.getContractBillcode(), 1).booleanValue()) {
            this.nextOrder(tenantCode, contractBillcode);
        } else if (this.checkSendgoods(tenantCode, contractBillcode, 2).booleanValue()) {
            this.nextOrder(tenantCode, contractBillcode);
        }
        return "success";
    }

    protected OcContractReDomain getContractByCode(String contractBillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "oc.contract.getContractByCode";
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.object2Json(param));
        this.logger.error("DataVipVopRefundApiServiceImpl.queryContractPage.param", (Object)JsonUtil.object2Json(param));
        String contractStr = this.internalInvoke(apiCode, params);
        return JsonUtil.json2Object(contractStr, OcContractReDomain.class);
    }

    private void updateSendgoodsState(SgSendgoodsReDomain sgSendgoodsReDomain) {
        HashMap<String, Object> sgParam2 = new HashMap<String, Object>();
        sgParam2.put("sgSendgoodsDomain", JsonUtil.object2Json(sgSendgoodsReDomain));
        String s = this.inInvokeApi("sg.sendgoods.updateSendgoods", sgParam2);
    }

    private void backOrder(String tenantCode, String contractBillcode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        String s = this.inInvokeApi("oc.contractEngine.sendContractBack", param);
    }

    private void nextOrder(String tenantCode, String contractBillcode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        String s = this.inInvokeApi("oc.contractEngine.sendContractNext", param);
    }

    public String inInvokeApi(String apiCode, Map<String, Object> map) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return result;
    }

    private Boolean checkSendgoods(String tenantCode, String contractBillcode, Integer state) {
        HashMap<String, String> sgParam3 = new HashMap<String, String>(2);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        sgParam3.put("contractBillcode", contractBillcode);
        sgParam3.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.object2Json(sgParam3));
        List<SgSendgoodsReDomain> sgSendgoodsReDomainList2 = this.inInvokeToQuery("sg.sendgoods.querySendgoodsPage", map, SgSendgoodsReDomain.class);
        if (ListUtil.isEmpty(sgSendgoodsReDomainList2)) {
            if (state == -1) {
                this.logger.error("DataVipVopRefundApiServiceImpl.checkSendgoods.\u6574\u5355\u53d6\u6d88", (Object)contractBillcode);
                return true;
            }
            this.logger.error("DataVipVopRefundApiServiceImpl.checkSendgoods.\u627e\u4e0d\u5230\u5b50\u5f39\u4fe1\u606f", (Object)contractBillcode);
            return false;
        }
        for (SgSendgoodsReDomain sendgoodsReDomain : sgSendgoodsReDomainList2) {
            if (sendgoodsReDomain.getDataOpnextbillstate() == -1 || Objects.equals(sendgoodsReDomain.getDataOpnextbillstate(), state)) continue;
            return false;
        }
        return true;
    }

    public <T> List<T> inInvokeToQuery(String apiCode, Map<String, Object> map, Class<T> clazz) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        QueryResult queryResult = JsonUtil.json2Object(result, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return null;
        }
        return JsonUtil.json2ObjectList(JsonUtil.object2Json(queryResult.getList()), clazz);
    }

    private List<CupSupplyGetOrderInfoData> getOrderDetail(String contractNbillcode, String tenantCode) {
        CupSupplyGetOrderInfoRequest request = new CupSupplyGetOrderInfoRequest();
        request.setOrderSn(contractNbillcode);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyOrderService", "getOrderDetail", JsonUtil.object2Json(request), tenantCode);
        CupSupplyGetOrderDetailResponse response = client.doRequest(CupSupplyGetOrderDetailResponse.class);
        return response.getDataList();
    }
}

