/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.vipvop.service.Util;

import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.HmacUtils;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.WebUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.beans.Configure;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;

public class ClientUtil {
    private static final String SYS_CODE = "ClientUtil";
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private static HttpClient client = HttpClientBuilder.create().build();
    Configure configure = new Configure();

    public ClientUtil(String service, String method, String busiParams, String tenantCode) {
        if (busiParams == null) {
            busiParams = "{}";
        }
        busiParams = "{\"request\":" + busiParams + "}";
        this.logger.error("ClientUtil\u8bf7\u6c42\u65b9\u6cd5\uff1a", (Object)(service + "-" + method));
        this.logger.error("ClientUtil\u8bf7\u6c42\u4e1a\u52a1\u53c2\u6570\uff1a", (Object)busiParams);
        this.configure.setAppKey(this.getAppKey(tenantCode)).setAppSecrect(this.getAppSecret(tenantCode)).setFormat("JSON").setService(service).setMethod(method).setTimestamp(String.valueOf(System.currentTimeMillis() / 1000L)).setVersion("1.0.0").setUrl(ClientUtil.getDdFalgSetting(tenantCode, "vipvop", "url", "")).setBusinessData(busiParams);
    }

    public <T> T doRequest(Class<T> clazz) {
        try {
            Map<String, String> sysParams = this.doSign(this.configure);
            HttpPost post = new HttpPost(this.configure.getUrl() + "?" + WebUtil.getQueryString(sysParams));
            post.setEntity((HttpEntity)new StringEntity(this.configure.getBusinessData(), WebUtil.getContentType(this.configure.getFormat())));
            HttpResponse res = client.execute((HttpUriRequest)post);
            String responseStr = this.doResponse(res);
            responseStr = responseStr.substring(responseStr.indexOf("\"result\":") + 9, responseStr.length() - 1);
            this.logger.error("ClientUtil\u54cd\u5e94\u7ed3\u679c\uff1a", (Object)responseStr);
            return JsonUtil.json2Object(responseStr, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Map<String, String> doSign(Configure configure) throws Exception {
        Map<String, String> params = this.getSysParam(configure);
        String data = WebUtil.convertToSortStr(params) + configure.getBusinessData();
        String sign = HmacUtils.byte2hex(HmacUtils.encryptHMAC(data, configure.getAppSecrect()));
        this.logger.error("ClientUtil\u7b7e\u540d\u7ed3\u679c\uff1a", (Object)sign);
        params.put("sign", sign);
        return params;
    }

    private String doResponse(HttpResponse res) throws Exception {
        int code = res.getStatusLine().getStatusCode();
        if (code == 200) {
            HttpEntity entity = res.getEntity();
            if (entity.getContentLength() == 0L) {
                throw new Exception("business-Interface no response data!");
            }
            return WebUtil.stream2Str(entity.getContent());
        }
        throw new Exception("Request vipapis interface Exception\u3010" + code + "\u3011\uff01");
    }

    private Map<String, String> getSysParam(Configure configure) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", configure.getService());
        params.put("method", configure.getMethod());
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("format", configure.getFormat());
        params.put("appKey", configure.getAppKey());
        params.put("version", configure.getVersion());
        params.put("accessToken", configure.getAccessToken());
        return params;
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        return value;
    }

    private String getAppKey(String tenantCode) {
        return ClientUtil.getDdFalgSetting(tenantCode, "vipvop", "appKey", "");
    }

    private String getAppSecret(String tenantCode) {
        return ClientUtil.getDdFalgSetting(tenantCode, "vipvop", "appSecret", "");
    }

    private String getRequest_client_ip(String tenantCode) {
        return ClientUtil.getDdFalgSetting(tenantCode, "vipvop", "request_client_ip", "");
    }
}

