/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.vipvop.service.service.impl;

import com.vip.cup.supply.vop.structs.aftersale.CupSupplyCancelAfterSaleApplyRequest;
import com.vip.cup.supply.vop.structs.aftersale.CupSupplyCancelAfterSaleApplyResponse;
import com.vip.cup.supply.vop.structs.aftersale.CupSupplyCreateReturnApplyRequest;
import com.vip.cup.supply.vop.structs.aftersale.CupSupplyCreateReturnApplyResponse;
import com.vip.cup.supply.vop.structs.aftersale.CupSupplyCreateReturnApplyUpdateInfoRequest;
import com.vip.cup.supply.vop.structs.aftersale.CupSupplyCreateReturnApplyUpdateInfoResponse;
import com.vip.cup.supply.vop.structs.aftersale.CupSupplyNotifyReturnRefundResultRequest;
import com.vip.cup.supply.vop.structs.aftersale.CupSupplyNotifyReturnRefundResultResponse;
import com.vip.cup.supply.vop.structs.aftersale.CupSupplyPullOutReturnUpdateRequest;
import com.vip.cup.supply.vop.structs.aftersale.CupSupplyPullOutReturnUpdateResponse;
import com.vip.cup.supply.vop.structs.aftersale.ReturnApplyGoodInfo;
import com.vip.cup.supply.vop.structs.aftersale.ReturnApplyInfo;
import com.vip.cup.supply.vop.structs.aftersale.ReturnApplyStatusInfoData;
import com.vip.cup.supply.vop.structs.order.CupSupplyCreateCancelOrderRequest;
import com.vip.cup.supply.vop.structs.order.CupSupplyCreateCancelOrderResponse;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderDetailResponse;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderInfoData;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderInfoRequest;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.ClientUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SgSendgoodsGoodsReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.service.DataVipVopRefundApiService;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataVipVopRefundApiServiceImpl
extends BaseServiceImpl
implements DataVipVopRefundApiService {
    private static final String SYS_CODE = "DataVipVopRefundApiServiceImpl";

    @Override
    public String createCancelOrder(OcRefundReDomain ocRefundDomain) {
        if (ocRefundDomain == null || ocRefundDomain.getTenantCode() == null || !"41".equals(ocRefundDomain.getContractType())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.preHoldForOrderBySku.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocRefundDomain));
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        String contractNbillcode = ocRefundDomain.getContractNbillcode();
        CupSupplyCreateCancelOrderRequest request = new CupSupplyCreateCancelOrderRequest();
        request.setExtOrderSn(ocRefundDomain.getContractBillcode());
        request.setApplyId(ocRefundDomain.getRefundCode());
        request.setVipOrderSn(contractNbillcode);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyOrderService", "createCancelOrder", JsonUtil.object2Json(request), tenantCode);
        CupSupplyCreateCancelOrderResponse response = client.doRequest(CupSupplyCreateCancelOrderResponse.class);
        if (response == null || response.getCode() != 0) {
            this.logger.error("DataVipVopRefundApiServiceImpl.preHoldForOrderBySku.\u7533\u8bf7\u5931\u8d25", (Object)ocRefundDomain.getRefundCode());
            return "error";
        }
        HashMap<String, String> sgMap = new HashMap<String, String>(4);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        sgMap.put("contractBillcode", ocRefundDomain.getContractBillcode());
        sgMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.object2Json(sgMap));
        List<SgSendgoodsReDomain> sgSendgoodsReDomainList = this.inInvokeToQuery("sg.sendgoods.querySendgoodsPage", map, SgSendgoodsReDomain.class);
        if (ListUtil.isNotEmpty(sgSendgoodsReDomainList)) {
            SgSendgoodsDomain sendgoodsReDomain = null;
            for (SgSendgoodsReDomain sgSendgoodsReDomain : sgSendgoodsReDomainList) {
                if (!sgSendgoodsReDomain.getContractNbillcode().equals(contractNbillcode)) continue;
                sendgoodsReDomain = sgSendgoodsReDomain;
            }
            if (sendgoodsReDomain == null) {
                this.logger.error("DataVipVopRefundApiServiceImpl.createCancelOrder.\u5b50\u5355\u4e0d\u5b58\u5728", (Object)contractNbillcode);
                return "error";
            }
            sendgoodsReDomain.setDataOpnextbillstate(-1);
            this.updateSendgoodsState((SgSendgoodsReDomain)sendgoodsReDomain);
            return "success";
        }
        return "success";
    }

    @Override
    public String checkOrderCancel(OcRefundReDomain ocRefundDomain) {
        String contractBillcode;
        if (ocRefundDomain == null || ocRefundDomain.getTenantCode() == null || !"41".equals(ocRefundDomain.getContractType())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.preHoldForOrderBySku.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocRefundDomain));
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        if (this.checkSendgoods(tenantCode, contractBillcode = ocRefundDomain.getContractBillcode(), -1).booleanValue()) {
            this.backOrder(tenantCode, contractBillcode);
        }
        return "success";
    }

    @Override
    public String checkOrderNext(OcRefundReDomain ocRefundDomain) {
        String contractBillcode;
        if (ocRefundDomain == null || ocRefundDomain.getTenantCode() == null || !"41".equals(ocRefundDomain.getContractType())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.preHoldForOrderBySku.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocRefundDomain));
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        if (this.checkSendgoods(tenantCode, contractBillcode = ocRefundDomain.getContractBillcode(), 1).booleanValue()) {
            this.nextOrder(tenantCode, contractBillcode);
        } else if (this.checkSendgoods(tenantCode, contractBillcode, 2).booleanValue()) {
            this.nextOrder(tenantCode, contractBillcode);
        }
        return "success";
    }

    @Override
    public String createReturnApply(OcRefundReDomain ocRefundDomain) {
        if (ocRefundDomain == null || ocRefundDomain.getTenantCode() == null || !"41".equals(ocRefundDomain.getContractType())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.createReturnApply.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocRefundDomain));
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        String contractNbillcode = ocRefundDomain.getContractNbillcode();
        String refundType = ocRefundDomain.getRefundType();
        String refundCode = ocRefundDomain.getRefundCode();
        Integer returnsWay = null;
        if ("VIPB02".equals(refundType)) {
            returnsWay = 1;
        } else if ("VIPB03".equals(refundType)) {
            returnsWay = 2;
        }
        if (returnsWay == null) {
            this.logger.error("DataVipVopRefundApiServiceImpl.createReturnApply.\u9000\u6b3e\u7c7b\u578b\u9519\u8bef", (Object)(refundCode + "\u2014\u2014" + refundType));
            return "error";
        }
        CupSupplyCreateReturnApplyRequest request = new CupSupplyCreateReturnApplyRequest();
        ReturnApplyInfo info = new ReturnApplyInfo();
        info.setExtApplyId(refundCode);
        info.setExtOrderSn(ocRefundDomain.getContractBillcode());
        info.setAddTime(Long.valueOf(ocRefundDomain.getGmtCreate().getTime()));
        info.setReason(StringUtils.isBlank((String)ocRefundDomain.getRefundMeo()) ? ocRefundDomain.getRefundEx() : ocRefundDomain.getRefundMeo());
        info.setVipOrderSn(contractNbillcode);
        info.setReturnsWay(returnsWay);
        request.setInfo(info);
        ArrayList<ReturnApplyGoodInfo> goodsList = new ArrayList<ReturnApplyGoodInfo>();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            int refundGoodsNum = Integer.parseInt(ocRefundGoodsDomain.getRefundGoodsNum().stripTrailingZeros().toPlainString());
            for (int i = 0; i < refundGoodsNum; ++i) {
                ReturnApplyGoodInfo applyGoodInfo = new ReturnApplyGoodInfo();
                applyGoodInfo.setGoodsType(Integer.valueOf(0));
                applyGoodInfo.setSkuId(ocRefundGoodsDomain.getSkuNo());
                goodsList.add(applyGoodInfo);
            }
        }
        request.setReturnApplyGoods(goodsList);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyAfterSaleService", "createReturnApply", JsonUtil.object2Json(request), tenantCode);
        CupSupplyCreateReturnApplyResponse response = client.doRequest(CupSupplyCreateReturnApplyResponse.class);
        if (response == null || response.getCode() != 0) {
            this.logger.error("DataVipVopRefundApiServiceImpl.preHoldForOrderBySku.\u7533\u8bf7\u552e\u540e\u5931\u8d25", (Object)refundCode);
            return "error";
        }
        return "success";
    }

    @Override
    public String createReturnApplyUpdateInfo(OcRefundReDomain ocRefundDomain) {
        if (ocRefundDomain == null || ocRefundDomain.getTenantCode() == null || !"41".equals(ocRefundDomain.getContractType())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.createReturnApplyUpdateInfo.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocRefundDomain));
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        String refundCode = ocRefundDomain.getRefundCode();
        CupSupplyCreateReturnApplyUpdateInfoRequest request = new CupSupplyCreateReturnApplyUpdateInfoRequest();
        request.setExtApplyId(refundCode);
        request.setUpdateTime(Long.valueOf(ocRefundDomain.getGmtModified().getTime()));
        request.setTransportNo(ocRefundDomain.getPackageBillno());
        request.setCarrierName(ocRefundDomain.getPackageName());
        request.setExtOrderSn(ocRefundDomain.getContractBillcode());
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyAfterSaleService", "createReturnApplyUpdateInfo", JsonUtil.object2Json(request), tenantCode);
        CupSupplyCreateReturnApplyUpdateInfoResponse response = client.doRequest(CupSupplyCreateReturnApplyUpdateInfoResponse.class);
        if (response == null || response.getCode() != 0) {
            this.logger.error("DataVipVopRefundApiServiceImpl.createReturnApplyUpdateInfo.\u56de\u5199\u7269\u6d41\u4fe1\u606f\u5931\u8d25", (Object)refundCode);
            return "error";
        }
        return "success";
    }

    @Override
    public void pullOutReturnUpdate(String channelCode, String tenantCode) {
        if (channelCode == null || tenantCode == null) {
            this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u53c2\u6570\u4e3a\u7a7a", (Object)channelCode);
            return;
        }
        CupSupplyPullOutReturnUpdateRequest request = new CupSupplyPullOutReturnUpdateRequest();
        Calendar calendar = Calendar.getInstance();
        request.setEndTime(Long.valueOf(calendar.getTime().getTime()));
        calendar.add(12, -2);
        request.setStartTime(Long.valueOf(calendar.getTime().getTime()));
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyAfterSaleService", "pullOutReturnUpdate", JsonUtil.object2Json(request), tenantCode);
        CupSupplyPullOutReturnUpdateResponse response = client.doRequest(CupSupplyPullOutReturnUpdateResponse.class);
        if (response == null) {
            this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u62c9\u53d6\u552e\u540e\u6d88\u606f\u5931\u8d25", (Object)response);
            return;
        }
        if (ListUtil.isEmpty((Collection)response.getData())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u62c9\u53d6\u552e\u540e\u6d88\u606f\u4e3a\u7a7a", (Object)response);
            return;
        }
        for (ReturnApplyStatusInfoData datum : response.getData()) {
            HashMap<String, Object> map;
            String extraData = datum.getExtraData();
            String refundCode = datum.getExtApplyId();
            Map extraDataMap = JsonUtil.json2Map(extraData);
            if (MapUtil.isEmpty((Map)extraDataMap)) {
                this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u5ba1\u6838\u4fe1\u606f\u4e3a\u7a7a", (Object)extraData);
                continue;
            }
            OcRefundReDomain refundByCode = this.getRefundByCode(refundCode, tenantCode);
            if (null == refundByCode) {
                this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u9000\u5355\u4e0d\u5b58\u5728", (Object)refundCode);
                continue;
            }
            Integer msgCode = (Integer)extraDataMap.get("msgCode");
            if ("110100".equals(datum.getScenarioCode())) {
                if (0 != refundByCode.getDataState()) {
                    this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u9000\u5355\u5df2\u5904\u7406", (Object)refundCode);
                    continue;
                }
                if (110102 != datum.getReturnStatus()) {
                    this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u9000\u5355\u72b6\u6001\u9519\u8bef", (Object)(refundCode + "\u2014\u2014" + datum.getReturnStatus()));
                    continue;
                }
                if (10000 == msgCode) {
                    this.nextRefund(refundCode, tenantCode, null);
                    HashMap<String, String> sgMap = new HashMap<String, String>(3);
                    map = new HashMap(1);
                    sgMap.put("contractBillcode", refundByCode.getContractBillcode());
                    sgMap.put("sendgoodsCode", refundByCode.getContractNbillcode());
                    sgMap.put("tenantCode", tenantCode);
                    map.put("map", JsonUtil.object2Json(sgMap));
                    List<SgSendgoodsGoodsReDomain> sgSendgoodsGoodsReDomainList = this.inInvokeToQuery("sg.sendgoods.querySendgoodsGoodsPage", map, SgSendgoodsGoodsReDomain.class);
                    if (ListUtil.isEmpty(sgSendgoodsGoodsReDomainList)) {
                        this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u627e\u4e0d\u5230\u5b50\u5355\u5546\u54c1\u6570\u636e", (Object)JsonUtil.object2Json(sgMap));
                        continue;
                    }
                    for (OcRefundGoodsDomain ocRefundGoodsDomain : refundByCode.getOcRefundGoodsDomainList()) {
                        for (SgSendgoodsGoodsReDomain sgSendgoodsGoodsReDomain : sgSendgoodsGoodsReDomainList) {
                            if (!ocRefundGoodsDomain.getContractGoodsCode().equals(sgSendgoodsGoodsReDomain.getContractGoodsCode())) continue;
                            sgSendgoodsGoodsReDomain.setContractGoodsRefnum(sgSendgoodsGoodsReDomain.getContractGoodsRefnum().add(ocRefundGoodsDomain.getRefundGoodsNum()));
                            this.updateSendgoodsGoods(sgSendgoodsGoodsReDomain);
                        }
                    }
                    boolean refundFlag = true;
                    for (SgSendgoodsGoodsReDomain sgSendgoodsGoodsReDomain : sgSendgoodsGoodsReDomainList) {
                        if (sgSendgoodsGoodsReDomain.getContractGoodsRefnum().compareTo(sgSendgoodsGoodsReDomain.getSendgoodsGoodsCamount()) >= 0) continue;
                        refundFlag = false;
                    }
                    if (!refundFlag) continue;
                    HashMap<String, Object> sgParam = new HashMap<String, Object>(1);
                    sgParam.put("tenantCode", tenantCode);
                    sgParam.put("sendgoodsCode", refundByCode.getContractNbillcode());
                    SgSendgoodsReDomain sgSendgoodsReDomain = this.inInvokeApi("sg.sendgoods.getSendgoodsByCode", sgParam, SgSendgoodsReDomain.class);
                    if (null == sgSendgoodsReDomain) {
                        this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u5b50\u5355\u4fe1\u606f\u4e3a\u7a7a", (Object)JsonUtil.object2Json(sgParam));
                        continue;
                    }
                    sgSendgoodsReDomain.setDataOpnextbillstate(-1);
                    this.updateSendgoodsState(sgSendgoodsReDomain);
                    continue;
                }
                if (10001 != msgCode) continue;
                Map dataMap = JsonUtil.json2Map(JsonUtil.object2Json(extraDataMap.get("data")));
                map = new HashMap<String, Object>();
                if (MapUtil.isNotEmpty((Map)dataMap)) {
                    String reason = (String)dataMap.get("reason");
                    refundByCode.setRefundMeo(reason);
                    map.put("refundMeo", reason);
                    HashMap<String, Object> refundMap = new HashMap<String, Object>();
                    refundMap.put("ocRefundDomain", JsonUtil.object2Json(refundByCode));
                    this.inInvokeApi("oc.refund.updateRefund", refundMap);
                }
                this.backRefund(refundCode, tenantCode, map);
                continue;
            }
            if (!"110700".equals(datum.getScenarioCode())) continue;
            if (2 != refundByCode.getDataState()) {
                this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u9000\u5355\u5df2\u5904\u7406", (Object)refundCode);
                continue;
            }
            if (110701 != datum.getReturnStatus() && 110702 != datum.getReturnStatus()) {
                this.logger.error("DataVipVopRefundApiServiceImpl.pullOutReturnUpdate.\u9000\u5355\u72b6\u6001\u9519\u8bef", (Object)(refundCode + "\u2014\u2014" + datum.getReturnStatus()));
                continue;
            }
            if (11301 == msgCode) {
                this.nextRefund(refundCode, tenantCode, null);
                continue;
            }
            if (11300 != msgCode) continue;
            refundByCode.setRefundMeo(extraDataMap.get("message").toString());
            HashMap<String, Object> refundMap = new HashMap<String, Object>();
            refundMap.put("ocRefundDomain", JsonUtil.object2Json(refundByCode));
            this.inInvokeApi("oc.refund.updateRefund", refundMap);
            map = new HashMap();
            map.put("refundMeo", extraDataMap.get("message").toString());
            this.backRefund(refundCode, tenantCode, map);
        }
    }

    @Override
    public String notifyReturnRefundResult(OcRefundReDomain ocRefundDomain) {
        if (ocRefundDomain == null || ocRefundDomain.getTenantCode() == null || !"41".equals(ocRefundDomain.getContractType())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.notifyReturnRefundResult.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocRefundDomain));
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        CupSupplyNotifyReturnRefundResultRequest request = new CupSupplyNotifyReturnRefundResultRequest();
        request.setVipOrderSn(ocRefundDomain.getContractNbillcode());
        request.setRefundAmount(ocRefundDomain.getRefundMoney().toPlainString());
        request.setRefundFinishDate(Long.valueOf(ocRefundDomain.getGmtModified().getTime()));
        request.setExtApplyId(ocRefundDomain.getRefundCode());
        request.setExtOrderSn(ocRefundDomain.getContractBillcode());
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyAfterSaleService", "notifyReturnRefundResult", JsonUtil.object2Json(request), tenantCode);
        CupSupplyNotifyReturnRefundResultResponse response = client.doRequest(CupSupplyNotifyReturnRefundResultResponse.class);
        if (response == null || response.getCode() != 0) {
            this.logger.error("DataVipVopRefundApiServiceImpl.notifyReturnRefundResult.\u9000\u6b3e\u6210\u529f\u901a\u77e5\u5931\u8d25", (Object)JsonUtil.object2Json(response));
            return "error";
        }
        return "success";
    }

    @Override
    public String cancelAfterSaleApply(OcRefundReDomain ocRefundDomain) {
        if (ocRefundDomain == null || ocRefundDomain.getTenantCode() == null || !"41".equals(ocRefundDomain.getContractType())) {
            this.logger.error("DataVipVopRefundApiServiceImpl.cancelAfterSaleApply.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocRefundDomain));
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        CupSupplyCancelAfterSaleApplyRequest request = new CupSupplyCancelAfterSaleApplyRequest();
        request.setExtApplyId(ocRefundDomain.getRefundCode());
        request.setUpdateTime(Long.valueOf(ocRefundDomain.getGmtModified().getTime()));
        request.setExtOrderSn(ocRefundDomain.getContractBillcode());
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyAfterSaleService", "cancelAfterSaleApply", JsonUtil.object2Json(request), tenantCode);
        CupSupplyCancelAfterSaleApplyResponse response = client.doRequest(CupSupplyCancelAfterSaleApplyResponse.class);
        if (response == null || response.getCode() != 0) {
            this.logger.error("DataVipVopRefundApiServiceImpl.cancelAfterSaleApply.\u53d6\u6d88\u552f\u54c1\u4f1a\u552e\u540e\u5355", (Object)JsonUtil.object2Json(response));
            return "error";
        }
        return "success";
    }

    protected OcContractReDomain getContractByCode(String contractBillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "oc.contract.getContractByCode";
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.object2Json(param));
        this.logger.error("DataVipVopRefundApiServiceImpl.queryContractPage.param", (Object)JsonUtil.object2Json(param));
        String contractStr = this.internalInvoke(apiCode, params);
        return JsonUtil.json2Object(contractStr, OcContractReDomain.class);
    }

    private void updateSendgoodsState(SgSendgoodsReDomain sgSendgoodsReDomain) {
        HashMap<String, Object> sgParam2 = new HashMap<String, Object>();
        sgParam2.put("sgSendgoodsDomain", JsonUtil.object2Json(sgSendgoodsReDomain));
        String s = this.inInvokeApi("sg.sendgoods.updateSendgoods", sgParam2);
    }

    private void updateSendgoodsGoods(SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain) {
        HashMap<String, Object> sgParam2 = new HashMap<String, Object>();
        sgParam2.put("sgSendgoodsGoodsDomain", JsonUtil.object2Json(sgSendgoodsGoodsDomain));
        String s = this.inInvokeApi("sg.sendgoods.updateSendgoodsGoods", sgParam2);
    }

    private void backOrder(String tenantCode, String contractBillcode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        String s = this.inInvokeApi("oc.contractEngine.sendContractBack", param);
    }

    private void nextOrder(String tenantCode, String contractBillcode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        String s = this.inInvokeApi("oc.contractEngine.sendContractNext", param);
    }

    private void nextRefund(String refundCode, String tenantCode, Map<String, Object> map) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("refundCode", refundCode);
        param.put("tenantCode", tenantCode);
        param.put("map", MapUtil.isEmpty(map) ? null : JsonUtil.object2Json(map));
        String s = this.inInvokeApi("oc.refundEngine.sendRefundNext", param);
    }

    private void backRefund(String refundCode, String tenantCode, Map<String, Object> map) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("refundCode", refundCode);
        param.put("tenantCode", tenantCode);
        param.put("map", MapUtil.isEmpty(map) ? null : JsonUtil.object2Json(map));
        String s = this.inInvokeApi("oc.refundEngine.sendRefundBack", param);
    }

    protected OcRefundReDomain getRefundByCode(String refundCode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "oc.refund.getRefundByCode";
        param.put("refundCode", refundCode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.object2Json(param));
        this.logger.error("DataVipVopRefundApiServiceImpl.getContractByCode.param", (Object)JsonUtil.object2Json(param));
        String refundStr = this.internalInvoke(apiCode, params);
        return JsonUtil.json2Object(refundStr, OcRefundReDomain.class);
    }

    public String inInvokeApi(String apiCode, Map<String, Object> map) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return result;
    }

    public <T> T inInvokeApi(String apiCode, Map<String, Object> map, Class<T> clazz) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return JsonUtil.json2Object(JsonUtil.object2Json(result), clazz);
    }

    private Boolean checkSendgoods(String tenantCode, String contractBillcode, Integer state) {
        HashMap<String, String> sgParam3 = new HashMap<String, String>(2);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        sgParam3.put("contractBillcode", contractBillcode);
        sgParam3.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.object2Json(sgParam3));
        List<SgSendgoodsReDomain> sgSendgoodsReDomainList2 = this.inInvokeToQuery("sg.sendgoods.querySendgoodsPage", map, SgSendgoodsReDomain.class);
        if (ListUtil.isEmpty(sgSendgoodsReDomainList2)) {
            if (state == -1) {
                this.logger.error("DataVipVopRefundApiServiceImpl.checkSendgoods.\u6574\u5355\u53d6\u6d88", (Object)contractBillcode);
                return true;
            }
            this.logger.error("DataVipVopRefundApiServiceImpl.checkSendgoods.\u627e\u4e0d\u5230\u5b50\u5355\u4fe1\u606f", (Object)contractBillcode);
            return false;
        }
        for (SgSendgoodsReDomain sendgoodsReDomain : sgSendgoodsReDomainList2) {
            if (sendgoodsReDomain.getDataOpnextbillstate() == -1 || Objects.equals(sendgoodsReDomain.getDataOpnextbillstate(), state)) continue;
            return false;
        }
        return true;
    }

    public <T> List<T> inInvokeToQuery(String apiCode, Map<String, Object> map, Class<T> clazz) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        QueryResult queryResult = JsonUtil.json2Object(result, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return null;
        }
        return JsonUtil.json2ObjectList(JsonUtil.object2Json(queryResult.getList()), clazz);
    }

    private List<CupSupplyGetOrderInfoData> getOrderDetail(String contractNbillcode, String tenantCode) {
        CupSupplyGetOrderInfoRequest request = new CupSupplyGetOrderInfoRequest();
        request.setOrderSn(contractNbillcode);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyOrderService", "getOrderDetail", JsonUtil.object2Json(request), tenantCode);
        CupSupplyGetOrderDetailResponse response = client.doRequest(CupSupplyGetOrderDetailResponse.class);
        return response.getDataList();
    }
}

