/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.vipvop.service.Util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;

public class WebUtil {
    public static final String AJAX_HEADER = "x-requested-with";
    public static final String XMLHTTPREQUEST = "XMLHttpRequest";
    private static String CHARACTER_CODING = "UTF-8";
    private static String CONTENT_TYPE_XML = "application/xml";
    private static String CONTENT_TYPE_JSON = "application/json";

    public static String convertToSortStr(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            String value = params.get(key);
            if (!WebUtil.isNotEmpty(new String[]{key, value})) continue;
            query.append((String)key).append(value);
        }
        return query.toString();
    }

    public static boolean isNotEmpty(String ... values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            for (String value : values) {
                result &= !StringUtils.isEmpty((CharSequence)value);
            }
        }
        return result;
    }

    public static String getQueryString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder query = new StringBuilder();
        boolean hasParam = false;
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            String value = params.get(key);
            if (!WebUtil.isNotEmpty(new String[]{key, value})) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append((String)key).append("=").append(URLEncoder.encode(value, CHARACTER_CODING));
        }
        return query.toString();
    }

    public static String stream2Str(InputStream is) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = -1;
        while ((i = is.read()) != -1) {
            baos.write(i);
        }
        is.close();
        return baos.toString();
    }

    public static ContentType getContentType(String format) {
        ContentType contentType = ContentType.create((String)CONTENT_TYPE_XML, (String)CHARACTER_CODING);
        if ("JSON".equalsIgnoreCase(format)) {
            contentType = ContentType.create((String)CONTENT_TYPE_JSON, (String)CHARACTER_CODING);
        }
        return contentType;
    }
}

