/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.vipvop.service.service.impl;

import com.vip.cup.supply.vop.AddressMsg;
import com.vip.cup.supply.vop.AreaVisibleVo;
import com.vip.cup.supply.vop.CupChannelPriceModel;
import com.vip.cup.supply.vop.CupChannelPriceResp;
import com.vip.cup.supply.vop.CupGetAddressMsgRequest;
import com.vip.cup.supply.vop.CupGetAddressMsgResponse;
import com.vip.cup.supply.vop.CupGetMerItemArea;
import com.vip.cup.supply.vop.CupGetMerItemAreaRequest;
import com.vip.cup.supply.vop.CupGetMerItemAreaResponse;
import com.vip.cup.supply.vop.CupGetProdSkuDetailListData;
import com.vip.cup.supply.vop.CupGetProdSkuDetailModel;
import com.vip.cup.supply.vop.CupGetProdSpuDetailProductModel;
import com.vip.cup.supply.vop.CupGetProductSkuPriceData;
import com.vip.cup.supply.vop.CupSupplyShopCancelForOrderRequest;
import com.vip.cup.supply.vop.CupSupplyShopCancelForOrderResponse;
import com.vip.cup.supply.vop.CupSupplyShopCancelOrder;
import com.vip.cup.supply.vop.CupSupplyShopGetSkuStockData;
import com.vip.cup.supply.vop.CupSupplyShopGetSkuStockRequest;
import com.vip.cup.supply.vop.CupSupplyShopGetSkuStockResponse;
import com.vip.cup.supply.vop.CupSupplyShopPreHoldForOrderBySkuRequest;
import com.vip.cup.supply.vop.CupSupplyShopPreHoldForOrderBySkuResponse;
import com.vip.cup.supply.vop.CupSupplyShopPreHoldInvResult;
import com.vip.cup.supply.vop.CupSupplyShopPreHoldOrder;
import com.vip.cup.supply.vop.CupSupplyShopSkuStock;
import com.vip.cup.supply.vop.OptResult;
import com.vip.cup.supply.vop.structs.order.CupSupplyCreateOrderRequest;
import com.vip.cup.supply.vop.structs.order.CupSupplyCreateOrderResponse;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderDetailResponse;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderInfoData;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderInfoRequest;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderTransportInfoRequest;
import com.vip.cup.supply.vop.structs.order.CupSupplyGetOrderTransportInfoResponse;
import com.vip.cup.supply.vop.structs.order.CupSupplyNotifyTpOrderUpdateRequest;
import com.vip.cup.supply.vop.structs.order.CupSupplyNotifyTpOrderUpdateResponse;
import com.vip.cup.supply.vop.structs.order.CupSupplyOrderConsigneeInfo;
import com.vip.cup.supply.vop.structs.order.CupSupplyOrderGoods;
import com.vip.cup.supply.vop.structs.order.CupSupplyOrderInfo;
import com.vip.cup.supply.vop.structs.order.CupSupplyPullTpOrderUpdateMessageRequest;
import com.vip.cup.supply.vop.structs.order.CupSupplyPullTpOrderUpdateMessageResponse;
import com.vip.cup.supply.vop.structs.order.OrderGoodInfo;
import com.vip.cup.supply.vop.structs.order.TpOrderUpdateMsgVO;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.ClientUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.BsArea;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.BsProvince;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.BsRoad;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.CheckGoodsBean;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SgSendgoodsPackageDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.vip.CupGetProdSpuDetailListData;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.vip.CupGetProdSpuDetailModel;
import com.yqbsoft.laser.service.ext.data.vipvop.service.goods.service.EsGoodsServiceImpl;
import com.yqbsoft.laser.service.ext.data.vipvop.service.service.DataVipVopOrderApiService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataVipVopOrderApiServiceImpl
extends BaseServiceImpl
implements DataVipVopOrderApiService {
    private static final String SYS_CODE = "DataVipVopOrderApiServiceImpl";

    @Override
    public Boolean cancelForOrder(String skuIdListStr, String vipLastAareaId, String tenantCode) {
        if (StringUtils.isBlank((String)skuIdListStr) || StringUtils.isBlank((String)vipLastAareaId) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("DataVipVopOrderApiServiceImpl.cancelForOrder.param is null", (Object)(skuIdListStr + "|" + vipLastAareaId + "|" + tenantCode));
            return null;
        }
        String[] split = skuIdListStr.split(",");
        CupSupplyShopCancelForOrderRequest request = new CupSupplyShopCancelForOrderRequest();
        ArrayList<CupSupplyShopCancelOrder> cancelOrderList = new ArrayList<CupSupplyShopCancelOrder>();
        CupSupplyShopCancelOrder cupSupplyShopCancelOrder = new CupSupplyShopCancelOrder();
        cupSupplyShopCancelOrder.setSkuIdList(Arrays.asList(split));
        cupSupplyShopCancelOrder.setOrderId("");
        cancelOrderList.add(cupSupplyShopCancelOrder);
        request.setCancelOrderList(cancelOrderList);
        request.setVipLastAareaId(vipLastAareaId);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyShopStockService", "cancelForOrder", JsonUtil.object2Json(request), tenantCode);
        CupSupplyShopCancelForOrderResponse response = client.doRequest(CupSupplyShopCancelForOrderResponse.class);
        if (MapUtil.isEmpty((Map)response.getData().getOptResultMap())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.cancelForOrder.\u5f52\u574f\u5546\u54c1\u5e93\u5b58\u4e3a\u7a7a", (Object)JsonUtil.object2Json(response));
            return false;
        }
        Map optResultMap = response.getData().getOptResultMap();
        for (String string : split) {
        }
        return true;
    }

    @Override
    public String getAddressMsg(String areaParentCode, String tenantCode) {
        if (StringUtils.isBlank((String)areaParentCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("DataVipVopOrderApiServiceImpl.getAddressMsg.param is null", (Object)(areaParentCode + "|" + tenantCode));
            return null;
        }
        CupGetAddressMsgRequest request = new CupGetAddressMsgRequest();
        request.setAreaId(areaParentCode);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupAddressService", "getAddressMsg", JsonUtil.object2Json(request), tenantCode);
        CupGetAddressMsgResponse response = client.doRequest(CupGetAddressMsgResponse.class);
        return JsonUtil.object2Json(response.getData());
    }

    @Override
    public void checkAddress(String tenantCode) {
        CupGetAddressMsgResponse response = this.getCupGetAddressMsg("101", tenantCode);
        if (response.getData() == null || ListUtil.isEmpty((Collection)response.getData().getNextLevelAddrs())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.getAddressMsgMethod.\u627e\u4e0d\u5230\u4e00\u7ea7\u5730\u5740", (Object)("101 | " + tenantCode));
            return;
        }
        String provinceCode = null;
        String areaParentCode = null;
        String areaCode = null;
        HashMap<String, String> param1 = new HashMap<String, String>();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        param1.put("tenantCode", tenantCode);
        for (AddressMsg nextLevelAddr1 : response.getData().getNextLevelAddrs()) {
            param1.put("provincName", nextLevelAddr1.getName());
            map1.put("map", JsonUtil.object2Json(param1));
            List<BsProvince> bsProvinceList = this.inInvokeToQuery("bs.province.queryProvincePage", map1, BsProvince.class);
            if (ListUtil.isNotEmpty(bsProvinceList)) {
                if (bsProvinceList.size() > 1) {
                    for (BsProvince bsProvince : bsProvinceList) {
                        if (!StringUtils.isBlank((String)bsProvince.getProvincRemark())) continue;
                        bsProvince.setProvincRemark("s");
                        String string = this.updateProvince(bsProvince);
                    }
                    continue;
                }
                BsProvince bsProvince = bsProvinceList.get(0);
                if (StringUtils.isBlank((String)bsProvince.getPerganaCode()) || StringUtils.isBlank((String)bsProvince.getPerganaName())) {
                    bsProvince.setPerganaCode(nextLevelAddr1.getCodeStr());
                    bsProvince.setPerganaName(nextLevelAddr1.getName());
                    String string = this.updateProvince(bsProvince);
                }
                provinceCode = bsProvince.getProvinceCode();
            }
            if ((response = this.getCupGetAddressMsg(nextLevelAddr1.getCodeStr(), tenantCode)).getData() == null || ListUtil.isEmpty((Collection)response.getData().getNextLevelAddrs())) {
                this.logger.error("DataVipVopOrderApiServiceImpl.getAddressMsgMethod.\u627e\u4e0d\u5230\u4e8c\u7ea7\u5730\u5740", (Object)(nextLevelAddr1.getCodeStr() + " | " + tenantCode));
                continue;
            }
            HashMap<String, String> param2 = new HashMap<String, String>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            param2.put("tenantCode", tenantCode);
            param2.put("provinceCode", provinceCode);
            for (AddressMsg nextLevelAddr2 : response.getData().getNextLevelAddrs()) {
                param2.put("areaName", nextLevelAddr2.getName());
                hashMap.put("map", JsonUtil.object2Json(param2));
                List<BsArea> areaList = this.inInvokeToQuery("bs.area.queryAreaPage", hashMap, BsArea.class);
                if (ListUtil.isNotEmpty(areaList)) {
                    if (areaList.size() > 1) {
                        for (BsArea bsArea : areaList) {
                            if (!StringUtils.isBlank((String)bsArea.getAreaRemark())) continue;
                            bsArea.setAreaRemark("s");
                            String string = this.updateArea(bsArea);
                        }
                        continue;
                    }
                    BsArea bsArea = areaList.get(0);
                    if (StringUtils.isBlank((String)bsArea.getWeaterCode()) || StringUtils.isBlank((String)bsArea.getAreaRemark())) {
                        bsArea.setWeaterCode(nextLevelAddr2.getCodeStr());
                        bsArea.setAreaRemark(nextLevelAddr2.getName());
                        String string = this.updateArea(bsArea);
                    }
                    areaParentCode = bsArea.getAreaCode();
                }
                if ((response = this.getCupGetAddressMsg(nextLevelAddr2.getCodeStr(), tenantCode)).getData() == null || ListUtil.isEmpty((Collection)response.getData().getNextLevelAddrs())) {
                    this.logger.error("DataVipVopOrderApiServiceImpl.getAddressMsgMethod.\u627e\u4e0d\u5230\u4e09\u7ea7\u5730\u5740", (Object)(nextLevelAddr2.getCodeStr() + " | " + tenantCode));
                    continue;
                }
                HashMap<String, String> param3 = new HashMap<String, String>();
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                param3.put("tenantCode", tenantCode);
                param3.put("areaParentCode", areaParentCode);
                for (AddressMsg nextLevelAddr3 : response.getData().getNextLevelAddrs()) {
                    param3.put("areaName", nextLevelAddr3.getName());
                    hashMap2.put("map", JsonUtil.object2Json(param3));
                    List<BsArea> areaList3 = this.inInvokeToQuery("bs.area.queryAreaPage", hashMap2, BsArea.class);
                    if (ListUtil.isNotEmpty(areaList3)) {
                        if (areaList3.size() > 1) {
                            for (BsArea bsArea : areaList3) {
                                if (!StringUtils.isBlank((String)bsArea.getAreaRemark())) continue;
                                bsArea.setAreaRemark("s");
                                String string = this.updateArea(bsArea);
                            }
                            continue;
                        }
                        BsArea bsArea3 = areaList3.get(0);
                        if (StringUtils.isBlank((String)bsArea3.getWeaterCode()) || StringUtils.isBlank((String)bsArea3.getAreaRemark())) {
                            bsArea3.setWeaterCode(nextLevelAddr3.getCodeStr());
                            bsArea3.setAreaRemark(nextLevelAddr3.getName());
                            String string = this.updateArea(bsArea3);
                        }
                        areaCode = bsArea3.getAreaCode();
                    }
                    if ((response = this.getCupGetAddressMsg(nextLevelAddr3.getCodeStr(), tenantCode)).getData() == null || ListUtil.isEmpty((Collection)response.getData().getNextLevelAddrs())) {
                        this.logger.error("DataVipVopOrderApiServiceImpl.getAddressMsgMethod.\u627e\u4e0d\u5230\u56db\u7ea7\u5730\u5740", (Object)(nextLevelAddr3.getCodeStr() + " | " + tenantCode));
                        continue;
                    }
                    HashMap<String, String> param4 = new HashMap<String, String>();
                    HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                    param4.put("tenantCode", tenantCode);
                    param4.put("areaCode", areaCode);
                    for (AddressMsg nextLevelAddr4 : response.getData().getNextLevelAddrs()) {
                        param4.put("roadName", nextLevelAddr4.getName());
                        hashMap3.put("map", JsonUtil.object2Json(param4));
                        List<BsRoad> bsRoadList = this.inInvokeToQuery("bs.road.queryRoadPage", hashMap3, BsRoad.class);
                        if (!ListUtil.isNotEmpty(bsRoadList)) continue;
                        if (bsRoadList.size() > 1) {
                            for (BsRoad bsRoad : bsRoadList) {
                                if (!StringUtils.isBlank((String)bsRoad.getRoadMap())) continue;
                                bsRoad.setRoadMap("s");
                                String string = this.updateRoad(bsRoad);
                            }
                            continue;
                        }
                        BsRoad bsRoad = bsRoadList.get(0);
                        if (!StringUtils.isBlank((String)bsRoad.getRoadPcode()) && !StringUtils.isBlank((String)bsRoad.getRoadMap())) continue;
                        bsRoad.setRoadPcode(nextLevelAddr4.getCodeStr());
                        bsRoad.setRoadMap(nextLevelAddr4.getName());
                        String string = this.updateRoad(bsRoad);
                    }
                }
            }
        }
    }

    @Override
    public String getMerItemArea(String spuIdStr, String tenantCode) {
        if (StringUtils.isBlank((String)spuIdStr) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("DataVipVopOrderApiServiceImpl.getAddressMsg.param is null", (Object)(spuIdStr + "|" + tenantCode));
            return null;
        }
        CupGetMerItemAreaRequest request = new CupGetMerItemAreaRequest();
        request.setSpuIds(Arrays.asList(spuIdStr.split(",")));
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupAddressService", "getMerItemArea", JsonUtil.object2Json(request), tenantCode);
        CupGetMerItemAreaResponse response = client.doRequest(CupGetMerItemAreaResponse.class);
        return JsonUtil.object2Json(response.getData());
    }

    @Override
    public String getSkuDetails(String spuIdListStr, String skuIdListStr, String tenantCode, String cityName, String areaCode) {
        if (StringUtils.isBlank((String)spuIdListStr) || StringUtils.isBlank((String)skuIdListStr) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)cityName) || StringUtils.isBlank((String)areaCode)) {
            this.logger.error("DataVipVopOrderApiServiceImpl.getSkuDetails.param is null", (Object)(spuIdListStr + "|" + skuIdListStr + "|" + tenantCode + "|" + cityName + "|" + areaCode));
            return null;
        }
        EsGoodsServiceImpl service = new EsGoodsServiceImpl();
        ArrayList<CheckGoodsBean> checkGoodsBeanList = new ArrayList<CheckGoodsBean>();
        CupGetProdSpuDetailListData prodSpuDetail = service.getProdSpuDetail(spuIdListStr, tenantCode);
        if (prodSpuDetail == null) {
            return null;
        }
        for (CupGetProdSpuDetailModel cupGetProdSpuDetailModel : prodSpuDetail.getSpuDetailList()) {
            CupGetProdSpuDetailProductModel productModel = cupGetProdSpuDetailModel.getProductModel();
            String prodSpuId = productModel.getProdSpuId();
            CupGetProdSkuDetailListData prodSkuDetailList = service.getProdSkuDetailList(productModel.getProdSpuId(), tenantCode);
            if (prodSkuDetailList == null) continue;
            for (CupGetProdSkuDetailModel cupGetProdSkuDetailModel : prodSkuDetailList.getSkuDetailList()) {
                String prodSkuId = cupGetProdSkuDetailModel.getProdSkuId();
                if (!skuIdListStr.contains(prodSkuId)) continue;
                CheckGoodsBean checkGoodsBean = new CheckGoodsBean();
                checkGoodsBean.setSkuEocode(prodSkuId);
                CupGetProductSkuPriceData productSkuPrice = service.getProductSkuPrice(prodSkuId, tenantCode);
                List priceRespList = productSkuPrice.getPriceRespList();
                CupChannelPriceModel priceModel = ((CupChannelPriceResp)priceRespList.get(0)).getPriceModel();
                BigDecimal marketPrice = priceModel.getMarketPrice() != null ? new BigDecimal(priceModel.getMarketPrice()) : BigDecimal.ZERO;
                BigDecimal distributionPrice = priceModel.getDistributionPrice() != null ? new BigDecimal(priceModel.getDistributionPrice()) : BigDecimal.ZERO;
                BigDecimal salesPrice = new BigDecimal(EsGoodsServiceImpl.getGrossProfitMargin(tenantCode)).multiply(distributionPrice).setScale(2, RoundingMode.HALF_UP);
                Boolean skuStateFlag = service.checkSkuState(productModel, cupGetProdSkuDetailModel, distributionPrice, marketPrice, salesPrice, tenantCode);
                boolean areaRestrict = this.isAreaRestrict(tenantCode, cityName, productModel, prodSpuId);
                CupSupplyShopGetSkuStockData data = this.getCupSupplyShopGetSkuStock(tenantCode, areaCode, prodSkuId);
                Map skuStockMap = new HashMap();
                if (data != null) {
                    skuStockMap = data.getSkuStockMap();
                }
                Integer skuStock = skuStockMap.get(prodSkuId) == null ? 0 : Integer.parseInt((String)skuStockMap.get(prodSkuId));
                checkGoodsBean.setSkuState(skuStateFlag != false ? 1 : 0);
                checkGoodsBean.setSalePrice(salesPrice);
                checkGoodsBean.setAreaRestrict(areaRestrict);
                checkGoodsBean.setGoodsStockNum(skuStock);
                checkGoodsBeanList.add(checkGoodsBean);
            }
        }
        return JsonUtil.object2Json(checkGoodsBeanList);
    }

    private CupSupplyShopGetSkuStockData getCupSupplyShopGetSkuStock(String tenantCode, String areaCode, String prodSkuId) {
        CupSupplyShopGetSkuStockRequest request = new CupSupplyShopGetSkuStockRequest();
        request.setSkuIdList(Arrays.asList(prodSkuId.split(",")));
        request.setVipLastAareaId(areaCode);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyShopStockService", "getSkuStock", JsonUtil.object2Json(request), tenantCode);
        CupSupplyShopGetSkuStockResponse response = client.doRequest(CupSupplyShopGetSkuStockResponse.class);
        CupSupplyShopGetSkuStockData data = response.getData();
        return data;
    }

    private boolean isAreaRestrict(String tenantCode, String cityName, CupGetProdSpuDetailProductModel productModel, String prodSpuId) {
        String resultStr = this.getMerItemArea(productModel.getProdSpuId(), tenantCode);
        CupGetMerItemArea cupGetMerItemArea = JsonUtil.json2Object(resultStr, CupGetMerItemArea.class);
        if (cupGetMerItemArea == null) {
            return false;
        }
        Map midAreaMap = cupGetMerItemArea.getMidAreaMap();
        if (MapUtil.isEmpty((Map)midAreaMap)) {
            this.logger.error("DataVipVopOrderApiServiceImpl.getMerItemArea.\u67e5\u8be2\u6570\u636e\u5931\u8d25", (Object)(prodSpuId + "-" + resultStr));
            return false;
        }
        AreaVisibleVo areaVisibleVo = (AreaVisibleVo)midAreaMap.get(prodSpuId);
        if (areaVisibleVo == null) {
            this.logger.error("DataVipVopOrderApiServiceImpl.getMerItemArea.\u5339\u914d\u6570\u636e\u5931\u8d25", (Object)(prodSpuId + "-" + resultStr));
            return false;
        }
        return "1".equals(areaVisibleVo.getIsAllFlag()) || this.checkSpuAddress(cityName, areaVisibleVo);
    }

    private boolean checkSpuAddress(String cityName, AreaVisibleVo areaVisibleVo) {
        boolean flag = false;
        for (String areaVisible : areaVisibleVo.getAreaVisibles()) {
            if (!cityName.equals(areaVisible)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private CupGetAddressMsgResponse getCupGetAddressMsg(String areaId, String tenantCode) {
        CupGetAddressMsgRequest request = new CupGetAddressMsgRequest();
        request.setAreaId(areaId);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupAddressService", "getAddressMsg", JsonUtil.object2Json(request), tenantCode);
        return client.doRequest(CupGetAddressMsgResponse.class);
    }

    private String updateProvince(BsProvince bsProvince) {
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        updateMap.put("bsProvinceDomain", JsonUtil.object2Json(bsProvince));
        String result = this.inInvokeApi("bs.province.updateProvince", updateMap);
        return result;
    }

    private String updateArea(BsArea bsArea) {
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        updateMap.put("bsAreaDomain", JsonUtil.object2Json(bsArea));
        String result = this.inInvokeApi("bs.area.updateArea", updateMap);
        return result;
    }

    private String updateRoad(BsRoad bsRoad) {
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        updateMap.put("bsRoadDomain", JsonUtil.object2Json(bsRoad));
        String result = this.inInvokeApi("bs.road.updateRoad", updateMap);
        return result;
    }

    @Override
    public String createOrder(OcContractReDomain ocContractDomain) {
        if (ocContractDomain == null || ocContractDomain.getTenantCode() == null || !"41".equals(ocContractDomain.getContractType())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.createOrder.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocContractDomain));
            return "error";
        }
        if (ListUtil.isEmpty(ocContractDomain.getGoodsList()) || StringUtils.isBlank((String)ocContractDomain.getAreaCode())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.createOrder.\u53c2\u6570\u9519\u8bef", (Object)JsonUtil.object2Json(ocContractDomain));
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        String orderId = ocContractDomain.getContractBillcode();
        BigDecimal amount = BigDecimal.ZERO;
        CupSupplyCreateOrderRequest request = new CupSupplyCreateOrderRequest();
        ArrayList<CupSupplyOrderGoods> orderGoods = new ArrayList<CupSupplyOrderGoods>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            CupSupplyOrderGoods goods = new CupSupplyOrderGoods();
            goods.setAmount(Integer.valueOf(ocContractGoodsDomain.getGoodsCamount().intValue()));
            goods.setVipSkuId(ocContractGoodsDomain.getSkuNo());
            goods.setVipSpuId(ocContractGoodsDomain.getGoodsEocode());
            goods.setExtSkuId(ocContractGoodsDomain.getSkuCode());
            amount = amount.add(ocContractGoodsDomain.getPricesetAsprice().multiply(ocContractGoodsDomain.getGoodsCamount()));
            goods.setDistributionPrice(ocContractGoodsDomain.getPricesetAsprice().toPlainString());
            orderGoods.add(goods);
        }
        request.setOrderGoods(orderGoods);
        CupSupplyOrderConsigneeInfo orderConsigneeInfo = new CupSupplyOrderConsigneeInfo();
        orderConsigneeInfo.setConsignee(ocContractDomain.getGoodsReceiptMem());
        orderConsigneeInfo.setMobile(ocContractDomain.getGoodsReceiptPhone());
        orderConsigneeInfo.setAddress(ocContractDomain.getGoodsReceiptArrdess());
        orderConsigneeInfo.setAreaId(ocContractDomain.getAreaName());
        orderConsigneeInfo.setThirdAreaId(ocContractDomain.getAreaCode());
        request.setOrderConsignee(orderConsigneeInfo);
        CupSupplyOrderInfo orderInfo = new CupSupplyOrderInfo();
        orderInfo.setAddTime(Long.valueOf(ocContractDomain.getGmtCreate().getTime()));
        orderInfo.setExtOrderSn(orderId);
        orderInfo.setMoney(amount.toPlainString());
        request.setOrderInfo(orderInfo);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyOrderService", "createOrder", JsonUtil.object2Json(request), tenantCode);
        CupSupplyCreateOrderResponse response = client.doRequest(CupSupplyCreateOrderResponse.class);
        if (response == null || response.getData() == null) {
            this.logger.error("DataVipVopOrderApiServiceImpl.createOrder.\u4e0b\u5355\u5931\u8d25", (Object)JsonUtil.object2Json(response));
            return "error";
        }
        String vipOrderSn = response.getData().getVipOrderSn();
        ocContractDomain.setContractNbillcode(vipOrderSn);
        ocContractDomain.setContractNbbillcode(vipOrderSn);
        ocContractDomain.setGoodsList(null);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("ocContractReDomain", JsonUtil.object2Json(ocContractDomain));
        String s = this.inInvokeApi("oc.contract.updateContractReById", param);
        return "success";
    }

    @Override
    public String preHoldForOrderBySku(OcContractReDomain ocContractDomain) {
        if (ocContractDomain == null || ocContractDomain.getTenantCode() == null || !"41".equals(ocContractDomain.getContractType())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.preHoldForOrderBySku.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocContractDomain));
            return "error";
        }
        if (ListUtil.isEmpty(ocContractDomain.getGoodsList()) || StringUtils.isBlank((String)ocContractDomain.getAreaCode())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.preHoldForOrderBySku.\u53c2\u6570\u9519\u8bef", (Object)JsonUtil.object2Json(ocContractDomain));
            return "error";
        }
        String areaCode = ocContractDomain.getAreaCode();
        String tenantCode = ocContractDomain.getTenantCode();
        String orderId = ocContractDomain.getContractBillcode();
        CupSupplyShopGetSkuStockRequest request = new CupSupplyShopGetSkuStockRequest();
        ArrayList<String> skuIdList = new ArrayList<String>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            skuIdList.add(ocContractGoodsDomain.getSkuNo());
        }
        request.setSkuIdList(skuIdList);
        request.setVipLastAareaId(areaCode);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyShopStockService", "getSkuStock", JsonUtil.object2Json(request), tenantCode);
        CupSupplyShopGetSkuStockResponse response = client.doRequest(CupSupplyShopGetSkuStockResponse.class);
        if (response == null || response.getData() == null || MapUtil.isEmpty((Map)response.getData().getSkuStockMap())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.preHoldForOrderBySku.\u67e5\u8be2\u5e93\u5b58\u5931\u8d25", (Object)JsonUtil.object2Json(response));
            return "error";
        }
        Map skuStockMap = response.getData().getSkuStockMap();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            String stock = (String)skuStockMap.get(ocContractGoodsDomain.getSkuNo());
            if (StringUtils.isBlank((String)stock)) {
                this.logger.error("DataVipVopOrderApiServiceImpl.preHoldForOrderBySku.\u5e93\u5b58\u4e0d\u8db3", (Object)JsonUtil.object2Json(skuStockMap));
                return "error";
            }
            if (new BigDecimal(stock).compareTo(ocContractGoodsDomain.getGoodsCamount()) >= 0) continue;
            this.logger.error("DataVipVopOrderApiServiceImpl.preHoldForOrderBySku.\u5e93\u5b58\u4e0d\u8db3", (Object)JsonUtil.object2Json(skuStockMap));
            return "error";
        }
        CupSupplyShopPreHoldForOrderBySkuRequest request1 = new CupSupplyShopPreHoldForOrderBySkuRequest();
        ArrayList<CupSupplyShopPreHoldOrder> cupSupplyShopPreHoldOrderList = new ArrayList<CupSupplyShopPreHoldOrder>();
        CupSupplyShopPreHoldOrder cupSupplyShopPreHoldOrder = new CupSupplyShopPreHoldOrder();
        ArrayList<CupSupplyShopSkuStock> cupSupplyShopSkuStockList = new ArrayList<CupSupplyShopSkuStock>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            CupSupplyShopSkuStock cupSupplyShopSkuStock = new CupSupplyShopSkuStock();
            cupSupplyShopSkuStock.setSkuId(ocContractGoodsDomain.getSkuNo());
            cupSupplyShopSkuStock.setNum(Integer.valueOf(ocContractGoodsDomain.getGoodsCamount().intValue()));
            cupSupplyShopSkuStockList.add(cupSupplyShopSkuStock);
        }
        cupSupplyShopPreHoldOrder.setSkuStock(cupSupplyShopSkuStockList);
        cupSupplyShopPreHoldOrder.setOrderId(orderId);
        cupSupplyShopPreHoldOrderList.add(cupSupplyShopPreHoldOrder);
        request1.setPreHoldSkuStockList(cupSupplyShopPreHoldOrderList);
        request1.setVipLastAareaId(areaCode);
        ClientUtil client1 = new ClientUtil("com.vip.cup.supply.vop.CupSupplyShopStockService", "preHoldForOrderBySku", JsonUtil.object2Json(request1), tenantCode);
        CupSupplyShopPreHoldForOrderBySkuResponse response1 = client1.doRequest(CupSupplyShopPreHoldForOrderBySkuResponse.class);
        if (response1 == null || response1.getData() == null || MapUtil.isEmpty((Map)response1.getData().getPreHoldOrderMap())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.preHoldForOrderBySku.\u9884\u5360\u5e93\u5b58\u5931\u8d25", (Object)JsonUtil.object2Json(response1));
            return "error";
        }
        Map preHoldOrderMap = response1.getData().getPreHoldOrderMap();
        CupSupplyShopPreHoldInvResult cupSupplyShopPreHoldInvResult = (CupSupplyShopPreHoldInvResult)preHoldOrderMap.get(orderId);
        if (cupSupplyShopPreHoldInvResult.getOptResult().getCode() != 200) {
            this.logger.error("DataVipVopOrderApiServiceImpl.preHoldForOrderBySku.\u9884\u5360\u5e93\u5b58\u5931\u8d25", (Object)JsonUtil.object2Json(response1));
            return "error";
        }
        return "success";
    }

    @Override
    public String cancelForOrder(OcContractReDomain ocContractDomain) {
        String result;
        if (ocContractDomain == null || ocContractDomain.getTenantCode() == null || !"41".equals(ocContractDomain.getContractType())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.cancelForOrder.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocContractDomain));
            return "error";
        }
        if (ListUtil.isEmpty(ocContractDomain.getGoodsList()) || StringUtils.isBlank((String)ocContractDomain.getAreaCode())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.cancelForOrder.\u53c2\u6570\u9519\u8bef", (Object)JsonUtil.object2Json(ocContractDomain));
            return "error";
        }
        String areaCode = ocContractDomain.getAreaCode();
        String tenantCode = ocContractDomain.getTenantCode();
        String orderId = ocContractDomain.getContractBillcode();
        ArrayList<String> skuIdList = new ArrayList<String>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            skuIdList.add(ocContractGoodsDomain.getSkuNo());
        }
        int i = 0;
        do {
            result = this.returnStock(tenantCode, areaCode, skuIdList, orderId);
        } while (++i != 3 && "error".equals(result));
        return "success";
    }

    public String returnStock(String tenantCode, String areaCode, List<String> skuIdList, String orderId) {
        CupSupplyShopCancelForOrderRequest request = new CupSupplyShopCancelForOrderRequest();
        ArrayList<CupSupplyShopCancelOrder> cancelOrderList = new ArrayList<CupSupplyShopCancelOrder>();
        CupSupplyShopCancelOrder cupSupplyShopCancelOrder = new CupSupplyShopCancelOrder();
        cupSupplyShopCancelOrder.setSkuIdList(skuIdList);
        cupSupplyShopCancelOrder.setOrderId(orderId);
        cancelOrderList.add(cupSupplyShopCancelOrder);
        request.setCancelOrderList(cancelOrderList);
        request.setVipLastAareaId(areaCode);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyShopStockService", "cancelForOrder", JsonUtil.object2Json(request), tenantCode);
        CupSupplyShopCancelForOrderResponse response = client.doRequest(CupSupplyShopCancelForOrderResponse.class);
        if (response == null || response.getData() == null || MapUtil.isEmpty((Map)response.getData().getOptResultMap())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.returnStock.\u5f52\u8fd8\u5e93\u5b58\u5931\u8d25", (Object)JsonUtil.object2Json(response));
            return "error";
        }
        OptResult optResult = (OptResult)response.getData().getOptResultMap().get(orderId);
        if (optResult == null || optResult.getCode() != 200) {
            this.logger.error("DataVipVopOrderApiServiceImpl.returnStock.\u5f52\u8fd8\u5e93\u5b58\u5931\u8d25", (Object)JsonUtil.object2Json(response));
            return "error";
        }
        return "success";
    }

    @Override
    public String orderPayNotice(OcContractReDomain ocContractDomain) {
        if (ocContractDomain == null || ocContractDomain.getDataState() != 2 || !"41".equals(ocContractDomain.getContractType())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.orderPayNotice.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocContractDomain));
            return "error";
        }
        Map<String, Object> map = this.makeExtraData(ocContractDomain);
        return this.notifyTpOrderUpdate(ocContractDomain, map);
    }

    private Map<String, Object> makeExtraData(OcContractReDomain ocContractDomain) {
        BigDecimal amount = BigDecimal.ZERO;
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            amount = amount.add(ocContractGoodsDomain.getPricesetAsprice());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("money", amount.toPlainString());
        map.put("payer", ocContractDomain.getMemberBname());
        map.put("payTime", ocContractDomain.getGmtModified().getTime() / 1000L);
        return map;
    }

    @Override
    public String orderCancelNotice(OcContractReDomain ocContractDomain) {
        if (ocContractDomain == null || ocContractDomain.getDataState() != -1 || !"41".equals(ocContractDomain.getContractType())) {
            this.logger.error("DataVipVopOrderApiServiceImpl.orderCancelNotice.\u53c2\u6570\u4e3a\u7a7a", (Object)JsonUtil.object2Json(ocContractDomain));
            return "error";
        }
        return this.notifyTpOrderUpdate(ocContractDomain, null);
    }

    private String notifyTpOrderUpdate(OcContractReDomain ocContractDomain, Map<String, Object> map) {
        String tenantCode = ocContractDomain.getTenantCode();
        Integer dataState = ocContractDomain.getDataState();
        Integer scenarioCode = null;
        Integer extOrderStatus = null;
        if (dataState == -1) {
            scenarioCode = 100300;
            extOrderStatus = 305;
        } else if (dataState == 2) {
            scenarioCode = 100100;
            extOrderStatus = 120;
        }
        CupSupplyNotifyTpOrderUpdateRequest request = new CupSupplyNotifyTpOrderUpdateRequest();
        request.setExtOrderSn(ocContractDomain.getContractBillcode());
        request.setScenarioCode(scenarioCode);
        request.setExtOrderStatus(extOrderStatus);
        request.setExtraData(MapUtil.isNotEmpty(map) ? JsonUtil.object2Json(map) : null);
        request.setUpdateTime(Long.valueOf(ocContractDomain.getGmtModified().getTime()));
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyOrderService", "notifyTpOrderUpdate", JsonUtil.object2Json(request), tenantCode);
        int i = 0;
        do {
            ++i;
            CupSupplyNotifyTpOrderUpdateResponse response = client.doRequest(CupSupplyNotifyTpOrderUpdateResponse.class);
            if (response.getCode() != 0) continue;
            return "success";
        } while (i <= 3);
        return "error";
    }

    @Override
    public String pullOrderStatusChangeMessage(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u53c2\u6570\u4e3a\u7a7a", (Object)(channelCode + "\u2014\u2014\u2014\u2014" + tenantCode));
            return "error";
        }
        CupSupplyPullTpOrderUpdateMessageRequest request = new CupSupplyPullTpOrderUpdateMessageRequest();
        Calendar calendar = Calendar.getInstance();
        request.setEndTime(Long.valueOf(calendar.getTime().getTime()));
        calendar.add(12, -2);
        request.setStartTime(Long.valueOf(calendar.getTime().getTime()));
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyOrderService", "pullTpOrderUpdateMsg", JsonUtil.object2Json(request), tenantCode);
        CupSupplyPullTpOrderUpdateMessageResponse response = client.doRequest(CupSupplyPullTpOrderUpdateMessageResponse.class);
        if (response == null || ListUtil.isEmpty((Collection)response.getTpOrderUpdateMsgVOList())) {
            return "success";
        }
        for (TpOrderUpdateMsgVO tpOrderUpdateMsgVO : response.getTpOrderUpdateMsgVOList()) {
            Map dataMap;
            Map extraDataMap;
            String extraData;
            OcContractReDomain contractByCode = this.getContractByCode(tpOrderUpdateMsgVO.getOrderSn(), tenantCode);
            if (contractByCode == null || ListUtil.isEmpty(contractByCode.getGoodsList())) continue;
            if ("801".equals(tpOrderUpdateMsgVO.getExtOrderStatus()) || "802".equals(tpOrderUpdateMsgVO.getExtOrderStatus())) {
                List<String> orderSnList;
                if (2 != contractByCode.getDataState()) {
                    this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u8ba2\u5355\u72b6\u6001\u9519\u8bef", (Object)(JsonUtil.object2Json(tpOrderUpdateMsgVO) + "\u2014\u2014" + contractByCode.getDataState()));
                    continue;
                }
                HashMap<String, Object> sgMap = new HashMap<String, Object>(4);
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                sgMap.put("contractBillcode", contractByCode.getContractBillcode());
                sgMap.put("tenantCode", tenantCode);
                sgMap.put("startRow", 0);
                sgMap.put("rows", 1);
                map.put("map", JsonUtil.object2Json(sgMap));
                List<SgSendgoodsReDomain> sgSendgoodsReDomainList = this.inInvokeToQuery("sg.sendgoods.querySendgoodsPage", map, SgSendgoodsReDomain.class);
                if (ListUtil.isNotEmpty(sgSendgoodsReDomainList)) {
                    this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u62c6\u5f39\u4fe1\u606f\u5df2\u4fdd\u5b58", (Object)JsonUtil.object2Json(sgMap));
                    continue;
                }
                String extraData2 = tpOrderUpdateMsgVO.getExtraData();
                Map extraDataMap2 = JsonUtil.json2Map(extraData2);
                if (MapUtil.isEmpty((Map)extraDataMap2)) {
                    this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u62c6\u5f39\u4fe1\u606f\u4e3a\u7a7a", (Object)extraData2);
                    continue;
                }
                ArrayList<SgSendgoodsDomain> sgSendgoodsDomainList = new ArrayList<SgSendgoodsDomain>();
                if ("801".equals(tpOrderUpdateMsgVO.getExtOrderStatus())) {
                    SgSendgoodsDomain sgSendgoodsDomain = new SgSendgoodsDomain();
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsDomain, (Object)contractByCode);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    sgSendgoodsDomain.setDataOpnextbillstate(0);
                    sgSendgoodsDomain.setContractNbillcode(contractByCode.getContractNbillcode());
                    sgSendgoodsDomain.setSendgoodsCode(contractByCode.getContractNbillcode());
                    sgSendgoodsDomainList.add(sgSendgoodsDomain);
                    this.saveSendgoodsGoods(tenantCode, contractByCode, contractByCode.getContractNbillcode());
                } else {
                    Map dataMap2 = JsonUtil.json2Map(JsonUtil.object2Json(extraDataMap2.get("data")));
                    if (MapUtil.isEmpty((Map)dataMap2)) {
                        this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.dataMap.\u62c6\u5f39\u4fe1\u606f\u4e3a\u7a7a", (Object)extraDataMap2);
                        continue;
                    }
                    orderSnList = JsonUtil.json2ObjectList(JsonUtil.object2Json(dataMap2.get("orderSnList")), String.class);
                    if (ListUtil.isEmpty(orderSnList)) {
                        this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.orderSnList.\u62c6\u5f39\u4fe1\u606f\u4e3a\u7a7a", (Object)dataMap2);
                        continue;
                    }
                    for (String orderSn : orderSnList) {
                        SgSendgoodsDomain sgSendgoodsDomain = new SgSendgoodsDomain();
                        try {
                            BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsDomain, (Object)contractByCode);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        sgSendgoodsDomain.setDataOpnextbillstate(0);
                        sgSendgoodsDomain.setContractNbillcode(orderSn);
                        sgSendgoodsDomain.setSendgoodsCode(orderSn);
                        sgSendgoodsDomainList.add(sgSendgoodsDomain);
                        this.saveSendgoodsGoods(tenantCode, contractByCode, orderSn);
                    }
                }
                HashMap<String, Object> sgParam = new HashMap<String, Object>();
                sgParam.put("sgSendgoodsDomainList", JsonUtil.object2Json(sgSendgoodsDomainList));
                orderSnList = this.inInvokeApi("sg.sendgoods.saveSendgoodsBatch", sgParam);
                continue;
            }
            if ("410".equals(tpOrderUpdateMsgVO.getExtOrderStatus())) {
                if (2 != contractByCode.getDataState() && 8 != contractByCode.getDataState()) {
                    this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u8ba2\u5355\u72b6\u6001\u9519\u8bef", (Object)(JsonUtil.object2Json(tpOrderUpdateMsgVO) + "\u2014\u2014" + contractByCode.getDataState()));
                    continue;
                }
                extraData = tpOrderUpdateMsgVO.getExtraData();
                extraDataMap = JsonUtil.json2Map(extraData);
                if (MapUtil.isEmpty((Map)extraDataMap)) {
                    this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u62c6\u5f39\u4fe1\u606f\u4e3a\u7a7a", (Object)extraData);
                    continue;
                }
                dataMap = JsonUtil.json2Map(JsonUtil.object2Json(extraDataMap.get("data")));
                if (MapUtil.isEmpty((Map)dataMap)) {
                    this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.dataMap.\u62c6\u5f39\u4fe1\u606f\u4e3a\u7a7a", (Object)extraData);
                    continue;
                }
                this.checkOrderPackage(tenantCode, contractByCode);
                String vipOrderSn = dataMap.get("vipOrderSn").toString();
                String carrierName = dataMap.get("carrierName").toString();
                String transportNo = dataMap.get("transportNo").toString();
                HashMap<String, String> sgMap2 = new HashMap<String, String>(4);
                HashMap<String, Object> map2 = new HashMap<String, Object>(1);
                sgMap2.put("sendgoodsCode", vipOrderSn);
                sgMap2.put("expressName", carrierName);
                sgMap2.put("packageBillno", transportNo);
                sgMap2.put("tenantCode", tenantCode);
                map2.put("map", JsonUtil.object2Json(sgMap2));
                List<SgSendgoodsPackageDomain> sendgoodsPackageDomainList = this.inInvokeToQuery("sg.sendgoods.querySendgoodsPackagePage", map2, SgSendgoodsPackageDomain.class);
                if (ListUtil.isNotEmpty(sendgoodsPackageDomainList)) {
                    this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u5b50\u5355\u53d1\u8d27\u4fe1\u606f\u5df2\u4fdd\u5b58", (Object)JsonUtil.object2Json(sgMap2));
                    continue;
                }
                HashMap<String, Object> sgMap = new HashMap<String, Object>(4);
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                sgMap.put("contractNbillcode", vipOrderSn);
                sgMap.put("tenantCode", tenantCode);
                sgMap.put("startRow", 0);
                sgMap.put("rows", 1);
                map.put("map", JsonUtil.object2Json(sgMap));
                List<SgSendgoodsReDomain> sgSendgoodsReDomainList = this.inInvokeToQuery("sg.sendgoods.querySendgoodsPage", map, SgSendgoodsReDomain.class);
                if (ListUtil.isEmpty(sgSendgoodsReDomainList)) {
                    this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u5b50\u5355\u4fe1\u606f\u4e3a\u7a7a", (Object)JsonUtil.object2Json(sgMap));
                    continue;
                }
                SgSendgoodsReDomain sgSendgoodsReDomain = sgSendgoodsReDomainList.get(0);
                SgSendgoodsPackageDomain sgSendgoodsPackageDomain = new SgSendgoodsPackageDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)sgSendgoodsPackageDomain, (Object)sgSendgoodsReDomain);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sgSendgoodsPackageDomain.setExpressName(carrierName);
                sgSendgoodsPackageDomain.setPackageBillno(transportNo);
                HashMap<String, Object> sgParam = new HashMap<String, Object>();
                sgParam.put("sgSendgoodsPackageDomain", JsonUtil.object2Json(sgSendgoodsPackageDomain));
                String s = this.inInvokeApi("sg.sendgoods.saveSendgoodsPackage", sgParam);
                sgSendgoodsReDomain.setDataOpnextbillstate(1);
                this.updateSendgoodsState(sgSendgoodsReDomain);
                if (!this.checkSendgoods(tenantCode, contractByCode, 1).booleanValue()) continue;
                this.nextOrder(tenantCode, contractByCode);
                continue;
            }
            if (!"510".equals(tpOrderUpdateMsgVO.getExtOrderStatus())) continue;
            if (8 != contractByCode.getDataState() && 3 != contractByCode.getDataState()) {
                this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u8ba2\u5355\u72b6\u6001\u9519\u8bef", (Object)(JsonUtil.object2Json(tpOrderUpdateMsgVO) + "\u2014\u2014" + contractByCode.getDataState()));
                continue;
            }
            extraData = tpOrderUpdateMsgVO.getExtraData();
            extraDataMap = JsonUtil.json2Map(extraData);
            if (MapUtil.isEmpty((Map)extraDataMap)) {
                this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u62c6\u5f39\u4fe1\u606f\u4e3a\u7a7a", (Object)extraData);
                continue;
            }
            dataMap = JsonUtil.json2Map(JsonUtil.object2Json(extraDataMap.get("data")));
            if (MapUtil.isEmpty((Map)dataMap)) {
                this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.dataMap.\u62c6\u5f39\u4fe1\u606f\u4e3a\u7a7a", (Object)extraData);
                continue;
            }
            HashMap<String, Object> sgMap = new HashMap<String, Object>(4);
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            sgMap.put("contractNbillcode", dataMap.get("vipOrderSn").toString());
            sgMap.put("tenantCode", tenantCode);
            sgMap.put("startRow", 0);
            sgMap.put("rows", 1);
            map.put("map", JsonUtil.object2Json(sgMap));
            List<SgSendgoodsReDomain> sgSendgoodsReDomainList = this.inInvokeToQuery("sg.sendgoods.querySendgoodsPage", map, SgSendgoodsReDomain.class);
            if (ListUtil.isEmpty(sgSendgoodsReDomainList)) {
                this.logger.error("DataVipVopOrderApiServiceImpl.pullOrderStatusChangeMessage.\u5b50\u5355\u4fe1\u606f\u4e3a\u7a7a", (Object)JsonUtil.object2Json(sgMap));
                continue;
            }
            SgSendgoodsReDomain sgSendgoodsReDomain = sgSendgoodsReDomainList.get(0);
            sgSendgoodsReDomain.setDataOpnextbillstate(2);
            this.updateSendgoodsState(sgSendgoodsReDomain);
            if (!this.checkSendgoods(tenantCode, contractByCode, 2).booleanValue()) continue;
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(5, 7);
            contractByCode.setContractEffectivedate(calendar2.getTime());
            this.updateOrder(contractByCode);
            this.nextOrder(tenantCode, contractByCode);
        }
        return "success";
    }

    private void saveSendgoodsGoods(String tenantCode, OcContractReDomain contractByCode, String orderSn) {
        CupSupplyGetOrderInfoRequest orderInfoRequest = new CupSupplyGetOrderInfoRequest();
        orderInfoRequest.setOrderSn(orderSn);
        ClientUtil clientUtil = new ClientUtil("com.vip.cup.supply.vop.CupSupplyOrderService", "getOrderDetail", JsonUtil.object2Json(orderInfoRequest), tenantCode);
        CupSupplyGetOrderDetailResponse orderDetailResponse = clientUtil.doRequest(CupSupplyGetOrderDetailResponse.class);
        if (orderDetailResponse == null || ListUtil.isEmpty((Collection)orderDetailResponse.getDataList())) {
            return;
        }
        CupSupplyGetOrderInfoData orderInfoData = (CupSupplyGetOrderInfoData)orderDetailResponse.getDataList().get(0);
        if (ListUtil.isEmpty((Collection)orderInfoData.getOrderGoodInfos())) {
            return;
        }
        ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomainList = new ArrayList<SgSendgoodsGoodsDomain>();
        for (OrderGoodInfo orderGoodInfo : orderInfoData.getOrderGoodInfos()) {
            for (OcContractGoodsDomain ocContractGoodsDomain : contractByCode.getGoodsList()) {
                if (!orderGoodInfo.getProdSkuId().equals(ocContractGoodsDomain.getSkuNo())) continue;
                SgSendgoodsGoodsDomain sendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)sendgoodsGoodsDomain, (Object)ocContractGoodsDomain);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sendgoodsGoodsDomain.setSendgoodsCode(orderSn);
                sendgoodsGoodsDomain.setSendgoodsGoodsCamount(new BigDecimal(orderGoodInfo.getAmount()));
                sgSendgoodsGoodsDomainList.add(sendgoodsGoodsDomain);
            }
        }
        HashMap<String, Object> sgParam = new HashMap<String, Object>();
        sgParam.put("sgSendgoodsGoodsDomainList", JsonUtil.object2Json(sgSendgoodsGoodsDomainList));
        String s = this.inInvokeApi("sg.sendgoods.saveSendgoodsGoodsBatch", sgParam);
    }

    @Override
    public String getOrderDetail(String contractNbillcode, String tenantCode) {
        if (StringUtils.isBlank((String)contractNbillcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("DataVipVopOrderApiServiceImpl.getOrderDetail.\u53c2\u6570\u4e3a\u7a7a", (Object)(contractNbillcode + "\u2014\u2014\u2014\u2014" + tenantCode));
            return "error";
        }
        CupSupplyGetOrderInfoRequest request = new CupSupplyGetOrderInfoRequest();
        request.setOrderSn(contractNbillcode);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyOrderService", "getOrderDetail", JsonUtil.object2Json(request), tenantCode);
        CupSupplyGetOrderDetailResponse response = client.doRequest(CupSupplyGetOrderDetailResponse.class);
        return JsonUtil.object2Json(response.getDataList());
    }

    @Override
    public String queryLogistics(String contractNbillcode, String tenantCode) {
        if (StringUtils.isBlank((String)contractNbillcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("DataVipVopOrderApiServiceImpl.queryLogistics.\u53c2\u6570\u4e3a\u7a7a", (Object)(contractNbillcode + "\u2014\u2014\u2014\u2014" + tenantCode));
            return null;
        }
        CupSupplyGetOrderTransportInfoRequest request = new CupSupplyGetOrderTransportInfoRequest();
        request.setOrderSn(contractNbillcode);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyOrderService", "getOrderTransportInfo", JsonUtil.object2Json(request), tenantCode);
        CupSupplyGetOrderTransportInfoResponse response = client.doRequest(CupSupplyGetOrderTransportInfoResponse.class);
        return JsonUtil.object2Json(response.getDataList());
    }

    public <T> List<T> inInvokeToQuery(String apiCode, Map<String, Object> map, Class<T> clazz) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        QueryResult queryResult = JsonUtil.json2Object(result, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return null;
        }
        return JsonUtil.json2ObjectList(JsonUtil.object2Json(queryResult.getList()), clazz);
    }

    public String inInvokeApi(String apiCode, Map<String, Object> map) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return result;
    }

    protected OcContractReDomain getContractByCode(String contractBillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "oc.contract.getContractByCode";
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.object2Json(param));
        this.logger.error("DataVipVopOrderApiServiceImpl.getContractByCode.param", (Object)JsonUtil.object2Json(param));
        String contractStr = this.internalInvoke(apiCode, params);
        return JsonUtil.json2Object(contractStr, OcContractReDomain.class);
    }

    private void updateOrder(OcContractReDomain contractByCode) {
        contractByCode.setGoodsList(null);
        HashMap<String, Object> param1 = new HashMap<String, Object>();
        param1.put("ocContractReDomain", JsonUtil.object2Json(contractByCode));
        String s = this.inInvokeApi("oc.contract.updateContractReById", param1);
    }

    private void nextOrder(String tenantCode, OcContractReDomain contractByCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", contractByCode.getContractBillcode());
        param.put("tenantCode", tenantCode);
        String s = this.inInvokeApi("oc.contractEngine.sendContractNext", param);
    }

    private Boolean checkSendgoods(String tenantCode, OcContractReDomain contractByCode, Integer state) {
        HashMap<String, String> sgParam3 = new HashMap<String, String>(2);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        sgParam3.put("contractBillcode", contractByCode.getContractBillcode());
        sgParam3.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.object2Json(sgParam3));
        List<SgSendgoodsReDomain> sgSendgoodsReDomainList2 = this.inInvokeToQuery("sg.sendgoods.querySendgoodsPage", map, SgSendgoodsReDomain.class);
        if (ListUtil.isEmpty(sgSendgoodsReDomainList2)) {
            this.logger.error("DataVipVopOrderApiServiceImpl.checkSendgoods.\u627e\u4e0d\u5230\u5b50\u5f39\u4fe1\u606f", (Object)contractByCode.getContractBillcode());
            return false;
        }
        for (SgSendgoodsReDomain sendgoodsReDomain : sgSendgoodsReDomainList2) {
            if (sendgoodsReDomain.getDataOpnextbillstate() == -1 || Objects.equals(sendgoodsReDomain.getDataOpnextbillstate(), state)) continue;
            return false;
        }
        return true;
    }

    private void updateSendgoodsState(SgSendgoodsReDomain sgSendgoodsReDomain) {
        HashMap<String, Object> sgParam2 = new HashMap<String, Object>();
        sgParam2.put("sgSendgoodsDomain", JsonUtil.object2Json(sgSendgoodsReDomain));
        String s = this.inInvokeApi("sg.sendgoods.updateSendgoods", sgParam2);
    }

    private synchronized void checkOrderPackage(String tenantCode, OcContractReDomain contractByCode) {
        HashMap<String, Object> sgMap = new HashMap<String, Object>(4);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        sgMap.put("contractBillcode", contractByCode.getContractBillcode());
        sgMap.put("tenantCode", tenantCode);
        sgMap.put("startRow", 0);
        sgMap.put("rows", 1);
        map.put("map", JsonUtil.object2Json(sgMap));
        List<SgSendgoodsPackageDomain> sendgoodsPackageDomainList = this.inInvokeToQuery("sg.sendgoods.querySendgoodsPackagePage", map, SgSendgoodsPackageDomain.class);
        if (ListUtil.isEmpty(sendgoodsPackageDomainList)) {
            contractByCode.setDataState(8);
            this.updateOrder(contractByCode);
        }
    }
}

