/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.vipvop.service.goods.service;

import com.vip.cup.supply.vop.AckMessageCookieRequest;
import com.vip.cup.supply.vop.AckMessageResponse;
import com.vip.cup.supply.vop.Attribute;
import com.vip.cup.supply.vop.AttributeValue;
import com.vip.cup.supply.vop.BizIdType;
import com.vip.cup.supply.vop.CupChannelPriceModel;
import com.vip.cup.supply.vop.CupChannelPriceReqModel;
import com.vip.cup.supply.vop.CupChannelPriceResp;
import com.vip.cup.supply.vop.CupGetProdSkuDetailListData;
import com.vip.cup.supply.vop.CupGetProdSkuDetailListRequest;
import com.vip.cup.supply.vop.CupGetProdSkuDetailListResponse;
import com.vip.cup.supply.vop.CupGetProdSkuDetailModel;
import com.vip.cup.supply.vop.CupGetProdSkuListData;
import com.vip.cup.supply.vop.CupGetProdSkuListRequest;
import com.vip.cup.supply.vop.CupGetProdSkuListResponse;
import com.vip.cup.supply.vop.CupGetProdSpuDetailBrandModel;
import com.vip.cup.supply.vop.CupGetProdSpuDetailListRequest;
import com.vip.cup.supply.vop.CupGetProdSpuDetailProductModel;
import com.vip.cup.supply.vop.CupGetProdSpuListData;
import com.vip.cup.supply.vop.CupGetProdSpuListRequest;
import com.vip.cup.supply.vop.CupGetProdSpuListResponse;
import com.vip.cup.supply.vop.CupGetProductSkuPriceData;
import com.vip.cup.supply.vop.CupGetProductSkuPriceRequest;
import com.vip.cup.supply.vop.CupGetProductSkuPriceResponse;
import com.vip.cup.supply.vop.CupResult;
import com.vip.cup.supply.vop.ReqContext;
import com.vip.cup.supply.vop.SimpleEventMessageInfo;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.ClientUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.Catagory;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.DisChannel;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.EditSkuDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.GoodsMessage;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsBrand;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsBrandDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsClasstree;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsPntree;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsSpec;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsSpecDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsSpecGroup;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsSpecOption;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SpuData;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.vip.CupGetProdSpuDetailListData;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.vip.CupGetProdSpuDetailListResponse;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.vip.CupGetProdSpuDetailModel;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.vip.ProdSpuDetailCategoryModel;
import com.yqbsoft.laser.service.ext.data.vipvop.service.goods.EsGoodsService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EsGoodsServiceImpl
extends BaseServiceImpl
implements EsGoodsService {
    private String SYS_CODE = ".EsGoodsServiceImpl";
    protected static volatile Map<String, Object> brandMap = new HashMap<String, Object>();
    protected static volatile Map<String, RsClasstree> classtreeMap = new HashMap<String, RsClasstree>();
    protected static final String inOneClasstreeCodeRedisKey = "inOneClasstreeCodeKey";
    protected static final String inTwoClasstreeCodeRedisKey = "inTwoClasstreeCodeKey";
    protected static final String inThreeClasstreeCodeRedisKey = "inThreeClasstreeCodeKey";
    protected static final String defaultMinPrice = "88";
    protected static final String IMAGE_URL = "https://a.vpimg3.com";
    protected static final Object brandlock = new Object();
    private static final String CLASSTREE_QUERY_API_CODE = "rs.rsClasstree.getClasstreeByCode";
    private static final String CLASSTREE_QUERY_API_PAGE = "rs.rsClasstree.queryClasstreePage";
    private static final String BRAND_QUERY_API_CODE = "rs.brand.queryBrandPage";
    private static final String BRAND_ADD_API_CODE = "rs.resource.sendSaveBrand";
    private static final String BRAND_GET_API_CODE = "rs.brand.getBrandByName";
    private static final String RESOURCEGOODS_ADD_CODE_PASS = "rs.resource.sendSavePassResourceGoodsBatch";
    private static final String RESOURCEGOODS_ADD_CODE = "rs.resource.sendSaveResourceGoodsBatch";
    private static final String RESOURCEGOODS_DEL_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SOLD_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SHELVE_CODE = "rs.resource.sendUpdateShelveGoods";
    private static final String RESOURCEGOODS_UPDATE_CODE = "rs.resource.sendUpdateSkuEdit";
    private static final String RESOURCEGOODS_QUERY_NO = "rs.resourceGoods.queryResourceGoodsPage";
    private static final String SKU_QUERY_NO = "rs.sku.querySkuOnePage";
    private static final String RESOURCEGOODS_QUERY_GOODS_PAGE = "rs.resourceGoods.queryResourceGoodsPage";
    private static final String CLASSTREE_ADD_API_CODE = "rs.resource.sendSaveClasstree";
    private static final String PNTREE_QUERY_API_CODE = "rs.pntree.queryPntreePage";
    private static final String RESOURCEGOODS_GETNO_API_CODE = "rs.resourceGoods.getResourceBySkuNo";
    private static final String SKU_QUERY_API_CODE = "rs.sku.getSkuBySkuNo";
    private static final String IMG_ADDRESS_N1 = "http://img13.360buyimg.com/n1/";
    private static final String PNTREE_NAME = "\u552f\u54c1\u4f1a\u9ed8\u8ba4";

    public static String getGrossProfitMargin(String tenantCode) {
        String grossProfitMargin = EsGoodsServiceImpl.getDdFalgSetting(tenantCode, "vipvop", "Gross_profit_margin", "");
        if (grossProfitMargin == null) {
            grossProfitMargin = "1.2";
        }
        return grossProfitMargin;
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        return value;
    }

    @Override
    public boolean saveVipVopSpuIds(SpuData spuData) {
        if (spuData == null || spuData.getDisChannel() == null) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoods.spuData is null", (Object)JsonUtil.object2Json(spuData));
            return false;
        }
        String tenantCode = spuData.getTenantCode();
        DisChannel disChannel = spuData.getDisChannel();
        String spuId = spuData.getGoodsNo();
        CupGetProdSpuDetailListData spuDetail = this.getProdSpuDetail(spuId, tenantCode);
        if (spuDetail == null || ListUtil.isEmpty(spuDetail.getSpuDetailList())) {
            this.logger.error(this.SYS_CODE + ".sendComSaveGoods.spuDetail is null", (Object)spuId);
            return false;
        }
        ArrayList<RsResourceGoodsDomain> goodsListUp = new ArrayList<RsResourceGoodsDomain>();
        ArrayList<RsResourceGoodsDomain> goodsListStop = new ArrayList<RsResourceGoodsDomain>();
        for (CupGetProdSpuDetailModel cupGetProdSpuDetailModel : spuDetail.getSpuDetailList()) {
            ProdSpuDetailCategoryModel categoryModel;
            CupGetProdSpuDetailBrandModel brandModel = cupGetProdSpuDetailModel.getBrandModel();
            String brandCode = null;
            String brandName = null;
            if (brandModel != null) {
                brandName = brandModel.getBrandEnName();
                brandCode = EsGoodsServiceImpl.checkBrandMap(brandName, tenantCode);
            }
            if ((categoryModel = cupGetProdSpuDetailModel.getCategoryModel()) == null || ListUtil.isEmpty(categoryModel.getCategoryList())) {
                this.logger.error(this.SYS_CODE + ".sendComSaveGoods.categoryModel is null", (Object)spuId);
                return false;
            }
            String classTreeCode = categoryModel.getCategoryId();
            String classTreeName = EsGoodsServiceImpl.checkClasstreeMap(categoryModel.getCategoryId(), categoryModel.getCategoryList(), disChannel, spuData.getPntreeCode(), tenantCode);
            String classtreeFullName = "";
            for (Catagory catagory : categoryModel.getCategoryList()) {
                classtreeFullName = "/" + catagory.getCategoryName();
            }
            classtreeFullName = classtreeFullName.substring(1);
            CupGetProdSkuDetailListData prodSkuDetailList = this.getProdSkuDetailList(spuId, tenantCode);
            if (prodSkuDetailList == null || ListUtil.isEmpty((Collection)prodSkuDetailList.getSkuDetailList())) {
                this.logger.error(this.SYS_CODE + ".sendComSaveGoods.getProdSkuDetailList is null", (Object)spuId);
                return false;
            }
            CupGetProdSpuDetailProductModel productModel = cupGetProdSpuDetailModel.getProductModel();
            String goodsListUrl = productModel.getListUrl();
            List goodsImageUrls = productModel.getImageUrls();
            List goodsSystemDesImages = productModel.getSystemDesImages();
            for (CupGetProdSkuDetailModel skuDetailModel : prodSkuDetailList.getSkuDetailList()) {
                if (StringUtils.isNotBlank((String)spuData.getSkuNo()) && !spuData.getSkuNo().equals(skuDetailModel.getProdSkuId())) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoods.spuData.getSkuNo()", (Object)(spuData.getSkuNo() + "\u2014\u2014" + skuDetailModel.getProdSkuId()));
                    continue;
                }
                HashMap<String, Object> goodsMap = new HashMap<String, Object>();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("goodsNo", skuDetailModel.getProdSkuId());
                map.put("tenantCode", tenantCode);
                map.put("memberCode", disChannel.getMemberCcode());
                map.put("startRow", 0);
                map.put("rows", 1);
                goodsMap.put("map", JsonUtil.object2Json(map));
                List<RsResourceGoodsReDomain> list = this.inInvokeToQuery("rs.resourceGoods.queryResourceGoodsPage", goodsMap, RsResourceGoodsReDomain.class);
                if (ListUtil.isNotEmpty(list)) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoods.\u5546\u54c1\u5df2\u5b58\u5728", (Object)skuDetailModel.getProdSkuId());
                    continue;
                }
                String prodSkuId = skuDetailModel.getProdSkuId();
                CupGetProductSkuPriceData productSkuPrice = this.getProductSkuPrice(prodSkuId, tenantCode);
                if (productSkuPrice == null || ListUtil.isEmpty((Collection)productSkuPrice.getPriceRespList())) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoods.getProductSkuPrice is null", (Object)prodSkuId);
                    continue;
                }
                List priceRespList = productSkuPrice.getPriceRespList();
                CupChannelPriceModel priceModel = ((CupChannelPriceResp)priceRespList.get(0)).getPriceModel();
                if (priceModel == null) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoods.getPriceModel is null \u67e5\u4e0d\u5230\u4ef7\u683c", (Object)prodSkuId);
                    continue;
                }
                BigDecimal marketPrice = StringUtils.isNotBlank((String)priceModel.getMarketPrice()) ? new BigDecimal(priceModel.getMarketPrice()) : BigDecimal.ZERO;
                BigDecimal distributionPrice = StringUtils.isNotBlank((String)priceModel.getDistributionPrice()) ? new BigDecimal(priceModel.getDistributionPrice()) : BigDecimal.ZERO;
                BigDecimal salesPrice = new BigDecimal(EsGoodsServiceImpl.getGrossProfitMargin(tenantCode)).multiply(distributionPrice).setScale(2, RoundingMode.HALF_UP);
                String skuListUrl = StringUtils.isBlank((String)skuDetailModel.getListUrl()) ? goodsListUrl : skuDetailModel.getListUrl();
                skuListUrl = IMAGE_URL + skuListUrl;
                this.logger.error(this.SYS_CODE + ".sendComSaveGoods.\u5546\u54c1\u4e3b\u56fe.skuListUrl", (Object)skuListUrl);
                List skuImageUrls = ListUtil.isEmpty((Collection)skuDetailModel.getImageUrls()) ? goodsImageUrls : skuDetailModel.getImageUrls();
                List skuSystemDesImages = ListUtil.isEmpty((Collection)skuDetailModel.getSystemDesImages()) ? goodsSystemDesImages : skuDetailModel.getSystemDesImages();
                RsResourceGoodsDomain rsResourceGoodsDomain = this.makeRsresourceGoods(spuData, tenantCode, disChannel);
                String skuName = "";
                if (StringUtils.isNotBlank((String)skuDetailModel.getColor())) {
                    skuName = skuName + skuDetailModel.getColor() + " ";
                }
                if (StringUtils.isNotBlank((String)skuDetailModel.getSize())) {
                    skuName = skuName + skuDetailModel.getSize() + "";
                }
                if (StringUtils.isNotBlank((String)skuName)) {
                    skuName = " " + skuName;
                }
                if (this.checkSkuState(productModel, skuDetailModel, distributionPrice, marketPrice, salesPrice, tenantCode).booleanValue()) {
                    goodsListUp.add(rsResourceGoodsDomain);
                } else {
                    goodsListStop.add(rsResourceGoodsDomain);
                }
                if (StringUtils.isNotBlank((String)brandCode)) {
                    rsResourceGoodsDomain.setBrandCode(brandCode);
                    rsResourceGoodsDomain.setBrandName(brandName);
                }
                rsResourceGoodsDomain.setClasstreeCode(classTreeCode);
                rsResourceGoodsDomain.setClasstreeName(classTreeName);
                rsResourceGoodsDomain.setClasstreeFullName(classtreeFullName);
                rsResourceGoodsDomain.setGoodsName(productModel.getProductName() + skuName);
                rsResourceGoodsDomain.setPricesetNprice(salesPrice);
                rsResourceGoodsDomain.setPricesetMakeprice(marketPrice);
                rsResourceGoodsDomain.setPricesetAsprice(distributionPrice);
                rsResourceGoodsDomain.setGoodsNo(prodSkuId);
                rsResourceGoodsDomain.setGoodsEocode(spuId);
                rsResourceGoodsDomain.setDataPic(skuListUrl);
                rsResourceGoodsDomain.setRsGoodsFileDomainList(this.getGoodsFile(skuImageUrls, tenantCode));
                rsResourceGoodsDomain.setGoodsRemark(this.makeRemark(skuSystemDesImages).toString());
                ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
                RsSkuDomain rsSkuDomain = new RsSkuDomain();
                rsSkuDomain.setClasstreeCode(classTreeCode);
                rsSkuDomain.setClasstreeName(classTreeName);
                rsSkuDomain.setSkuName(StringUtils.isBlank((String)skuName) ? "\u5e38\u89c4" : skuName.substring(1));
                rsSkuDomain.setDataPic(skuListUrl);
                rsSkuDomain.setTenantCode(tenantCode);
                rsSkuDomain.setGoodsNum(spuData.getGoodsNum());
                rsSkuDomain.setGoodsSupplynum(spuData.getGoodsNum());
                rsSkuDomain.setGoodsNo(prodSkuId);
                rsSkuDomain.setGoodsEocode(spuId);
                rsSkuDomain.setSkuEocode(prodSkuId);
                rsSkuDomain.setDataOpbillstate(0);
                rsSkuDomain.setPricesetNprice(rsResourceGoodsDomain.getPricesetNprice());
                rsSkuDomain.setPricesetMakeprice(rsResourceGoodsDomain.getPricesetMakeprice());
                rsSkuDomain.setPricesetAsprice(rsResourceGoodsDomain.getPricesetAsprice());
                rsSkuDomain.setSkuNo(prodSkuId);
                rsSkuDomain.setRsGoodsFileDomainList(rsResourceGoodsDomain.getRsGoodsFileDomainList());
                rsSkuDomainList.add(rsSkuDomain);
                rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainList);
                this.makeSpec(rsResourceGoodsDomain, skuDetailModel.getAttrSupplyeProps());
            }
        }
        if (ListUtil.isNotEmpty(goodsListUp)) {
            HashMap<String, String> goodsparamMap = new HashMap<String, String>();
            goodsparamMap.put("goodsList", JsonUtil.object2Json(goodsListUp));
            String resultGoods = null;
            try {
                this.logger.error(this.SYS_CODE + ".sendSavePassResourceGoodsBatch-----", (Object)JsonUtil.object2Json(goodsListUp));
                resultGoods = (String)this.getInternalRouter().inInvoke(RESOURCEGOODS_ADD_CODE_PASS, goodsparamMap);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".sendSavePassResourceGoodsBatch.e", (Object)(tenantCode + "--" + resultGoods), (Throwable)e);
                return false;
            }
        }
        if (ListUtil.isNotEmpty(goodsListStop)) {
            HashMap<String, String> goodsparamMap2 = new HashMap<String, String>();
            goodsparamMap2.put("goodsList", JsonUtil.object2Json(goodsListStop));
            String resultGoods2 = null;
            try {
                this.logger.error(this.SYS_CODE + ".sendSaveResourceGoodsBatch-----", (Object)JsonUtil.object2Json(goodsListStop));
                resultGoods2 = (String)this.getInternalRouter().inInvoke(RESOURCEGOODS_ADD_CODE, goodsparamMap2);
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".sendSaveResourceGoodsBatch.e", (Object)(tenantCode + "--" + resultGoods2), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public void saveGoodsMessageHandler(GoodsMessage goodsMessage) {
        SimpleEventMessageInfo messageInfo = goodsMessage.getMessageInfo();
        DisChannel disChannel = goodsMessage.getDisChannel();
        String tenantCode = disChannel.getTenantCode();
        BizIdType bizIdType = messageInfo.getBizIdType();
        String bizId = messageInfo.getBizId();
        SpuData spuData = new SpuData();
        spuData.setDisChannel(disChannel);
        spuData.setTenantCode(disChannel.getTenantCode());
        if (bizIdType == BizIdType.SPU) {
            spuData.setGoodsShowno(bizId);
            spuData.setGoodsNo(bizId);
        } else {
            String spuIdBySkuId = this.getSpuIdBySkuId(tenantCode, bizId);
            if (StringUtils.isBlank((String)spuIdBySkuId)) {
                return;
            }
            spuData.setSkuNo(bizId);
            spuData.setGoodsShowno(spuIdBySkuId);
            spuData.setGoodsNo(spuIdBySkuId);
        }
        String pntreeCode = EsGoodsServiceImpl.getPntreeCode(tenantCode);
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(this.SYS_CODE + ".saveGoodsMessageHandle.pntreeCode is null", (Object)tenantCode);
            return;
        }
        spuData.setPntreeCode(pntreeCode);
        spuData.setGoodsNum(new BigDecimal("9999"));
        spuData.setPntreeName(PNTREE_NAME);
        if (this.saveVipVopSpuIds(spuData)) {
            this.ackMessage(messageInfo, tenantCode);
        }
    }

    @Override
    public void updateGoodsStateMessageHandler(GoodsMessage goodsMessage) {
        SimpleEventMessageInfo messageInfo = goodsMessage.getMessageInfo();
        DisChannel disChannel = goodsMessage.getDisChannel();
        String tenantCode = disChannel.getTenantCode();
        String bizId = messageInfo.getBizId();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        HashMap<String, Object> goodsMap = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsEocode", bizId);
        map.put("goodsType", "41");
        map.put("memberCode", disChannel.getMemberCcode());
        map.put("memberCcode", disChannel.getMemberCcode());
        map.put("channelCode", null);
        goodsMap.put("map", JsonUtil.object2Json(map));
        List<RsResourceGoodsReDomain> list = this.inInvokeToQuery("rs.resourceGoods.queryResourceGoodsPage", goodsMap, RsResourceGoodsReDomain.class);
        if (ListUtil.isEmpty(list)) {
            return;
        }
        CupGetProdSpuDetailListData prodSpuDetailListData = this.getProdSpuDetail(bizId, tenantCode);
        if (prodSpuDetailListData == null || ListUtil.isEmpty(prodSpuDetailListData.getSpuDetailList())) {
            this.logger.error(this.SYS_CODE + ".updateGoodsStateMessageHandler.\u67e5\u8be2SPU\u8be6\u60c5\u5931\u8d25", (Object)bizId);
            return;
        }
        CupGetProdSpuDetailModel cupGetProdSpuDetailModel = prodSpuDetailListData.getSpuDetailList().get(0);
        CupGetProdSpuDetailProductModel productModel = cupGetProdSpuDetailModel.getProductModel();
        if (productModel.getOnline() == 2 && productModel.getIsDeleted() == 0) {
            CupGetProdSkuDetailListData prodSkuDetailList = this.getProdSkuDetailList(bizId, tenantCode);
            if (null == prodSkuDetailList || ListUtil.isEmpty((Collection)prodSkuDetailList.getSkuDetailList())) {
                this.logger.error(this.SYS_CODE + ".updateGoodsStateMessageHandler.\u67e5\u8be2SKU\u8be6\u60c5\u5931\u8d25", (Object)bizId);
                return;
            }
            HashSet<String> skuIdSet = new HashSet<String>();
            for (CupGetProdSkuDetailModel skuDetailModel : prodSkuDetailList.getSkuDetailList()) {
                if (!"1".equals(skuDetailModel.getVipSkuState()) || skuDetailModel.getStatus() != 1) continue;
                skuIdSet.add(skuDetailModel.getProdSkuId());
            }
            ArrayList<Integer> goodsIds = new ArrayList<Integer>();
            String minPrice = this.getMinPrice(tenantCode);
            for (RsResourceGoodsReDomain reDomain : list) {
                if (!skuIdSet.contains(reDomain.getGoodsNo()) || reDomain.getDataOpbillstate() != 0 || reDomain.getPricesetNprice().compareTo(reDomain.getPricesetMakeprice()) > 0 || reDomain.getPricesetAsprice().compareTo(new BigDecimal(minPrice)) < 0) continue;
                goodsIds.add(reDomain.getGoodsId());
            }
            if (ListUtil.isNotEmpty(goodsIds)) {
                map2.put("goodsIds", JsonUtil.object2Json(goodsIds));
                String string = this.inInvokeApi(RESOURCEGOODS_SHELVE_CODE, map2);
            }
        } else {
            ArrayList<Integer> goodsIds = new ArrayList<Integer>();
            CupGetProdSkuDetailListData prodSkuDetailList = this.getProdSkuDetailList(bizId, tenantCode);
            if (null == prodSkuDetailList || ListUtil.isEmpty((Collection)prodSkuDetailList.getSkuDetailList())) {
                this.logger.error(this.SYS_CODE + ".updateGoodsStateMessageHandler.\u67e5\u8be2SKU\u8be6\u60c5\u5931\u8d25", (Object)bizId);
                return;
            }
            for (RsResourceGoodsReDomain reDomain : list) {
                if (reDomain.getDataOpbillstate() != 1) continue;
                goodsIds.add(reDomain.getGoodsId());
            }
            if (ListUtil.isNotEmpty(goodsIds)) {
                map2.put("goodsIds", JsonUtil.object2Json(goodsIds));
                String string = this.inInvokeApi("rs.resource.sendUpdateSoldOutGoods", map2);
            }
        }
        this.ackMessage(messageInfo, tenantCode);
    }

    @Override
    public void updateGoodsPriceMessageHandler(GoodsMessage goodsMessage) {
        GoodsBean goodsBySkuNo;
        String prodSkuId;
        CupGetProductSkuPriceData productSkuPrice;
        SimpleEventMessageInfo messageInfo = goodsMessage.getMessageInfo();
        DisChannel disChannel = goodsMessage.getDisChannel();
        String tenantCode = disChannel.getTenantCode();
        RsSkuDomain rsSkuDomain = this.getSkuBySkuNo(disChannel, messageInfo.getBizId());
        if (rsSkuDomain == null) {
            return;
        }
        if (null == rsSkuDomain.getPricesetNprice()) {
            rsSkuDomain.setPricesetNprice(BigDecimal.ZERO);
        }
        if (null == rsSkuDomain.getPricesetAsprice()) {
            rsSkuDomain.setPricesetAsprice(BigDecimal.ZERO);
        }
        if (null == rsSkuDomain.getPricesetMakeprice()) {
            rsSkuDomain.setPricesetMakeprice(BigDecimal.ZERO);
        }
        if ((productSkuPrice = this.getProductSkuPrice(prodSkuId = rsSkuDomain.getSkuNo(), tenantCode)) == null || ListUtil.isEmpty((Collection)productSkuPrice.getPriceRespList())) {
            this.logger.error(this.SYS_CODE + ".updateGoodsPriceMessageHandler.getProductSkuPrice is null", (Object)prodSkuId);
            return;
        }
        List priceRespList = productSkuPrice.getPriceRespList();
        CupChannelPriceModel priceModel = ((CupChannelPriceResp)priceRespList.get(0)).getPriceModel();
        if (priceModel == null) {
            this.logger.error(this.SYS_CODE + ".updateGoodsPriceMessageHandler.getPriceModel is null \u67e5\u4e0d\u5230\u4ef7\u683c", (Object)prodSkuId);
            return;
        }
        BigDecimal marketPrice = StringUtils.isNotBlank((String)priceModel.getMarketPrice()) ? new BigDecimal(priceModel.getMarketPrice()) : BigDecimal.ZERO;
        BigDecimal distributionPrice = StringUtils.isNotBlank((String)priceModel.getDistributionPrice()) ? new BigDecimal(priceModel.getDistributionPrice()) : BigDecimal.ZERO;
        BigDecimal salesPrice = new BigDecimal(EsGoodsServiceImpl.getGrossProfitMargin(tenantCode)).multiply(distributionPrice).setScale(2, RoundingMode.HALF_UP);
        if (rsSkuDomain.getPricesetNprice().compareTo(salesPrice) == 0 && rsSkuDomain.getPricesetMakeprice().compareTo(marketPrice) == 0) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.PricesetNprice", (Object)(prodSkuId + "=" + salesPrice));
            this.ackMessage(messageInfo, tenantCode);
            return;
        }
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        editSkuDomain.setSkuId(rsSkuDomain.getSkuId());
        editSkuDomain.setGoodsCode(rsSkuDomain.getGoodsCode());
        editSkuDomain.setSkuCode(rsSkuDomain.getSkuCode());
        editSkuDomain.setSkuNo(String.valueOf(rsSkuDomain.getSkuNo()));
        editSkuDomain.setPricesetNprice(salesPrice);
        editSkuDomain.setPricesetMakeprice(marketPrice);
        editSkuDomain.setPricesetAsprice(distributionPrice);
        editSkuDomain.setMemberCode(disChannel.getMemberCode());
        editSkuDomain.setMemberCcode(disChannel.getMemberCcode());
        editSkuDomain.setTenantCode(disChannel.getTenantCode());
        String json = JsonUtil.object2Json(editSkuDomain);
        this.logger.error(this.SYS_CODE + ".synJdVopPrice.info", (Object)json);
        try {
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("editSkuDomain", json);
            this.getInternalRouter().inInvoke(RESOURCEGOODS_UPDATE_CODE, updateMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.e", (Throwable)e);
        }
        boolean upFlag = false;
        String minPrice = this.getMinPrice(tenantCode);
        if (salesPrice.compareTo(marketPrice) <= 0 && distributionPrice.compareTo(new BigDecimal(minPrice)) >= 0) {
            upFlag = true;
        }
        if (null == (goodsBySkuNo = this.getGoodsBySkuNo(rsSkuDomain.getSkuNo(), disChannel))) {
            return;
        }
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        goodsIds.add(goodsBySkuNo.getRsResourceGoods().getGoodsId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (rsSkuDomain.getDataOpbillstate() == 1) {
            if (!upFlag && ListUtil.isNotEmpty(goodsIds)) {
                map.put("goodsIds", JsonUtil.object2Json(goodsIds));
                String string = this.inInvokeApi("rs.resource.sendUpdateSoldOutGoods", map);
            }
        } else if (rsSkuDomain.getDataOpbillstate() == 0 && upFlag && ListUtil.isNotEmpty(goodsIds)) {
            map.put("goodsIds", JsonUtil.object2Json(goodsIds));
            String string = this.inInvokeApi(RESOURCEGOODS_SHELVE_CODE, map);
        }
        this.ackMessage(messageInfo, tenantCode);
    }

    @Override
    public void updateGoodsDataMessageHandler(GoodsMessage goodsMessage) {
        SimpleEventMessageInfo messageInfo = goodsMessage.getMessageInfo();
        DisChannel disChannel = goodsMessage.getDisChannel();
        String tenantCode = disChannel.getTenantCode();
        GoodsBean goodsBean = this.getGoodsBySkuNo(messageInfo.getBizId(), disChannel);
        if (goodsBean == null) {
            return;
        }
        String spuId = goodsBean.getRsResourceGoods().getGoodsEocode();
        CupGetProdSpuDetailListData prodSpuDetail = this.getProdSpuDetail(spuId, tenantCode);
        if (prodSpuDetail == null || ListUtil.isEmpty(prodSpuDetail.getSpuDetailList())) {
            return;
        }
        for (CupGetProdSpuDetailModel cupGetProdSpuDetailModel : prodSpuDetail.getSpuDetailList()) {
            CupGetProdSkuDetailListData prodSkuDetailList;
            CupGetProdSpuDetailBrandModel brandModel = cupGetProdSpuDetailModel.getBrandModel();
            String brandCode = null;
            String brandName = null;
            if (brandModel != null) {
                brandName = brandModel.getBrandEnName();
                brandCode = EsGoodsServiceImpl.checkBrandMap(brandName, tenantCode);
            }
            String classTreeCode = null;
            String classTreeName = null;
            ProdSpuDetailCategoryModel categoryModel = cupGetProdSpuDetailModel.getCategoryModel();
            if (categoryModel != null && ListUtil.isNotEmpty(categoryModel.getCategoryList())) {
                classTreeCode = categoryModel.getCategoryId();
                classTreeName = EsGoodsServiceImpl.checkClasstreeMap(categoryModel.getCategoryId(), categoryModel.getCategoryList(), disChannel, null, tenantCode);
            }
            if ((prodSkuDetailList = this.getProdSkuDetailList(spuId, tenantCode)) == null || ListUtil.isEmpty((Collection)prodSkuDetailList.getSkuDetailList())) {
                this.logger.error(this.SYS_CODE + ".sendComSaveGoods.getProdSkuDetailList is null", (Object)spuId);
                continue;
            }
            CupGetProdSpuDetailProductModel productModel = cupGetProdSpuDetailModel.getProductModel();
            String goodsListUrl = productModel.getListUrl();
            List goodsImageUrls = productModel.getImageUrls();
            List goodsSystemDesImages = productModel.getSystemDesImages();
            for (CupGetProdSkuDetailModel skuDetailModel : prodSkuDetailList.getSkuDetailList()) {
                String skuListUrl;
                if (!messageInfo.getBizId().equals(skuDetailModel.getProdSkuId())) continue;
                String string = skuListUrl = StringUtils.isBlank((String)skuDetailModel.getListUrl()) ? goodsListUrl : skuDetailModel.getListUrl();
                if (!skuListUrl.contains("Http")) {
                    skuListUrl = IMAGE_URL + skuListUrl;
                }
                List skuImageUrls = ListUtil.isEmpty((Collection)skuDetailModel.getImageUrls()) ? goodsImageUrls : skuDetailModel.getImageUrls();
                List skuSystemDesImages = ListUtil.isEmpty((Collection)skuDetailModel.getSystemDesImages()) ? goodsSystemDesImages : skuDetailModel.getSystemDesImages();
                EditSkuDomain editSkuDomain = new EditSkuDomain();
                RsResourceGoodsDomain rsResourceGoods = goodsBean.getRsResourceGoods();
                if (rsResourceGoods != null && StringUtils.isNotBlank((String)rsResourceGoods.getGoodsCode()) && StringUtils.isNotBlank((String)rsResourceGoods.getSpuCode())) {
                    editSkuDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
                    editSkuDomain.setSpuCode(rsResourceGoods.getSpuCode());
                }
                if (StringUtils.isNotBlank((String)brandCode)) {
                    editSkuDomain.setBrandCode(brandCode);
                }
                if (StringUtils.isNotBlank((String)brandName)) {
                    editSkuDomain.setBrandName(brandName);
                }
                if (StringUtils.isNotBlank((String)classTreeCode)) {
                    editSkuDomain.setClasstreeCode(classTreeCode);
                }
                if (StringUtils.isNotBlank((String)classTreeName)) {
                    editSkuDomain.setClasstreeName(classTreeName);
                }
                editSkuDomain.setMemberCode(disChannel.getMemberCcode());
                editSkuDomain.setMemberName(disChannel.getMemberCname());
                editSkuDomain.setMemberCcode(disChannel.getMemberCcode());
                editSkuDomain.setMemberCname(disChannel.getMemberCname());
                editSkuDomain.setMemberMname(disChannel.getMemberMname());
                editSkuDomain.setMemberMcode(disChannel.getMemberMcode());
                editSkuDomain.setTenantCode(tenantCode);
                editSkuDomain.setGoodsName(productModel.getProductName());
                editSkuDomain.setDataPic(skuListUrl);
                editSkuDomain.setPartsnameNumunit("\u4ef6");
                editSkuDomain.setGoodsMinnum(new BigDecimal("1"));
                editSkuDomain.setGoodsNum(new BigDecimal("9999"));
                editSkuDomain.setGoodsSupplynum(new BigDecimal("9999"));
                editSkuDomain.setGoodsNo(messageInfo.getBizId());
                editSkuDomain.setSkuNo(String.valueOf(messageInfo.getBizId()));
                editSkuDomain.setGoodsType("41");
                editSkuDomain.setGoodsPro("11");
                editSkuDomain.setRsGoodsFileDomainList(this.getGoodsFile(skuImageUrls, tenantCode));
                editSkuDomain.setGoodsRemark(this.makeRemark(skuSystemDesImages).toString());
                HashMap<String, String> goodsparamMap = new HashMap<String, String>();
                goodsparamMap.put("editSkuDomain", JsonUtil.object2Json(editSkuDomain));
                String resultGoods = null;
                try {
                    resultGoods = (String)this.getInternalRouter().inInvoke(RESOURCEGOODS_UPDATE_CODE, goodsparamMap);
                }
                catch (Exception e) {
                    this.logger.error(this.SYS_CODE + ".sendComSaveGoods.e", (Object)resultGoods, (Throwable)e);
                    return;
                }
            }
        }
        this.ackMessage(messageInfo, tenantCode);
    }

    @Override
    public void deleteGoodsMessageHandler(GoodsMessage goodsMessage) {
        SimpleEventMessageInfo messageInfo = goodsMessage.getMessageInfo();
        DisChannel disChannel = goodsMessage.getDisChannel();
        String tenantCode = disChannel.getTenantCode();
        GoodsBean goodsBySkuNo = this.getGoodsBySkuNo(messageInfo.getBizId(), disChannel);
        if (goodsBySkuNo == null) {
            return;
        }
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        goodsIds.add(goodsBySkuNo.getRsResourceGoods().getGoodsId());
        this.delGoodsByGoodsIds(goodsIds);
        this.ackMessage(messageInfo, tenantCode);
    }

    private void ackMessage(SimpleEventMessageInfo messageInfo, String tenantCode) {
        CupResult cupResult;
        AckMessageResponse response = this.ackMessageRequest(messageInfo, tenantCode);
        if (MapUtil.isEmpty((Map)response.getResultMap())) {
            response = this.ackMessageRequest(messageInfo, tenantCode);
        }
        if (!(cupResult = (CupResult)response.getResultMap().get(messageInfo.getMessageId())).getResult().booleanValue()) {
            response = this.ackMessageRequest(messageInfo, tenantCode);
        }
    }

    public <T> List<T> inInvokeToQuery(String apiCode, Map<String, Object> map, Class<T> clazz) {
        this.logger.error(this.SYS_CODE + ".inInvokeToQuery" + apiCode, (Object)JsonUtil.object2Json(map));
        String result = (String)this.getInternalRouter().inInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        QueryResult queryResult = JsonUtil.json2Object(result, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return null;
        }
        return JsonUtil.json2ObjectList(JsonUtil.object2Json(queryResult.getList()), clazz);
    }

    public String inInvokeApi(String apiCode, Map<String, Object> map) {
        this.logger.error(this.SYS_CODE + ".inInvokeApi" + apiCode, (Object)JsonUtil.object2Json(map));
        String result = (String)this.getInternalRouter().inInvoke(apiCode, map);
        this.logger.error(this.SYS_CODE + ".inInvokeApi" + apiCode, (Object)JsonUtil.object2Json(map));
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return result;
    }

    private GoodsBean getGoodsBySkuNo(String skuNo, DisChannel disChannel) {
        if (StringUtils.isBlank((String)skuNo) || null == disChannel) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", disChannel.getMemberCcode());
        params.put("memberCcode", disChannel.getMemberCcode());
        params.put("channelCode", null);
        params.put("goodsType", "41");
        params.put("tenantCode", disChannel.getTenantCode());
        this.logger.error(this.SYS_CODE + ".getGoodsBySkuNo" + JsonUtil.object2Json(params));
        return (GoodsBean)this.getForObject(RESOURCEGOODS_GETNO_API_CODE, GoodsBean.class, params);
    }

    private void delGoodsByGoodsIds(List<Integer> goodsIds) {
        if (ListUtil.isEmpty(goodsIds)) {
            this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", goodsIds);
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.put("goodsIds", JsonUtil.object2Json(goodsIds));
            this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds.maps:", (Object)JsonUtil.object2Json(params));
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u5220\u9664\u5931\u8d25", (Object)e.getMessage());
            throw new ApiException(this.SYS_CODE + ".delGoodsByGoodsIds.ex", (Throwable)e);
        }
    }

    private AckMessageResponse ackMessageRequest(SimpleEventMessageInfo messageInfo, String tenantCode) {
        AckMessageCookieRequest request = new AckMessageCookieRequest();
        ReqContext reqContext = new ReqContext();
        reqContext.setAppId(this.getAppKey(tenantCode));
        request.setReqContext(reqContext);
        HashSet<Long> messageIds = new HashSet<Long>();
        messageIds.add(messageInfo.getMessageId());
        request.setMessageIds(messageIds);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyMessagePullService", "ackEventCookieMessages", JsonUtil.object2Json(request), tenantCode);
        AckMessageResponse response = client.doRequest(AckMessageResponse.class);
        return response;
    }

    private String getSpuIdBySkuId(String tenantCode, String bizId) {
        Integer total = 0;
        Integer page = 0;
        Integer pageSize = 50;
        do {
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
            CupGetProdSpuListData data = this.getCupGetProdSpuListData(page, pageSize, tenantCode);
            if (data == null || ListUtil.isEmpty((Collection)data.getSpuList())) break;
            for (String spuId : data.getSpuList()) {
                List<CupGetProdSkuListData> prodSkuList = this.getProdSkuList(spuId, tenantCode);
                if (prodSkuList == null || ListUtil.isEmpty(prodSkuList)) continue;
                for (CupGetProdSkuListData skuListData : prodSkuList) {
                    if (ListUtil.isEmpty((Collection)skuListData.getSkuList())) continue;
                    for (String skuId : skuListData.getSkuList()) {
                        if (!skuId.equals(bizId)) continue;
                        return spuId;
                    }
                }
            }
            total = data.getTotal();
        } while (page * pageSize < total);
        return null;
    }

    private RsSkuDomain getSkuBySkuNo(DisChannel disChannel, String bizId) {
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("skuNo", bizId);
        mapP.put("memberCode", disChannel.getMemberCcode());
        mapP.put("memberCcode", disChannel.getMemberCcode());
        mapP.put("channelCode", null);
        mapP.put("tenantCode", disChannel.getTenantCode());
        mapP.put("goodsType", "41");
        InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        String skuStr = (String)internalRouter.inInvoke(SKU_QUERY_API_CODE, mapP);
        if (StringUtils.isBlank((String)skuStr)) {
            return null;
        }
        return JsonUtil.json2Object(skuStr, RsSkuDomain.class);
    }

    private CupGetProdSpuListData getCupGetProdSpuListData(Integer page, Integer pageSize, String tenantCode) {
        CupGetProdSpuListRequest request = new CupGetProdSpuListRequest();
        request.setPage(page);
        request.setPageSize(pageSize);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyProductService", "getProdSpuList", JsonUtil.object2Json(request), tenantCode);
        CupGetProdSpuListData data = null;
        try {
            CupGetProdSpuListResponse response = client.doRequest(CupGetProdSpuListResponse.class);
            if (response.getCode() != 0) {
                return data;
            }
            data = response.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    private RsResourceGoodsDomain makeRsresourceGoods(SpuData spuData, String tenantCode, DisChannel disChannel) {
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsOrigin("2");
        rsResourceGoodsDomain.setMschannelCode(disChannel.getChannelCode());
        rsResourceGoodsDomain.setMschannelName(disChannel.getChannelName());
        rsResourceGoodsDomain.setPntreeCode(spuData.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(spuData.getPntreeName());
        rsResourceGoodsDomain.setMemberCode(disChannel.getMemberCcode());
        rsResourceGoodsDomain.setMemberName(disChannel.getMemberCname());
        rsResourceGoodsDomain.setMemberCcode(disChannel.getMemberCcode());
        rsResourceGoodsDomain.setMemberCname(disChannel.getMemberCname());
        rsResourceGoodsDomain.setMemberMname(disChannel.getMemberMname());
        rsResourceGoodsDomain.setMemberMcode(disChannel.getMemberMcode());
        rsResourceGoodsDomain.setChannelCode("");
        rsResourceGoodsDomain.setTenantCode(tenantCode);
        rsResourceGoodsDomain.setGoodsProperty5("0");
        rsResourceGoodsDomain.setPartsnameNumunit("\u4ef6");
        rsResourceGoodsDomain.setGoodsOneweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsMinnum(new BigDecimal("1"));
        rsResourceGoodsDomain.setDataOpbillstate(0);
        rsResourceGoodsDomain.setGoodsNum(spuData.getGoodsNum());
        rsResourceGoodsDomain.setGoodsSupplynum(spuData.getGoodsNum());
        rsResourceGoodsDomain.setGoodsType("41");
        rsResourceGoodsDomain.setGoodsPro("11");
        return rsResourceGoodsDomain;
    }

    public Boolean checkSkuState(CupGetProdSpuDetailProductModel productModel, CupGetProdSkuDetailModel skuDetailModel, BigDecimal distributionPrice, BigDecimal marketPrice, BigDecimal salesPrice, String tenantCode) {
        String minPrice = this.getMinPrice(tenantCode);
        if (this.checkVipVopState(productModel, skuDetailModel).booleanValue() && salesPrice.compareTo(marketPrice) <= 0 && distributionPrice.compareTo(new BigDecimal(minPrice)) >= 0) {
            return true;
        }
        return false;
    }

    public Boolean checkVipVopState(CupGetProdSpuDetailProductModel productModel, CupGetProdSkuDetailModel skuDetailModel) {
        if (productModel == null || skuDetailModel == null) {
            return false;
        }
        if (productModel.getOnline() == 2 && productModel.getIsDeleted() == 0 && "1".equals(skuDetailModel.getVipSkuState()) && skuDetailModel.getStatus() == 1) {
            return true;
        }
        return false;
    }

    private String getClasstreeName(String classtreeCode, String tenantCode) {
        RsClasstree classtree = this.getClasstree(classtreeCode, tenantCode);
        return classtree.getClasstreeName();
    }

    private RsClasstree getClasstree(String classtreeCode, String tenantCode) {
        String key = classtreeCode + "-" + tenantCode;
        RsClasstree classtree = classtreeMap.get(key);
        if (classtree == null) {
            RsClasstree classtreeByCode = EsGoodsServiceImpl.getClasstreeByCode(classtreeCode, tenantCode);
            classtreeMap.put(key, classtree);
            return classtreeByCode;
        }
        return classtree;
    }

    private static RsClasstree getClasstreeByCode(String classtreeCode, String tenantCode) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("tenantCode", tenantCode);
        map1.put("classtreeCode", classtreeCode);
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.object2Json(map1));
        RsClasstree rsClasstree = null;
        InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        String classtreeStr = (String)internalRouter.inInvoke(CLASSTREE_QUERY_API_CODE, mapP);
        rsClasstree = JsonUtil.json2Object(classtreeStr, RsClasstree.class);
        return rsClasstree;
    }

    private StringBuilder makeRemark(List<String> skuSystemDesImages) {
        StringBuilder stringBuilder = new StringBuilder();
        if (ListUtil.isEmpty(skuSystemDesImages)) {
            return stringBuilder;
        }
        for (String skuSystemDesImage : skuSystemDesImages) {
            if (skuSystemDesImage.contains("http")) {
                stringBuilder.append("<div>< img src=\"").append(skuSystemDesImage).append("\"></div>");
                continue;
            }
            stringBuilder.append("<div>< img src=\"https://a.vpimg3.com").append(skuSystemDesImage).append("\"></div>");
        }
        return stringBuilder;
    }

    public CupGetProdSkuDetailListData getProdSkuDetailList(String spuId, String tenantCode) {
        CupGetProdSkuDetailListRequest request = new CupGetProdSkuDetailListRequest();
        request.setSpuIdList(Arrays.asList(spuId));
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyProductService", "getProdSkuDetailList", JsonUtil.object2Json(request), tenantCode);
        CupGetProdSkuDetailListData data = null;
        try {
            CupGetProdSkuDetailListResponse response = client.doRequest(CupGetProdSkuDetailListResponse.class);
            if (response.getCode() != 0) {
                return data;
            }
            data = response.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public List<CupGetProdSkuListData> getProdSkuList(String spuId, String tenantCode) {
        CupGetProdSkuListRequest request = new CupGetProdSkuListRequest();
        request.setSpuIdList(Arrays.asList(spuId));
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyProductService", "getProdSkuList", JsonUtil.object2Json(request), tenantCode);
        List data = null;
        try {
            CupGetProdSkuListResponse response = client.doRequest(CupGetProdSkuListResponse.class);
            if (response.getCode() != 0) {
                return data;
            }
            data = response.getDataList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public CupGetProductSkuPriceData getProductSkuPrice(String prodSkuId, String tenantCode) {
        CupGetProductSkuPriceRequest request = new CupGetProductSkuPriceRequest();
        ArrayList<CupChannelPriceReqModel> value = new ArrayList<CupChannelPriceReqModel>();
        CupChannelPriceReqModel cupChannelPriceReqModel = new CupChannelPriceReqModel();
        cupChannelPriceReqModel.setProdSkuId(prodSkuId);
        value.add(cupChannelPriceReqModel);
        request.setPriceReqList(value);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyProductService", "getProductSkuPrice", JsonUtil.object2Json(request), tenantCode);
        CupGetProductSkuPriceData data = null;
        try {
            CupGetProductSkuPriceResponse response = client.doRequest(CupGetProductSkuPriceResponse.class);
            if (response.getCode() != 0) {
                return data;
            }
            data = response.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public CupGetProdSpuDetailListData getProdSpuDetail(String spuId, String tenantCode) {
        CupGetProdSpuDetailListRequest request = new CupGetProdSpuDetailListRequest();
        request.setSpuIdList(Arrays.asList(spuId.split(",")));
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyProductService", "getProdSpuDetailList", JsonUtil.object2Json(request), tenantCode);
        CupGetProdSpuDetailListData data = null;
        try {
            CupGetProdSpuDetailListResponse response = client.doRequest(CupGetProdSpuDetailListResponse.class);
            if (response.getCode() != 0) {
                return data;
            }
            data = response.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    private synchronized void makeSpec(RsResourceGoodsDomain rsResourceGoodsDomain, List<Attribute> attributeList) {
        if (null == rsResourceGoodsDomain || ListUtil.isEmpty(attributeList)) {
            return;
        }
        ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
        String tenantCode = rsResourceGoodsDomain.getTenantCode();
        String memberCode = rsResourceGoodsDomain.getMemberCode();
        String memberName = rsResourceGoodsDomain.getMemberName();
        HashMap<String, String> specGroupMap = new HashMap<String, String>();
        HashMap<String, String> specGroupMapStr = new HashMap<String, String>();
        specGroupMapStr.put("memberCode", memberCode);
        specGroupMapStr.put("tenantCode", tenantCode);
        specGroupMap.put("map", JsonUtil.object2Json(specGroupMapStr));
        QueryResult supQueryResult = this.sendReSupObject("rs.spec.querySpecGroupPage", specGroupMap, RsSpecGroup.class);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            HashMap<String, Object> mapStr = new HashMap<String, Object>();
            String specGroupCode = this.saveSpecOption(tenantCode, memberCode, memberName, mapStr);
            if (specGroupCode == null) {
                return;
            }
            specGroupMapStr.put("specGroupCode", specGroupCode);
            for (Attribute attribute : attributeList) {
                specGroupMapStr.remove("specCode");
                specGroupMapStr.remove("specOptionName");
                specGroupMapStr.put("specName", attribute.getAttributeName());
                specGroupMap.put("map", JsonUtil.object2Json(specGroupMapStr));
                QueryResult querySpecPage = this.sendReSupObject("rs.spec.querySpecPage", specGroupMap, RsSpec.class);
                String specCode = null;
                specCode = null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList()) ? this.saveSpec(tenantCode, memberCode, memberName, specGroupCode, attribute) : ((RsSpec)querySpecPage.getList().get(0)).getSpecCode();
                specGroupMapStr.remove("specName");
                specGroupMapStr.put("specCode", specCode);
                for (AttributeValue value : attribute.getValues()) {
                    specGroupMapStr.put("specOptionName", value.getOptionAliases());
                    specGroupMap.put("map", JsonUtil.object2Json(specGroupMapStr));
                    QueryResult optionSupQueryResult = this.sendReSupObject("rs.spec.querySpecOptionPage", specGroupMap, RsSpecOption.class);
                    if (null == optionSupQueryResult || ListUtil.isEmpty((Collection)optionSupQueryResult.getList())) {
                        String string = this.saveSpecOption(tenantCode, memberCode, memberName, specGroupCode, specCode, value.getOptionAliases());
                    }
                    RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
                    rsSpecValueDomain.setSpecCode(specCode);
                    rsSpecValueDomain.setTenantCode(tenantCode);
                    rsSpecValueDomain.setSpecValueType("1");
                    rsSpecValueDomain.setSpecValueFlag("1");
                    rsSpecValueDomain.setSpecGroupCode(specGroupCode);
                    rsSpecValueDomain.setSpecName(attribute.getAttributeName());
                    rsSpecValueDomain.setSpecValueValue(value.getOptionAliases());
                    rsSpecValueDomainList.add(rsSpecValueDomain);
                }
            }
        } else {
            RsSpecGroup rsSpecGroup = (RsSpecGroup)supQueryResult.getList().get(0);
            String specGroupCode = rsSpecGroup.getSpecGroupCode();
            HashMap<String, String> querySpecMap = new HashMap<String, String>();
            HashMap<String, String> querySpecMapStr = new HashMap<String, String>();
            querySpecMapStr.put("specGroupCode", specGroupCode);
            querySpecMapStr.put("memberCode", rsResourceGoodsDomain.getMemberCode());
            querySpecMapStr.put("tenantCode", tenantCode);
            for (Attribute attribute : attributeList) {
                String specCode = null;
                querySpecMapStr.remove("specCode");
                querySpecMapStr.remove("specOptionName");
                querySpecMapStr.put("specName", attribute.getAttributeName());
                querySpecMap.put("map", JsonUtil.object2Json(querySpecMapStr));
                QueryResult querySpecPage = this.sendReSupObject("rs.spec.querySpecPage", querySpecMap, RsSpec.class);
                specCode = null == querySpecPage || ListUtil.isEmpty((Collection)querySpecPage.getList()) ? this.saveSpec(tenantCode, memberCode, memberName, specGroupCode, attribute) : ((RsSpec)querySpecPage.getList().get(0)).getSpecCode();
                querySpecMapStr.remove("specName");
                querySpecMapStr.put("specCode", specCode);
                for (AttributeValue value : attribute.getValues()) {
                    querySpecMapStr.put("specOptionName", value.getOptionAliases());
                    querySpecMap.put("map", JsonUtil.object2Json(querySpecMapStr));
                    QueryResult optionSupQueryResult = this.sendReSupObject("rs.spec.querySpecOptionPage", querySpecMap, RsSpecOption.class);
                    if (null == optionSupQueryResult || ListUtil.isEmpty((Collection)optionSupQueryResult.getList())) {
                        String string = this.saveSpecOption(tenantCode, memberCode, memberName, specGroupCode, specCode, value.getOptionAliases());
                    }
                    RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
                    rsSpecValueDomain.setSpecCode(specCode);
                    rsSpecValueDomain.setTenantCode(tenantCode);
                    rsSpecValueDomain.setSpecValueType("1");
                    rsSpecValueDomain.setSpecValueFlag("1");
                    rsSpecValueDomain.setSpecGroupCode(specGroupCode);
                    rsSpecValueDomain.setSpecName(attribute.getAttributeName());
                    rsSpecValueDomain.setSpecValueValue(value.getOptionAliases());
                    rsSpecValueDomainList.add(rsSpecValueDomain);
                }
            }
        }
        rsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
    }

    private String saveSpecOption(String tenantCode, String memberCode, String memberName, String specGroupCode, String specCode, String optionName) {
        HashMap<String, String> mapStr2 = new HashMap<String, String>();
        RsSpecOptionDomain specOptionDomain = new RsSpecOptionDomain();
        specOptionDomain.setTenantCode(tenantCode);
        specOptionDomain.setSpecGroupCode(specGroupCode);
        specOptionDomain.setSpecCode(specCode);
        specOptionDomain.setSpecOptionName(optionName);
        specOptionDomain.setMemberCode(memberCode);
        specOptionDomain.setMemberName(memberName);
        mapStr2.put("rsSpecOptionDomain", JsonUtil.object2Json(specOptionDomain));
        String specOptionCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", mapStr2);
        if (StringUtils.isBlank((String)specOptionCode)) {
            this.logger.error(this.SYS_CODE + ".makeSpec.checkGoods.saveSpec", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.object2Json(specOptionDomain)));
            return null;
        }
        return specOptionCode;
    }

    private String saveSpec(String tenantCode, String memberCode, String memberName, String specGroupCode, Attribute attribute) {
        HashMap<String, String> mapStr1 = new HashMap<String, String>();
        RsSpecDomain rsSpecDomain = new RsSpecDomain();
        rsSpecDomain.setSpecName(attribute.getAttributeName());
        rsSpecDomain.setSpecGroupCode(specGroupCode);
        rsSpecDomain.setTenantCode(tenantCode);
        rsSpecDomain.setSpecDefault("0");
        rsSpecDomain.setMemberCode(memberCode);
        rsSpecDomain.setMemberName(memberName);
        mapStr1.put("rsSpecDomain", JsonUtil.object2Json(rsSpecDomain));
        String specCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpec", mapStr1);
        if (StringUtils.isBlank((String)specCode)) {
            this.logger.error(this.SYS_CODE + ".makeSpec.checkGoods.saveSpec", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.object2Json(rsSpecDomain)));
            return specCode;
        }
        return specCode;
    }

    private String saveSpecOption(String tenantCode, String memberCode, String memberName, Map<String, Object> mapStr) {
        RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
        rsSpecGroupDomain.setTenantCode(tenantCode);
        rsSpecGroupDomain.setMemberCode(memberCode);
        rsSpecGroupDomain.setMemberName(memberName);
        rsSpecGroupDomain.setSpecGroupName(memberName);
        rsSpecGroupDomain.setTenantCode(tenantCode);
        mapStr.put("rsSpecGroupDomain", JsonUtil.object2Json(rsSpecGroupDomain));
        String specGroupCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", mapStr);
        if (StringUtils.isBlank((String)specGroupCode)) {
            this.logger.error(this.SYS_CODE + ".makeSpec.checkGoods.saveSpecGroup", (Object)("\u89c4\u683c\u7ec4\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsSpecGroupDomain:" + JsonUtil.object2Json(rsSpecGroupDomain)));
            return null;
        }
        return specGroupCode;
    }

    private List<RsGoodsFileDomain> getGoodsFile(List<String> goodsFileList, String tenantCode) {
        if (ListUtil.isEmpty(goodsFileList)) {
            return null;
        }
        ArrayList<RsGoodsFileDomain> goodsFilesortDomainList = new ArrayList<RsGoodsFileDomain>();
        for (String goodsFileUrl : goodsFileList) {
            RsGoodsFileDomain rsGoodsFilesortDomain = new RsGoodsFileDomain();
            rsGoodsFilesortDomain.setGoodsFileUrl(goodsFileUrl);
            rsGoodsFilesortDomain.setTenantCode(tenantCode);
            goodsFilesortDomainList.add(rsGoodsFilesortDomain);
        }
        return goodsFilesortDomainList;
    }

    private static synchronized String checkBrandMap(String brandName, String tenantCode) {
        String brandCode;
        if (null == brandMap) {
            brandMap = EsGoodsServiceImpl.getBrandAll(tenantCode);
        }
        if (StringUtils.isBlank((String)(brandCode = (String)brandMap.get(brandName))) && null != brandName) {
            brandCode = EsGoodsServiceImpl.saveBrand(brandName, tenantCode);
            brandMap.put(brandName, brandCode);
        }
        return brandCode;
    }

    private static Map<String, Object> getBrandAll(String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.object2Json(map));
        InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        String brands = (String)internalRouter.inInvoke(BRAND_QUERY_API_CODE, mapP);
        List<RsBrand> brandList = null;
        try {
            SupQueryResult supQueryResult = JsonUtil.json2Object(brands, SupQueryResult.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getRows())) {
                return null;
            }
            brandList = JsonUtil.json2ObjectList(JsonUtil.object2Json(supQueryResult.getRows()), RsBrand.class);
        }
        catch (Exception supQueryResult) {
            // empty catch block
        }
        if (ListUtil.isEmpty(brandList)) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> mapRes = new HashMap<String, Object>();
        for (RsBrand rsBrand : brandList) {
            mapRes.put(rsBrand.getBrandName(), rsBrand.getBrandCode());
        }
        return mapRes;
    }

    private static String saveBrand(String brandName, String tenantCode) {
        if (StringUtils.isBlank((String)brandName) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("tenantCode", tenantCode);
        mapP.put("brandName", brandName);
        InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        String brandStr = (String)internalRouter.inInvoke(BRAND_GET_API_CODE, mapP);
        RsBrand rsBrand = JsonUtil.json2Object(brandStr, RsBrand.class);
        if (null != rsBrand && StringUtils.isNotBlank((String)rsBrand.getBrandCode())) {
            return rsBrand.getBrandCode();
        }
        RsBrandDomain rsBrandDomain = new RsBrandDomain();
        rsBrandDomain.setBrandName(brandName);
        rsBrandDomain.setTenantCode(tenantCode);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("rsBrandDomain", JsonUtil.object2Json(rsBrandDomain));
        return (String)internalRouter.inInvoke(BRAND_ADD_API_CODE, map1);
    }

    private static String checkClasstreeMap(String classtreeCode, List<Catagory> catagoryList, DisChannel disChannel, String pntreeCode, String tenantCode) {
        if (StringUtils.isBlank((String)classtreeCode) || ListUtil.isEmpty(catagoryList) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String key = classtreeCode + "-" + tenantCode;
        String classTreeName = DisUtil.getRemotMap((String)inThreeClasstreeCodeRedisKey, (String)key);
        if (StringUtils.isBlank((String)classTreeName)) {
            RsClasstree rsClasstree = EsGoodsServiceImpl.checkClasstree(classtreeCode, tenantCode);
            if (null != rsClasstree) {
                DisUtil.setMap((String)inThreeClasstreeCodeRedisKey, (String)key, (String)rsClasstree.getClasstreeName());
                return rsClasstree.getClasstreeName();
            }
            return EsGoodsServiceImpl.saveClasstree(catagoryList, disChannel, pntreeCode);
        }
        return classTreeName;
    }

    public static synchronized String saveClasstree(List<Catagory> catagoryList, DisChannel disChannel, String pntreeCode) {
        String classTreeName = "";
        HashMap<Integer, String> catagoryMap = new HashMap<Integer, String>();
        for (Catagory catagory : catagoryList) {
            catagoryMap.put(catagory.getCategoryLevel(), catagory.getCategoryId());
        }
        for (Catagory catagory : catagoryList) {
            String key = catagory.getCategoryId() + "-" + disChannel.getTenantCode();
            if (catagory.getCategoryLevel() == 0 ? StringUtils.isNotBlank((String)DisUtil.getRemotMap((String)inOneClasstreeCodeRedisKey, (String)key)) : (catagory.getCategoryLevel() == 1 ? StringUtils.isNotBlank((String)DisUtil.getRemotMap((String)inTwoClasstreeCodeRedisKey, (String)key)) : catagory.getCategoryLevel() == 2 && StringUtils.isNotBlank((String)DisUtil.getRemotMap((String)inThreeClasstreeCodeRedisKey, (String)key)))) continue;
            RsClasstreeDomain rsClasstreeDomain = new RsClasstreeDomain();
            rsClasstreeDomain.setClasstreeCode(String.valueOf(catagory.getCategoryId()));
            rsClasstreeDomain.setClasstreeName(catagory.getCategoryName());
            rsClasstreeDomain.setClasstreeParentcode("-1");
            if (catagory.getCategoryLevel() != 0) {
                rsClasstreeDomain.setClasstreeParentcode(String.valueOf(catagoryMap.get(catagory.getCategoryLevel() - 1)));
            }
            rsClasstreeDomain.setClasstreeLast("1");
            if (catagory.getCategoryLevel() == 2) {
                classTreeName = catagory.getCategoryName();
                rsClasstreeDomain.setClasstreeLast("0");
                rsClasstreeDomain.setPntreeCode(pntreeCode);
                if (StringUtils.isBlank((String)pntreeCode)) {
                    rsClasstreeDomain.setPntreeCode(EsGoodsServiceImpl.getPntreeCode(disChannel.getTenantCode()));
                }
            }
            rsClasstreeDomain.setClasstreeType("8");
            rsClasstreeDomain.setTenantCode(disChannel.getTenantCode());
            rsClasstreeDomain.setMemberCode(disChannel.getMemberCode());
            rsClasstreeDomain.setMemberName(disChannel.getMemberName());
            HashMap<String, String> mapR = new HashMap<String, String>();
            mapR.put("rsClasstreeDomain", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
            InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
            Object o = internalRouter.inInvoke(CLASSTREE_ADD_API_CODE, mapR);
            if (catagory.getCategoryLevel() == 0) {
                DisUtil.setMap((String)inOneClasstreeCodeRedisKey, (String)key, (String)rsClasstreeDomain.getClasstreeName());
                continue;
            }
            if (catagory.getCategoryLevel() == 1) {
                DisUtil.setMap((String)inTwoClasstreeCodeRedisKey, (String)key, (String)rsClasstreeDomain.getClasstreeName());
                continue;
            }
            if (catagory.getCategoryLevel() != 2) continue;
            DisUtil.setMap((String)inThreeClasstreeCodeRedisKey, (String)key, (String)rsClasstreeDomain.getClasstreeName());
        }
        return classTreeName;
    }

    private static RsClasstree checkClasstree(String classtreeCode, String tenantCode) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("tenantCode", tenantCode);
        map1.put("classtreeCode", classtreeCode);
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(map1));
        RsClasstree rsClasstree = null;
        InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        String classtreeStr = (String)internalRouter.inInvoke(CLASSTREE_QUERY_API_CODE, mapP);
        rsClasstree = (RsClasstree)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(classtreeStr, RsClasstree.class);
        return rsClasstree;
    }

    public static String getPntreeCode(String tenantCode) {
        HashMap<String, String> mapR = new HashMap<String, String>();
        mapR.put("pntreeName", PNTREE_NAME);
        mapR.put("tenantCode", tenantCode);
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.object2Json(mapR));
        InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        String pntreeStr = (String)internalRouter.inInvoke(PNTREE_QUERY_API_CODE, mapP);
        List<RsPntree> pntreeList = null;
        try {
            SupQueryResult supQueryResult = JsonUtil.json2Object(pntreeStr, SupQueryResult.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                return null;
            }
            pntreeList = JsonUtil.json2ObjectList(JsonUtil.object2Json(supQueryResult.getList()), RsPntree.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ListUtil.isEmpty(pntreeList)) {
            return null;
        }
        return ((RsPntree)pntreeList.get(0)).getPntreeCode();
    }

    private String getAppKey(String tenantCode) {
        return EsGoodsServiceImpl.getDdFalgSetting(tenantCode, "vipvop", "appKey", "");
    }

    private String getMinPrice(String tenantCode) {
        String minPrice = EsGoodsServiceImpl.getDdFalgSetting(tenantCode, "vipvop", "minPrice", "");
        if (StringUtils.isBlank((String)minPrice)) {
            minPrice = defaultMinPrice;
        }
        return minPrice;
    }
}

