/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.vipvop.service.service.impl;

import com.vip.cup.supply.vop.CupChannelPriceReqModel;
import com.vip.cup.supply.vop.CupGetProdSpuListData;
import com.vip.cup.supply.vop.CupGetProdSpuListRequest;
import com.vip.cup.supply.vop.CupGetProdSpuListResponse;
import com.vip.cup.supply.vop.CupGetProductSkuPriceRequest;
import com.vip.cup.supply.vop.CupGetProductSkuPriceResponse;
import com.vip.cup.supply.vop.CupSupplyShopGetSkuStockRequest;
import com.vip.cup.supply.vop.CupSupplyShopGetSkuStockResponse;
import com.vip.cup.supply.vop.PullMessageCookieRequest;
import com.vip.cup.supply.vop.PullMessageResponse;
import com.vip.cup.supply.vop.ReqContext;
import com.vip.cup.supply.vop.SimpleEventMessageInfo;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.ClientUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.Util.JsonUtil;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.DisChannel;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.DisOauthTokenDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.GoodsMessage;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.OauthBeanForVop;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.RsPntree;
import com.yqbsoft.laser.service.ext.data.vipvop.service.domain.SpuData;
import com.yqbsoft.laser.service.ext.data.vipvop.service.es.EsSendEnginePollThread;
import com.yqbsoft.laser.service.ext.data.vipvop.service.es.EsSendEnginePutThread;
import com.yqbsoft.laser.service.ext.data.vipvop.service.es.EsSendEngineService;
import com.yqbsoft.laser.service.ext.data.vipvop.service.es.GoodsMessagePollThread;
import com.yqbsoft.laser.service.ext.data.vipvop.service.es.GoodsMessagePutThread;
import com.yqbsoft.laser.service.ext.data.vipvop.service.es.GoodsMessageService;
import com.yqbsoft.laser.service.ext.data.vipvop.service.goods.EsGoodsService;
import com.yqbsoft.laser.service.ext.data.vipvop.service.service.DataVipVopApiService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import vipapis.oauth.RefreshTokenRequest;
import vipapis.oauth.RefreshTokenResponse;

class DataVipVopApiServiceImpl
extends BaseServiceImpl
implements DataVipVopApiService {
    private static final String SYS_CODE = "DataCyyApiServiceImpl";
    private static final String CACHECHANNEL = "DisChannel-channelCode";
    private static final String PNTREE_NAME = "\u552f\u54c1\u4f1a\u9ed8\u8ba4";
    private static final Object ESLOCK = new Object();
    private static EsSendEngineService esSendEngineService;
    private static final Object MESSAGELOCK;
    private static GoodsMessageService goodsMessageService;
    public static final String ACCESSTOKEN = "DisOauthToken-channelCode-accessToken";
    public static final String REFRESHTOKEN = "DisOauthToken-channelCode-refreshToken";

    DataVipVopApiServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsSendEngineService getEsSendEngineService() {
        if (null == esSendEngineService) {
            Object object = ESLOCK;
            synchronized (object) {
                if (null == esSendEngineService) {
                    esSendEngineService = new EsSendEngineService((EsGoodsService)SpringApplicationContextUtil.getBean((String)"esGoodsService"));
                    for (int i = 0; i < 30; ++i) {
                        esSendEngineService.addPollPool(new EsSendEnginePollThread(esSendEngineService));
                    }
                }
                return esSendEngineService;
            }
        }
        return esSendEngineService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoodsMessageService getGoodsMessageService() {
        if (null == goodsMessageService) {
            Object object = MESSAGELOCK;
            synchronized (object) {
                if (null == goodsMessageService) {
                    goodsMessageService = new GoodsMessageService((EsGoodsService)SpringApplicationContextUtil.getBean((String)"esGoodsService"));
                    for (int i = 0; i < 30; ++i) {
                        goodsMessageService.addPollPool(new GoodsMessagePollThread(goodsMessageService));
                    }
                }
                return goodsMessageService;
            }
        }
        return goodsMessageService;
    }

    @Override
    public String saveGoodsList(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("DataCyyApiServiceImpl.saveGoodsList.param is null", (Object)(channelCode + "-" + tenantCode));
            return this.makeResult(false, "\u53c2\u6570\u4e3a\u7a7a");
        }
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (null == disChannel) {
            this.logger.error("DataCyyApiServiceImpl.saveGoodsList.disChannel is null", (Object)(channelCode + "-" + tenantCode));
            return this.makeResult(false, "\u6e20\u9053\u4e3a\u7a7a");
        }
        Integer total = 0;
        Integer page = 0;
        Integer pageSize = 50;
        do {
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
            CupGetProdSpuListData data = this.getCupGetProdSpuListData(page, pageSize, tenantCode);
            if (data == null) {
                this.logger.error("DataCyyApiServiceImpl.saveGoodsList.data is null", (Object)(channelCode + "-" + tenantCode));
                return this.makeResult(false, "\u67e5\u8be2\u552f\u54c1\u4f1aSPU\u5217\u8868\u9519\u8bef");
            }
            if (ListUtil.isEmpty((Collection)data.getSpuList())) {
                this.logger.error("DataCyyApiServiceImpl.saveGoodsList.data getSpuList", (Object)(page + "-" + total));
                break;
            }
            total = data.getTotal();
            String pntreeCode = DataVipVopApiServiceImpl.getPntreeCode(tenantCode);
            if (StringUtils.isBlank((String)pntreeCode)) {
                this.logger.error("DataCyyApiServiceImpl.saveGoodsList.pntreeCode is null", (Object)tenantCode);
                return this.makeResult(false, "\u670d\u52a1\u5668\u9519\u8bef");
            }
            List<SpuData> spuDataList = this.getSpuData(tenantCode, disChannel, data, pntreeCode);
            DataVipVopApiServiceImpl.getEsSendEngineService().addPutPool(new EsSendEnginePutThread(DataVipVopApiServiceImpl.getEsSendEngineService(), spuDataList));
        } while (page * pageSize < total);
        return this.makeResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public String getAccessToken(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("DataCyyApiServiceImpl.getAccessToken param is null");
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (null == disChannel) {
            this.logger.error("DataCyyApiServiceImpl.getAccessToken.disChannel is null", (Object)(channelCode + "-" + tenantCode));
            return this.makeResult(false, "\u6e20\u9053\u4e3a\u7a7a");
        }
        String accessTokenKey = "DisOauthToken-channelCode-accessToken-" + disChannel.getChannelCode() + "-" + disChannel.getMemberCode() + "-" + disChannel.getTenantCode();
        String accessToken = SupDisUtil.getRemot((String)accessTokenKey);
        if (StringUtils.isNotBlank((String)accessToken)) {
            return accessToken;
        }
        String refreshTokenKey = "DisOauthToken-channelCode-refreshToken-" + disChannel.getChannelCode() + "-" + disChannel.getMemberCode() + "-" + disChannel.getTenantCode();
        String refreshToken = SupDisUtil.getRemot((String)refreshTokenKey);
        if (StringUtils.isBlank((String)refreshToken)) {
            this.logger.error("DataCyyApiServiceImpl.getAccessToken.refreshTokenKey", (Object)refreshTokenKey);
            return "\u6ca1\u6709\u5237\u65b0\u4ee4\u724c";
        }
        accessToken = this.refreshToken(tenantCode, disChannel, accessTokenKey, refreshTokenKey, refreshToken);
        return accessToken;
    }

    @Override
    public String getSkuStock(String skuIdListStr, String vipLastAareaId, String tenantCode) {
        if (StringUtils.isBlank((String)skuIdListStr) || StringUtils.isBlank((String)vipLastAareaId) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("DataCyyApiServiceImpl.getSkuStock.param is null", (Object)(skuIdListStr + "-" + vipLastAareaId + "-" + tenantCode));
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        CupSupplyShopGetSkuStockRequest request = new CupSupplyShopGetSkuStockRequest();
        request.setSkuIdList(Arrays.asList(skuIdListStr.split(",")));
        request.setVipLastAareaId(vipLastAareaId);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyShopStockService", "getSkuStock", JsonUtil.object2Json(request), tenantCode);
        CupSupplyShopGetSkuStockResponse response = client.doRequest(CupSupplyShopGetSkuStockResponse.class);
        if (response.getCode() != 0) {
            return response.getMsg();
        }
        return JsonUtil.object2Json(response.getData());
    }

    @Override
    public String getSkuPrice(String skuIdListStr, String tenantCode) {
        if (StringUtils.isBlank((String)skuIdListStr) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("DataCyyApiServiceImpl.getSkuPrice.param is null", (Object)(skuIdListStr + "-" + tenantCode));
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        CupGetProductSkuPriceRequest request = new CupGetProductSkuPriceRequest();
        ArrayList<CupChannelPriceReqModel> value = new ArrayList<CupChannelPriceReqModel>();
        for (String skuId : skuIdListStr.split(",")) {
            CupChannelPriceReqModel cupChannelPriceReqModel = new CupChannelPriceReqModel();
            cupChannelPriceReqModel.setProdSkuId(skuId);
            value.add(cupChannelPriceReqModel);
        }
        request.setPriceReqList(value);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyProductService", "getProductSkuPrice", JsonUtil.object2Json(request), tenantCode);
        CupGetProductSkuPriceResponse response = client.doRequest(CupGetProductSkuPriceResponse.class);
        return JsonUtil.object2Json(response.getData());
    }

    @Override
    public void pullEventCookieMessages(String channelCode, String tenantCode) {
        DisChannel disChannel = this.getDisChannel(tenantCode, channelCode);
        if (disChannel == null) {
            return;
        }
        PullMessageCookieRequest request = new PullMessageCookieRequest();
        ReqContext reqContext = new ReqContext();
        reqContext.setAppId(this.getAppKey(tenantCode));
        request.setReqContext(reqContext);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyMessagePullService", "pullEventCookieMessages", JsonUtil.object2Json(request), tenantCode);
        PullMessageResponse response = client.doRequest(PullMessageResponse.class);
        if (ListUtil.isNotEmpty((Collection)response.getMessageInfos())) {
            List messageInfoList = response.getMessageInfos();
            for (SimpleEventMessageInfo messageInfo : messageInfoList) {
                GoodsMessage goodsMessage = new GoodsMessage();
                goodsMessage.setEventType(messageInfo.getEventType());
                goodsMessage.setMessageInfo(messageInfo);
                goodsMessage.setDisChannel(disChannel);
                DataVipVopApiServiceImpl.getGoodsMessageService().addPutPool(new GoodsMessagePutThread(DataVipVopApiServiceImpl.getGoodsMessageService(), goodsMessage));
            }
        }
    }

    private String refreshToken(String tenantCode, DisChannel disChannel, String accessTokenKey, String refreshTokenKey, String refreshToken) {
        RefreshTokenRequest request = new RefreshTokenRequest();
        request.setClient_id(this.getAppKey(tenantCode));
        request.setClient_secret(this.getAppSecret(tenantCode));
        request.setRequest_client_ip(this.getRequest_client_ip(tenantCode));
        request.setRefresh_token(refreshToken);
        String requestStr = JsonUtil.object2Json(request);
        ClientUtil client = new ClientUtil("vipapis.oauth.OauthService", "refreshToken", requestStr, tenantCode);
        RefreshTokenResponse response = client.doRequest(RefreshTokenResponse.class);
        this.logger.error("DataCyyApiServiceImpl.getAccessToken.refreshTokenResponse", (Object)JsonUtil.object2Json(response));
        String accessToken = response.getAccess_token();
        refreshToken = response.getRefresh_token();
        long expires = response.getExpires_time().getTime() - System.currentTimeMillis() - 600L;
        SupDisUtil.set((String)accessTokenKey, (String)accessToken, (int)((int)expires));
        long refreshExpires = response.getRefresh_expires_time().getTime() - System.currentTimeMillis() - 600L;
        SupDisUtil.set((String)refreshTokenKey, (String)refreshToken, (int)((int)refreshExpires));
        OauthBeanForVop oauthBean = new OauthBeanForVop();
        oauthBean.setAccess_token(accessToken);
        oauthBean.setExpires_in((int)expires);
        oauthBean.setRefresh_token(refreshToken);
        this.saveDisToken(disChannel, oauthBean);
        return accessToken;
    }

    private void saveDisToken(DisChannel disChannel, OauthBeanForVop oauthBean) {
        if (null == disChannel || null == oauthBean) {
            this.logger.error("DataCyyApiServiceImpl.saveDisToken.json");
            return;
        }
        String api = "dis.oauth.saveOauthToken";
        String memberCode = disChannel.getMemberCode();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DisOauthTokenDomain disOauthTokenDomain = new DisOauthTokenDomain();
        disOauthTokenDomain.setChannelCode(disChannel.getChannelCode());
        disOauthTokenDomain.setChannelName(disChannel.getChannelName());
        disOauthTokenDomain.setMemberCode(memberCode);
        disOauthTokenDomain.setMemberName(memberCode);
        disOauthTokenDomain.setOauthTokenExpireIn(oauthBean.getExpires_in());
        disOauthTokenDomain.setOauthTokenRefreshToken(oauthBean.getRefresh_token());
        disOauthTokenDomain.setOauthTokenToken(oauthBean.getAccess_token());
        Long updateTime = new Date().getTime() + (long)disOauthTokenDomain.getOauthTokenExpireIn().intValue();
        disOauthTokenDomain.setOauthTokenUpdateTime(new Date(updateTime));
        disOauthTokenDomain.setTenantCode(disChannel.getTenantCode());
        paramMap.put("disOauthTokenDomain", JsonUtil.object2Json(disOauthTokenDomain));
        this.internalInvoke(api, paramMap);
    }

    private List<SpuData> getSpuData(String tenantCode, DisChannel disChannel, CupGetProdSpuListData data, String pntreeCode) {
        ArrayList<SpuData> spuDataList = new ArrayList<SpuData>();
        for (String spuId : data.getSpuList()) {
            SpuData spuData = new SpuData();
            spuData.setTenantCode(tenantCode);
            spuData.setGoodsShowno(spuId);
            spuData.setGoodsNo(spuId);
            spuData.setDisChannel(disChannel);
            spuData.setPntreeCode(pntreeCode);
            spuData.setGoodsNum(new BigDecimal("9999"));
            spuData.setPntreeName(PNTREE_NAME);
            spuDataList.add(spuData);
        }
        return spuDataList;
    }

    private CupGetProdSpuListData getCupGetProdSpuListData(Integer page, Integer pageSize, String tenantCode) {
        String testSpu = DataVipVopApiServiceImpl.getDdFalgSetting(tenantCode, "vipvop", "testSpu", "");
        if (StringUtils.isNotBlank((String)testSpu)) {
            return JsonUtil.json2Object("{\"spuList\":[\"" + testSpu + "\"],\"total\":1}", CupGetProdSpuListData.class);
        }
        CupGetProdSpuListRequest request = new CupGetProdSpuListRequest();
        request.setPage(page);
        request.setPageSize(pageSize);
        ClientUtil client = new ClientUtil("com.vip.cup.supply.vop.CupSupplyProductService", "getProdSpuList", JsonUtil.object2Json(request), tenantCode);
        CupGetProdSpuListData data = null;
        try {
            CupGetProdSpuListResponse response = client.doRequest(CupGetProdSpuListResponse.class);
            if (response.getCode() != 0) {
                return data;
            }
            data = response.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    private String makeResult(boolean flag, String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", flag);
        resultMap.put("msg", msg);
        return JsonUtil.object2Json(resultMap);
    }

    private String getAppKey(String tenantCode) {
        return DataVipVopApiServiceImpl.getDdFalgSetting(tenantCode, "vipvop", "appKey", "");
    }

    private String getAppSecret(String tenantCode) {
        return DataVipVopApiServiceImpl.getDdFalgSetting(tenantCode, "vipvop", "appSecret", "");
    }

    private String getRequest_client_ip(String tenantCode) {
        return DataVipVopApiServiceImpl.getDdFalgSetting(tenantCode, "vipvop", "request_client_ip", "");
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        return value;
    }

    protected OcContractReDomain getContractByCode(String contractBillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "oc.contract.getContractByCode";
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.object2Json(param));
        String contractStr = this.internalInvoke(apiCode, params);
        OcContractReDomain contractReDomain = JsonUtil.json2Object(contractStr, OcContractReDomain.class);
        return contractReDomain;
    }

    protected void sendContractNext(String contractBillcode, String tenantCode, Map<String, Object> map) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        String apiCode = "oc.contractEngine.sendContractNext";
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        param.put("map", JsonUtil.object2Json(map));
        this.logger.error("DataCyyApiServiceImpl.sendContractNext.param", (Object)JsonUtil.object2Json(param));
        this.internalInvoke(apiCode, param);
    }

    protected DisChannel getDisChannel(String tenantCode, String channelCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error("DataCyyApiServiceImpl.param");
            return null;
        }
        String json = DisUtil.getMap((String)CACHECHANNEL, (String)(channelCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("DataCyyApiServiceImpl.getDisChannel.json", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        DisChannel disChannel = JsonUtil.json2Object(json, DisChannel.class);
        if (null == disChannel) {
            this.logger.error("DataCyyApiServiceImpl.getDisChannel.disChannel", (Object)(channelCode + "-" + tenantCode));
            return null;
        }
        return disChannel;
    }

    public static String getPntreeCode(String tenantCode) {
        HashMap<String, String> mapR = new HashMap<String, String>();
        mapR.put("pntreeName", PNTREE_NAME);
        mapR.put("tenantCode", tenantCode);
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("map", JsonUtil.object2Json(mapR));
        InternalRouter internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        String pntreeStr = (String)internalRouter.inInvoke("rs.pntree.queryPntreePage", mapP);
        List<RsPntree> pntreeList = null;
        try {
            SupQueryResult supQueryResult = JsonUtil.json2Object(pntreeStr, SupQueryResult.class);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                return null;
            }
            pntreeList = JsonUtil.json2ObjectList(JsonUtil.object2Json(supQueryResult.getList()), RsPntree.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ListUtil.isEmpty(pntreeList)) {
            return null;
        }
        return ((RsPntree)pntreeList.get(0)).getPntreeCode();
    }

    static {
        MESSAGELOCK = new Object();
    }
}

