/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataEmployeeService;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.Base64;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.BusBaseService;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.HashKit;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.HttpUtils;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrgEmployee;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrgEmployeeDomain;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.UmUserReDomainBean;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.enums.ReturnEnums;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.Authentication;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.AuthenticationInfoRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.SaveAuthenticationRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.SearchOrderRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ContractResponseVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ErrorMessage;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.FlightOrderInfoEntity;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.HotelOrderInfoEntity;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ItineraryEntity;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.OrderRefundData;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.PayOrderResponseData;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.PayOrderStateResponse;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.RefundContractResponseVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.RefundRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ResponseStatus;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.SearchOrderResponse;
import com.yqbsoft.laser.service.ext.data.domain.AuthenticationInfoDomain;
import com.yqbsoft.laser.service.ext.data.domain.ContractVo;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcPackageDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.PayOrderRequestData;
import com.yqbsoft.laser.service.ext.data.request.PayNotifyRequestAuth;
import com.yqbsoft.laser.service.ext.data.request.PayNotifyRequestData;
import com.yqbsoft.laser.service.ext.data.request.PayNotifyRequestType;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;

@Service(value="dataInDataEmployeeServiceImpl")
public class DataInDataEmployeeServiceImpl
extends BusBaseService
implements DataEmployeeService {
    private static final String SYS_CODE = "DataInDataEmployeeServiceImpl";

    public String PayOrderState(Map<String, Object> resStream, String tenantCode) {
        this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.resStream", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        PayOrderStateResponse payOrderStateResponse = new PayOrderStateResponse("0");
        if (resStream == null) {
            payOrderStateResponse.setErrno("1");
            payOrderStateResponse.setErrmsg("\u63a8\u9001\u72b6\u6001\u6570\u636e\u4e3a\u7a7a");
            this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.payOrderStateResponse", (Object)JsonUtil.buildNormalBinder().toJson((Object)payOrderStateResponse));
            return JsonUtil.buildNonNullBinder().toJson((Object)payOrderStateResponse);
        }
        if (!this.checkPayOrderSign(resStream, tenantCode)) {
            payOrderStateResponse.setErrno("1");
            payOrderStateResponse.setErrmsg("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
            this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.payOrderStateResponse", (Object)JsonUtil.buildNormalBinder().toJson((Object)payOrderStateResponse));
            return JsonUtil.buildNonNullBinder().toJson((Object)payOrderStateResponse);
        }
        String appkey = this.getDdFlag(tenantCode, "appkey", "appkey");
        String appSecurity = this.getDdFlag(tenantCode, "appsecurity", "appsecurity");
        String queryOrderUrl = this.getDdFlag(tenantCode, "queryOrderUrl", "queryOrderUrl");
        String ticket = this.getticket(appkey, appSecurity, tenantCode, "rs");
        HashMap<String, String> headers = new HashMap<String, String>();
        String orderId = resStream.get("orderId").toString();
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode,fuzzy", new Object[]{orderId, tenantCode, false}));
        OcContractReDomain ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
        String userCode = ocContractReDomain.getUserCode();
        Integer olddataState = ocContractReDomain.getDataState();
        SearchOrderRequest searchOrderRequest = this.getSearchOrderRequest(resStream, appkey, ticket, orderId, userCode);
        this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.searchOrderRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)searchOrderRequest));
        String result = null;
        try {
            headers.put("Content-Type", "application/json;charset=utf-8");
            HttpResponse httpResponse = HttpUtils.doPost(queryOrderUrl, headers, JsonUtil.buildNonNullBinder().toJson((Object)searchOrderRequest));
            result = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.result", (Object)result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (StringUtils.isNotBlank((String)result)) {
            SearchOrderResponse searchOrderResponse = (SearchOrderResponse)JSON.parseObject((String)result, SearchOrderResponse.class);
            for (ItineraryEntity itineraryEntity : searchOrderResponse.getItineraryList()) {
                List<FlightOrderInfoEntity> flightOrderInfoList;
                List<HotelOrderInfoEntity> hotelOrderInfoList = itineraryEntity.getHotelOrderInfoList();
                if (ListUtil.isNotEmpty(hotelOrderInfoList)) {
                    for (HotelOrderInfoEntity hotelOrderInfoEntity : hotelOrderInfoList) {
                        switch (hotelOrderInfoEntity.getOrderDetailStatus()) {
                            case "Submitted": {
                                ocContractReDomain.setDataState(Integer.valueOf(1));
                                ocContractReDomain.setDataStatestr("\u5df2\u63d0\u4ea4");
                                break;
                            }
                            case "Wait": {
                                ocContractReDomain.setDataState(Integer.valueOf(2));
                                ocContractReDomain.setDataStatestr("\u5f85\u53d1\u8d27");
                                break;
                            }
                            case "Confirmed": {
                                ocContractReDomain.setDataState(Integer.valueOf(2));
                                ocContractReDomain.setDataStatestr("\u5df2\u786e\u8ba4");
                                break;
                            }
                            case "Paid": {
                                ocContractReDomain.setDataState(Integer.valueOf(2));
                                ocContractReDomain.setDataStatestr("\u5df2\u4ed8\u6b3e");
                                break;
                            }
                            case "Dealed": {
                                ocContractReDomain.setDataState(Integer.valueOf(5));
                                ocContractReDomain.setDataStatestr("\u4ea4\u6613\u5b8c\u6210");
                                break;
                            }
                            case "Cancelled": {
                                ocContractReDomain.setDataState(Integer.valueOf(-1));
                                ocContractReDomain.setDataStatestr("\u5df2\u53d6\u6d88");
                                break;
                            }
                            case "UnSubmit": {
                                ocContractReDomain.setDataState(Integer.valueOf(-1));
                                ocContractReDomain.setDataStatestr("\u5df2\u53d6\u6d88");
                                break;
                            }
                            default: {
                                ocContractReDomain.setDataStatestr("\u672a\u77e5\u8ba2\u5355\u72b6\u6001");
                            }
                        }
                        this.updateContractReById(ocContractReDomain);
                    }
                }
                if (!ListUtil.isNotEmpty(flightOrderInfoList = itineraryEntity.getFlightOrderInfoList())) continue;
                for (FlightOrderInfoEntity flightOrderInfoEntity : flightOrderInfoList) {
                    switch (flightOrderInfoEntity.getBasicInfo().getOrderStatusCode()) {
                        case "W": {
                            ocContractReDomain.setDataState(Integer.valueOf(1));
                            ocContractReDomain.setDataStatestr("\u672a\u5904\u7406");
                            break;
                        }
                        case "P": {
                            ocContractReDomain.setDataState(Integer.valueOf(2));
                            ocContractReDomain.setDataStatestr("\u5904\u7406\u4e2d");
                            break;
                        }
                        case "C": {
                            ocContractReDomain.setDataState(Integer.valueOf(-1));
                            ocContractReDomain.setDataStatestr("\u5df2\u53d6\u6d88");
                            break;
                        }
                        case "R": {
                            ocContractReDomain.setDataState(Integer.valueOf(-1));
                            ocContractReDomain.setDataStatestr("\u5df2\u53d6\u6d88");
                            break;
                        }
                        case "T": {
                            ocContractReDomain.setDataState(Integer.valueOf(2));
                            ocContractReDomain.setDataStatestr("\u5f85\u53d1\u8d27");
                            break;
                        }
                        case "S": {
                            ocContractReDomain.setDataState(Integer.valueOf(5));
                            ocContractReDomain.setDataStatestr("\u4ea4\u6613\u6210\u529f");
                            break;
                        }
                        default: {
                            ocContractReDomain.setDataStatestr("\u672a\u77e5\u8ba2\u5355\u72b6\u6001");
                        }
                    }
                    this.updateContractReById(ocContractReDomain);
                }
            }
        }
        return JsonUtil.buildNonNullBinder().toJson((Object)payOrderStateResponse);
    }

    private SearchOrderRequest getSearchOrderRequest(Map<String, Object> resStream, String appkey, String ticket, String orderId, String userCode) {
        SearchOrderRequest searchOrderRequest = new SearchOrderRequest();
        PayNotifyRequestAuth payNotifyRequestAuth = new PayNotifyRequestAuth(appkey, ticket);
        searchOrderRequest.setAuth(payNotifyRequestAuth);
        searchOrderRequest.setOrderID(orderId);
        searchOrderRequest.setEID(userCode);
        searchOrderRequest.setSearchType(resStream.get("productType").equals("FlightDomestic") ? "2" : "4");
        return searchOrderRequest;
    }

    private boolean checkPayOrderSign(Map<String, Object> resStream, String tenantCode) {
        String sign = resStream.get("sign").toString();
        String Secret = this.getDdFlag(tenantCode, "PayOrderSecret", "PayOrderSecret");
        String approveScenario = resStream.get("approveScenario") == null ? "" : resStream.get("approveScenario").toString();
        String orderStatus = resStream.get("orderStatus") == null ? "" : resStream.get("orderStatus").toString();
        String refundType = resStream.get("refundType") == null ? "" : resStream.get("refundType").toString();
        String orderId = resStream.get("orderId") == null ? "" : resStream.get("orderId").toString();
        String statusIDs = resStream.get("statusIDs") == null ? "" : resStream.get("statusIDs").toString();
        String productType = resStream.get("productType") == null ? "" : resStream.get("productType").toString();
        String corpId = resStream.get("corpId") == null ? "" : resStream.get("corpId").toString();
        String getSign = this.GetSign(corpId, productType, orderStatus, orderId, statusIDs, refundType, Secret, approveScenario);
        return sign.equals(getSign);
    }

    public String saveAuthentication(List<AuthenticationInfoDomain> authenticationInfoDomains, String tenantCode) {
        if (ListUtil.isEmpty(authenticationInfoDomains)) {
            return "\u540c\u6b65\u5458\u5de5\u4e3a\u7a7a";
        }
        this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.authenticationInfoDomains", (Object)JsonUtil.buildNormalBinder().toJson(authenticationInfoDomains));
        if (authenticationInfoDomains.size() > 500) {
            return "\u60a8\u540c\u6b65\u7684\u5458\u5de5\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7500\u4f4d\u5458\u5de5";
        }
        String msg = null;
        Integer Num = 1;
        Map<String, String> map = new HashMap<String, String>();
        ArrayList<AuthenticationInfoRequest> authenticationInfoRequests = new ArrayList<AuthenticationInfoRequest>();
        SaveAuthenticationRequest saveAuthenticationRequest = new SaveAuthenticationRequest();
        String appkey = this.getDdFlag(tenantCode, "appkey", "appkey");
        String appSecurity = this.getDdFlag(tenantCode, "appsecurity", "appsecurity");
        String authurl = this.getDdFlag(tenantCode, "authurl", "authurl");
        String corpid = this.getDdFlag(tenantCode, "corpid", "corpid");
        String subaccountname = this.getDdFlag(tenantCode, "subaccountname", "subaccountname");
        String ticket = this.makeTicketLock(appkey, appSecurity, tenantCode);
        try {
            this.checkParams(appkey, authurl, corpid, subaccountname);
        }
        catch (Exception e) {
            this.logger.error("DataInDataEmployeeServiceImpl.checkParams", (Object)e.getMessage());
            this.logger.error("DataInDataEmployeeServiceImpl.checkParams", (Object)("appkey:" + appkey + "-appSecurity:" + appSecurity + "-authurl:" + authurl + "-corpid:" + corpid + "-subaccountname:" + subaccountname + "-ticket:" + ticket));
            return "\u5b58\u5728\u53c2\u6570\u4e3a\u7a7a";
        }
        saveAuthenticationRequest.setAppkey(appkey);
        saveAuthenticationRequest.setTicket(ticket);
        saveAuthenticationRequest.setCorporationID(corpid);
        for (AuthenticationInfoDomain authenticationInfoDomain : authenticationInfoDomains) {
            Authentication authencation = new Authentication(subaccountname);
            try {
                BeanUtils.copyAllPropertys((Object)authencation, (Object)authenticationInfoDomain);
                AuthenticationInfoRequest authenticationInfoRequest = new AuthenticationInfoRequest(String.valueOf(Num), authencation);
                authenticationInfoRequests.add(authenticationInfoRequest);
                Integer n = Num;
                Integer n2 = Num = Integer.valueOf(Num + 1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        saveAuthenticationRequest.setAuthenticationInfoList(authenticationInfoRequests);
        this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.msg", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveAuthenticationRequest));
        msg = JsonUtil.buildNormalBinder().toJson((Object)saveAuthenticationRequest);
        this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.msg", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveAuthenticationRequest));
        try {
            map.put("Content-Type", "application/json;charset=utf-8");
            HttpResponse httpResponse = HttpUtils.doPost(authurl, map, msg);
            String result = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            map = (Map)JSON.parseObject((String)result, Map.class);
            this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ReturnEnums.Authsuccess.getErrCode().equals(map.get("Result"))) {
            for (AuthenticationInfoRequest authenticationInfoRequest : authenticationInfoRequests) {
                try {
                    QueryResult<OrgEmployee> queryResult = this.queryEmployeeOnePage(authenticationInfoRequest.getAuthentication().getEmployeeID(), tenantCode);
                    if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) continue;
                    OrgEmployee orgEmployee = (OrgEmployee)queryResult.getList().get(0);
                    if (queryResult != null) {
                        OrgEmployeeDomain orgEmployeeDomain = new OrgEmployeeDomain();
                        orgEmployeeDomain.setEmployeeState("1");
                        orgEmployeeDomain.setEmployeeMessage("\u540c\u6b65\u6210\u529f");
                        BeanUtils.copyAllPropertys((Object)orgEmployeeDomain, (Object)orgEmployee);
                        String userinfo = this.updateEmployee(orgEmployeeDomain);
                        this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.userinfo", (Object)userinfo);
                        continue;
                    }
                    this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.Result.queryResult" + JsonUtil.buildNormalBinder().toJson(queryResult));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (ReturnEnums.Autherror.getErrCode().equals(map.get("Failed"))) {
            String messageList = map.get("ErrorMessageList");
            List errorMessages = JSON.parseArray((String)messageList, ErrorMessage.class);
            for (ErrorMessage errorMessage : errorMessages) {
                try {
                    QueryResult<OrgEmployee> queryResult = this.queryEmployeeOnePage(errorMessage.getEmployeeID(), tenantCode);
                    if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) continue;
                    OrgEmployee orgEmployee = (OrgEmployee)queryResult.getList().get(0);
                    if (orgEmployee != null) {
                        OrgEmployeeDomain orgEmployeeDomain = new OrgEmployeeDomain();
                        orgEmployeeDomain.setEmployeeState("2");
                        orgEmployeeDomain.setEmployeeMessage(errorMessage.getMessage());
                        BeanUtils.copyAllPropertys((Object)orgEmployeeDomain, (Object)orgEmployee);
                        String userinfo = this.updateEmployee(orgEmployeeDomain);
                        this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.error.userinfo", (Object)userinfo);
                        continue;
                    }
                    this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.Failed.userByCode" + JsonUtil.buildNormalBinder().toJson(queryResult));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    private synchronized String makeTicketLock(String appkey, String appSecurity, String tenantCode) {
        String ticket = SupDisUtil.get((String)"ticket");
        if (StringUtils.isBlank((String)ticket)) {
            ticket = this.getticket(appkey, appSecurity, tenantCode, "rs");
            SupDisUtil.set((String)"ticket", (String)ticket, (int)120);
        }
        return ticket;
    }

    public String login(String userinfoCode, String tenantCode) {
        String appkey = this.getDdFlag(tenantCode, "appkey", "appkey");
        String appSecurity = this.getDdFlag(tenantCode, "appsecurity", "appsecurity");
        String AppId = this.getDdFlag(tenantCode, "AppId", "AppId");
        String InitPage = this.getDdFlag(tenantCode, "InitPage", "InitPage");
        String loginUrl = this.getDdFlag(tenantCode, "loginUrl", "loginUrl");
        String AccessUserId = this.getDdFlag(tenantCode, "AccessUserId", "AccessUserId");
        String CallbackH5 = this.getDdFlag(tenantCode, "CallbackH5", "CallbackH5");
        this.logger.error("appkey\uff1a" + appkey + "appSecurity:" + appSecurity + "AppId" + AppId + "InitPage" + InitPage + "loginUrl:" + loginUrl);
        HashMap<String, String> params = new HashMap<String, String>();
        String token = this.getticket(appkey, appSecurity, tenantCode, "sso");
        if (StringUtils.isNotBlank((String)token)) {
            params.put("AppKey", appkey);
            params.put("AppSecurity", appSecurity);
            params.put("Ticket", token);
            params.put("AppId", AppId);
            params.put("InitPage", InitPage);
            params.put("loginUrl", loginUrl);
            params.put("AccessUserId", AccessUserId);
            params.put("EmployeeID", userinfoCode);
            params.put("Callback", CallbackH5);
            return this.makeLoginParams(params);
        }
        return null;
    }

    public String makeLoginParams(Map<String, String> params) {
        String AccessUserId = params.get("AccessUserId");
        String EmployeeID = params.get("EmployeeID");
        String Ticket = params.get("Ticket");
        String AppId = params.get("AppId");
        String CorpPayType = "private";
        String InitPage = params.get("InitPage");
        String OnError = "ErrorCode";
        String appsecurity = params.get("AppSecurity");
        String Callback = params.get("Callback");
        this.logger.error("AccessUserId\uff1a" + AccessUserId + "EmployeeID:" + EmployeeID + "Ticket:" + Ticket + "CorpPayType:" + CorpPayType + "InitPage:" + InitPage + "OnError" + OnError + "appsecurity:" + appsecurity + "Callback:" + Callback);
        String Signature2 = DataInDataEmployeeServiceImpl.getMD5Hash(AccessUserId + EmployeeID + CorpPayType + DataInDataEmployeeServiceImpl.getMD5Hash(appsecurity));
        StringBuffer SsoData = new StringBuffer();
        SsoData.append("AccessUserId=" + AccessUserId + "&").append("EmployeeId=" + EmployeeID + "&").append("Token=" + Ticket + "&").append("AppId=" + AppId + "&").append("Signature=" + Signature2 + "&").append("CorpPayType=" + CorpPayType + "&").append("InitPage=" + InitPage + "&").append("OnError=" + OnError + "&").append("Callback=" + Callback);
        return params.get("loginUrl") + Base64.getEncoder().encodeToString(SsoData.toString().getBytes());
    }

    public String saveXcContract(Map<String, Object> resStream, String tenantCode) {
        QueryResult<OcContractReDomain> queryResult;
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcContract.parStr:" + JsonUtil.buildNormalBinder().toJson(resStream) + "-tenantCode:" + tenantCode);
        String requestId = resStream.get("requestId").toString();
        String sign = resStream.get("sign").toString();
        String dateTime = resStream.get("dateTime").toString();
        String corpId = resStream.get("corpId").toString();
        String payUrl = this.getDdFlag(tenantCode, "payUrl", "payUrl");
        String toJson = JsonUtil.buildNormalBinder().toJson(resStream.get("reqData"));
        PayOrderRequestData payOrderRequestData = (PayOrderRequestData)JsonUtil.buildNormalBinder().getJsonToObject(toJson, PayOrderRequestData.class);
        String payType = payOrderRequestData.getPayType();
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcContract.payOrderRequestData:" + JsonUtil.buildNormalBinder().toJson((Object)payOrderRequestData));
        payOrderRequestData.setRedirectUrl(payOrderRequestData.getRedirectUrl().replace("%26", "&"));
        String orderUserId = payOrderRequestData.getOrderUserId();
        String appSecret = this.getDdFlag(tenantCode, "appSecret", "appSecret");
        ContractResponseVo contractResponseVo = new ContractResponseVo();
        PayOrderResponseData payOrderResponseData = new PayOrderResponseData();
        ResponseStatus responseStatus = new ResponseStatus(false, "error", 1);
        contractResponseVo.setData(payOrderResponseData);
        contractResponseVo.setStatus(responseStatus);
        ContractVo contractVo = new ContractVo();
        contractVo.setRequestId(requestId);
        contractVo.setDateTime(dateTime);
        contractVo.setReqData(payOrderRequestData);
        contractVo.setCorpId(corpId);
        String signs = this.getSign(contractVo, appSecret);
        if (!sign.equals(signs)) {
            responseStatus.setMessage("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01");
            return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
        }
        UmUserReDomainBean userByCode = this.getUserByCode(orderUserId, tenantCode);
        if (userByCode == null) {
            responseStatus.setMessage("\u7528\u6237\u4e0d\u5b58\u5728!");
            return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
        }
        String userinfoCode = userByCode.getUserPcode();
        PayOrderRequestData order = contractVo.getReqData();
        if (!"REBOOK".equals(order.getPayType()) && (queryResult = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode,fuzzy", new Object[]{String.valueOf(order.getOrderId()), tenantCode, false}))) != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            OcContractReDomain ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
            payOrderResponseData.setPayUrl(payUrl + ocContractReDomain.getContractBillcode());
            responseStatus.setErrorCode(0);
            responseStatus.setSuccess(true);
            responseStatus.setMessage("success");
            return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
        }
        UmUserinfoReDomain userinfoByCode = null;
        OrgEmployee employee = null;
        if (StringUtils.isNotBlank((String)userinfoCode)) {
            userinfoByCode = this.getUserinfoByCode(userinfoCode, tenantCode);
            QueryResult<OrgEmployee> queryEmployeePage = this.queryEmployeePage(userinfoCode, tenantCode);
            if (null == queryEmployeePage || ListUtil.isEmpty((Collection)queryEmployeePage.getList())) {
                this.logger.error("DataInDataEmployeeServiceImpl.queryEmployeePage is null\uff0ctradeno\uff1a" + userinfoCode);
                return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
            }
            employee = (OrgEmployee)queryEmployeePage.getList().get(0);
        }
        if (null == userinfoByCode) {
            QueryResult<UmUserinfoReDomain> qlist = this.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{userinfoCode, tenantCode}));
            if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
                this.logger.error("DataInDataEmployeeServiceImpl.userinfoByCode is null\uff0ctradeno\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)contractVo));
                return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
            }
            userinfoByCode = (UmUserinfoReDomain)qlist.getList().get(0);
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        try {
            OcContractDomain ocContractDomain = new OcContractDomain();
            if (employee != null) {
                ocContractDomain.setCompanyCode(employee.getCompanyCode());
                ocContractDomain.setCompanyShortname(employee.getCompanyShortname());
                ocContractDomain.setChannelName(employee.getCompanyShortname());
            }
            ocContractDomain.setGoodsPmbillno(order.getPayNo());
            ocContractDomain.setContractRemark(order.getRedirectUrl());
            ocContractDomain.setTenantCode(tenantCode);
            ocContractDomain.setAppmanageIcode("031");
            ocContractDomain.setUserCode(orderUserId);
            ocContractDomain.setUserName(userinfoByCode.getUserinfoPhone());
            ocContractDomain.setMemberBcode(userinfoByCode.getUserinfoCode());
            ocContractDomain.setMemberBname(userinfoByCode.getUserinfoCompname());
            ocContractDomain.setMemberCode(memberCode);
            ocContractDomain.setMemberName("\u798f\u5229\u5e73\u53f0");
            ocContractDomain.setMemberCcode(memberCode);
            ocContractDomain.setMemberCname("\u798f\u5229\u5e73\u53f0");
            ocContractDomain.setContractType("48");
            ocContractDomain.setContractNbillcode(String.valueOf(order.getOrderId()));
            ocContractDomain.setContractInmoney(order.getPayAmount());
            ocContractDomain.setContractMoney(order.getPayAmount());
            ocContractDomain.setDataBmoney(order.getPayAmount());
            ocContractDomain.setDataStatestr("\u672a\u652f\u4ed8");
            ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
            OcPackageDomain ocPackageDomain = new OcPackageDomain();
            List<OcContractGoodsDomain> contractGoodsList = this.getOcContractGoodsDomains(tenantCode, contractVo, userinfoByCode);
            ocPackageDomain.setContractGoodsList(contractGoodsList);
            packageList.add(ocPackageDomain);
            ocContractDomain.setPackageList(packageList);
            String ocContractCode = this.saveOrder(ocContractDomain);
            if (StringUtils.isNotBlank((String)ocContractCode)) {
                payOrderResponseData.setPayUrl(payUrl + ocContractCode);
                responseStatus.setErrorCode(0);
                responseStatus.setSuccess(true);
                responseStatus.setMessage("success");
            }
        }
        catch (Exception e) {
            this.logger.error("DataInDataEmployeeServiceImpl.saveDangaoContract.Exception" + JsonUtil.buildNormalBinder().toJson((Object)e));
        }
        return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
    }

    public String saveXcRefund(Map<String, Object> resStream, String tenantCode) {
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.resStream:" + JsonUtil.buildNormalBinder().toJson(resStream) + "-tenantCode:" + tenantCode);
        ResponseStatus responseStatus = new ResponseStatus(true, "success", 0);
        RefundContractResponseVo refundContractResponseVo = new RefundContractResponseVo();
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.reqData:{}", (Object)JsonUtil.buildNormalBinder().toJson(resStream.get("reqData")));
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.reqData2:{}", (Object)resStream.get("reqData").toString());
        RefundRequest refundRequest = (RefundRequest)JSON.parseObject((String)JsonUtil.buildNormalBinder().toJson(resStream.get("reqData")), RefundRequest.class);
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.refundRequest:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)refundRequest));
        String appSecret = this.getDdFlag(tenantCode, "appSecret", "appSecret");
        String sign = resStream.get("sign").toString();
        String corpId = resStream.get("corpId").toString();
        String dateTime = resStream.get("dateTime").toString();
        String requestId = resStream.get("requestId").toString();
        refundContractResponseVo.setRequestId(requestId);
        refundContractResponseVo.setCorpId(corpId);
        refundContractResponseVo.setDateTime(dateTime);
        refundContractResponseVo.setReqData(refundRequest);
        for (OrderRefundData orderRefundData : refundRequest.getOrderRefundDataList()) {
            HashMap<String, Object> orderMap = new HashMap<String, Object>();
            orderMap.put("tenantCode", tenantCode);
            if (orderRefundData.getOrderType() == 1) {
                orderMap.put("goodsPmbillno", String.valueOf(orderRefundData.getRefPayNo()));
            } else {
                orderMap.put("contractNbillcode", String.valueOf(orderRefundData.getOrderId()));
            }
            orderMap.put("contractType", "48");
            orderMap.put("dataStateStr", "2,3,4,5");
            orderMap.put("childFlag", true);
            orderMap.put("fuzzy", false);
            this.logger.error("DataInDataEmployeeServiceImpl.saveRefund.param.map", (Object)JsonUtil.buildNormalBinder().toJson(orderMap));
            QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(orderMap);
            if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
                responseStatus.setSuccess(false);
                responseStatus.setMessage("\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
                responseStatus.setErrorCode(1);
                return JsonUtil.buildNonNullBinder().toJson((Object)responseStatus);
            }
            OcContractReDomain ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
            List goodsList = ocContractReDomain.getGoodsList();
            List<OcRefundDomain> refundDomainList = null;
            refundDomainList = orderRefundData.getOrderType() == 1 ? this.queryRefundOcodePage(orderRefundData.getRefPayNo(), tenantCode) : this.queryRefundPage(orderRefundData.getOrderId(), tenantCode);
            if (ListUtil.isNotEmpty(refundDomainList)) {
                this.logger.error("DataInDataEmployeeServiceImpl.saveRefund.queryRefundPage Repeated Refund map = " + JsonUtil.buildNormalBinder().toJson(orderMap));
                responseStatus.setSuccess(false);
                responseStatus.setErrorCode(1);
                responseStatus.setMessage("\u8be5\u8ba2\u5355\u5df2\u7533\u8bf7\u9000\u6b3e");
                return JsonUtil.buildNormalBinder().toJson((Object)responseStatus);
            }
            OcRefundDomain ocRefundDomain = new OcRefundDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)ocContractReDomain);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocRefundDomain.setRefundType("XCB01");
            ocRefundDomain.setRefundUsertype("0");
            ocRefundDomain.setRefundNcode(orderRefundData.getTransactionId());
            ocRefundDomain.setRefundOcode(orderRefundData.getRefPayNo());
            ocRefundDomain.setContractState(ocContractReDomain.getDataState());
            if (orderRefundData.getRefundAmount() == null) {
                ocRefundDomain.setRefundMoney(ocContractReDomain.getDataBmoney());
            }
            ocRefundDomain.setRefundMoney(new BigDecimal(orderRefundData.getRefundAmount()));
            ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ocRefundGoodsDomain.setRefundGoodsAmt(ocContractReDomain.getDataBmoney());
                ocRefundGoodsDomain.setRefundGoodsNum(ocContractGoodsDomain.getGoodsCamount());
                ocRefundGoodsDomain.setGoodsCamount(ocContractGoodsDomain.getGoodsNum());
                ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
            }
            ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
            String refundCode = this.sendSaveRefund(ocRefundDomain);
            this.logger.error("DataInDataEmployeeServiceImpl.saveRefund.refundCode" + refundCode);
        }
        return JsonUtil.buildNormalBinder().toJson((Object)responseStatus);
    }

    public String PayOrderStateCallback(OcContractDomain ocContractDomain) {
        this.logger.error("DataInDataEmployeeServiceImpl.PayOrderStateCallback:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        String tenantCode = ocContractDomain.getTenantCode();
        String appkey = this.getDdFlag(tenantCode, "appkey", "appkey");
        String appSecret = this.getDdFlag(tenantCode, "appSecret", "appSecret");
        String PayNotifyUrl = this.getDdFlag(tenantCode, "PayNotifyUrl", "PayNotifyUrl");
        String appSecurity = this.getDdFlag(tenantCode, "appsecurity", "appsecurity");
        String getticket = this.getticket(appkey, appSecurity, tenantCode, "rs");
        if (StringUtils.isBlank((String)getticket)) {
            this.logger.error("DataInDataEmployeeServiceImplgetticket.ticket", (Object)"getticket is null");
            return "fail";
        }
        PayNotifyRequestType payNotifyRequestType = this.makePayParam(ocContractDomain);
        String sign = this.getSign(payNotifyRequestType, appSecret);
        payNotifyRequestType.setSign(sign);
        payNotifyRequestType.setAuth(new PayNotifyRequestAuth(appkey, getticket));
        this.logger.error("DataInDataEmployeeServiceImplPayOrderStateCallback.payNotifyRequestType", (Object)JsonUtil.buildNormalBinder().toJson((Object)payNotifyRequestType));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=utf-8");
        try {
            HttpResponse httpResponse = HttpUtils.doPost(PayNotifyUrl, headers, JsonUtil.buildNormalBinder().toJson((Object)payNotifyRequestType));
            String result = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            this.logger.error("DataInDataEmployeeServiceImplPayOrderStateCallback.result", (Object)result);
            Map map = (Map)JSON.parseObject((String)result, Map.class);
            if (Boolean.valueOf(map.get("success").toString()).booleanValue()) {
                return "success";
            }
        }
        catch (Exception e) {
            return "fail";
        }
        return "fail";
    }

    private PayNotifyRequestType makePayParam(OcContractDomain ocContractDomain) {
        PayNotifyRequestType payNotifyRequestType = new PayNotifyRequestType();
        PayNotifyRequestData requestData = new PayNotifyRequestData();
        payNotifyRequestType.setRequestId(this.getUUID());
        payNotifyRequestType.setDateTime(String.valueOf(new Date().getTime()));
        requestData.setOrderId(Long.valueOf(ocContractDomain.getContractNbillcode()));
        requestData.setTransactionId(ocContractDomain.getGoodsPmbillno());
        requestData.setPayStatus(Integer.valueOf(3));
        payNotifyRequestType.setReqData(requestData);
        return payNotifyRequestType;
    }

    public synchronized String getUUID() {
        return UUID.randomUUID().toString();
    }

    public String PayCallback(PayNotifyRequestType payNotifyRequestType) {
        return "success";
    }

    private List<OcContractGoodsDomain> getOcContractGoodsDomains(String tenantCode, ContractVo contractVo, UmUserinfoReDomain userinfoByCode) {
        PayOrderRequestData payOrderRequestData = contractVo.getReqData();
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setGoodsType("48");
        ocContractGoodsDomain.setPricesetNprice(payOrderRequestData.getPayAmount());
        ocContractGoodsDomain.setPricesetAsprice(payOrderRequestData.getPayAmount());
        ocContractGoodsDomain.setContractGoodsGtype("2");
        ocContractGoodsDomain.setGoodsCode(payOrderRequestData.getPayNo());
        this.makeOrderState(ocContractGoodsDomain, payOrderRequestData);
        ocContractGoodsDomain.setSkuName(String.valueOf(payOrderRequestData.getOrderType()));
        ocContractGoodsDomain.setDataPic("");
        ocContractGoodsDomain.setDataPicpath("");
        ocContractGoodsDomain.setGoodsNum(new BigDecimal("0"));
        ocContractGoodsDomain.setTenantCode(tenantCode);
        ocContractGoodsDomain.setMemberCode(payOrderRequestData.getOrderUserId());
        ocContractGoodsDomain.setMemberName("\u798f\u5229\u5e73\u53f0");
        ocContractGoodsDomain.setMemberCcode(payOrderRequestData.getOrderUserId());
        ocContractGoodsDomain.setMemberCname("\u798f\u5229\u5e73\u53f0");
        ocContractGoodsDomain.setMemberBcode(userinfoByCode.getUserinfoCode());
        ocContractGoodsDomain.setMemberBname(userinfoByCode.getUserinfoCompname());
        contractGoodsList.add(ocContractGoodsDomain);
        return contractGoodsList;
    }

    private void makeOrderState(OcContractGoodsDomain ocContractGoodsDomain, PayOrderRequestData payOrderRequestData) {
        String payType;
        switch (payType = payOrderRequestData.getPayType()) {
            case "BOOK": {
                payOrderRequestData.setPayType("\u9884\u8ba2");
                break;
            }
            case "REBOOK": {
                payOrderRequestData.setPayType("\u6539\u7b7e");
                break;
            }
            default: {
                payOrderRequestData.setPayType("\u672a\u77e5\u652f\u4ed8\u573a\u666f\uff1a" + payOrderRequestData.getPayType());
            }
        }
        switch (payOrderRequestData.getOrderType()) {
            case 1: {
                ocContractGoodsDomain.setGoodsName("\u673a\u7968" + payOrderRequestData.getPayType());
                break;
            }
            case 2: {
                ocContractGoodsDomain.setGoodsName("\u9152\u5e97" + payOrderRequestData.getPayType());
                break;
            }
            case 3: {
                ocContractGoodsDomain.setGoodsName("\u6253\u8f66" + payOrderRequestData.getPayType());
                break;
            }
            case 4: {
                ocContractGoodsDomain.setGoodsName("\u63a5\u9001\u673a" + payOrderRequestData.getPayType());
                break;
            }
            case 5: {
                ocContractGoodsDomain.setGoodsName("\u5305\u8f66" + payOrderRequestData.getPayType());
                break;
            }
            case 6: {
                ocContractGoodsDomain.setGoodsName("\u79df\u8f66" + payOrderRequestData.getPayType());
                break;
            }
            case 7: {
                ocContractGoodsDomain.setGoodsName("\u6c7d\u8f66\u7968" + payOrderRequestData.getPayType());
                break;
            }
            case 8: {
                ocContractGoodsDomain.setGoodsName("\u706b\u8f66\u7968" + payOrderRequestData.getPayType());
                break;
            }
            case 9: {
                ocContractGoodsDomain.setGoodsName("\u6743\u76ca" + payOrderRequestData.getPayType());
                break;
            }
            default: {
                ocContractGoodsDomain.setGoodsName("\u672a\u77e5\u8ba2\u5355\u7c7b\u578b" + payOrderRequestData.getPayType());
            }
        }
    }

    protected String sendSaveRefund(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.refundEngine.sendSaveRefund";
        param.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        return this.internalInvoke(apiCode, param);
    }

    protected List<OcRefundDomain> queryRefundPage(String contractNbillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        String apiCode = "oc.refund.queryRefundPage";
        param.put("contractNbillcode", contractNbillcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataInDataEmployeeServiceImpl.queryRefundPage.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult refundQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List refundDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)refundQuery.getList()), OcRefundDomain.class);
        return refundDomainList;
    }

    protected List<OcRefundDomain> queryRefundOcodePage(String refundOcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        String apiCode = "oc.refund.queryRefundPage";
        param.put("refundOcode", refundOcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataInDataEmployeeServiceImpl.queryRefundPage.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult refundQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List refundDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)refundQuery.getList()), OcRefundDomain.class);
        return refundDomainList;
    }

    private String saveOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error("DataInDataEmployeeServiceImpl.saveOrder.ocContractDomain");
            return null;
        }
        String apiCode = "oc.shopping.sendContractByDel";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected QueryResult<UmUserinfoReDomain> queryUserinfoPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmUserinfoReDomain.class);
    }

    protected QueryResult<OcContractReDomain> queryOrderPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("DataInDataEmployeeServiceImpl.queryOrderPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractPageReDomain";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
    }

    protected String updateUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) {
        if (null == umUserinfoDomainBean) {
            this.logger.error("DataInDataEmployeeServiceImpl.queryOrderPage.updateUserinfo", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
            return null;
        }
        String apiCode = "um.user.sendUpdateUserinfo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected String updateEmployee(OrgEmployeeDomain orgEmployeeDomain) {
        if (null == orgEmployeeDomain) {
            this.logger.error("DataInDataEmployeeServiceImpl.queryOrderPage.updateEmployee", (Object)JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeDomain));
            return null;
        }
        String apiCode = "org.ChannelsendBase.sendUpdateEmployee";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orgEmployeeDomain", JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userinfoCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    protected UmUserReDomainBean getUserByCode(String userCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserByUserCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userCode", userCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserReDomainBean)this.getForObject(apiCode, UmUserReDomainBean.class, paramMap);
    }

    protected QueryResult<OrgEmployee> queryEmployeePage(String userinfoCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userinfoCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "org.employee.queryEmployeePage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return this.sendReSupObject(apiCode, param, OrgEmployee.class);
    }

    protected QueryResult<OrgEmployee> queryEmployeeOnePage(String userCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "org.employee.queryEmployeePage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userCode", userCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return this.sendReSupObject(apiCode, param, OrgEmployee.class);
    }

    protected String updateContractReById(OcContractReDomain ocContractReDomain) {
        String apiCode = "oc.contract.updateContractReById";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractReDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected String updateContractState(Integer contractSubId, Integer dataState, Integer oldDataState) {
        String apiCode = "oc.contract.updateContractState";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractSubId", String.valueOf(contractSubId));
        paramMap.put("dataState", String.valueOf(dataState));
        paramMap.put("oldDataState", String.valueOf(oldDataState));
        return this.internalInvoke(apiCode, paramMap);
    }

    private String getticket(String appKey, String appSecurity, String tenantCode, String type) {
        String ticketUrl = this.getDdFlag(tenantCode, "ticketUrl", "ticketUrl");
        String ticket = null;
        switch (type) {
            case "rs": {
                ticketUrl = this.getDdFlag(tenantCode, "rsticketUrl", "rsticketUrl");
                break;
            }
            case "sso": {
                ticketUrl = this.getDdFlag(tenantCode, "ticketUrl", "ticketUrl");
                break;
            }
            default: {
                ticketUrl = this.getDdFlag(tenantCode, "ticketUrl", "ticketUrl");
            }
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        Map params = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=utf-8");
        try {
            params.put("appKey", appKey);
            params.put("appSecurity", appSecurity);
            HttpResponse httpResponse = HttpUtils.doPost(ticketUrl, headers, JsonUtil.buildNonNullBinder().toJson(params));
            String result = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            params = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
            this.logger.error("DataInDataEmployeeServiceImpl.getticket.params" + JsonUtil.buildNormalBinder().toJson(params));
            switch (type) {
                case "rs": {
                    ticket = ((String)params.get("Ticket")).toString();
                    break;
                }
                case "sso": {
                    ticket = ((String)params.get("Token")).toString();
                    break;
                }
                case "order": {
                    ticket = ((String)params.get("Token")).toString();
                    break;
                }
                default: {
                    ticket = ((String)params.get("Token")).toString();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ticket;
    }

    public String GetSign(String corpId, String productType, String orderStatus, String orderId, String statusIDs, String refundType, String secret, String approveScenario) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("secret", secret);
        hashMap.put("corpId", corpId);
        hashMap.put("productType", productType);
        hashMap.put("orderId", orderId);
        hashMap.put("orderStatus", orderStatus);
        Set collection = hashMap.keySet();
        ArrayList list = new ArrayList(collection);
        Collections.sort(list);
        String str = "";
        for (int i = 0; i < list.size(); ++i) {
            str = str + (String)list.get(i) + "=" + (String)hashMap.get(list.get(i));
            if (i == list.size() - 1) continue;
            str = str + "&";
        }
        return DigestUtils.shaHex((String)str).toUpperCase();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(alphabetic=true)
    public String getSign(Object object, String appSecret) {
        ObjectMapper mapper = new ObjectMapper();
        Map maps = null;
        String sortedBody = null;
        try {
            String serialize = mapper.writeValueAsString(object);
            maps = (Map)mapper.readValue(serialize, (TypeReference)new TypeReference<TreeMap<String, Object>>(){});
            Iterator it = maps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (!key.equals("sign") && !key.equals("signType") && maps.get(key) != null && !maps.get(key).equals("")) continue;
                it.remove();
            }
            Map mapReqData = (Map)maps.get("reqData");
            TreeMap<String, BigDecimal> sortedMapReqData = new TreeMap<String, BigDecimal>(mapReqData);
            maps.put("reqData", sortedMapReqData);
            if (sortedMapReqData.get("payAmount") != null) {
                String payAmount = sortedMapReqData.get("payAmount").toString();
                BigDecimal bigDecimal = new BigDecimal(payAmount);
                sortedMapReqData.put("payAmount", bigDecimal.setScale(2, 4));
            }
            sortedBody = mapper.writeValueAsString((Object)maps);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.logger.error("DataInDataEmployeeServiceImpl.getSign:{}", (Object)(sortedBody + appSecret));
        return HashKit.sha512(sortedBody + appSecret);
    }

    public static String getSigns(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        Map maps = null;
        String sortedBody = null;
        try {
            String serialize = mapper.writeValueAsString(object);
            maps = (Map)mapper.readValue(serialize, (TypeReference)new TypeReference<TreeMap<String, Object>>(){});
            Iterator it = maps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (!key.equals("sign") && !key.equals("signType") && maps.get(key) != null && !maps.get(key).equals("")) continue;
                it.remove();
            }
            Map mapReqData = (Map)maps.get("reqData");
            TreeMap<String, BigDecimal> sortedMapReqData = new TreeMap<String, BigDecimal>(mapReqData);
            maps.put("reqData", sortedMapReqData);
            if (sortedMapReqData.get("payAmount") != null) {
                String payAmount = sortedMapReqData.get("payAmount").toString();
                BigDecimal bigDecimal = new BigDecimal(payAmount);
                sortedMapReqData.put("payAmount", bigDecimal.setScale(2, 4));
            }
            sortedBody = mapper.writeValueAsString((Object)maps);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println(sortedBody);
        return HashKit.sha512(sortedBody);
    }

    public static String getMD5Hash(String source) {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(source.getBytes());
            for (byte b : md5.digest()) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String res = "{\n    \"ItineraryList\": [\n        {\n            \"JourneyNO\": null,\n            \"FlightOrderInfoList\": null,\n            \"HotelOrderInfoList\": [\n                {\n                    \"cancelOffline\": false,\n                    \"OrderID\": \"32282406357\",\n                    \"TripID\": \"0\",\n                    \"UID\": \"2703201095\",\n                    \"PreEmployeeID\": \"2024051000000051\",\n                    \"PreEmployeeName\": \"\u6d4b\u8bd5\u5458\u5de5\",\n                    \"Currency\": \"CNY\",\n                    \"Amount\": 61.480000,\n                    \"AmountRMB\": 61.480000,\n                    \"CustomPayAmount\": 61.480000,\n                    \"SettlementAmount\": 61.480000,\n                    \"PostAmount\": 0.000000,\n                    \"PayType\": \"\u516c\u53f8\u8d26\u6237\",\n                    \"CustomPayCurrency\": \"CNY\",\n                    \"CustomPayExchange\": 1.000000000,\n                    \"SettlementCurrency\": \"CNY\",\n                    \"SettlementExchange\": 1.000000000,\n                    \"IsMixPayment\": \"F\",\n                    \"SettlementACCNTAmt\": 0.000000,\n                    \"SettlementPersonAmt\": 0.000000,\n                    \"AddedFees\": 0.000000,\n                    \"FrontendServiceFee\": 0,\n                    \"HotelType\": \"\u4f1a\u5458\u9152\u5e97\",\n                    \"HotelName\": \"\u8fea\u66fc\u82b1\u56ed\u9152\u5e97(\u91cd\u5e86\u6c5f\u5317\u56fd\u9645\u673a\u573a\u5e97)\",\n                    \"HotelEnName\": \"Diman Garden Hotel (Chongqing Jiangbei International Airport)\",\n                    \"StarLicence\": \"F\",\n                    \"Star\": 3,\n                    \"CustomerEval\": 2.5,\n                    \"Telephone\": \"+86-23-88791331\",\n                    \"Address\": \"\u53cc\u5317\u8857138\u53f7\",\n                    \"StartTime\": \"2024-06-29 23:59:00\",\n                    \"EndTime\": \"2024-06-30 00:00:00\",\n                    \"ProvinceEname\": \"Chongqing\",\n                    \"CityID\": 4,\n                    \"CityName\": \"\u91cd\u5e86\",\n                    \"CityEnName\": \"Chongqing\",\n                    \"RoomName\": \"\u7279\u60e0\u5927\u5e8a\u623f\",\n                    \"IsDomestic\": true,\n                    \"RoomType\": \"Default\",\n                    \"MealType\": 4,\n                    \"MasterHotelID\": 1477247,\n                    \"DistrictID\": 992,\n                    \"DistrictName\": \"\u6e1d\u5317\u533a\",\n                    \"OrderStatus\": \"\u5df2\u53d6\u6d88\",\n                    \"OrderDetailStatus\": \"Cancelled\",\n                    \"OrderDetailStatusName\": \"\u5df2\u53d6\u6d88\",\n                    \"OrderDate\": \"2024-05-16 17:19:06\",\n                    \"LastCancelTime\": \"2024-06-29 18:00:00\",\n                    \"CancelTime\": \"2024-05-16 17:34:31\",\n                    \"CancelReasonCode\": \"\u884c\u7a0b\u6539\u53d8\",\n                    \"CancelReasonDesc\": \"\",\n                    \"FundAccount\": 1367808,\n                    \"SubAccount\": 1452508,\n                    \"BalanceType\": \"Prepay to Ctrip\",\n                    \"Corp_payType\": \"\u516c\u8d39\",\n                    \"ContactEmail\": \"\",\n                    \"ContactName\": \"\u5546\u65c5\u5ba2\u6237\",\n                    \"ContactTel\": \"15320307250\",\n                    \"HotelConfirmNo\": \"999232282406992\",\n                    \"JourneyNo\": null,\n                    \"CostCenter\": null,\n                    \"CostCenter2\": null,\n                    \"CostCenter3\": null,\n                    \"CostCenter4\": \"\",\n                    \"CostCenter5\": \"\",\n                    \"CostCenter6\": \"\",\n                    \"JourneyReason\": \"\",\n                    \"Project\": \"\",\n                    \"Defineflag\": null,\n                    \"Defineflag2\": null,\n                    \"AuthorizeStatus\": \"\u65e0\u9700\u6388\u6743\",\n                    \"ConfirmPerson\": \"\",\n                    \"ConfirmPerson2\": \"\",\n                    \"ConfirmPersonCC\": null,\n                    \"ConfirmPersonCC2\": null,\n                    \"ConfirmType\": \"\",\n                    \"ConfirmType2\": \"\",\n                    \"ConfirmPersonEmloyeeID\": null,\n                    \"ConfirmPersonCCEmloyeeID\": null,\n                    \"ConfirmPerson2EmloyeeID\": null,\n                    \"ConfirmPersonCC2EmloyeeID\": null,\n                    \"GLat\": 29.726473356055756,\n                    \"GLon\": 106.63201893807124,\n                    \"GDLat\": 29.726473356055756,\n                    \"GDLon\": 106.63201893807124,\n                    \"Lat\": 29.73221,\n                    \"Lon\": 106.638572,\n                    \"LowPriceRC\": null,\n                    \"LowPriceRCInfo\": null,\n                    \"LowPriceRC_VV\": null,\n                    \"AgreementRC\": null,\n                    \"AgreementRCInfo\": null,\n                    \"AgreementRC_VV\": null,\n                    \"MinPriceRC\": null,\n                    \"MinPriceRC_VV\": null,\n                    \"RoomQuantity\": 1,\n                    \"RoomDays\": 1,\n                    \"IsHasSpecialInvoice\": \"F\",\n                    \"IsAutoAmadeus\": \"F\",\n                    \"IsHandAmadeus\": \"F\",\n                    \"ServerFrom\": \"App\",\n                    \"IsOfficialCard\": null,\n                    \"CouponAmount\": 0,\n                    \"TMCPriceType\": \"\",\n                    \"PlatformOrderID\": \"\",\n                    \"LadderDeductAmount\": 0,\n                    \"TPMaxPrice\": 0.000000,\n                    \"ClientName\": \"\u4ee3\u6e1d\",\n                    \"ClientInfo\": [\n                        {\n                            \"RoomIndex\": 0,\n                            \"ClientName\": \"\u4ee3\u6e1d\",\n                            \"EmployeeID\": \"\",\n                            \"CostCenter1\": \"\",\n                            \"CostCenter2\": \"\",\n                            \"CostCenter3\": \"\",\n                            \"CostCenter4\": \"\",\n                            \"CostCenter5\": \"\",\n                            \"CostCenter6\": \"\",\n                            \"Dept1\": null,\n                            \"Dept2\": null,\n                            \"Dept3\": null,\n                            \"Dept4\": null,\n                            \"Dept5\": null,\n                            \"Dept6\": null,\n                            \"Dept7\": null,\n                            \"Dept8\": null,\n                            \"Dept9\": null,\n                            \"Dept10\": null,\n                            \"CheckinTime\": \"\",\n                            \"CheckoutTime\": \"\",\n                            \"ActualDepartureTime\": \"\",\n                            \"ShareOrderAmount\": 0,\n                            \"ClientPreApprovalNo\": null,\n                            \"Price\": null,\n                            \"Star\": null,\n                            \"ActualUpperAmount\": 0.000000,\n                            \"ActualCheckInTime\": \"\",\n                            \"ShareRefundAmount\": 0,\n                            \"Quantity\": null,\n                            \"MobilePhone\": \"15320307260\",\n                            \"UserNamePinyin\": \"DaiYu\",\n                            \"ActualDepartureTimeUTC\": \"\",\n                            \"ActualCheckInTimeUTC\": \"\",\n                            \"NeedSendEmail\": \"F\",\n                            \"NeedSendMsg\": \"T\",\n                            \"ShareAccntAmount\": null,\n                            \"NonEmployee\": true,\n                            \"ShareRoomStandard\": null,\n                            \"ActualDateList\": null,\n                            \"Email\": null,\n                            \"CountryCode\": \"86\",\n                            \"CorpUserId\": \"\"\n                        }\n                    ],\n                    \"RoomInfo\": [\n                        {\n                            \"Room\": 1531946942,\n                            \"RoomName\": \"\u7279\u60e0\u5927\u5e8a\u623f\",\n                            \"RoomEnName\": \"Special Queen Room\",\n                            \"BasicRoomTypeName\": \"\u7279\u60e0\u5927\u5e8a\u623f\",\n                            \"BasicRoomTypeEnName\": \"Special Queen Room\",\n                            \"BedType\": \"1\u5f201.8\u7c73\u5927\u5e8a\",\n                            \"ETA\": \"2024-06-29 00:00:00\",\n                            \"ETD\": \"2024-06-30 00:00:00\",\n                            \"Price\": 61.480000,\n                            \"Currency\": \"CNY\",\n                            \"Exchange\": 1.0,\n                            \"Breakfast\": 0,\n                            \"AddBreakfast\": 0,\n                            \"AddBreakfastPrice\": 0,\n                            \"Meals\": 0,\n                            \"RemainQuantity\": 0,\n                            \"RefundQuantity\": 1,\n                            \"BedInfo\": {\n                                \"BedTypeDesc\": \"1\u5f201.8\u7c73\u5927\u5e8a\",\n                                \"BedDetailDesc\": \"1\u5f20\u5927\u5e8a1.8\u7c73\"\n                            },\n                            \"SettlementRemittedTaxAmount\": null,\n                            \"MealType\": 4,\n                            \"RoomID\": 1531946942\n                        }\n                    ],\n                    \"AuditInfo\": null,\n                    \"RefundInfo\": [\n                        {\n                            \"RefundInfoID\": 275854448176709940,\n                            \"RefundCustomerAmount\": 61.480000,\n                            \"Currency\": \"CNY\",\n                            \"ExchangeRate\": 1.000000000,\n                            \"RefundPaymentList\": [\n                                {\n                                    \"RefundID\": \"5ab2e6a2-45a8-4a6b-ad21-14f73cf2b4b6\",\n                                    \"RefundChannel\": \"CorpAccount\",\n                                    \"Amount\": 61.480000\n                                }\n                            ],\n                            \"RefundDetailList\": [\n                                {\n                                    \"RoomAmount\": 0\n                                }\n                            ],\n                            \"ModifyFormId\": null\n                        }\n                    ],\n                    \"PaymentInfo\": {\n                        \"PaymentItemList\": [\n                            {\n                                \"PrePayType\": \"ACCNT\",\n                                \"PaymentStatus\": \"T\",\n                                \"Currency\": \"CNY\",\n                                \"Exchange\": 1.000000,\n                                \"Amount\": 61.4800\n                            }\n                        ],\n                        \"OriginalTotalAmountExclude\": null\n                    },\n                    \"PaymentReceivedList\": [\n                        {\n                            \"BillNo\": \"3058048001782679\",\n                            \"RelatedBillNo\": null,\n                            \"Amount\": 61.480000,\n                            \"Currency\": \"CNY\",\n                            \"ExchangeRate\": 1.000000000,\n                            \"TransactionType\": \"D\",\n                            \"PaymentStatus\": \"SUCCESS\",\n                            \"PaymentTime\": \"2024-05-16 17:19:15\",\n                            \"PaymentType\": \"ACCNT\"\n                        },\n                        {\n                            \"BillNo\": \"3058048001783502\",\n                            \"RelatedBillNo\": \"3058048001782679\",\n                            \"Amount\": 61.480000,\n                            \"Currency\": \"CNY\",\n                            \"ExchangeRate\": 1.000000000,\n                            \"TransactionType\": \"R\",\n                            \"PaymentStatus\": \"SUCCESS\",\n                            \"PaymentTime\": \"2024-05-16 17:34:32\",\n                            \"PaymentType\": \"ACCNT\"\n                        }\n                    ],\n                    \"StepPaymentList\": [\n                        {\n                            \"PaymentPercent\": 0,\n                            \"Currency\": \"CNY\",\n                            \"Amount\": 58.0,\n                            \"StartDate\": null,\n                            \"EndDate\": null\n                        }\n                    ],\n                    \"IsOnline\": \"T\",\n                    \"CorporationId\": \"RCYX\",\n                    \"CountryName\": \"\u4e2d\u56fd\",\n                    \"ProvinceId\": 4,\n                    \"ProvinceName\": \"\u91cd\u5e86\",\n                    \"CountryCode\": \"CN\",\n                    \"GuaranteeAmountType\": 16,\n                    \"GuaranteeAmount\": 58.000000,\n                    \"GuaranteeAmountCurrency\": \"CNY\",\n                    \"PaidGuaranteeAmount\": 58.000000,\n                    \"PaidGuaranteeAmountCurrency\": \"CNY\",\n                    \"PolicyPreApprovalNo\": null,\n                    \"ContractRoomExistedFlag\": \"N\",\n                    \"ApplyFormDetailList\": null,\n                    \"DockingVendorPlatform\": null,\n                    \"DockingVendorPlatformAccount\": null,\n                    \"CorpDockingInfoList\": null,\n                    \"HotelTypeCode\": \"M\",\n                    \"BrandName\": \"\",\n                    \"UsedVccPay\": false,\n                    \"RefundAmountInfo\": {\n                        \"TotalChargeOfRoomAmount\": 0.000000,\n                        \"RefundTotalAmount\": 61.480000,\n                        \"SubcriptionFee\": 0\n                    },\n                    \"TravelControlMode\": \"C\",\n                    \"HtlStandardCtlRule\": \"A\",\n                    \"HtlStandardSharePercentage\": \"1\",\n                    \"HtlStandardFixPrice\": null,\n                    \"RepeatBookingOrderList\": null,\n                    \"RepeatBookingRC\": null,\n                    \"RepeatBookingDesc\": null,\n                    \"RepeatBookingRC_VV\": null,\n                    \"Scene\": null,\n                    \"MobilePhone\": \"15320307250\",\n                    \"UserNamePinyin\": \"\",\n                    \"AuditDataInfoList\": null,\n                    \"ConfigCurrency\": null,\n                    \"ConfigExchangeToSettlement\": null,\n                    \"TpConfigMinPrice\": 0.000000,\n                    \"TpConfigMaxPrice\": 0.000000,\n                    \"SettlementRemittedTaxTotalAmount\": null,\n                    \"ArrivalDayUTC\": \"2024-06-28T16:00:00Z\",\n                    \"DepartureDayUTC\": \"2024-06-29T16:00:00Z\",\n                    \"DistrictCode\": \"500000\",\n                    \"AfterServiceCharge\": 0,\n                    \"VatFlag\": \"F\",\n                    \"IsCancelOffline\": false,\n                    \"ParentCityID\": null,\n                    \"ParentCityName\": null,\n                    \"ParentCityEnName\": null,\n                    \"StandardControlType\": \"AVERAGE_PRICE\",\n                    \"TravelPolicyDailyInfoList\": [\n                        {\n                            \"EffectDate\": \"2024-06-29\",\n                            \"OrderInControl\": true,\n                            \"FloatPriceInfoList\": null\n                        }\n                    ],\n                    \"ArrivalDate\": \"2024-06-29\",\n                    \"DepartureDate\": \"2024-06-30\",\n                    \"CancelDeadlineBJ\": \"2024-06-29 18:00:00\",\n                    \"CancelDeadlineLocal\": \"2024-06-29 18:00:00\",\n                    \"CancelDeadlineUTC\": \"2024-06-29T10:00:00Z\",\n                    \"AfterServiceFee\": 0,\n                    \"HotelEmissionInfoList\": [\n                        {\n                            \"OrderID\": 32282406357,\n                            \"RebookIssueID\": null,\n                            \"PassengerName\": \"\u4ee3\u6e1d\",\n                            \"SectorID\": null,\n                            \"ItineraryID\": null,\n                            \"ProductNo\": \"1531946942\",\n                            \"ProductLevel\": \"0\",\n                            \"DepartureTime\": null,\n                            \"CarbonEmission\": 0,\n                            \"MedianCarbonEmission\": 0\n                        }\n                    ],\n                    \"CustomOrderAmount\": 61.480000,\n                    \"OriginalExchange\": 1.000000000,\n                    \"OriginalCurrency\": \"CNY\",\n                    \"ReferenceOrderID\": 0,\n                    \"ReferenceByOrderID\": 0,\n                    \"ReferenceType\": \"N\"\n                }\n            ],\n            \"TrainOrderInfoList\": null,\n            \"HotelSupplementOrderInfoList\": null,\n            \"TrainSupplementOrderInfoList\": null,\n            \"CarOrderInfoList\": null,\n            \"CarQuickOrderInfoList\": null,\n            \"DomPickUpOrderInfoList\": null,\n            \"DomCharterCarOrderInfoList\": null,\n            \"IntlTrainOrderInfoList\": null,\n            \"CustomizedCharterCarOrderInfoList\": null,\n            \"MealsOrderInfoList\": null,\n            \"MeetingOrderInfoList\": null,\n            \"IntlRentalCarOrderInfoList\": null\n        }\n    ],\n    \"Status\": {\n        \"Success\": true,\n        \"Message\": \"\u8c03\u7528\u6210\u529f\u3002\",\n        \"ErrorCode\": 0\n    }\n}";
        Map map = (Map)JSON.parseObject((String)res, Map.class);
        SearchOrderResponse searchOrderResponse = (SearchOrderResponse)JSON.parseObject((String)JSON.toJSONString((Object)map), SearchOrderResponse.class);
        for (ItineraryEntity itineraryEntity : searchOrderResponse.getItineraryList()) {
            for (HotelOrderInfoEntity hotelOrderInfoEntity : itineraryEntity.getHotelOrderInfoList()) {
                System.out.println(hotelOrderInfoEntity.getOrderDetailStatus() + hotelOrderInfoEntity.getOrderDetailStatusName());
            }
        }
    }
}

