/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataEmployeeService;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.Base64;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.BusBaseService;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.HashKit;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.Util.HttpUtils;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrgEmployee;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.OrgEmployeeDomain;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.ServiceFeeXc;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.UmUserReDomainBean;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.domain.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.enums.ReturnEnums;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.Authentication;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.AuthenticationInfoRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.SaveAuthenticationRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.request.SearchOrderRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ContractResponseVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ErrorMessage;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.FlightOrderInfoEntity;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.HotelOrderInfoEntity;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ItineraryEntity;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.OrderRefundData;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.PayOrderResponseData;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.PayOrderStateResponse;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.RefundContractResponseVo;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.RefundRequest;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.ResponseStatus;
import com.yqbsoft.laser.service.ext.data.chuanhangcrm.service.response.SearchOrderResponse;
import com.yqbsoft.laser.service.ext.data.domain.AuthenticationInfoDomain;
import com.yqbsoft.laser.service.ext.data.domain.ContractVo;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractproDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcPackageDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.PayOrderRequestData;
import com.yqbsoft.laser.service.ext.data.request.PayNotifyRequestAuth;
import com.yqbsoft.laser.service.ext.data.request.PayNotifyRequestData;
import com.yqbsoft.laser.service.ext.data.request.PayNotifyRequestType;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;

@Service(value="dataInDataEmployeeServiceImpl")
public class DataInDataEmployeeServiceImpl
extends BusBaseService
implements DataEmployeeService {
    private static final String SYS_CODE = "DataInDataEmployeeServiceImpl";

    public String PayOrderState(Map<String, Object> resStream, String tenantCode) {
        this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.resStream", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        PayOrderStateResponse payOrderStateResponse = new PayOrderStateResponse("0");
        if (resStream == null) {
            payOrderStateResponse.setErrno("1");
            payOrderStateResponse.setErrmsg("\u63a8\u9001\u72b6\u6001\u6570\u636e\u4e3a\u7a7a");
            this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.payOrderStateResponse", (Object)JsonUtil.buildNormalBinder().toJson((Object)payOrderStateResponse));
            return JsonUtil.buildNonNullBinder().toJson((Object)payOrderStateResponse);
        }
        if (!this.checkPayOrderSign(resStream, tenantCode)) {
            payOrderStateResponse.setErrno("1");
            payOrderStateResponse.setErrmsg("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
            this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.payOrderStateResponse", (Object)JsonUtil.buildNormalBinder().toJson((Object)payOrderStateResponse));
            return JsonUtil.buildNonNullBinder().toJson((Object)payOrderStateResponse);
        }
        String appkey = this.getDdFlag(tenantCode, "appkey", "appkey");
        String appSecurity = this.getDdFlag(tenantCode, "appsecurity", "appsecurity");
        String queryOrderUrl = this.getDdFlag(tenantCode, "queryOrderUrl", "queryOrderUrl");
        String ticket = this.getticket(appkey, appSecurity, tenantCode, "rs");
        HashMap<String, String> headers = new HashMap<String, String>();
        String orderId = resStream.get("orderId").toString();
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode,fuzzy", new Object[]{orderId, tenantCode, false}));
        OcContractReDomain ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
        String userCode = ocContractReDomain.getUserCode();
        SearchOrderRequest searchOrderRequest = this.getSearchOrderRequest(resStream, appkey, ticket, orderId, userCode);
        this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.searchOrderRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)searchOrderRequest));
        String result = null;
        try {
            headers.put("Content-Type", "application/json;charset=utf-8");
            HttpResponse httpResponse = HttpUtils.doPost(queryOrderUrl, headers, JsonUtil.buildNonNullBinder().toJson((Object)searchOrderRequest));
            result = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.result", (Object)result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (StringUtils.isNotBlank((String)result)) {
            SearchOrderResponse searchOrderResponse = (SearchOrderResponse)JSON.parseObject((String)result, SearchOrderResponse.class);
            for (ItineraryEntity itineraryEntity : searchOrderResponse.getItineraryList()) {
                List<FlightOrderInfoEntity> flightOrderInfoList;
                List<HotelOrderInfoEntity> hotelOrderInfoList = itineraryEntity.getHotelOrderInfoList();
                if (ListUtil.isNotEmpty(hotelOrderInfoList)) {
                    for (HotelOrderInfoEntity hotelOrderInfoEntity : hotelOrderInfoList) {
                        switch (hotelOrderInfoEntity.getOrderDetailStatus()) {
                            case "Submitted": {
                                ocContractReDomain.setDataState(Integer.valueOf(1));
                                ocContractReDomain.setDataStatestr("\u5df2\u63d0\u4ea4");
                                break;
                            }
                            case "Wait": {
                                ocContractReDomain.setDataState(Integer.valueOf(2));
                                ocContractReDomain.setDataStatestr("\u5f85\u53d1\u8d27");
                                break;
                            }
                            case "Confirmed": {
                                ocContractReDomain.setDataState(Integer.valueOf(2));
                                ocContractReDomain.setDataStatestr("\u5df2\u786e\u8ba4");
                                break;
                            }
                            case "Paid": {
                                ocContractReDomain.setDataState(Integer.valueOf(2));
                                ocContractReDomain.setDataStatestr("\u5df2\u4ed8\u6b3e");
                                break;
                            }
                            case "Dealed": {
                                ocContractReDomain.setDataState(Integer.valueOf(5));
                                ocContractReDomain.setDataStatestr("\u5df2\u6210\u4ea4");
                                break;
                            }
                            case "Cancelled": {
                                ocContractReDomain.setDataState(Integer.valueOf(-1));
                                ocContractReDomain.setDataStatestr("\u5df2\u53d6\u6d88");
                                break;
                            }
                            case "UnSubmit": {
                                ocContractReDomain.setDataState(Integer.valueOf(-1));
                                ocContractReDomain.setDataStatestr("\u5df2\u53d6\u6d88");
                                break;
                            }
                            default: {
                                ocContractReDomain.setDataStatestr("\u672a\u77e5\u8ba2\u5355\u72b6\u6001");
                            }
                        }
                        this.updateContractReById(ocContractReDomain);
                    }
                }
                if (!ListUtil.isNotEmpty(flightOrderInfoList = itineraryEntity.getFlightOrderInfoList())) continue;
                QueryResult<OcContractReDomain> orderList = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode,fuzzy", new Object[]{orderId, tenantCode, false}));
                this.logger.error("DataInDataEmployeeServiceImplPayOrderState.orderList", (Object)JSON.toJSONString(orderList));
                for (FlightOrderInfoEntity flightOrderInfoEntity : flightOrderInfoList) {
                    switch (flightOrderInfoEntity.getBasicInfo().getOrderStatusCode()) {
                        case "W": {
                            ocContractReDomain.setDataState(Integer.valueOf(1));
                            ocContractReDomain.setDataStatestr("\u672a\u5904\u7406");
                            break;
                        }
                        case "P": {
                            if (orderList == null || !ListUtil.isNotEmpty((Collection)orderList.getList())) break;
                            if (orderList.getList().size() > 1) {
                                ((OcContractReDomain)orderList.getList().get(orderList.getList().size() - 1)).setDataStatestr("\u5904\u7406\u4e2d");
                                break;
                            }
                            ocContractReDomain.setDataStatestr("\u5904\u7406\u4e2d");
                            break;
                        }
                        case "C": {
                            ocContractReDomain.setDataStatestr("\u5df2\u53d6\u6d88");
                            break;
                        }
                        case "R": {
                            if (orderList == null || !ListUtil.isNotEmpty((Collection)orderList.getList())) break;
                            for (OcContractReDomain contractReDomain : orderList.getList()) {
                                contractReDomain.setDataStatestr("\u5168\u90e8\u9000\u7968");
                                this.updateContractReById(contractReDomain);
                            }
                            break;
                        }
                        case "T": {
                            if (orderList == null || !ListUtil.isNotEmpty((Collection)orderList.getList())) break;
                            if (orderList.getList().size() > 1) {
                                for (OcContractReDomain contractReDomain : orderList.getList()) {
                                    contractReDomain.setDataState(Integer.valueOf(5));
                                    contractReDomain.setDataStatestr("\u90e8\u5206\u9000\u7968");
                                }
                                break;
                            }
                            ocContractReDomain.setDataState(Integer.valueOf(5));
                            ocContractReDomain.setDataStatestr("\u90e8\u5206\u9000\u7968");
                            break;
                        }
                        case "S": {
                            if (orderList == null || !ListUtil.isNotEmpty((Collection)orderList.getList())) break;
                            if (orderList.getList().size() > 1) {
                                ((OcContractReDomain)orderList.getList().get(orderList.getList().size() - 1)).setDataStatestr("\u5df2\u6210\u4ea4");
                                break;
                            }
                            ocContractReDomain.setDataStatestr("\u5df2\u6210\u4ea4");
                            break;
                        }
                        default: {
                            ocContractReDomain.setDataStatestr("\u672a\u77e5\u8ba2\u5355\u72b6\u6001");
                        }
                    }
                    if (orderList != null && ListUtil.isNotEmpty((Collection)orderList.getList()) && orderList.getList().size() > 1) {
                        for (OcContractReDomain contractReDomain : orderList.getList()) {
                            this.updateContractReById(contractReDomain);
                        }
                        continue;
                    }
                    this.updateContractReById(ocContractReDomain);
                }
            }
        }
        this.logger.error("DataInDataEmployeeServiceImpl.PayOrderState.payOrderStateResponse", (Object)JsonUtil.buildNormalBinder().toJson((Object)payOrderStateResponse));
        return JsonUtil.buildNonNullBinder().toJson((Object)payOrderStateResponse);
    }

    private SearchOrderRequest getSearchOrderRequest(Map<String, Object> resStream, String appkey, String ticket, String orderId, String userCode) {
        SearchOrderRequest searchOrderRequest = new SearchOrderRequest();
        PayNotifyRequestAuth payNotifyRequestAuth = new PayNotifyRequestAuth(appkey, ticket);
        searchOrderRequest.setAuth(payNotifyRequestAuth);
        searchOrderRequest.setOrderID(orderId);
        searchOrderRequest.setEID(userCode);
        searchOrderRequest.setSearchType(resStream.get("productType").equals("FlightDomestic") ? "2" : "4");
        return searchOrderRequest;
    }

    private boolean checkPayOrderSign(Map<String, Object> resStream, String tenantCode) {
        String sign = resStream.get("sign").toString();
        String Secret = this.getDdFlag(tenantCode, "PayOrderSecret", "PayOrderSecret");
        String approveScenario = resStream.get("approveScenario") == null ? "" : resStream.get("approveScenario").toString();
        String orderStatus = resStream.get("orderStatus") == null ? "" : resStream.get("orderStatus").toString();
        String refundType = resStream.get("refundType") == null ? "" : resStream.get("refundType").toString();
        String orderId = resStream.get("orderId") == null ? "" : resStream.get("orderId").toString();
        String statusIDs = resStream.get("statusIDs") == null ? "" : resStream.get("statusIDs").toString();
        String productType = resStream.get("productType") == null ? "" : resStream.get("productType").toString();
        String corpId = resStream.get("corpId") == null ? "" : resStream.get("corpId").toString();
        String getSign = this.GetSign(corpId, productType, orderStatus, orderId, statusIDs, refundType, Secret, approveScenario);
        return sign.equals(getSign);
    }

    public String saveAuthentication(List<AuthenticationInfoDomain> authenticationInfoDomains, String tenantCode) {
        if (ListUtil.isEmpty(authenticationInfoDomains)) {
            return "\u540c\u6b65\u5458\u5de5\u4e3a\u7a7a";
        }
        this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.authenticationInfoDomains", (Object)JsonUtil.buildNormalBinder().toJson(authenticationInfoDomains));
        if (authenticationInfoDomains.size() > 500) {
            return "\u60a8\u540c\u6b65\u7684\u5458\u5de5\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7500\u4f4d\u5458\u5de5";
        }
        String msg = null;
        Integer Num = 1;
        Map<String, String> map = new HashMap<String, String>();
        ArrayList<AuthenticationInfoRequest> authenticationInfoRequests = new ArrayList<AuthenticationInfoRequest>();
        SaveAuthenticationRequest saveAuthenticationRequest = new SaveAuthenticationRequest();
        String appkey = this.getDdFlag(tenantCode, "appkey", "appkey");
        String appSecurity = this.getDdFlag(tenantCode, "appsecurity", "appsecurity");
        String authurl = this.getDdFlag(tenantCode, "authurl", "authurl");
        String corpid = this.getDdFlag(tenantCode, "corpid", "corpid");
        String subaccountname = this.getDdFlag(tenantCode, "subaccountname", "subaccountname");
        String ticket = this.makeTicketLock(appkey, appSecurity, tenantCode);
        try {
            this.checkParams(appkey, authurl, corpid, subaccountname);
        }
        catch (Exception e) {
            this.logger.error("DataInDataEmployeeServiceImpl.checkParams", (Object)e.getMessage());
            this.logger.error("DataInDataEmployeeServiceImpl.checkParams", (Object)("appkey:" + appkey + "-appSecurity:" + appSecurity + "-authurl:" + authurl + "-corpid:" + corpid + "-subaccountname:" + subaccountname + "-ticket:" + ticket));
            return "\u5b58\u5728\u53c2\u6570\u4e3a\u7a7a";
        }
        saveAuthenticationRequest.setAppkey(appkey);
        saveAuthenticationRequest.setTicket(ticket);
        saveAuthenticationRequest.setCorporationID(corpid);
        for (AuthenticationInfoDomain authenticationInfoDomain : authenticationInfoDomains) {
            Authentication authencation = new Authentication(subaccountname);
            try {
                BeanUtils.copyAllPropertys((Object)authencation, (Object)authenticationInfoDomain);
                AuthenticationInfoRequest authenticationInfoRequest = new AuthenticationInfoRequest(String.valueOf(Num), authencation);
                authenticationInfoRequests.add(authenticationInfoRequest);
                Integer n = Num;
                Integer n2 = Num = Integer.valueOf(Num + 1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        saveAuthenticationRequest.setAuthenticationInfoList(authenticationInfoRequests);
        this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.msg", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveAuthenticationRequest));
        msg = JsonUtil.buildNormalBinder().toJson((Object)saveAuthenticationRequest);
        this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.msg", (Object)JsonUtil.buildNormalBinder().toJson((Object)saveAuthenticationRequest));
        try {
            map.put("Content-Type", "application/json;charset=utf-8");
            HttpResponse httpResponse = HttpUtils.doPost(authurl, map, msg);
            String result = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            map = (Map)JSON.parseObject((String)result, Map.class);
            this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ReturnEnums.Authsuccess.getErrCode().equals(map.get("Result"))) {
            for (AuthenticationInfoRequest authenticationInfoRequest : authenticationInfoRequests) {
                try {
                    QueryResult<OrgEmployee> queryResult = this.queryEmployeeOnePage(authenticationInfoRequest.getAuthentication().getEmployeeID(), tenantCode);
                    if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) continue;
                    OrgEmployee orgEmployee = (OrgEmployee)queryResult.getList().get(0);
                    if (queryResult != null) {
                        OrgEmployeeDomain orgEmployeeDomain = new OrgEmployeeDomain();
                        orgEmployeeDomain.setEmployeeState("1");
                        orgEmployeeDomain.setEmployeeMessage("\u540c\u6b65\u6210\u529f");
                        BeanUtils.copyAllPropertys((Object)orgEmployeeDomain, (Object)orgEmployee);
                        String userinfo = this.updateEmployee(orgEmployeeDomain);
                        this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.userinfo", (Object)userinfo);
                        continue;
                    }
                    this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.Result.queryResult" + JsonUtil.buildNormalBinder().toJson(queryResult));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (ReturnEnums.Autherror.getErrCode().equals(map.get("Failed"))) {
            String messageList = map.get("ErrorMessageList");
            List errorMessages = JSON.parseArray((String)messageList, ErrorMessage.class);
            for (ErrorMessage errorMessage : errorMessages) {
                try {
                    QueryResult<OrgEmployee> queryResult = this.queryEmployeeOnePage(errorMessage.getEmployeeID(), tenantCode);
                    if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) continue;
                    OrgEmployee orgEmployee = (OrgEmployee)queryResult.getList().get(0);
                    if (orgEmployee != null) {
                        OrgEmployeeDomain orgEmployeeDomain = new OrgEmployeeDomain();
                        orgEmployeeDomain.setEmployeeState("2");
                        orgEmployeeDomain.setEmployeeMessage(errorMessage.getMessage());
                        BeanUtils.copyAllPropertys((Object)orgEmployeeDomain, (Object)orgEmployee);
                        String userinfo = this.updateEmployee(orgEmployeeDomain);
                        this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.error.userinfo", (Object)userinfo);
                        continue;
                    }
                    this.logger.error("DataInDataEmployeeServiceImpl.saveAuthentication.Failed.userByCode" + JsonUtil.buildNormalBinder().toJson(queryResult));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    private synchronized String makeTicketLock(String appkey, String appSecurity, String tenantCode) {
        String ticket = SupDisUtil.get((String)"ticket");
        if (StringUtils.isBlank((String)ticket)) {
            ticket = this.getticket(appkey, appSecurity, tenantCode, "rs");
            SupDisUtil.set((String)"ticket", (String)ticket, (int)120);
        }
        return ticket;
    }

    public String login(String userinfoCode, String tenantCode) {
        String appkey = this.getDdFlag(tenantCode, "appkey", "appkey");
        String appSecurity = this.getDdFlag(tenantCode, "appsecurity", "appsecurity");
        String AppId = this.getDdFlag(tenantCode, "AppId", "AppId");
        String InitPage = this.getDdFlag(tenantCode, "InitPage", "InitPage");
        String loginUrl = this.getDdFlag(tenantCode, "loginUrl", "loginUrl");
        String AccessUserId = this.getDdFlag(tenantCode, "AccessUserId", "AccessUserId");
        String CallbackH5 = this.getDdFlag(tenantCode, "CallbackH5", "CallbackH5");
        this.logger.error("appkey\uff1a" + appkey + "appSecurity:" + appSecurity + "AppId" + AppId + "InitPage" + InitPage + "loginUrl:" + loginUrl);
        HashMap<String, String> params = new HashMap<String, String>();
        String token = this.getticket(appkey, appSecurity, tenantCode, "sso");
        if (StringUtils.isNotBlank((String)token)) {
            params.put("AppKey", appkey);
            params.put("AppSecurity", appSecurity);
            params.put("Ticket", token);
            params.put("AppId", AppId);
            params.put("InitPage", InitPage);
            params.put("loginUrl", loginUrl);
            params.put("AccessUserId", AccessUserId);
            params.put("EmployeeID", userinfoCode);
            params.put("Callback", CallbackH5);
            return this.makeLoginParams(params);
        }
        return null;
    }

    public String makeLoginParams(Map<String, String> params) {
        String AccessUserId = params.get("AccessUserId");
        String EmployeeID = params.get("EmployeeID");
        String Ticket = params.get("Ticket");
        String AppId = params.get("AppId");
        String CorpPayType = "private";
        String InitPage = params.get("InitPage");
        String OnError = "ErrorCode";
        String appsecurity = params.get("AppSecurity");
        String Callback = params.get("Callback");
        this.logger.error("AccessUserId\uff1a" + AccessUserId + "EmployeeID:" + EmployeeID + "Ticket:" + Ticket + "CorpPayType:" + CorpPayType + "InitPage:" + InitPage + "OnError" + OnError + "appsecurity:" + appsecurity + "Callback:" + Callback);
        String Signature2 = DataInDataEmployeeServiceImpl.getMD5Hash(AccessUserId + EmployeeID + CorpPayType + DataInDataEmployeeServiceImpl.getMD5Hash(appsecurity));
        StringBuffer SsoData = new StringBuffer();
        SsoData.append("AccessUserId=" + AccessUserId + "&").append("EmployeeId=" + EmployeeID + "&").append("Token=" + Ticket + "&").append("AppId=" + AppId + "&").append("Signature=" + Signature2 + "&").append("CorpPayType=" + CorpPayType + "&").append("InitPage=" + InitPage + "&").append("OnError=" + OnError + "&").append("Callback=" + Callback);
        return params.get("loginUrl") + Base64.getEncoder().encodeToString(SsoData.toString().getBytes());
    }

    public String saveXcContract(Map<String, Object> resStream, String tenantCode) {
        QueryResult<OcContractReDomain> queryResult;
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcContract.parStr:" + JsonUtil.buildNormalBinder().toJson(resStream) + "-tenantCode:" + tenantCode);
        String requestId = resStream.get("requestId").toString();
        String sign = resStream.get("sign").toString();
        String dateTime = resStream.get("dateTime").toString();
        String corpId = resStream.get("corpId").toString();
        String payUrl = this.getDdFlag(tenantCode, "payUrl", "payUrl");
        String toJson = JsonUtil.buildNormalBinder().toJson(resStream.get("reqData"));
        PayOrderRequestData payOrderRequestData = (PayOrderRequestData)JsonUtil.buildNormalBinder().getJsonToObject(toJson, PayOrderRequestData.class);
        String payType = payOrderRequestData.getPayType();
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcContract.payOrderRequestData:" + JsonUtil.buildNormalBinder().toJson((Object)payOrderRequestData));
        payOrderRequestData.setRedirectUrl(payOrderRequestData.getRedirectUrl().replace("%26", "&"));
        String orderUserId = payOrderRequestData.getOrderUserId();
        String appSecret = this.getDdFlag(tenantCode, "appSecret", "appSecret");
        ContractResponseVo contractResponseVo = new ContractResponseVo();
        PayOrderResponseData payOrderResponseData = new PayOrderResponseData();
        ResponseStatus responseStatus = new ResponseStatus(false, "error", 1);
        contractResponseVo.setData(payOrderResponseData);
        contractResponseVo.setStatus(responseStatus);
        ContractVo contractVo = new ContractVo();
        contractVo.setRequestId(requestId);
        contractVo.setDateTime(dateTime);
        contractVo.setReqData(payOrderRequestData);
        contractVo.setCorpId(corpId);
        String signs = this.getSign(contractVo, appSecret);
        if (!sign.equals(signs)) {
            responseStatus.setMessage("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01");
            return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
        }
        UmUserReDomainBean userByCode = this.getUserByCode(orderUserId, tenantCode);
        if (userByCode == null) {
            responseStatus.setMessage("\u7528\u6237\u4e0d\u5b58\u5728!");
            return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
        }
        String userinfoCode = userByCode.getUserPcode();
        PayOrderRequestData order = contractVo.getReqData();
        BigDecimal orderPayAmount = order.getPayAmount();
        if (!"REBOOK".equals(order.getPayType()) && (queryResult = this.queryOrderPage(this.getQueryMapParam("goodsPmbillno,tenantCode,fuzzy", new Object[]{order.getPayNo(), tenantCode, false}))) != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            OcContractReDomain ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
            payOrderResponseData.setPayUrl(payUrl + ocContractReDomain.getContractBillcode());
            responseStatus.setErrorCode(0);
            responseStatus.setSuccess(true);
            responseStatus.setMessage("success");
            return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
        }
        if ("REBOOK".equals(order.getPayType()) && (queryResult = this.queryOrderPage(this.getQueryMapParam("goodsPmbillno,tenantCode,fuzzy", new Object[]{order.getPayNo(), tenantCode, false}))) != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            OcContractReDomain ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
            payOrderResponseData.setPayUrl(payUrl + ocContractReDomain.getContractBillcode());
            responseStatus.setErrorCode(0);
            responseStatus.setSuccess(true);
            responseStatus.setMessage("success");
            return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
        }
        UmUserinfoReDomain userinfoByCode = null;
        OrgEmployee employee = null;
        if (StringUtils.isNotBlank((String)userinfoCode)) {
            userinfoByCode = this.getUserinfoByCode(userinfoCode, tenantCode);
            QueryResult<OrgEmployee> queryEmployeePage = this.queryEmployeePage(userinfoCode, tenantCode);
            if (null == queryEmployeePage || ListUtil.isEmpty((Collection)queryEmployeePage.getList())) {
                this.logger.error("DataInDataEmployeeServiceImpl.queryEmployeePage is null\uff0ctradeno\uff1a" + userinfoCode);
                return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
            }
            employee = (OrgEmployee)queryEmployeePage.getList().get(0);
        }
        if (null == userinfoByCode) {
            QueryResult<UmUserinfoReDomain> qlist = this.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{userinfoCode, tenantCode}));
            if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
                this.logger.error("DataInDataEmployeeServiceImpl.userinfoByCode is null" + JsonUtil.buildNormalBinder().toJson((Object)contractVo));
                return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
            }
            userinfoByCode = (UmUserinfoReDomain)qlist.getList().get(0);
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        try {
            OcContractDomain ocContractDomain = new OcContractDomain();
            if (employee != null) {
                ocContractDomain.setCompanyCode(employee.getCompanyCode());
                ocContractDomain.setCompanyShortname(employee.getCompanyShortname());
                ocContractDomain.setChannelName(employee.getCompanyShortname());
            }
            orderPayAmount = this.getOrderPayAmount(tenantCode, orderPayAmount, ocContractDomain);
            this.logger.error("DataInDataEmployeeServiceImpl.orderPayAmount\uff1a" + JSON.toJSONString((Object)ocContractDomain));
            ocContractDomain.setGoodsPmbillno(order.getPayNo());
            ocContractDomain.setContractRemark(order.getRedirectUrl());
            ocContractDomain.setAreaName(String.valueOf(payOrderRequestData.getOrderType()));
            ocContractDomain.setContractObillcode(payOrderRequestData.getPayType());
            ocContractDomain.setTenantCode(tenantCode);
            ocContractDomain.setUserCode(orderUserId);
            ocContractDomain.setUserName(userinfoByCode.getUserinfoPhone());
            ocContractDomain.setMemberBcode(userinfoByCode.getUserinfoCode());
            ocContractDomain.setMemberBname(userinfoByCode.getUserinfoCompname());
            ocContractDomain.setEmployeeName(employee.getEmployeeName());
            ocContractDomain.setEmployeeCode(employee.getEmployeeCode());
            ocContractDomain.setMemberBname(userinfoByCode.getUserinfoCompname());
            ocContractDomain.setMemberCode(memberCode);
            ocContractDomain.setMemberName("\u798f\u5229\u5e73\u53f0");
            ocContractDomain.setMemberCcode(memberCode);
            ocContractDomain.setMemberCname("\u798f\u5229\u5e73\u53f0");
            ocContractDomain.setContractType("48");
            ocContractDomain.setContractNbillcode(String.valueOf(order.getOrderId()));
            if (ocContractDomain.getCashback() != null) {
                ocContractDomain.setContractInmoney(orderPayAmount.subtract(ocContractDomain.getCashback()));
            } else {
                ocContractDomain.setContractInmoney(orderPayAmount);
            }
            ocContractDomain.setContractMoney(orderPayAmount);
            ocContractDomain.setDataBmoney(orderPayAmount);
            ocContractDomain.setDataStatestr("\u672a\u652f\u4ed8");
            ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
            OcPackageDomain ocPackageDomain = new OcPackageDomain();
            List<OcContractGoodsDomain> contractGoodsList = this.getOcContractGoodsDomains(tenantCode, contractVo, userinfoByCode, orderPayAmount);
            ocPackageDomain.setContractGoodsList(contractGoodsList);
            packageList.add(ocPackageDomain);
            ocContractDomain.setPackageList(packageList);
            String ocContractCode = this.saveOrder(ocContractDomain);
            if (StringUtils.isNotBlank((String)ocContractCode)) {
                payOrderResponseData.setPayUrl(payUrl + ocContractCode);
                responseStatus.setErrorCode(0);
                responseStatus.setSuccess(true);
                responseStatus.setMessage("success");
            }
        }
        catch (Exception e) {
            this.logger.error("DataInDataEmployeeServiceImpl.saveDangaoContract.Exception" + JsonUtil.buildNormalBinder().toJson((Object)e));
        }
        return JsonUtil.buildNonNullBinder().toJson((Object)contractResponseVo);
    }

    private BigDecimal getOrderPayAmount(String tenantCode, BigDecimal orderPayAmount, OcContractDomain ocContractDomain) {
        String serviceFee = this.getDdFlag(tenantCode, "serviceFee", "xiecheng");
        if (StringUtils.isNotBlank((String)serviceFee)) {
            ServiceFeeXc fee = (ServiceFeeXc)JSON.parseObject((String)serviceFee, ServiceFeeXc.class);
            this.logger.error("DataInDataEmployeeServiceImplsaveXcContract.serviceFeeXc", (Object)JSON.toJSONString((Object)fee));
            if (fee != null && "1".equals(fee.getD())) {
                ArrayList<OcContractproDomain> ocContractproDomainList = new ArrayList<OcContractproDomain>();
                OcContractproDomain ocContractproDomain = new OcContractproDomain();
                ocContractproDomain.setContractproRefrice1(orderPayAmount);
                if ("1".equals(fee.getC())) {
                    orderPayAmount = orderPayAmount.add(fee.getN()).setScale(2, 4);
                    ocContractproDomain.setContractproRefrice(fee.getN());
                }
                if ("0".equals(fee.getC())) {
                    BigDecimal divide = fee.getN().divide(new BigDecimal(100), 2, 4);
                    BigDecimal feenum = orderPayAmount.multiply(divide).setScale(2, 4);
                    orderPayAmount = orderPayAmount.add(feenum);
                    ocContractproDomain.setContractproRefrice(feenum);
                }
                ocContractproDomain.setTenantCode(tenantCode);
                ocContractproDomain.setContractproKey("serviceFee");
                ocContractproDomain.setContractproName("\u670d\u52a1\u8d39");
                ocContractproDomain.setContractproValue(fee.getX());
                ocContractproDomain.setContractproType(fee.getC());
                ocContractproDomain.setContractproNum(fee.getN());
                ocContractproDomainList.add(ocContractproDomain);
                ocContractDomain.setOcContractproDomainList(ocContractproDomainList);
                ocContractDomain.setCashback(ocContractproDomain.getContractproRefrice());
                ocContractDomain.setContractDelcode(fee.getC());
            }
        }
        this.logger.error("DataInDataEmployeeServiceImplsaveXcContract.getOrderPayAmount.orderPayAmount", (Object)orderPayAmount);
        return orderPayAmount;
    }

    public String saveXcRefund(Map<String, Object> resStream, String tenantCode) {
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.resStream:" + JsonUtil.buildNormalBinder().toJson(resStream) + "-tenantCode:" + tenantCode);
        ResponseStatus responseStatus = new ResponseStatus(true, "success", 0);
        RefundContractResponseVo refundContractResponseVo = new RefundContractResponseVo();
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.reqData:{}", (Object)JsonUtil.buildNormalBinder().toJson(resStream.get("reqData")));
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.reqData2:{}", (Object)resStream.get("reqData").toString());
        RefundRequest refundRequest = (RefundRequest)JSON.parseObject((String)JsonUtil.buildNormalBinder().toJson(resStream.get("reqData")), RefundRequest.class);
        this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.refundRequest:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)refundRequest));
        String appSecret = this.getDdFlag(tenantCode, "appSecret", "appSecret");
        String sign = resStream.get("sign").toString();
        String corpId = resStream.get("corpId").toString();
        String dateTime = resStream.get("dateTime").toString();
        String requestId = resStream.get("requestId").toString();
        refundContractResponseVo.setRequestId(requestId);
        refundContractResponseVo.setCorpId(corpId);
        refundContractResponseVo.setDateTime(dateTime);
        refundContractResponseVo.setReqData(refundRequest);
        String requestSign = this.getSign(refundContractResponseVo, appSecret);
        for (OrderRefundData orderRefundData : refundRequest.getOrderRefundDataList()) {
            BigDecimal refundAmount = orderRefundData.getRefundAmount();
            BigDecimal orderMoney = null;
            BigDecimal orderJPMoney = new BigDecimal("0");
            BigDecimal orderBmoneyMoney = null;
            BigDecimal cashbackMoney = new BigDecimal("0");
            BigDecimal cashbackJPMoney = new BigDecimal("0");
            QueryResult<OcContractReDomain> reDomainQueryResult = null;
            HashMap<String, Object> orderMap = new HashMap<String, Object>();
            orderMap.put("tenantCode", tenantCode);
            orderMap.put("goodsPmbillno", String.valueOf(orderRefundData.getRefPayNo()));
            orderMap.put("contractType", "48");
            orderMap.put("colName0", "DATA_STATE");
            orderMap.put("colValue0", "2,3,4,5");
            orderMap.put("childFlag", true);
            orderMap.put("fuzzy", false);
            this.logger.error("DataInDataEmployeeServiceImpl.saveRefund.param.map", (Object)JsonUtil.buildNormalBinder().toJson(orderMap));
            QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(orderMap);
            if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
                responseStatus.setSuccess(false);
                responseStatus.setMessage("\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
                responseStatus.setErrorCode(1);
                return JsonUtil.buildNonNullBinder().toJson((Object)responseStatus);
            }
            OcContractReDomain ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
            orderMoney = ocContractReDomain.getContractInmoney();
            orderBmoneyMoney = ocContractReDomain.getDataBmoney();
            List<OcRefundDomain> refundDomainList = this.queryRefundOcodePage(orderRefundData.getRefPayNo(), tenantCode);
            if (orderRefundData.getOrderType() == 1) {
                Map queryMapParam = this.getQueryMapParam("contractNbillcode,tenantCode,fuzzy", new Object[]{String.valueOf(orderRefundData.getOrderId()), tenantCode, false});
                queryMapParam.put("tenantCode", tenantCode);
                queryMapParam.put("contractType", "48");
                queryMapParam.put("colName0", "DATA_STATE");
                queryMapParam.put("colValue0", "2,3,4,5");
                queryMapParam.put("childFlag", true);
                reDomainQueryResult = this.queryOrderPage(queryMapParam);
                this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.reDomainQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(reDomainQueryResult));
                if (reDomainQueryResult != null && ListUtil.isNotEmpty((Collection)reDomainQueryResult.getList())) {
                    for (OcContractReDomain contractReDomain : reDomainQueryResult.getList()) {
                        orderJPMoney = orderJPMoney.add(contractReDomain.getContractInmoney());
                        cashbackJPMoney = cashbackJPMoney.add(contractReDomain.getCashback());
                    }
                    if ("BOOK".equals(ocContractReDomain.getContractObillcode())) {
                        QueryResult<OcContractReDomain> orderPage = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode,fuzzy", new Object[]{String.valueOf(orderRefundData.getOrderId()), tenantCode, false}));
                        if (orderPage != null && ListUtil.isNotEmpty((Collection)orderPage.getList())) {
                            for (OcContractReDomain contractReDomain : orderPage.getList()) {
                                BigDecimal orderYDMoney = new BigDecimal("20");
                                if (contractReDomain.getGoodsMoney() != null) continue;
                                contractReDomain.setGoodsMoney(new BigDecimal("0"));
                                contractReDomain.setGoodsMoney(contractReDomain.getGoodsMoney().add(orderYDMoney));
                            }
                        }
                        this.updateContractReById(ocContractReDomain);
                        refundAmount = refundAmount.add(new BigDecimal("20"));
                    }
                    this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund\uff1a\u591a\u8ba2\u5355\u9000\u6b3e\u670d\u52a1\u8d39\u603b\u91d1\u989d\uff1a", (Object)orderMoney);
                    this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.cashbackMoney", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain.getCashback()));
                    this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.refundAmount", (Object)refundAmount);
                    this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.orderJPMoney", (Object)orderJPMoney);
                    if (refundAmount.compareTo(orderMoney) == 0) {
                        refundAmount = refundAmount.add(ocContractReDomain.getCashback());
                        cashbackMoney = cashbackMoney.add(ocContractReDomain.getCashback());
                    } else {
                        BigDecimal divide = refundAmount.divide(orderMoney, 2, 4).multiply(ocContractReDomain.getCashback()).setScale(2, 4);
                        refundAmount = refundAmount.add(divide);
                        cashbackMoney = cashbackMoney.add(divide);
                        refundAmount = refundAmount.subtract(new BigDecimal("20"));
                        this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.refundAmount.end", (Object)refundAmount);
                        this.logger.error("DataInDataEmployeeServiceImpl.saveXcRefund.cashbackMoney.end", (Object)cashbackMoney);
                        orderJPMoney = orderJPMoney.add(cashbackJPMoney);
                    }
                }
            }
            if (orderRefundData.getOrderType() == 2) {
                if (refundAmount.compareTo(orderMoney) == 0) {
                    refundAmount = ocContractReDomain.getDataBmoney();
                    cashbackMoney = cashbackMoney.add(ocContractReDomain.getCashback());
                } else {
                    BigDecimal divide = refundAmount.divide(orderMoney, 2, 4).multiply(ocContractReDomain.getCashback()).setScale(2, 4);
                    cashbackMoney = cashbackMoney.add(divide);
                    refundAmount = refundAmount.add(divide);
                    BigDecimal refundSumMoney = new BigDecimal("0");
                    for (OcRefundDomain ocRefundDomain : refundDomainList) {
                        refundSumMoney.add(ocRefundDomain.getRefundMoney());
                    }
                    if (refundSumMoney.compareTo(orderBmoneyMoney) == 1) {
                        responseStatus.setSuccess(false);
                        responseStatus.setErrorCode(1);
                        responseStatus.setMessage("\u9000\u6b3e\u603b\u91d1\u989d\u8d85\u8fc7\u8ba2\u5355\u603b\u91d1\u989d");
                        return JsonUtil.buildNormalBinder().toJson((Object)responseStatus);
                    }
                }
            }
            OcRefundDomain ocRefundDomain = new OcRefundDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)ocRefundDomain, (Object)ocContractReDomain);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocRefundDomain.setRefundType("XCB01");
            ocRefundDomain.setRefundUsertype("0");
            ocRefundDomain.setCashback(cashbackMoney);
            ocRefundDomain.setRefundNcode(orderRefundData.getTransactionId());
            ocRefundDomain.setRefundOcode(orderRefundData.getRefPayNo());
            ocRefundDomain.setContractState(ocContractReDomain.getDataState());
            if (orderRefundData.getRefundAmount() == null) {
                ocRefundDomain.setRefundMoney(ocContractReDomain.getDataBmoney());
            }
            ocRefundDomain.setRefundMoney(refundAmount);
            ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ocRefundGoodsDomain.setRefundGoodsAmt(orderRefundData.getRefundAmount());
                ocRefundGoodsDomain.setRefundGoodsNum(ocContractGoodsDomain.getGoodsCamount());
                ocRefundGoodsDomain.setGoodsCamount(ocContractGoodsDomain.getGoodsNum());
                ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
            }
            ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
            this.logger.error("DataInDataEmployeeServiceImpl.saveRefund.ocRefundDomain", (Object)JSON.toJSONString((Object)ocRefundDomain));
            String refundCode = this.sendSaveRefund(ocRefundDomain);
            this.logger.error("DataInDataEmployeeServiceImpl.saveRefund.refundCode" + refundCode);
            List<OcRefundDomain> ocRefundDomains = this.queryRefundPage(String.valueOf(orderRefundData.getOrderId()), tenantCode);
            refundAmount = new BigDecimal("0");
            if (ocRefundDomains != null) {
                for (OcRefundDomain refundDomain : ocRefundDomains) {
                    refundAmount = refundAmount.add(refundDomain.getRefundMoney());
                }
            }
            this.logger.error("DataInDataEmployeeServiceImpl.saveRefund.JpState.refundAmount" + refundAmount);
            this.logger.error("DataInDataEmployeeServiceImpl.saveRefund.JpState." + orderJPMoney);
            this.logger.error("DataInDataEmployeeServiceImpl.saveRefund.JpState." + ocContractReDomain.getGoodsMoney());
            if (orderRefundData.getOrderType() != 1 || refundAmount.compareTo(orderJPMoney.subtract(ocContractReDomain.getGoodsMoney())) != 0) continue;
            this.logger.error("DataInDataEmployeeServiceImpl.saveRefund.updateOrderState");
            for (OcContractReDomain contractReDomain : reDomainQueryResult.getList()) {
                contractReDomain.setDataState(Integer.valueOf(-1));
                contractReDomain.setDataStatestr("\u5df2\u53d6\u6d88");
                this.updateContractReById(contractReDomain);
            }
        }
        return JsonUtil.buildNormalBinder().toJson((Object)responseStatus);
    }

    private synchronized String getOcRefundDomains(List<OcRefundDomain> refundDomainList, String tenantCode, OrderRefundData orderRefundData, OcContractReDomain ocContractReDomain) {
        BigDecimal sumMoney = new BigDecimal("0");
        if (orderRefundData.getOrderType() == 1) {
            refundDomainList = this.queryRefundOcodePage(orderRefundData.getRefPayNo(), tenantCode);
        } else if (orderRefundData.getOrderType() == 2) {
            refundDomainList = this.queryRefundPage(String.valueOf(orderRefundData.getOrderId()), tenantCode);
            if (ListUtil.isNotEmpty(refundDomainList)) {
                for (OcRefundDomain ocRefundDomain : refundDomainList) {
                    sumMoney = sumMoney.add(ocRefundDomain.getRefundMoney());
                }
                sumMoney.add(orderRefundData.getRefundAmount());
                if (sumMoney.compareTo(ocContractReDomain.getDataBmoney()) == -1 || sumMoney.compareTo(ocContractReDomain.getDataBmoney()) == 0) {
                    return null;
                }
            }
        } else {
            refundDomainList = this.queryRefundPage(String.valueOf(orderRefundData.getOrderId()), tenantCode);
        }
        return null;
    }

    public String PayOrderStateCallback(OcContractDomain ocContractDomain) {
        this.logger.error("DataInDataEmployeeServiceImpl.PayOrderStateCallback:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        String tenantCode = ocContractDomain.getTenantCode();
        String appkey = this.getDdFlag(tenantCode, "appkey", "appkey");
        String appSecret = this.getDdFlag(tenantCode, "appSecret", "appSecret");
        String PayNotifyUrl = this.getDdFlag(tenantCode, "PayNotifyUrl", "PayNotifyUrl");
        String appSecurity = this.getDdFlag(tenantCode, "appsecurity", "appsecurity");
        String getticket = this.getticket(appkey, appSecurity, tenantCode, "rs");
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("goodsPmbillno,tenantCode,fuzzy", new Object[]{ocContractDomain.getGoodsPmbillno(), tenantCode, false}));
        if (StringUtils.isBlank((String)getticket)) {
            this.logger.error("DataInDataEmployeeServiceImplgetticket.ticket", (Object)"getticket is null");
            return "fail";
        }
        PayNotifyRequestType payNotifyRequestType = this.makePayParam(ocContractDomain);
        String sign = this.getSign(payNotifyRequestType, appSecret);
        payNotifyRequestType.setSign(sign);
        payNotifyRequestType.setAuth(new PayNotifyRequestAuth(appkey, getticket));
        this.logger.error("DataInDataEmployeeServiceImplPayOrderStateCallback.payNotifyRequestType", (Object)JsonUtil.buildNormalBinder().toJson((Object)payNotifyRequestType));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=utf-8");
        try {
            HttpResponse httpResponse = HttpUtils.doPost(PayNotifyUrl, headers, JsonUtil.buildNormalBinder().toJson((Object)payNotifyRequestType));
            String result = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            this.logger.error("DataInDataEmployeeServiceImplPayOrderStateCallback.result", (Object)result);
            Map map = (Map)JSON.parseObject((String)result, Map.class);
            Map statusMap = (Map)JSON.parseObject((String)map.get("status").toString(), Map.class);
            if (Boolean.valueOf(statusMap.get("success").toString()).booleanValue()) {
                OcContractReDomain ocContractReDomain = null;
                if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                    ocContractReDomain = (OcContractReDomain)queryResult.getList().get(0);
                    ocContractReDomain.setContractDepositdate(new Date());
                    this.updateContractReById(ocContractReDomain);
                }
                if ("1".equals(ocContractReDomain.getAreaName())) {
                    ocContractReDomain.setDataState(Integer.valueOf(5));
                    this.updateContractReById(ocContractReDomain);
                }
                return "success";
            }
        }
        catch (Exception e) {
            return "fail";
        }
        return "fail";
    }

    private PayNotifyRequestType makePayParam(OcContractDomain ocContractDomain) {
        PayNotifyRequestType payNotifyRequestType = new PayNotifyRequestType();
        PayNotifyRequestData requestData = new PayNotifyRequestData();
        payNotifyRequestType.setRequestId(this.getUUID());
        payNotifyRequestType.setDateTime(String.valueOf(new Date().getTime()));
        requestData.setOrderId(Long.valueOf(ocContractDomain.getContractNbillcode()));
        requestData.setTransactionId(ocContractDomain.getGoodsPmbillno());
        requestData.setPayStatus(Integer.valueOf(3));
        payNotifyRequestType.setReqData(requestData);
        return payNotifyRequestType;
    }

    public synchronized String getUUID() {
        return UUID.randomUUID().toString();
    }

    public String PayCallback(PayNotifyRequestType payNotifyRequestType) {
        return "success";
    }

    private List<OcContractGoodsDomain> getOcContractGoodsDomains(String tenantCode, ContractVo contractVo, UmUserinfoReDomain userinfoByCode, BigDecimal orderPayAmount) {
        PayOrderRequestData payOrderRequestData = contractVo.getReqData();
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setGoodsType("48");
        ocContractGoodsDomain.setPricesetNprice(payOrderRequestData.getPayAmount());
        ocContractGoodsDomain.setPricesetAsprice(orderPayAmount);
        ocContractGoodsDomain.setContractGoodsGtype("2");
        ocContractGoodsDomain.setGoodsCode(payOrderRequestData.getPayNo());
        this.makeOrderState(ocContractGoodsDomain, payOrderRequestData);
        ocContractGoodsDomain.setSkuName("");
        ocContractGoodsDomain.setDataPic("");
        ocContractGoodsDomain.setDataPicpath("");
        ocContractGoodsDomain.setGoodsNum(new BigDecimal("0"));
        ocContractGoodsDomain.setTenantCode(tenantCode);
        ocContractGoodsDomain.setMemberCode(payOrderRequestData.getOrderUserId());
        ocContractGoodsDomain.setMemberName("\u798f\u5229\u5e73\u53f0");
        ocContractGoodsDomain.setMemberCcode(payOrderRequestData.getOrderUserId());
        ocContractGoodsDomain.setMemberCname("\u798f\u5229\u5e73\u53f0");
        ocContractGoodsDomain.setMemberBcode(userinfoByCode.getUserinfoCode());
        ocContractGoodsDomain.setMemberBname(userinfoByCode.getUserinfoCompname());
        contractGoodsList.add(ocContractGoodsDomain);
        return contractGoodsList;
    }

    private void makeOrderState(OcContractGoodsDomain ocContractGoodsDomain, PayOrderRequestData payOrderRequestData) {
        String payType;
        switch (payType = payOrderRequestData.getPayType()) {
            case "BOOK": {
                payOrderRequestData.setPayType("\u9884\u8ba2");
                break;
            }
            case "REBOOK": {
                payOrderRequestData.setPayType("\u6539\u7b7e");
                break;
            }
            default: {
                payOrderRequestData.setPayType("\u672a\u77e5\u652f\u4ed8\u573a\u666f\uff1a" + payOrderRequestData.getPayType());
            }
        }
        switch (payOrderRequestData.getOrderType()) {
            case 1: {
                ocContractGoodsDomain.setGoodsName("\u673a\u7968" + payOrderRequestData.getPayType());
                break;
            }
            case 2: {
                ocContractGoodsDomain.setGoodsName("\u9152\u5e97" + payOrderRequestData.getPayType());
                break;
            }
            case 3: {
                ocContractGoodsDomain.setGoodsName("\u6253\u8f66" + payOrderRequestData.getPayType());
                break;
            }
            case 4: {
                ocContractGoodsDomain.setGoodsName("\u63a5\u9001\u673a" + payOrderRequestData.getPayType());
                break;
            }
            case 5: {
                ocContractGoodsDomain.setGoodsName("\u5305\u8f66" + payOrderRequestData.getPayType());
                break;
            }
            case 6: {
                ocContractGoodsDomain.setGoodsName("\u79df\u8f66" + payOrderRequestData.getPayType());
                break;
            }
            case 7: {
                ocContractGoodsDomain.setGoodsName("\u6c7d\u8f66\u7968" + payOrderRequestData.getPayType());
                break;
            }
            case 8: {
                ocContractGoodsDomain.setGoodsName("\u706b\u8f66\u7968" + payOrderRequestData.getPayType());
                break;
            }
            case 9: {
                ocContractGoodsDomain.setGoodsName("\u6743\u76ca" + payOrderRequestData.getPayType());
                break;
            }
            default: {
                ocContractGoodsDomain.setGoodsName("\u672a\u77e5\u8ba2\u5355\u7c7b\u578b" + payOrderRequestData.getPayType());
            }
        }
    }

    protected String sendSaveRefund(OcRefundDomain ocRefundDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "oc.refundEngine.sendSaveRefund";
        param.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        return this.internalInvoke(apiCode, param);
    }

    protected List<OcRefundDomain> queryRefundPage(String contractNbillcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        String apiCode = "oc.refund.queryRefundPage";
        param.put("contractNbillcode", contractNbillcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataInDataEmployeeServiceImpl.queryRefundPage.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult refundQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List refundDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)refundQuery.getList()), OcRefundDomain.class);
        return refundDomainList;
    }

    protected List<OcRefundDomain> queryRefundOcodePage(String refundOcode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        String apiCode = "oc.refund.queryRefundPage";
        param.put("refundOcode", refundOcode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("DataInDataEmployeeServiceImpl.queryRefundPage.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String contractStr = this.internalInvoke(apiCode, params);
        QueryResult refundQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(contractStr, QueryResult.class);
        List refundDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)refundQuery.getList()), OcRefundDomain.class);
        return refundDomainList;
    }

    private String saveOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error("DataInDataEmployeeServiceImpl.saveOrder.ocContractDomain");
            return null;
        }
        String apiCode = "oc.shopping.sendContractByDel";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected QueryResult<UmUserinfoReDomain> queryUserinfoPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmUserinfoReDomain.class);
    }

    protected QueryResult<OcContractReDomain> queryOrderPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("DataInDataEmployeeServiceImpl.queryOrderPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractPageReDomain";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
    }

    protected String updateUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) {
        if (null == umUserinfoDomainBean) {
            this.logger.error("DataInDataEmployeeServiceImpl.queryOrderPage.updateUserinfo", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
            return null;
        }
        String apiCode = "um.user.sendUpdateUserinfo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected String updateEmployee(OrgEmployeeDomain orgEmployeeDomain) {
        if (null == orgEmployeeDomain) {
            this.logger.error("DataInDataEmployeeServiceImpl.queryOrderPage.updateEmployee", (Object)JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeDomain));
            return null;
        }
        String apiCode = "org.ChannelsendBase.sendUpdateEmployee";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orgEmployeeDomain", JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userinfoCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    protected UmUserReDomainBean getUserByCode(String userCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserByUserCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userCode", userCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserReDomainBean)this.getForObject(apiCode, UmUserReDomainBean.class, paramMap);
    }

    protected QueryResult<OrgEmployee> queryEmployeePage(String userinfoCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userinfoCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "org.employee.queryEmployeePage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return this.sendReSupObject(apiCode, param, OrgEmployee.class);
    }

    protected QueryResult<OrgEmployee> queryEmployeeOnePage(String userCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "org.employee.queryEmployeePage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userCode", userCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        return this.sendReSupObject(apiCode, param, OrgEmployee.class);
    }

    protected String updateContractReById(OcContractReDomain ocContractReDomain) {
        String apiCode = "oc.contract.updateContractReById";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractReDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected String updateContractState(Integer contractSubId, Integer dataState, Integer oldDataState) {
        String apiCode = "oc.contract.updateContractState";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractSubId", String.valueOf(contractSubId));
        paramMap.put("dataState", String.valueOf(dataState));
        paramMap.put("oldDataState", String.valueOf(oldDataState));
        return this.internalInvoke(apiCode, paramMap);
    }

    private String getticket(String appKey, String appSecurity, String tenantCode, String type) {
        String ticketUrl = this.getDdFlag(tenantCode, "ticketUrl", "ticketUrl");
        String ticket = null;
        switch (type) {
            case "rs": {
                ticketUrl = this.getDdFlag(tenantCode, "rsticketUrl", "rsticketUrl");
                break;
            }
            case "sso": {
                ticketUrl = this.getDdFlag(tenantCode, "ticketUrl", "ticketUrl");
                break;
            }
            default: {
                ticketUrl = this.getDdFlag(tenantCode, "ticketUrl", "ticketUrl");
            }
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        Map params = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=utf-8");
        try {
            params.put("appKey", appKey);
            params.put("appSecurity", appSecurity);
            HttpResponse httpResponse = HttpUtils.doPost(ticketUrl, headers, JsonUtil.buildNonNullBinder().toJson(params));
            String result = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            params = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
            this.logger.error("DataInDataEmployeeServiceImpl.getticket.params" + JsonUtil.buildNormalBinder().toJson(params));
            switch (type) {
                case "rs": {
                    ticket = ((String)params.get("Ticket")).toString();
                    break;
                }
                case "sso": {
                    ticket = ((String)params.get("Token")).toString();
                    break;
                }
                case "order": {
                    ticket = ((String)params.get("Token")).toString();
                    break;
                }
                default: {
                    ticket = ((String)params.get("Token")).toString();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ticket;
    }

    public String GetSign(String corpId, String productType, String orderStatus, String orderId, String statusIDs, String refundType, String secret, String approveScenario) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("secret", secret);
        hashMap.put("corpId", corpId);
        hashMap.put("productType", productType);
        hashMap.put("orderId", orderId);
        hashMap.put("orderStatus", orderStatus);
        Set collection = hashMap.keySet();
        ArrayList list = new ArrayList(collection);
        Collections.sort(list);
        String str = "";
        for (int i = 0; i < list.size(); ++i) {
            str = str + (String)list.get(i) + "=" + (String)hashMap.get(list.get(i));
            if (i == list.size() - 1) continue;
            str = str + "&";
        }
        return DigestUtils.shaHex((String)str).toUpperCase();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(alphabetic=true)
    public String getSign(Object object, String appSecret) {
        ObjectMapper mapper = new ObjectMapper();
        Map maps = null;
        String sortedBody = null;
        try {
            String serialize = mapper.writeValueAsString(object);
            maps = (Map)mapper.readValue(serialize, (TypeReference)new TypeReference<TreeMap<String, Object>>(){});
            Iterator it = maps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (!key.equals("sign") && !key.equals("signType") && maps.get(key) != null && !maps.get(key).equals("")) continue;
                it.remove();
            }
            Map mapReqData = (Map)maps.get("reqData");
            TreeMap<String, BigDecimal> sortedMapReqData = new TreeMap<String, BigDecimal>(mapReqData);
            maps.put("reqData", sortedMapReqData);
            if (sortedMapReqData.get("payAmount") != null) {
                String payAmount = sortedMapReqData.get("payAmount").toString();
                BigDecimal bigDecimal = new BigDecimal(payAmount);
                sortedMapReqData.put("payAmount", bigDecimal.setScale(2, 4));
            }
            sortedBody = mapper.writeValueAsString((Object)maps);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.logger.error("DataInDataEmployeeServiceImpl.getSign:{}", (Object)(sortedBody + appSecret));
        return HashKit.sha512(sortedBody + appSecret);
    }

    public static String getSigns(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        Map maps = null;
        String sortedBody = null;
        try {
            String serialize = mapper.writeValueAsString(object);
            maps = (Map)mapper.readValue(serialize, (TypeReference)new TypeReference<TreeMap<String, Object>>(){});
            Iterator it = maps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (!key.equals("sign") && !key.equals("signType") && maps.get(key) != null && !maps.get(key).equals("")) continue;
                it.remove();
            }
            Map mapReqData = (Map)maps.get("reqData");
            TreeMap<String, BigDecimal> sortedMapReqData = new TreeMap<String, BigDecimal>(mapReqData);
            maps.put("reqData", sortedMapReqData);
            if (sortedMapReqData.get("payAmount") != null) {
                String payAmount = sortedMapReqData.get("payAmount").toString();
                BigDecimal bigDecimal = new BigDecimal(payAmount);
                sortedMapReqData.put("payAmount", bigDecimal.setScale(2, 4));
            }
            sortedBody = mapper.writeValueAsString((Object)maps);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println(sortedBody);
        return HashKit.sha512(sortedBody);
    }

    public static String getMD5Hash(String source) {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(source.getBytes());
            for (byte b : md5.digest()) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String res = "{\n    \"sign\": \"1c56a4a136a2b1510eb35886321932d2b80eb81995f0fddb0e35aad3b157f54afe8721020fa1d09c5d5d75f1e2e28b4532af9d3af3321ff2d1a711bdb13156c8\",\n    \"requestId\": \"240519.211921.10.40.24.117.155.309369\",\n    \"dateTime\": \"20240519211921\",\n    \"reqData\": {\n        \"orderRefundDataList\": [\n            {\n                \"orderId\": 32395649295,\n                \"orderType\": 2,\n                \"orderUserId\": \"2024051000000051\",\n                \"refPayNo\": \"267240025885294657\",\n                \"refundAmount\": 103.88,\n                \"transactionId\": \"267240677984485455\"\n            }\n        ]\n    },\n    \"corpId\": \"RCYX\"\n}";
        Map map = (Map)JSON.parseObject((String)res, Map.class);
        System.out.println(map.keySet());
        String corpId = map.get("corpId").toString();
        String requestId = map.get("requestId").toString();
        String dateTime = map.get("dateTime").toString();
        String reqData = map.get("reqData").toString();
        String sign = map.get("sign").toString();
        RefundRequest refundRequest = (RefundRequest)JSON.parseObject((String)reqData, RefundRequest.class);
        RefundContractResponseVo refundContractResponseVo = new RefundContractResponseVo();
        refundContractResponseVo.setRequestId(requestId);
        refundContractResponseVo.setCorpId(corpId);
        refundContractResponseVo.setDateTime(dateTime);
        refundContractResponseVo.setReqData(refundRequest);
        ArrayList ocRefundDomainList = new ArrayList();
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        ocRefundDomain.setRefundMoney(new BigDecimal("207.76"));
        OcRefundDomain ocRefundDomain1 = new OcRefundDomain();
        ocRefundDomain1.setRefundMoney(new BigDecimal("207.76"));
        Collections.addAll(ocRefundDomainList, ocRefundDomain, ocRefundDomain1);
        BigDecimal sumMoney = new BigDecimal("0");
        BigDecimal orderMoney = new BigDecimal("413.52");
        for (OcRefundDomain ocRefundDomain2 : ocRefundDomainList) {
            sumMoney = sumMoney.add(ocRefundDomain2.getRefundMoney());
        }
        System.out.println(sumMoney.compareTo(orderMoney));
    }
}

