/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.xuankua.service.impl;

import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.data.api.DataXuankuaService;
import com.yqbsoft.laser.service.ext.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.data.domain.OcPackageDomain;
import com.yqbsoft.laser.service.ext.data.xuankua.service.domain.RetuenBean;
import com.yqbsoft.laser.service.ext.data.xuankua.service.domain.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.service.XuankuaService;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.support.ResultCode;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieOrderVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.drama.AuthCodeDomain;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DataXuankuaServiceImpl
extends BaseServiceImpl
implements DataXuankuaService {
    private static final String SYS_CODE = "DataXuankuaServiceImpl";
    @Autowired
    private XuankuaService xuankuaService;

    public XuankuaService getXuankuaService() {
        if (null == this.xuankuaService) {
            this.xuankuaService = (XuankuaService)ApplicationContextUtil.getService((String)"xuankuaService");
        }
        return this.xuankuaService;
    }

    public String getXuankuaShopUrl(String userPhone, String tenantCode, String userinfoCode) throws Exception {
        ResultCode<AuthCodeDomain> resultCode = this.xuankuaService.getAuthcode(userPhone);
        this.logger.error("DataXuankuaServiceImpl.getXuankuaShopUrl.resultCode = " + JsonUtil.buildNormalBinder().toJson(resultCode));
        if (resultCode.isSuccess()) {
            if (resultCode.getData() == null) {
                // empty if block
            }
            AuthCodeDomain data = resultCode.getData();
            this.logger.error("DataXuankuaServiceImplgetXuankuaShopUrl.result ", (Object)("https://test-open.xuankua.cn/route?appkey=rencaiyx&auth_code=" + data.getAuthCode() + "&txid=" + userinfoCode));
            return "https://testwap.mayiufu.com/rencaiyx/index?appkey=rencaiyx&auth_code=" + data.getAuthCode() + "&txid=" + userinfoCode;
        }
        return "error";
    }

    public static void main(String[] args) {
        DataXuankuaServiceImpl dataXuankuaService = new DataXuankuaServiceImpl();
        String xuankuaShopUrl = null;
        try {
            xuankuaShopUrl = dataXuankuaService.getXuankuaShopUrl("18897915069", "2021011200000001", "userinfoCode");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("xuankuaShopUrl = " + xuankuaShopUrl);
    }

    protected QueryResult<UmUserinfoReDomain> queryUserinfoPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmUserinfoReDomain.class);
    }

    public String saveXuankuaContract(String tradeno, String tenantCode) {
        ResultCode<XkMovieOrderVo> orderDetail = this.xuankuaService.getOrderDetail(tradeno);
        if (!orderDetail.isSuccess()) {
            return "error";
        }
        XkMovieOrderVo.OrderVo order = orderDetail.getData().getOrder();
        QueryResult<OcContractReDomain> queryResult = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode", new Object[]{order.getTradeno(), tenantCode}));
        if (ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            return ((OcContractReDomain)queryResult.getList().get(0)).getContractBillcode();
        }
        UmUserinfoReDomain userinfoByCode = null;
        if (StringUtils.isNotBlank((String)order.getTxid())) {
            userinfoByCode = this.getUserinfoByCode(order.getTxid(), tenantCode);
        }
        if (null == userinfoByCode) {
            QueryResult<UmUserinfoReDomain> qlist = this.queryUserinfoPage(this.getQueryMapParam("userinfoPhone,tenantCode", new Object[]{order.getMobile(), tenantCode}));
            if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
                return "error";
            }
            userinfoByCode = (UmUserinfoReDomain)qlist.getList().get(0);
        }
        try {
            OcContractDomain ocContractDomain = new OcContractDomain();
            ocContractDomain.setTenantCode(tenantCode);
            ocContractDomain.setContractNbillcode(order.getTradeno());
            ocContractDomain.setAppmanageIcode("031");
            ocContractDomain.setUserCode(userinfoByCode.getUserCode());
            ocContractDomain.setUserName(userinfoByCode.getUserinfoCompname());
            ocContractDomain.setMemberBcode(userinfoByCode.getUserinfoCode());
            ocContractDomain.setMemberBname(userinfoByCode.getUserinfoCompname());
            ocContractDomain.setMemberCode(userinfoByCode.getUserinfoParentCode());
            ocContractDomain.setMemberMname(userinfoByCode.getUserinfoParentName());
            ocContractDomain.setMemberCcode(userinfoByCode.getUserinfoParentCode());
            ocContractDomain.setMemberCname(userinfoByCode.getUserinfoParentName());
            ocContractDomain.setContractType("43");
            ocContractDomain.setContractInmoney(order.getSettleAmount());
            ocContractDomain.setContractMoney(order.getSettleAmount());
            ocContractDomain.setDataBmoney(order.getSettleAmount());
            ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
            OcPackageDomain ocPackageDomain = new OcPackageDomain();
            ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            ocContractGoodsDomain.setGoodsType("43");
            ocContractGoodsDomain.setPricesetNprice(order.getSettleAmount());
            ocContractGoodsDomain.setPricesetAsprice(order.getSettleAmount());
            ocContractGoodsDomain.setContractGoodsGtype("2");
            ocContractGoodsDomain.setGoodsCode("jygoods");
            ocContractGoodsDomain.setGoodsName(order.getMoviename());
            ocContractGoodsDomain.setGoodsNum(new BigDecimal(1));
            ocContractGoodsDomain.setTenantCode(tenantCode);
            ocContractGoodsDomain.setMemberCode(userinfoByCode.getUserinfoParentCode());
            ocContractGoodsDomain.setMemberMname(userinfoByCode.getUserinfoParentName());
            ocContractGoodsDomain.setMemberCcode(userinfoByCode.getUserinfoParentCode());
            ocContractGoodsDomain.setMemberCname(userinfoByCode.getUserinfoParentName());
            contractGoodsList.add(ocContractGoodsDomain);
            ocPackageDomain.setContractGoodsList(contractGoodsList);
            packageList.add(ocPackageDomain);
            ocContractDomain.setPackageList(packageList);
            RetuenBean retuenBean = this.saveOrder(ocContractDomain);
            return (String)retuenBean.getDataObj();
        }
        catch (Exception e) {
            this.logger.error("DataXuankuaServiceImpl.getXuankuaShopUrl.Exception" + JsonUtil.buildNormalBinder().toJson((Object)e));
            return "error";
        }
    }

    protected QueryResult<OcContractReDomain> queryOrderPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("DataXuankuaServiceImpl.queryOrderPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractReDomain.class);
    }

    protected UmUserinfoReDomain getUserinfoByCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    protected RetuenBean saveOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error("DataXuankuaServiceImpl.saveOrder.ocContractDomain");
            return null;
        }
        String apiCode = "oc.contractEngine.sendsaveContractRe";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        Map re = (Map)this.readObj(apiCode, paramMap, "map", new Object[]{String.class, Object.class});
        this.logger.error("DataXuankuaServiceImpl.saveOrder.re", (Object)re.toString());
        if (MapUtils.isEmpty((Map)re)) {
            return new RetuenBean("DataXuankuaServiceImpl.saveOrder.re", "null");
        }
        boolean s = (Boolean)re.get("success");
        if (!s) {
            return new RetuenBean((String)re.get("errCode"), (String)re.get("errMsg"));
        }
        return new RetuenBean((String)re.get("contractBillcode"));
    }

    public String sendContract(OcContractReDomain ocContractDomain) {
        ResultCode<String> resultCode = this.xuankuaService.sellSeat(ocContractDomain.getContractNbillcode(), ocContractDomain.getContractBillcode());
        if (resultCode.isSuccess()) {
            return "success";
        }
        return "error";
    }
}

