/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.http;

import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.http.FakeX509TrustManager;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.http.HttpMethod;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.http.HttpOther;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.http.HttpResult;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.http.SSLUtilities;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.support.RequestCallback;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    public static final int MAX_TOTAL_CONNECTIONS = 3000;
    public static final int MAX_ROUTE_CONNECTIONS = 800;
    public static final int DEFAULT_TIMEOUT = 10000;
    public static final int SHORT_TIMEOUT = 30000;
    public static final int Integer_TIMEOUT = 120000;
    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int CONNECTION_REQUEST_TIMEOUT = 500;
    public static final int CONNECTION_IDLE_TIMEOUT = 30000;
    public static final int EXCEPTION_HTTP_STATUSCODE = 9999;
    public static final int HTTP_STATUSCODE_HTTP_HOST_CONNECT_EXCEPTION = 9001;
    public static final int HTTP_STATUSCODE_CONNECT_TIMEOUT_EXCEPTION = 9002;
    public static final int HTTP_STATUSCODE_SOCKET_TIMEOUT_EXCEPTION = 9003;
    private static Map<String, AtomicInteger> hostCountMap = new ConcurrentHashMap<String, AtomicInteger>();
    private static ScheduledExecutorService scheduExec = null;
    private static PoolingHttpClientConnectionManager cm;
    private static RequestConfig defaultRequestConfig;
    private static Pattern QUERY_MAP_PATTERN;

    private static SSLConnectionSocketFactory getSSLConnectionSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManager[] _trustManagers = new TrustManager[]{new FakeX509TrustManager()};
            context.init(null, _trustManagers, new SecureRandom());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(context, new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"}, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return sslsf;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (KeyManagementException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static CloseableHttpClient getHttpClient() {
        CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRedirectStrategy((RedirectStrategy)new MyDefaultRedirectStrategy()).setDefaultRequestConfig(defaultRequestConfig).build();
        return httpclient;
    }

    public static CloseableHttpClient getHttpClient(int connectTimeout, int readTimeout) {
        RequestConfig requestConfig = RequestConfig.copy((RequestConfig)defaultRequestConfig).setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout).build();
        CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRedirectStrategy((RedirectStrategy)new MyDefaultRedirectStrategy()).setDefaultRequestConfig(requestConfig).build();
        return httpclient;
    }

    private static CloseableHttpClient getHttpClient(int connectTimeout, int readTimeout, CookieStore cookieStore) {
        if (cookieStore == null) {
            return HttpUtils.getHttpClient(connectTimeout, readTimeout);
        }
        RequestConfig requestConfig = RequestConfig.copy((RequestConfig)defaultRequestConfig).setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout).build();
        CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultCookieStore(cookieStore).setRedirectStrategy((RedirectStrategy)new MyDefaultRedirectStrategy()).setDefaultRequestConfig(requestConfig).build();
        return httpclient;
    }

    private static CookieStore getCookieStore(List<BasicClientCookie> cookies) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        if (cookies != null) {
            for (BasicClientCookie cookie : cookies) {
                cookieStore.addCookie((Cookie)cookie);
            }
        }
        return cookieStore;
    }

    public static void setMaxConnectionsPerHost(String url, int maxHostConnections) {
        try {
            URI uri = new URI(url);
            HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            cm.setMaxPerRoute(new HttpRoute(httpHost), maxHostConnections);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HttpResult getUrlAsString(String url) {
        HttpGet httpGet = HttpUtils.getHttpGet(url, null, null);
        HttpResult result = HttpUtils.executeHttpRequest((HttpUriRequest)httpGet, null, 10000, DEFAULT_CHARSET);
        return result;
    }

    public static HttpResult getUrlAsString(String url, Map params) {
        HttpGet httpGet = HttpUtils.getHttpGet(url, params, DEFAULT_CHARSET);
        HttpResult result = HttpUtils.executeHttpRequest((HttpUriRequest)httpGet, null, 10000, DEFAULT_CHARSET);
        return result;
    }

    public static HttpResult purgeUrlAsString(String url, HttpMethod method, Map params, Map reqHeader) {
        HttpOther httpOther = HttpUtils.getHttpOtherMethod(url, method, params, DEFAULT_CHARSET);
        HttpResult result = HttpUtils.executeHttpRequest((HttpUriRequest)httpOther, reqHeader, 10000, DEFAULT_CHARSET);
        return result;
    }

    public static HttpResult purgeBodyAsString(String url, HttpMethod method, String body) {
        return HttpUtils.purgeBodyAsString2(url, method, body, DEFAULT_CHARSET, null);
    }

    public static HttpResult purgeBodyAsString2(String url, HttpMethod method, String body, String encode, Map reqHeader) {
        HttpOther httpOther = HttpUtils.getHttpOtherMethod2(url, method, body, encode);
        HttpResult result = HttpUtils.executeHttpRequest((HttpUriRequest)httpOther, reqHeader, 10000, encode);
        return result;
    }

    public static HttpResult getUrlAsString(String url, Map params, int timeoutMills) {
        HttpGet httpGet = HttpUtils.getHttpGet(url, params, DEFAULT_CHARSET);
        HttpResult result = HttpUtils.executeHttpRequest((HttpUriRequest)httpGet, null, timeoutMills, DEFAULT_CHARSET);
        return result;
    }

    public static HttpResult getUrlAsString(String url, Map params, List<BasicClientCookie> cookies) {
        HttpGet httpGet = HttpUtils.getHttpGet(url, params, DEFAULT_CHARSET);
        HttpResult result = HttpUtils.executeHttpRequestWithCookie((HttpUriRequest)httpGet, null, 10000, DEFAULT_CHARSET, cookies);
        return result;
    }

    public static HttpResult getUrlAsString(String url, Map params, String encode) {
        HttpGet httpGet = HttpUtils.getHttpGet(url, params, encode);
        HttpResult result = HttpUtils.executeHttpRequest((HttpUriRequest)httpGet, null, 10000, encode);
        return result;
    }

    public static HttpResult getUrlAsString(String url, Map params, Map reqHeader, String encode) {
        HttpGet httpGet = HttpUtils.getHttpGet(url, params, encode);
        HttpResult result = HttpUtils.executeHttpRequest((HttpUriRequest)httpGet, reqHeader, 10000, encode);
        return result;
    }

    public static HttpResult getUrlAsString(String url, Map params, Map reqHeader, List<BasicClientCookie> cookies, String encode) {
        HttpGet httpGet = HttpUtils.getHttpGet(url, params, encode);
        HttpResult result = HttpUtils.executeHttpRequestWithCookie((HttpUriRequest)httpGet, reqHeader, 10000, encode, cookies);
        return result;
    }

    public static boolean getUrlAsInputStream(String url, Map params, RequestCallback callback) {
        HttpGet httpGet = HttpUtils.getHttpGet(url, params, DEFAULT_CHARSET);
        return HttpUtils.executeHttpRequest((HttpUriRequest)httpGet, null, null, callback, 10000);
    }

    public static boolean getUrlAsInputStream(String url, Map params, RequestCallback callback, String encode) {
        HttpGet httpGet = HttpUtils.getHttpGet(url, params, encode);
        return HttpUtils.executeHttpRequest((HttpUriRequest)httpGet, null, null, callback, 10000);
    }

    public static boolean getUrlAsInputStream(String url, Map params, RequestCallback callback, String encode, int timeoutMills) {
        HttpGet httpGet = HttpUtils.getHttpGet(url, params, encode);
        return HttpUtils.executeHttpRequest((HttpUriRequest)httpGet, null, null, callback, timeoutMills);
    }

    public static HttpResult postUrlAsString(String url, Map params) {
        HttpPost httpPost = HttpUtils.getHttpPost(url, params, DEFAULT_CHARSET);
        return HttpUtils.executeHttpRequest((HttpUriRequest)httpPost, null, 10000, DEFAULT_CHARSET);
    }

    public static HttpResult postUrlAsString(String url, Map params, List<BasicClientCookie> cookies) {
        HttpPost httpPost = HttpUtils.getHttpPost(url, params, DEFAULT_CHARSET);
        HttpResult result = HttpUtils.executeHttpRequestWithCookie((HttpUriRequest)httpPost, null, 10000, DEFAULT_CHARSET, cookies);
        return result;
    }

    public static HttpResult postUrlAsString(String url, Map params, int timeoutMills) {
        HttpPost httpPost = HttpUtils.getHttpPost(url, params, DEFAULT_CHARSET);
        return HttpUtils.executeHttpRequest((HttpUriRequest)httpPost, null, timeoutMills, DEFAULT_CHARSET);
    }

    public static HttpResult postBodyAsString(String url, String body) {
        return HttpUtils.postBodyAsString2(url, body, DEFAULT_CHARSET);
    }

    public static HttpResult postBodyAsString2(String url, String body, String encode) {
        HttpPost httpPost = HttpUtils.getHttpPost(url, body, encode);
        return HttpUtils.executeHttpRequest((HttpUriRequest)httpPost, null, 10000, encode);
    }

    public static HttpResult postBodyAsString2(String url, String body, String encode, Map header) {
        HttpPost httpPost = HttpUtils.getHttpPost(url, body, encode);
        return HttpUtils.executeHttpRequest((HttpUriRequest)httpPost, header, 10000, encode);
    }

    public static HttpResult postBodyAsString2(String url, byte[] body, String mimeType, String charset, Map header) {
        HttpPost httpPost = HttpUtils.getHttpPost(url, body, mimeType, charset);
        return HttpUtils.executeHttpRequest((HttpUriRequest)httpPost, header, 10000, charset);
    }

    public static HttpResult postBodyAsString(String url, String body, int timeoutMills) {
        return HttpUtils.postBodyAsString2(url, body, DEFAULT_CHARSET, timeoutMills);
    }

    public static HttpResult postBodyAsString2(String url, String body, String encode, int timeoutMills) {
        HttpPost httpPost = HttpUtils.getHttpPost(url, body, encode);
        return HttpUtils.executeHttpRequest((HttpUriRequest)httpPost, null, timeoutMills, encode);
    }

    public static HttpResult postUrlAsString(String url, Map params, Map reqHeader, String encode) {
        HttpPost httpPost = HttpUtils.getHttpPost(url, params, encode);
        return HttpUtils.executeHttpRequestWithCookie((HttpUriRequest)httpPost, reqHeader, 10000, encode, null);
    }

    public static HttpResult postUrlAsString3(String url, Map params, Map reqHeader, String encode, int timeoutMills) {
        HttpPost httpPost = HttpUtils.getHttpPost(url, params, encode);
        return HttpUtils.executeHttpRequestWithCookie((HttpUriRequest)httpPost, reqHeader, timeoutMills, encode, null);
    }

    public static boolean postUrlAsInputStream(String url, Map params, RequestCallback callback) {
        HttpPost httpPost = HttpUtils.getHttpPost(url, params, DEFAULT_CHARSET);
        return HttpUtils.executeHttpRequest((HttpUriRequest)httpPost, null, null, callback, 10000);
    }

    public static HttpResult uploadFile(String url, Map params, byte[] bytes, String inputName, String fileName) {
        return HttpUtils.uploadFile(url, params, bytes, inputName, fileName, DEFAULT_CHARSET);
    }

    public static HttpResult uploadFile(String url, Map params, byte[] bytes, String inputName, String fileName, String encode) {
        HashMap<String, byte[]> uploadMap = new HashMap<String, byte[]>();
        uploadMap.put(inputName, bytes);
        HashMap<String, String> fileNameMap = new HashMap<String, String>();
        fileNameMap.put(inputName, fileName);
        return HttpUtils.uploadFile(url, params, uploadMap, fileNameMap, encode);
    }

    public static HttpResult uploadFile(String url, Map params, Map<String, byte[]> uploadMap, Map fileNameMap) {
        return HttpUtils.uploadFile(url, params, uploadMap, fileNameMap, DEFAULT_CHARSET);
    }

    public static HttpResult uploadFile(String url, Map params, Map<String, byte[]> uploadMap, Map fileNameMap, String encode) {
        return HttpUtils.uploadFile(url, params, uploadMap, fileNameMap, encode, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpResult uploadFile(String url, Map params, Map<String, byte[]> uploadMap, Map fileNameMap, String encode, int timeout) {
        CookieStore cookieStore = HttpUtils.getCookieStore(null);
        CloseableHttpClient client = HttpUtils.getHttpClient(10000, timeout, cookieStore);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setCharset(Charset.forName(encode));
        HttpPost request = new HttpPost(url);
        for (String input : uploadMap.keySet()) {
            ByteArrayBody isb = new ByteArrayBody(uploadMap.get(input), String.valueOf(fileNameMap.get(input)));
            multipartEntityBuilder.addPart(input, (ContentBody)isb);
        }
        try {
            if (params != null && !params.isEmpty()) {
                for (String key : params.keySet()) {
                    multipartEntityBuilder.addTextBody(String.valueOf(key), String.valueOf(params.get(key)), ContentType.create((String)"text/plain", (Charset)Charset.forName(encode)));
                }
            }
            request.setEntity(multipartEntityBuilder.build());
            List reqcookie = cookieStore.getCookies();
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                Header[] headers;
                String result = "";
                HttpEntity entity = HttpUtils.getEntity((HttpResponse)response);
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)encode);
                }
                if (HttpUtils.isSuccess((HttpResponse)response)) {
                    HttpResult ret = HttpResult.getSuccessReturn(result);
                    HttpUtils.addHeader(ret, (HttpResponse)response);
                    List cookies = cookieStore.getCookies();
                    HttpUtils.addCookie(ret, cookies, reqcookie);
                    HttpResult httpResult = ret;
                    return httpResult;
                }
                int statusCode = response.getStatusLine().getStatusCode();
                String msg = "httpStatus:" + statusCode + response.getStatusLine().getReasonPhrase() + ", Header: ";
                for (Header header : headers = response.getAllHeaders()) {
                    msg = msg + header.getName() + ":" + header.getValue();
                }
                request.abort();
                HttpResult httpResult = HttpResult.getFailure("httpStatus:" + response.getStatusLine().getStatusCode(), statusCode, result);
                return httpResult;
            }
        }
        catch (HttpHostConnectException e) {
            request.abort();
            return HttpResult.getFailure(request.getURI() + " exception:" + ((Object)((Object)e)).getClass().getCanonicalName(), 9001);
        }
        catch (ConnectTimeoutException e) {
            request.abort();
            return HttpResult.getFailure(request.getURI() + " exception:" + ((Object)((Object)e)).getClass().getCanonicalName(), 9002);
        }
        catch (SocketTimeoutException e) {
            request.abort();
            return HttpResult.getFailure(request.getURI() + " exception:" + e.getClass().getCanonicalName(), 9003);
        }
        catch (Exception e) {
            request.abort();
            return HttpResult.getFailure(request.getURI() + " exception:" + e.getClass().getCanonicalName(), 9999);
        }
    }

    private static void addCookie(HttpResult ret, List<Cookie> cookies, List<Cookie> reqcookie) {
        try {
            for (Cookie cookie : cookies) {
                if (reqcookie.contains(cookie)) continue;
                ret.addCookie(cookie.getName(), cookie.getPath(), cookie.getValue(), cookie.getExpiryDate());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addHeader(HttpResult ret, HttpResponse response) {
        try {
            Header[] headers;
            for (Header header : headers = response.getAllHeaders()) {
                ret.addHeader(header.getName(), header.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static HttpPost getHttpPost(String url, Map params, String encoding) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept-Encoding", "gzip,deflate");
        if (params != null) {
            ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
            for (Object name : params.keySet()) {
                form.add(new BasicNameValuePair(String.valueOf(name), String.valueOf(params.get(name))));
            }
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, encoding);
                httpPost.setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return httpPost;
    }

    private static HttpOther getHttpOtherMethod(String url, HttpMethod method, Map params, String encoding) {
        HttpOther httpOther = HttpUtils.getHttpOtherMethod(url, method);
        if (params != null) {
            ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
            for (Object name : params.keySet()) {
                form.add(new BasicNameValuePair(String.valueOf(name), String.valueOf(params.get(name))));
            }
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, encoding);
                httpOther.setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return httpOther;
    }

    private static HttpOther getHttpOtherMethod(String url, HttpMethod method) {
        HttpOther httpOther = new HttpOther(method);
        httpOther.setURI(URI.create(url));
        httpOther.setHeader("Accept-Encoding", "gzip,deflate");
        return httpOther;
    }

    private static HttpOther getHttpOtherMethod2(String url, HttpMethod method, String body, String encoding) {
        HttpOther httpOther = HttpUtils.getHttpOtherMethod(url, method);
        if (body != null) {
            try {
                StringEntity entity = new StringEntity(body, encoding);
                httpOther.setEntity((HttpEntity)entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return httpOther;
    }

    private static HttpPost getHttpPost(String url, String body, String encoding) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept-Encoding", "gzip,deflate");
        if (body != null) {
            try {
                StringEntity entity = new StringEntity(body, encoding);
                httpPost.setEntity((HttpEntity)entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return httpPost;
    }

    private static HttpPost getHttpPost(String url, byte[] body, String mimeType, String charset) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept-Encoding", "gzip,deflate");
        if (body != null) {
            try {
                ContentType contentType = ContentType.create((String)mimeType, (String)charset);
                ByteArrayEntity entity = new ByteArrayEntity(body, contentType);
                httpPost.setEntity((HttpEntity)entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return httpPost;
    }

    private static HttpGet getHttpGet(String url, Map params, String encode) {
        String fullUrl = HttpUtils.getFullUrl(url, params, encode);
        HttpGet httpGet = new HttpGet(fullUrl);
        httpGet.setHeader("Accept-Encoding", "gzip,deflate");
        return httpGet;
    }

    public static String getFullUrl(String url, Map params, String encode) {
        if (params != null) {
            url = url.indexOf(63) == -1 ? url + "?" : url + "&";
            for (Object name : params.keySet()) {
                try {
                    if (!StringUtils.isNotBlank((CharSequence)String.valueOf(params.get(name)))) continue;
                    url = url + name + "=" + URLEncoder.encode(String.valueOf(params.get(name)), encode) + "&";
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private static HttpResult executeHttpRequest(HttpUriRequest request, Map reqHeader, int timeoutMills, String charset) {
        return HttpUtils.executeHttpRequestWithCookie(request, reqHeader, timeoutMills, charset, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HttpResult executeHttpRequestWithCookie(HttpUriRequest request, Map reqHeader, int timeoutMills, String charset, List<BasicClientCookie> cookies) {
        HttpUtils.hostCount(request);
        CookieStore cookieStore = HttpUtils.getCookieStore(cookies);
        CloseableHttpClient client = HttpUtils.getHttpClient(10000, timeoutMills, cookieStore);
        if (reqHeader != null) {
            for (Object name : reqHeader.keySet()) {
                request.addHeader(String.valueOf(name), String.valueOf(reqHeader.get(name)));
            }
        }
        try {
            List reqcookie = cookieStore.getCookies();
            try (CloseableHttpResponse response = client.execute(request);){
                HttpEntity entiry = HttpUtils.getEntity((HttpResponse)response);
                String result = "";
                if (entiry != null) {
                    result = EntityUtils.toString((HttpEntity)HttpUtils.getEntity((HttpResponse)response), (String)charset);
                }
                if (HttpUtils.isSuccess((HttpResponse)response)) {
                    HttpResult ret = HttpResult.getSuccessReturn(result);
                    HttpUtils.addHeader(ret, (HttpResponse)response);
                    List cookieList = cookieStore.getCookies();
                    HttpUtils.addCookie(ret, cookieList, reqcookie);
                    HttpResult httpResult = ret;
                    return httpResult;
                }
                int statusCode = response.getStatusLine().getStatusCode();
                HttpResult ret = HttpResult.getFailure("httpStatus:" + response.getStatusLine().getStatusCode(), statusCode, result);
                HttpUtils.addHeader(ret, (HttpResponse)response);
                String msg = "httpStatus:" + statusCode + response.getStatusLine().getReasonPhrase() + ", Header: " + ret.getAllHeaders();
                request.abort();
                HttpResult httpResult = ret;
                return httpResult;
            }
        }
        catch (HttpHostConnectException e) {
            request.abort();
            return HttpResult.getFailure(request.getURI() + " exception:" + ((Object)((Object)e)).getClass().getCanonicalName(), 9001);
        }
        catch (ConnectTimeoutException e) {
            request.abort();
            return HttpResult.getFailure(request.getURI() + " exception:" + ((Object)((Object)e)).getClass().getCanonicalName(), 9002);
        }
        catch (SocketTimeoutException e) {
            request.abort();
            return HttpResult.getFailure(request.getURI() + " exception:" + e.getClass().getCanonicalName(), 9003);
        }
        catch (Exception e) {
            request.abort();
            return HttpResult.getFailure(request.getURI() + " exception:" + e.getClass().getCanonicalName(), 9999);
        }
    }

    private static boolean isSuccess(HttpResponse response) {
        return response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() <= 207;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean executeHttpRequest(HttpUriRequest request, Map reqHeader, BasicClientCookie cookie, RequestCallback callback, int timeoutMills) {
        HttpUtils.hostCount(request);
        CookieStore cookieStore = HttpUtils.getCookieStore(Arrays.asList(cookie));
        CloseableHttpClient client = HttpUtils.getHttpClient(10000, timeoutMills, cookieStore);
        if (reqHeader != null) {
            for (Object name : reqHeader.keySet()) {
                request.addHeader(String.valueOf(name), String.valueOf(reqHeader.get(name)));
            }
        }
        try {
            Header[] headers;
            CloseableHttpResponse response = client.execute(request);
            if (HttpUtils.isSuccess((HttpResponse)response)) {
                boolean bl;
                HttpEntity entity = HttpUtils.getEntity((HttpResponse)response);
                if (entity == null) return false;
                InputStream instream = entity.getContent();
                try {
                    bl = callback.processResult(instream, HttpUtils.getAllHeaders((HttpResponse)response));
                    if (instream == null) return bl;
                }
                catch (Exception exception) {
                    if (instream == null) return false;
                    instream.close();
                    return false;
                    catch (Throwable throwable) {
                        if (instream == null) throw throwable;
                        instream.close();
                        throw throwable;
                    }
                }
                instream.close();
                return bl;
            }
            String msg = "httpStatus:" + response.getStatusLine().getStatusCode() + response.getStatusLine().getReasonPhrase() + ", Header: ";
            for (Header header : headers = response.getAllHeaders()) {
                msg = msg + header.getName() + ":" + header.getValue();
            }
            HttpEntity entity = HttpUtils.getEntity((HttpResponse)response);
            if (entity != null) {
                EntityUtils.toString((HttpEntity)entity);
            }
            request.abort();
            return false;
            finally {
                response.close();
            }
        }
        catch (Exception e) {
            request.abort();
        }
        return false;
    }

    private static Map getAllHeaders(HttpResponse response) {
        Header[] headers = response.getAllHeaders();
        CaseInsensitiveMap headerMap = new CaseInsensitiveMap();
        for (Header header : headers) {
            if (!StringUtils.isNotBlank((CharSequence)header.getName()) || !StringUtils.isNotBlank((CharSequence)header.getValue())) continue;
            headerMap.put(header.getName(), header.getValue());
        }
        return headerMap;
    }

    public static Map parseQueryStr(String queryString, String encode) {
        String value;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return map;
        }
        Matcher matcher = QUERY_MAP_PATTERN.matcher(queryString);
        String key = null;
        int end = 0;
        while (matcher.find()) {
            if (key != null) {
                try {
                    value = queryString.substring(end, matcher.start());
                    if (StringUtils.isNotBlank((CharSequence)value)) {
                        value = URLDecoder.decode(value, encode);
                        map.put(key, value);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            key = matcher.group(1);
            end = matcher.end();
        }
        if (key != null) {
            try {
                value = queryString.substring(end);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    value = URLDecoder.decode(value, encode);
                    map.put(key, value);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return map;
    }

    public static Map<String, Integer> getStats(boolean clean) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, AtomicInteger> entry : hostCountMap.entrySet()) {
            Integer value = entry.getValue().get();
            if (value <= 0) continue;
            result.put(entry.getKey(), value);
            if (!clean) continue;
            entry.getValue().addAndGet(-value.intValue());
        }
        return result;
    }

    private static HttpEntity getEntity(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        Header header = entity.getContentEncoding();
        if (header != null) {
            for (HeaderElement element : header.getElements()) {
                if (element.getName().toLowerCase().indexOf("gzip") == -1) continue;
                entity = new GzipDecompressingEntity(entity);
                break;
            }
        }
        return entity;
    }

    private static void hostCount(HttpUriRequest request) {
        try {
            if (request == null) {
                return;
            }
            if (request.getURI() == null || StringUtils.isBlank((CharSequence)request.getURI().getHost())) {
                return;
            }
            URI uri = request.getURI();
            int port = uri.getPort();
            String host = uri.getScheme() + "://" + uri.getHost() + (port == -1 ? "" : ":" + port) + uri.getPath();
            AtomicInteger al = hostCountMap.get(host);
            if (al == null) {
                al = new AtomicInteger(0);
                hostCountMap.put(host, al);
            }
            al.incrementAndGet();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        SSLUtilities.trustAllHostnames();
        SSLUtilities.trustAllHttpsCertificates();
        defaultRequestConfig = RequestConfig.custom().setCookieSpec("best-match").setExpectContinueEnabled(false).setStaleConnectionCheckEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setRedirectsEnabled(true).setConnectionRequestTimeout(500).setConnectTimeout(10000).setSocketTimeout(120000).build();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)HttpUtils.getSSLConnectionSocketFactory()).build();
        cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        cm.setMaxTotal(3000);
        cm.setDefaultMaxPerRoute(800);
        scheduExec = Executors.newScheduledThreadPool(3);
        scheduExec.scheduleWithFixedDelay(new LogHostCountCommand(), 1L, 1200L, TimeUnit.SECONDS);
        scheduExec.scheduleWithFixedDelay(new IdleConnectionEvictorCommand(), 1L, 300L, TimeUnit.SECONDS);
        QUERY_MAP_PATTERN = Pattern.compile("&?([^=&]+)=");
    }

    private static class IdleConnectionEvictorCommand
    implements Runnable {
        private IdleConnectionEvictorCommand() {
        }

        @Override
        public void run() {
            cm.closeExpiredConnections();
            PoolStats poolStats = cm.getTotalStats();
        }
    }

    private static class LogHostCountCommand
    implements Runnable {
        private LogHostCountCommand() {
        }

        @Override
        public void run() {
            Map<String, Integer> stats = HttpUtils.getStats(true);
            if (!stats.isEmpty()) {
                // empty if block
            }
        }
    }

    public static class FileRequestCallback
    implements RequestCallback {
        private File file;

        public FileRequestCallback(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean processResult(InputStream stream, Map headerMap) {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(this.file);
                IOUtils.copy((InputStream)stream, (OutputStream)os);
                ((OutputStream)os).close();
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                }
                catch (Exception exception) {}
            }
            return false;
        }
    }

    private static class MyDefaultRedirectStrategy
    extends DefaultRedirectStrategy {
        private MyDefaultRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
            int responseCode;
            boolean isRedirect = false;
            try {
                isRedirect = super.isRedirected(request, response, context);
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
            if (!(isRedirect || (responseCode = response.getStatusLine().getStatusCode()) != 301 && responseCode != 302)) {
                return true;
            }
            return isRedirect;
        }
    }
}

