/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.service;

import com.alibaba.fastjson.TypeReference;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.http.HttpResult;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.http.HttpUtils;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.sec.ApiSign;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.support.ResultCode;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.util.DateUtil;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.util.FastJsonUtil;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkHotMovieVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieCinemaListVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieCinemaVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieCityPlaydateVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieCityVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieCountyVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieLockResVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieMovieVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieOpiV2ListVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieOpiV3ListVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieOrderVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMoviePlayCinemaVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieSeatVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.XkMovieVo;
import com.yqbsoft.laser.service.ext.data.xuankua.service.xuankua.vo.drama.AuthCodeDomain;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class XuankuaService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String url = "https://test-open.xuankua.cn/route";
    public static final String jumpUrl = "https://testwap.mayiufu.com/rencaiyx/index";
    public static final String appkey = "rencaiyx";
    public static final String privatekey = "VHJDVOXRRILPMDPC34TE7BPWDYBRWUF8";
    private String pushUrl;
    private static Map<String, String> orderStatusMap = new ConcurrentHashMap<String, String>();

    private Map<String, String> getCommon(String method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("signmethod", "md5");
        params.put("method", method);
        params.put("v", "1.0");
        params.put("timestamp", DateUtil.getCurFullTimestampStr());
        return params;
    }

    private <T> ResultCode<T> getRes(Map<String, String> params, Class<T> clazz) {
        params.put("appkey", appkey);
        String sign = ApiSign.signMD5(params, privatekey);
        params.put("sign", sign);
        HttpResult result = null;
        for (int i = 0; i < 3 && !(result = HttpUtils.postUrlAsString(url, params)).isSuccess(); ++i) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!result.isSuccess()) {
            return ResultCode.getFailure(result.getStatus() + "", result.getMsg());
        }
        String response = result.getResponse();
        XkMovieVo vo = (XkMovieVo)FastJsonUtil.parseObject(response, new TypeReference<XkMovieVo<T>>(new Type[]{clazz}){});
        if (!vo.isSuccess()) {
            if (vo.getError() == null) {
                this.logger.warn("xk\u63a5\u53e3\u5f02\u5e38\uff1a{},{}", (Object)params.toString(), (Object)response);
                return ResultCode.getFailure("\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
            }
            return ResultCode.getFailure(vo.getError().getCode() + "", vo.getError().getDesp());
        }
        return ResultCode.getSuccessReturn(vo.getData());
    }

    public ResultCode<XkMovieCityVo> getCityList() {
        Map<String, String> params = this.getCommon("xuankua.city.list");
        return this.getRes(params, XkMovieCityVo.class);
    }

    public ResultCode<XkMovieCountyVo> getCountyList(Integer cityCode) {
        Map<String, String> params = this.getCommon("xuankua.county.list");
        params.put("citycode", cityCode + "");
        return this.getRes(params, XkMovieCountyVo.class);
    }

    public ResultCode<XkHotMovieVo> getHotMovie(Integer cityCode) {
        Map<String, String> params = this.getCommon("xuankua.movie.hot.list");
        params.put("citycode", cityCode + "");
        return this.getRes(params, XkHotMovieVo.class);
    }

    public ResultCode<XkHotMovieVo> getFutureMovie(Integer cityCode) {
        Map<String, String> params = this.getCommon("xuankua.movie.future.list");
        params.put("citycode", cityCode + "");
        return this.getRes(params, XkHotMovieVo.class);
    }

    public ResultCode<XkMovieMovieVo> getMovieDetail(Integer movieId, Integer cityCode) {
        Map<String, String> params = this.getCommon("xuankua.movie.detail");
        params.put("movieid", movieId + "");
        params.put("citycode", cityCode + "");
        return this.getRes(params, XkMovieMovieVo.class);
    }

    public ResultCode<AuthCodeDomain> getAuthcode(String userPhone) {
        Map<String, String> params = this.getCommon("xuankua.member.get.authcode");
        params.put("mobile", userPhone);
        return this.getRes(params, AuthCodeDomain.class);
    }

    public ResultCode<XkMovieCinemaVo> getCinemaDetail(Integer cinemaId) {
        Map<String, String> params = this.getCommon("xuankua.cinema.detail");
        params.put("cinemaid", cinemaId + "");
        return this.getRes(params, XkMovieCinemaVo.class);
    }

    public ResultCode<XkMovieCinemaListVo> getCinemaList(Integer citycode, Integer pageNo) {
        Map<String, String> params = this.getCommon("xuankua.cinema.list");
        params.put("citycode", citycode + "");
        params.put("page_no", pageNo + "");
        params.put("per", "100");
        return this.getRes(params, XkMovieCinemaListVo.class);
    }

    public ResultCode<XkMoviePlayCinemaVo> getMoviePlayCinemaList(Integer cityCode, Integer movieId, String playdate) {
        Map<String, String> params = this.getCommon("xuankua.movie.play.cinema.list");
        params.put("citycode", cityCode + "");
        params.put("movieid", movieId + "");
        params.put("playdate", playdate);
        return this.getRes(params, XkMoviePlayCinemaVo.class);
    }

    public ResultCode<XkMovieOpiV2ListVo> getOpiList(Integer cinemaId) {
        Map<String, String> params = this.getCommon("xuankua.opi.list.v2");
        params.put("cinemaid", cinemaId + "");
        return this.getRes(params, XkMovieOpiV2ListVo.class);
    }

    public ResultCode<XkMovieOpiV3ListVo> getOpiV3List(Integer cinemaId) {
        Map<String, String> params = this.getCommon("xuankua.opi.list.v3");
        params.put("cinemaid", cinemaId + "");
        return this.getRes(params, XkMovieOpiV3ListVo.class);
    }

    public ResultCode<XkMovieCityPlaydateVo> getCityMoviePlaydateList(Integer cityCode, Integer movieId) {
        Map<String, String> params = this.getCommon("xuankua.movie.city.playdate.list");
        params.put("citycode", cityCode + "");
        params.put("movieid", movieId + "");
        return this.getRes(params, XkMovieCityPlaydateVo.class);
    }

    public ResultCode<XkMovieSeatVo> getSeatMap(String opiid) {
        Map<String, String> params = this.getCommon("xuankua.opi.seat");
        params.put("opiid", opiid);
        return this.getRes(params, XkMovieSeatVo.class);
    }

    public ResultCode<XkMovieLockResVo> lockSeat(String opiid, String seatids, String seatnames, String mobile) {
        Map<String, String> params = this.getCommon("xuankua.order.create.v2");
        params.put("opiid", opiid);
        params.put("seatids", seatids);
        params.put("seatnames", seatnames);
        params.put("mobile", mobile);
        params.put("checkUnpaid", "N");
        params.put("checkTicking", "N");
        params.put("pushUrl", this.pushUrl);
        return this.getRes(params, XkMovieLockResVo.class);
    }

    public ResultCode<String> sellSeat(String xkTradeno, String partnerTradeno) {
        Map<String, String> params = this.getCommon("xuankua.order.pay.notify");
        params.put("tradeno", xkTradeno);
        params.put("partner_tradeno", partnerTradeno);
        return this.getRes(params, String.class);
    }

    public ResultCode<String> cancelOrder(String xkTradeno) {
        Map<String, String> params = this.getCommon("xuankua.order.cancel");
        params.put("tradeno", xkTradeno);
        return this.getRes(params, String.class);
    }

    public ResultCode<XkMovieOrderVo> getOrderDetail(String xkTradeno) {
        Map<String, String> params = this.getCommon("xuankua.order.detail.v2");
        params.put("tradeno", xkTradeno);
        return this.getRes(params, XkMovieOrderVo.class);
    }

    public boolean isValidSign(Map<String, String> params) {
        String signx = ApiSign.signMD5(params, privatekey);
        String sign = MapUtils.getString(params, (Object)"sign");
        return StringUtils.equalsIgnoreCase((CharSequence)sign, (CharSequence)signx);
    }

    static {
        orderStatusMap.put("N", "\u5f85\u652f\u4ed8");
        orderStatusMap.put("C", "\u5df2\u53d6\u6d88");
        orderStatusMap.put("E", "\u8ba2\u5355\u6709\u6548\u671f\u8fc7\u540e,\u6ca1\u6709\u6536\u5230\u4ed8\u6b3e\u901a\u77e5");
        orderStatusMap.put("P", "\u5df2\u4ed8\u6b3e");
        orderStatusMap.put("T", "\u901a\u77e5\u5904\u7406\u4e2d");
        orderStatusMap.put("S", "\u51fa\u7968\u6210\u529f");
        orderStatusMap.put("R", "\u9000\u6b3e\u5b8c\u6210");
    }
}

