/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRefundCtrlMapper;
import com.yqbsoft.laser.service.contract.domain.OcRefundCtrlCflowDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundCtrlDomain;
import com.yqbsoft.laser.service.contract.model.OcRefundCtrl;
import com.yqbsoft.laser.service.contract.refundes.RefundEsPollThread;
import com.yqbsoft.laser.service.contract.refundes.RefundEsPutThread;
import com.yqbsoft.laser.service.contract.refundes.RefundEsService;
import com.yqbsoft.laser.service.contract.service.OcRefundCtrlService;
import com.yqbsoft.laser.service.contract.service.OcRefundEngineService;
import com.yqbsoft.laser.service.contract.service.OcRefundService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRefundCtrlServiceImpl
extends BaseServiceImpl
implements OcRefundCtrlService {
    private static final String SYS_CODE = "oc.CONTRACT.OcRefundCtrlServiceImpl";
    private static RefundEsService refundEsService;
    private static Object lock;
    private OcRefundCtrlMapper ocRefundCtrlMapper;

    public void setOcRefundCtrlMapper(OcRefundCtrlMapper ocRefundCtrlMapper) {
        this.ocRefundCtrlMapper = ocRefundCtrlMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRefundCtrlMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundCtrlServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRefundCtrl(OcRefundCtrlDomain ocRefundCtrlDomain) {
        if (null == ocRefundCtrlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundCtrlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRefundCtrlDefault(OcRefundCtrl ocRefundCtrl) {
        if (null == ocRefundCtrl) {
            return;
        }
        if (null == ocRefundCtrl.getDataState()) {
            ocRefundCtrl.setDataState(0);
        }
        if (null == ocRefundCtrl.getGmtCreate()) {
            ocRefundCtrl.setGmtCreate(this.getSysDate());
        }
        ocRefundCtrl.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocRefundCtrl.getRefundCtrlSeqno())) {
            ocRefundCtrl.setRefundCtrlSeqno(this.createUUIDString());
        }
    }

    private int getRefundCtrlMaxCode() {
        int code = 0;
        try {
            return this.ocRefundCtrlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundCtrlServiceImpl.getRefundCtrlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRefundCtrlUpdataDefault(OcRefundCtrl ocRefundCtrl) {
        if (null == ocRefundCtrl) {
            return;
        }
        ocRefundCtrl.setGmtModified(this.getSysDate());
    }

    private void saveRefundCtrlModel(OcRefundCtrl ocRefundCtrl) throws ApiException {
        if (null == ocRefundCtrl) {
            return;
        }
        try {
            this.ocRefundCtrlMapper.insert(ocRefundCtrl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.saveRefundCtrlModel.ex", (Throwable)e);
        }
    }

    private OcRefundCtrl getRefundCtrlModelById(Integer refundCtrlId) {
        if (null == refundCtrlId) {
            return null;
        }
        try {
            return this.ocRefundCtrlMapper.selectByPrimaryKey(refundCtrlId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundCtrlServiceImpl.getRefundCtrlModelById", (Throwable)e);
            return null;
        }
    }

    public OcRefundCtrl getRefundCtrlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRefundCtrlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundCtrlServiceImpl.getRefundCtrlModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRefundCtrlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundCtrlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.delRefundCtrlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.delRefundCtrlModelByCode.num");
        }
    }

    private void deleteRefundCtrlModel(Integer refundCtrlId) throws ApiException {
        if (null == refundCtrlId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundCtrlMapper.deleteByPrimaryKey(refundCtrlId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.deleteRefundCtrlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.deleteRefundCtrlModel.num");
        }
    }

    private void updateRefundCtrlModel(OcRefundCtrl ocRefundCtrl) throws ApiException {
        if (null == ocRefundCtrl) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundCtrlMapper.updateByPrimaryKeySelective(ocRefundCtrl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.updateRefundCtrlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.updateRefundCtrlModel.num");
        }
    }

    private void updateStateRefundCtrlModel(Integer refundCtrlId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == refundCtrlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCtrlId", refundCtrlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRefundCtrlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.updateStateRefundCtrlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.updateStateRefundCtrlModel.null");
        }
    }

    private void updateUStateByBillCodeModel(String refundCode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRefundCtrlMapper.updateUStateByBillCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.updateUStateByBillCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.updateUStateByBillCodeModel.null");
        }
    }

    private OcRefundCtrl makeRefundCtrl(OcRefundCtrlDomain ocRefundCtrlDomain, OcRefundCtrl ocRefundCtrl) {
        if (null == ocRefundCtrlDomain) {
            return null;
        }
        if (null == ocRefundCtrl) {
            ocRefundCtrl = new OcRefundCtrl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundCtrl, (Object)ocRefundCtrlDomain);
            return ocRefundCtrl;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundCtrlServiceImpl.makeRefundCtrl", (Throwable)e);
            return null;
        }
    }

    private List<OcRefundCtrl> queryRefundCtrlModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRefundCtrlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundCtrlServiceImpl.queryRefundCtrlModel", (Throwable)e);
            return null;
        }
    }

    private int countRefundCtrl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRefundCtrlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundCtrlServiceImpl.countRefundCtrl", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveRefundCtrl(OcRefundCtrlDomain ocRefundCtrlDomain) throws ApiException {
        String msg = this.checkRefundCtrl(ocRefundCtrlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.saveRefundCtrl.checkRefundCtrl", msg);
        }
        OcRefundCtrl ocRefundCtrl = this.makeRefundCtrl(ocRefundCtrlDomain, null);
        this.setRefundCtrlDefault(ocRefundCtrl);
        this.saveRefundCtrlModel(ocRefundCtrl);
        return ocRefundCtrl.getRefundCtrlSeqno();
    }

    @Override
    public void updateRefundCtrlState(Integer refundCtrlId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundCtrlModel(refundCtrlId, dataState, oldDataState);
    }

    @Override
    public void updateRefundCtrl(OcRefundCtrlDomain ocRefundCtrlDomain) throws ApiException {
        String msg = this.checkRefundCtrl(ocRefundCtrlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.updateRefundCtrl.checkRefundCtrl", msg);
        }
        OcRefundCtrl oldOcRefundCtrl = this.getRefundCtrlModelById(ocRefundCtrlDomain.getRefundCtrlId());
        if (null == oldOcRefundCtrl) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.updateRefundCtrl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRefundCtrl ocRefundCtrl = this.makeRefundCtrl(ocRefundCtrlDomain, oldOcRefundCtrl);
        this.setRefundCtrlUpdataDefault(ocRefundCtrl);
        this.updateRefundCtrlModel(ocRefundCtrl);
    }

    @Override
    public OcRefundCtrl getRefundCtrl(Integer refundCtrlId) {
        return this.getRefundCtrlModelById(refundCtrlId);
    }

    @Override
    public void deleteRefundCtrl(Integer refundCtrlId) throws ApiException {
        this.deleteRefundCtrlModel(refundCtrlId);
    }

    @Override
    public QueryResult<OcRefundCtrl> queryRefundCtrlPage(Map<String, Object> map) {
        List<OcRefundCtrl> ocRefundCtrlList = this.queryRefundCtrlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefundCtrl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundCtrlList);
        return queryResult;
    }

    @Override
    public OcRefundCtrl getRefundCtrlByCode(Map<String, Object> map) {
        return this.getRefundCtrlModelByCode(map);
    }

    @Override
    public OcRefundCtrl getRefundCtrlByRefundCode(String refundCode, String tenantCode) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", tenantCode);
        List<OcRefundCtrl> list = this.queryRefundCtrlModelPage(map);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public void delRefundCtrlByCode(Map<String, Object> map) throws ApiException {
        this.delRefundCtrlModelByCode(map);
    }

    @Override
    public void updateRefundCtrlCflow(OcRefundCtrlCflowDomain ocRefundCtrlCflowDomain) {
        if (null == ocRefundCtrlCflowDomain) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.updateRefundCtrlRecflow.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCtrlSeqno", ocRefundCtrlCflowDomain.getRefundCtrlSeqno());
        map.put("tenantCode", ocRefundCtrlCflowDomain.getTenantCode());
        OcRefundCtrl ocRefundCtrl = this.getRefundCtrlModelByCode(map);
        if (null == ocRefundCtrl) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.updateRefundCtrlRecflow.modelnull", ((Object)map).toString());
        }
        ocRefundCtrl.setRecflowCode(ocRefundCtrlCflowDomain.getRecflowCode());
        ocRefundCtrl.setRecflowNodeCode(ocRefundCtrlCflowDomain.getRecflowNodeCode());
        ocRefundCtrl.setRecflowPprocessCode(ocRefundCtrlCflowDomain.getRecflowPprocessCode());
        if (null != ocRefundCtrlCflowDomain.getDataState()) {
            ocRefundCtrl.setDataState(ocRefundCtrlCflowDomain.getDataState());
        }
        this.updateRefundCtrlModel(ocRefundCtrl);
    }

    @Override
    public void updateRefundCtrluStateByRefundCode(String refundCode, String tenantCode, Integer dataState, Integer oldDataState) {
        this.updateUStateByBillCodeModel(refundCode, tenantCode, dataState, oldDataState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RefundEsService getRefundEsService() {
        Object object = lock;
        synchronized (object) {
            if (null == refundEsService) {
                refundEsService = new RefundEsService((OcRefundEngineService)SpringApplicationContextUtil.getBean((String)"ocRefundEngineService"));
                for (int i = 0; i < 20; ++i) {
                    refundEsService.addPollPool(new RefundEsPollThread(refundEsService));
                }
            }
            return refundEsService;
        }
    }

    @Override
    public void loadRefundCtrlProcess() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<OcRefundCtrl> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = OcRefundCtrlServiceImpl.getRefundEsService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", OcRefundCtrlServiceImpl.getRefundEsService().getPage());
                result = this.queryRefundCtrlPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    OcRefundCtrlServiceImpl.getRefundEsService().addPutPool(new RefundEsPutThread(OcRefundCtrlServiceImpl.getRefundEsService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), result.getRows()));
                    if (result.getRows().size() == OcRefundCtrlServiceImpl.getRefundEsService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            OcRefundCtrlServiceImpl.getRefundEsService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundCtrlServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    static {
        lock = new Object();
    }
}

