/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcNvrMapper;
import com.yqbsoft.laser.service.contract.domain.OcNvrDomain;
import com.yqbsoft.laser.service.contract.domain.OcNvrReDomain;
import com.yqbsoft.laser.service.contract.model.OcNvr;
import com.yqbsoft.laser.service.contract.service.OcNvrService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcNvrServiceImpl
extends BaseServiceImpl
implements OcNvrService {
    private static final String SYS_CODE = "oc.CONTRACT.OcNvrServiceImpl";
    private OcNvrMapper ocNvrMapper;

    public void setOcNvrMapper(OcNvrMapper ocNvrMapper) {
        this.ocNvrMapper = ocNvrMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocNvrMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcNvrServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checknvr(OcNvrDomain ocNvrDomain) {
        if (null == ocNvrDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocNvrDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setnvrDefault(OcNvr ocNvr) {
        if (null == ocNvr) {
            return;
        }
        if (null == ocNvr.getDataState()) {
            ocNvr.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocNvr.getGmtCreate()) {
            ocNvr.setGmtCreate(date);
        }
        ocNvr.setGmtModified(date);
        if (StringUtils.isBlank((String)ocNvr.getNvrCode())) {
            ocNvr.setNvrCode(this.getNo(null, "OcNvr", "ocNvr", ocNvr.getTenantCode()));
        }
    }

    private int getnvrMaxCode() {
        int code = 0;
        try {
            return this.ocNvrMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcNvrServiceImpl.getnvrMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setnvrUpdataDefault(OcNvr ocNvr) {
        if (null == ocNvr) {
            return;
        }
        ocNvr.setGmtModified(this.getSysDate());
    }

    private void savenvrModel(OcNvr ocNvr) throws ApiException {
        if (null == ocNvr) {
            return;
        }
        try {
            this.ocNvrMapper.insert(ocNvr);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.savenvrModel.ex", (Throwable)e);
        }
    }

    private void savenvrBatchModel(List<OcNvr> ocNvrList) throws ApiException {
        if (null == ocNvrList || ocNvrList.isEmpty()) {
            return;
        }
        try {
            this.ocNvrMapper.insertBatch(ocNvrList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.savenvrBatchModel.ex", (Throwable)e);
        }
    }

    private OcNvr getnvrModelById(Integer nvrId) {
        if (null == nvrId) {
            return null;
        }
        try {
            return this.ocNvrMapper.selectByPrimaryKey(nvrId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcNvrServiceImpl.getnvrModelById", (Throwable)e);
            return null;
        }
    }

    private OcNvr getnvrModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocNvrMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcNvrServiceImpl.getnvrModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delnvrModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocNvrMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.delnvrModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.delnvrModelByCode.num");
        }
    }

    private void deletenvrModel(Integer nvrId) throws ApiException {
        if (null == nvrId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocNvrMapper.deleteByPrimaryKey(nvrId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.deletenvrModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.deletenvrModel.num");
        }
    }

    private void updatenvrModel(OcNvr ocNvr) throws ApiException {
        if (null == ocNvr) {
            return;
        }
        int i = 0;
        try {
            i = this.ocNvrMapper.updateByPrimaryKey(ocNvr);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.updatenvrModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.updatenvrModel.num");
        }
    }

    private void updateStatenvrModel(Integer nvrId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == nvrId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nvrId", nvrId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocNvrMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.updateStatenvrModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.updateStatenvrModel.null");
        }
    }

    private void updateStatenvrModelByCode(String tenantCode, String nvrCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)nvrCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("nvrCode", nvrCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocNvrMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.updateStatenvrModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.updateStatenvrModelByCode.null");
        }
    }

    private OcNvr makenvr(OcNvrDomain ocNvrDomain, OcNvr ocNvr) {
        if (null == ocNvrDomain) {
            return null;
        }
        if (null == ocNvr) {
            ocNvr = new OcNvr();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocNvr, (Object)ocNvrDomain);
            return ocNvr;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcNvrServiceImpl.makenvr", (Throwable)e);
            return null;
        }
    }

    private OcNvrReDomain makeOcNvrReDomain(OcNvr ocNvr) {
        if (null == ocNvr) {
            return null;
        }
        OcNvrReDomain ocNvrReDomain = new OcNvrReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocNvrReDomain, (Object)ocNvr);
            return ocNvrReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcNvrServiceImpl.makeOcNvrReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcNvr> querynvrModelPage(Map<String, Object> parammap) {
        try {
            return this.ocNvrMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcNvrServiceImpl.querynvrModel", (Throwable)e);
            return null;
        }
    }

    private int countnvr(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocNvrMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcNvrServiceImpl.countnvr", (Throwable)e);
        }
        return i;
    }

    private OcNvr createOcNvr(OcNvrDomain ocNvrDomain) {
        String msg = this.checknvr(ocNvrDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.savenvr.checknvr", msg);
        }
        OcNvr ocNvr = this.makenvr(ocNvrDomain, null);
        this.setnvrDefault(ocNvr);
        return ocNvr;
    }

    @Override
    public String savenvr(OcNvrDomain ocNvrDomain) throws ApiException {
        OcNvr ocNvr = this.createOcNvr(ocNvrDomain);
        this.savenvrModel(ocNvr);
        return ocNvr.getNvrCode();
    }

    @Override
    public String savenvrBatch(List<OcNvrDomain> ocNvrDomainList) throws ApiException {
        if (null == ocNvrDomainList || ocNvrDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcNvr> ocNvrList = new ArrayList<OcNvr>();
        String code = "";
        for (OcNvrDomain ocNvrDomain : ocNvrDomainList) {
            OcNvr ocNvr = this.createOcNvr(ocNvrDomain);
            code = ocNvr.getNvrCode();
            ocNvrList.add(ocNvr);
        }
        this.savenvrBatchModel(ocNvrList);
        return code;
    }

    @Override
    public void updatenvrState(Integer nvrId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == nvrId) {
            return;
        }
        this.updateStatenvrModel(nvrId, dataState, oldDataState, map);
    }

    @Override
    public void updatenvrStateByCode(String tenantCode, String nvrCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)nvrCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatenvrModelByCode(tenantCode, nvrCode, dataState, oldDataState, map);
    }

    @Override
    public void updatenvr(OcNvrDomain ocNvrDomain) throws ApiException {
        String msg = this.checknvr(ocNvrDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.updatenvr.checknvr", msg);
        }
        OcNvr oldOcNvr = this.getnvrModelById(ocNvrDomain.getNvrId());
        if (null == oldOcNvr) {
            throw new ApiException("oc.CONTRACT.OcNvrServiceImpl.updatenvr.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcNvr ocNvr = this.makenvr(ocNvrDomain, oldOcNvr);
        this.setnvrUpdataDefault(ocNvr);
        this.updatenvrModel(ocNvr);
    }

    @Override
    public OcNvr getnvr(Integer nvrId) {
        if (null == nvrId) {
            return null;
        }
        return this.getnvrModelById(nvrId);
    }

    @Override
    public void deletenvr(Integer nvrId) throws ApiException {
        if (null == nvrId) {
            return;
        }
        this.deletenvrModel(nvrId);
    }

    @Override
    public QueryResult<OcNvr> querynvrPage(Map<String, Object> map) {
        List<OcNvr> ocNvrList = this.querynvrModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countnvr(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocNvrList);
        return queryResult;
    }

    @Override
    public OcNvr getnvrByCode(String tenantCode, String nvrCode) throws ApiException {
        if (StringUtils.isBlank((String)nvrCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("nvrCode", nvrCode);
        return this.getnvrModelByCode(map);
    }

    @Override
    public void deletenvrByCode(String tenantCode, String nvrCode) throws ApiException {
        if (StringUtils.isBlank((String)nvrCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("nvrCode", nvrCode);
        this.delnvrModelByCode(map);
    }
}

