/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOrderLogMapper;
import com.yqbsoft.laser.service.data.domain.DaOrderLogDomain;
import com.yqbsoft.laser.service.data.domain.DaOrderLogReDomain;
import com.yqbsoft.laser.service.data.model.DaOrderLog;
import com.yqbsoft.laser.service.data.service.DaOrderLogService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaOrderLogServiceImpl
extends BaseServiceImpl
implements DaOrderLogService {
    private static final String SYS_CODE = "da.DaOrderLogServiceImpl";
    private DaOrderLogMapper daOrderLogMapper;

    public void setDaOrderLogMapper(DaOrderLogMapper daOrderLogMapper) {
        this.daOrderLogMapper = daOrderLogMapper;
    }

    private Date getSysDate() {
        try {
            return this.daOrderLogMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaOrderLogServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOrderLog(DaOrderLogDomain daOrderLogDomain) {
        if (null == daOrderLogDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOrderLogDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOrderLogDefault(DaOrderLog daOrderLog) {
        if (null == daOrderLog) {
            return;
        }
        if (null == daOrderLog.getDataState()) {
            daOrderLog.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOrderLog.getGmtCreate()) {
            daOrderLog.setGmtCreate(date);
        }
        daOrderLog.setGmtModified(date);
        if (StringUtils.isBlank((String)daOrderLog.getLogCode())) {
            daOrderLog.setLogCode(this.getNo(null, "DaOrderLog", "daOrderLog", daOrderLog.getTenantCode()));
        }
    }

    private int getOrderLogMaxCode() {
        int code = 0;
        try {
            return this.daOrderLogMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaOrderLogServiceImpl.getOrderLogMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOrderLogUpdataDefault(DaOrderLog daOrderLog) {
        if (null == daOrderLog) {
            return;
        }
        daOrderLog.setGmtModified(this.getSysDate());
    }

    private void saveOrderLogModel(DaOrderLog daOrderLog) throws ApiException {
        if (null == daOrderLog) {
            return;
        }
        try {
            this.daOrderLogMapper.insert(daOrderLog);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOrderLogServiceImpl.saveOrderLogModel.ex", (Throwable)e);
        }
    }

    private void saveOrderLogBatchModel(List<DaOrderLog> daOrderLogList) throws ApiException {
        if (null == daOrderLogList || daOrderLogList.isEmpty()) {
            return;
        }
        try {
            this.daOrderLogMapper.insertBatch(daOrderLogList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOrderLogServiceImpl.saveOrderLogBatchModel.ex", (Throwable)e);
        }
    }

    private DaOrderLog getOrderLogModelById(Integer daOrderLogId) {
        if (null == daOrderLogId) {
            return null;
        }
        try {
            return this.daOrderLogMapper.selectByPrimaryKey(daOrderLogId);
        }
        catch (Exception e) {
            this.logger.error("da.DaOrderLogServiceImpl.getOrderLogModelById", (Throwable)e);
            return null;
        }
    }

    private DaOrderLog getOrderLogModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daOrderLogMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOrderLogServiceImpl.getOrderLogModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOrderLogModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderLogMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOrderLogServiceImpl.delOrderLogModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOrderLogServiceImpl.delOrderLogModelByCode.num");
        }
    }

    private void deleteOrderLogModel(Integer daOrderLogId) throws ApiException {
        if (null == daOrderLogId) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderLogMapper.deleteByPrimaryKey(daOrderLogId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOrderLogServiceImpl.deleteOrderLogModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOrderLogServiceImpl.deleteOrderLogModel.num");
        }
    }

    private void updateOrderLogModel(DaOrderLog daOrderLog) throws ApiException {
        if (null == daOrderLog) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderLogMapper.updateByPrimaryKey(daOrderLog);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOrderLogServiceImpl.updateOrderLogModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaOrderLogServiceImpl.updateOrderLogModel.num");
        }
    }

    private void updateStateOrderLogModel(Integer daOrderLogId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == daOrderLogId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("daOrderLogId", daOrderLogId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOrderLogMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOrderLogServiceImpl.updateStateOrderLogModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOrderLogServiceImpl.updateStateOrderLogModel.null");
        }
    }

    private void updateStateOrderLogModelByCode(String tenantCode, String daOrderLogCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)daOrderLogCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("daOrderLogCode", daOrderLogCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOrderLogMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaOrderLogServiceImpl.updateStateOrderLogModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaOrderLogServiceImpl.updateStateOrderLogModelByCode.null");
        }
    }

    private DaOrderLog makeOrderLog(DaOrderLogDomain daOrderLogDomain, DaOrderLog daOrderLog) {
        if (null == daOrderLogDomain) {
            return null;
        }
        if (null == daOrderLog) {
            daOrderLog = new DaOrderLog();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOrderLog, (Object)daOrderLogDomain);
            return daOrderLog;
        }
        catch (Exception e) {
            this.logger.error("da.DaOrderLogServiceImpl.makeOrderLog", (Throwable)e);
            return null;
        }
    }

    private DaOrderLogReDomain makeDaOrderLogReDomain(DaOrderLog daOrderLog) {
        if (null == daOrderLog) {
            return null;
        }
        DaOrderLogReDomain daOrderLogReDomain = new DaOrderLogReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOrderLogReDomain, (Object)daOrderLog);
            return daOrderLogReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaOrderLogServiceImpl.makeDaOrderLogReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaOrderLog> queryOrderLogModelPage(Map<String, Object> parammap) {
        try {
            return this.daOrderLogMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaOrderLogServiceImpl.queryOrderLogModel", (Throwable)e);
            return null;
        }
    }

    private int countOrderLog(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOrderLogMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaOrderLogServiceImpl.countOrderLog", (Throwable)e);
        }
        return i;
    }

    private DaOrderLog createDaOrderLog(DaOrderLogDomain daOrderLogDomain) {
        String msg = this.checkOrderLog(daOrderLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOrderLogServiceImpl.saveOrderLog.checkOrderLog", msg);
        }
        DaOrderLog daOrderLog = this.makeOrderLog(daOrderLogDomain, null);
        this.setOrderLogDefault(daOrderLog);
        return daOrderLog;
    }

    @Override
    public String saveOrderLog(DaOrderLogDomain daOrderLogDomain) throws ApiException {
        DaOrderLog daOrderLog = this.createDaOrderLog(daOrderLogDomain);
        this.saveOrderLogModel(daOrderLog);
        return daOrderLog.getLogCode();
    }

    @Override
    public String saveOrderLogBatch(List<DaOrderLogDomain> daOrderLogDomainList) throws ApiException {
        if (null == daOrderLogDomainList || daOrderLogDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOrderLog> daOrderLogList = new ArrayList<DaOrderLog>();
        String code = "";
        for (DaOrderLogDomain daOrderLogDomain : daOrderLogDomainList) {
            DaOrderLog daOrderLog = this.createDaOrderLog(daOrderLogDomain);
            code = daOrderLog.getLogCode();
            daOrderLogList.add(daOrderLog);
        }
        this.saveOrderLogBatchModel(daOrderLogList);
        return code;
    }

    @Override
    public void updateOrderLogState(Integer daOrderLogId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == daOrderLogId) {
            return;
        }
        this.updateStateOrderLogModel(daOrderLogId, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderLogStateByCode(String tenantCode, String daOrderLogCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)daOrderLogCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOrderLogModelByCode(tenantCode, daOrderLogCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderLog(DaOrderLogDomain daOrderLogDomain) throws ApiException {
        String msg = this.checkOrderLog(daOrderLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaOrderLogServiceImpl.updateOrderLog.checkOrderLog", msg);
        }
        DaOrderLog oldDaOrderLog = this.getOrderLogModelById(daOrderLogDomain.getLogId());
        if (null == oldDaOrderLog) {
            throw new ApiException("da.DaOrderLogServiceImpl.updateOrderLog.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOrderLog daOrderLog = this.makeOrderLog(daOrderLogDomain, oldDaOrderLog);
        this.setOrderLogUpdataDefault(daOrderLog);
        this.updateOrderLogModel(daOrderLog);
    }

    @Override
    public DaOrderLog getOrderLog(Integer daOrderLogId) {
        if (null == daOrderLogId) {
            return null;
        }
        return this.getOrderLogModelById(daOrderLogId);
    }

    @Override
    public void deleteOrderLog(Integer daOrderLogId) throws ApiException {
        if (null == daOrderLogId) {
            return;
        }
        this.deleteOrderLogModel(daOrderLogId);
    }

    @Override
    public QueryResult<DaOrderLog> queryOrderLogPage(Map<String, Object> map) {
        List<DaOrderLog> daOrderLogList = this.queryOrderLogModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderLog(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOrderLogList);
        return queryResult;
    }

    @Override
    public DaOrderLog getOrderLogByCode(String tenantCode, String daOrderLogCode) throws ApiException {
        if (StringUtils.isBlank((String)daOrderLogCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("logCode", daOrderLogCode);
        return this.getOrderLogModelByCode(map);
    }

    @Override
    public void deleteOrderLogByCode(String tenantCode, String daOrderLogCode) throws ApiException {
        if (StringUtils.isBlank((String)daOrderLogCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("daOrderLogCode", daOrderLogCode);
        this.delOrderLogModelByCode(map);
    }
}

