/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaGoodsSellMapper;
import com.yqbsoft.laser.service.data.domain.DaGoodsSellDomain;
import com.yqbsoft.laser.service.data.domain.DaGoodsSellReDomain;
import com.yqbsoft.laser.service.data.model.DaGoodsSell;
import com.yqbsoft.laser.service.data.service.DaGoodsSellService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaGoodsSellServiceImpl
extends BaseServiceImpl
implements DaGoodsSellService {
    private static final String SYS_CODE = "da.DaGoodsSellServiceImpl";
    private DaGoodsSellMapper daGoodsSellMapper;

    public void setDaGoodsSellMapper(DaGoodsSellMapper daGoodsSellMapper) {
        this.daGoodsSellMapper = daGoodsSellMapper;
    }

    private Date getSysDate() {
        try {
            return this.daGoodsSellMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaGoodsSellServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDaGoodsSell(DaGoodsSellDomain daGoodsSellDomain) {
        if (null == daGoodsSellDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daGoodsSellDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDaGoodsSellDefault(DaGoodsSell daGoodsSell) {
        if (null == daGoodsSell) {
            return;
        }
        if (null == daGoodsSell.getDataState()) {
            daGoodsSell.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daGoodsSell.getGmtCreate()) {
            daGoodsSell.setGmtCreate(date);
        }
        daGoodsSell.setGmtModified(date);
        if (StringUtils.isBlank((String)daGoodsSell.getGoodsSellCode())) {
            daGoodsSell.setGoodsSellCode(this.getNo(null, "DaGoodsSell", "daGoodsSell", daGoodsSell.getTenantCode()));
        }
    }

    private int getDaGoodsSellMaxCode() {
        int code = 0;
        try {
            return this.daGoodsSellMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaGoodsSellServiceImpl.getDaGoodsSellMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDaGoodsSellUpdataDefault(DaGoodsSell daGoodsSell) {
        if (null == daGoodsSell) {
            return;
        }
        daGoodsSell.setGmtModified(this.getSysDate());
    }

    private void saveDaGoodsSellModel(DaGoodsSell daGoodsSell) throws ApiException {
        if (null == daGoodsSell) {
            return;
        }
        try {
            this.daGoodsSellMapper.insert(daGoodsSell);
        }
        catch (Exception e) {
            throw new ApiException("da.DaGoodsSellServiceImpl.saveDaGoodsSellModel.ex", (Throwable)e);
        }
    }

    private void saveDaGoodsSellBatchModel(List<DaGoodsSell> daGoodsSellList) throws ApiException {
        if (null == daGoodsSellList || daGoodsSellList.isEmpty()) {
            return;
        }
        try {
            this.daGoodsSellMapper.insertBatch(daGoodsSellList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaGoodsSellServiceImpl.saveDaGoodsSellBatchModel.ex", (Throwable)e);
        }
    }

    private DaGoodsSell getDaGoodsSellModelById(Integer goodsSellId) {
        if (null == goodsSellId) {
            return null;
        }
        try {
            return this.daGoodsSellMapper.selectByPrimaryKey(goodsSellId);
        }
        catch (Exception e) {
            this.logger.error("da.DaGoodsSellServiceImpl.getDaGoodsSellModelById", (Throwable)e);
            return null;
        }
    }

    private DaGoodsSell getDaGoodsSellModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daGoodsSellMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaGoodsSellServiceImpl.getDaGoodsSellModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDaGoodsSellModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daGoodsSellMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaGoodsSellServiceImpl.delDaGoodsSellModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaGoodsSellServiceImpl.delDaGoodsSellModelByCode.num");
        }
    }

    private void deleteDaGoodsSellModel(Integer goodsSellId) throws ApiException {
        if (null == goodsSellId) {
            return;
        }
        int i = 0;
        try {
            i = this.daGoodsSellMapper.deleteByPrimaryKey(goodsSellId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaGoodsSellServiceImpl.deleteDaGoodsSellModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaGoodsSellServiceImpl.deleteDaGoodsSellModel.num");
        }
    }

    private void updateDaGoodsSellModel(DaGoodsSell daGoodsSell) throws ApiException {
        if (null == daGoodsSell) {
            return;
        }
        int i = 0;
        try {
            i = this.daGoodsSellMapper.updateByPrimaryKey(daGoodsSell);
        }
        catch (Exception e) {
            throw new ApiException("da.DaGoodsSellServiceImpl.updateDaGoodsSellModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaGoodsSellServiceImpl.updateDaGoodsSellModel.num");
        }
    }

    private void updateStateDaGoodsSellModel(Integer goodsSellId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == goodsSellId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsSellId", goodsSellId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daGoodsSellMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaGoodsSellServiceImpl.updateStateDaGoodsSellModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaGoodsSellServiceImpl.updateStateDaGoodsSellModel.null");
        }
    }

    private void updateStateDaGoodsSellModelByCode(String tenantCode, String goodsSellCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)goodsSellCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsSellCode", goodsSellCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daGoodsSellMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaGoodsSellServiceImpl.updateStateDaGoodsSellModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaGoodsSellServiceImpl.updateStateDaGoodsSellModelByCode.null");
        }
    }

    private DaGoodsSell makeDaGoodsSell(DaGoodsSellDomain daGoodsSellDomain, DaGoodsSell daGoodsSell) {
        if (null == daGoodsSellDomain) {
            return null;
        }
        if (null == daGoodsSell) {
            daGoodsSell = new DaGoodsSell();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daGoodsSell, (Object)daGoodsSellDomain);
            return daGoodsSell;
        }
        catch (Exception e) {
            this.logger.error("da.DaGoodsSellServiceImpl.makeDaGoodsSell", (Throwable)e);
            return null;
        }
    }

    private DaGoodsSellReDomain makeDaGoodsSellReDomain(DaGoodsSell daGoodsSell) {
        if (null == daGoodsSell) {
            return null;
        }
        DaGoodsSellReDomain daGoodsSellReDomain = new DaGoodsSellReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daGoodsSellReDomain, (Object)daGoodsSell);
            return daGoodsSellReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaGoodsSellServiceImpl.makeDaGoodsSellReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaGoodsSell> queryDaGoodsSellModelPage(Map<String, Object> parammap) {
        try {
            return this.daGoodsSellMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaGoodsSellServiceImpl.queryDaGoodsSellModel", (Throwable)e);
            return null;
        }
    }

    private int countDaGoodsSell(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daGoodsSellMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaGoodsSellServiceImpl.countDaGoodsSell", (Throwable)e);
        }
        return i;
    }

    private DaGoodsSell createDaGoodsSell(DaGoodsSellDomain daGoodsSellDomain) {
        String msg = this.checkDaGoodsSell(daGoodsSellDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaGoodsSellServiceImpl.saveDaGoodsSell.checkDaGoodsSell", msg);
        }
        DaGoodsSell daGoodsSell = this.makeDaGoodsSell(daGoodsSellDomain, null);
        this.setDaGoodsSellDefault(daGoodsSell);
        return daGoodsSell;
    }

    @Override
    public String saveDaGoodsSell(DaGoodsSellDomain daGoodsSellDomain) throws ApiException {
        DaGoodsSell daGoodsSell = this.createDaGoodsSell(daGoodsSellDomain);
        this.saveDaGoodsSellModel(daGoodsSell);
        return daGoodsSell.getGoodsSellCode();
    }

    @Override
    public String saveDaGoodsSellBatch(List<DaGoodsSellDomain> daGoodsSellDomainList) throws ApiException {
        if (null == daGoodsSellDomainList || daGoodsSellDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaGoodsSell> daGoodsSellList = new ArrayList<DaGoodsSell>();
        String code = "";
        for (DaGoodsSellDomain daGoodsSellDomain : daGoodsSellDomainList) {
            DaGoodsSell daGoodsSell = this.createDaGoodsSell(daGoodsSellDomain);
            code = daGoodsSell.getGoodsSellCode();
            daGoodsSellList.add(daGoodsSell);
        }
        this.saveDaGoodsSellBatchModel(daGoodsSellList);
        return code;
    }

    @Override
    public void updateDaGoodsSellState(Integer goodsSellId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == goodsSellId) {
            return;
        }
        this.updateStateDaGoodsSellModel(goodsSellId, dataState, oldDataState, map);
    }

    @Override
    public void updateDaGoodsSellStateByCode(String tenantCode, String goodsSellCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)goodsSellCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDaGoodsSellModelByCode(tenantCode, goodsSellCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDaGoodsSell(DaGoodsSellDomain daGoodsSellDomain) throws ApiException {
        String msg = this.checkDaGoodsSell(daGoodsSellDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaGoodsSellServiceImpl.updateDaGoodsSell.checkDaGoodsSell", msg);
        }
        DaGoodsSell oldDaGoodsSell = this.getDaGoodsSellModelById(daGoodsSellDomain.getGoodsSellId());
        if (null == oldDaGoodsSell) {
            throw new ApiException("da.DaGoodsSellServiceImpl.updateDaGoodsSell.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaGoodsSell daGoodsSell = this.makeDaGoodsSell(daGoodsSellDomain, oldDaGoodsSell);
        this.setDaGoodsSellUpdataDefault(daGoodsSell);
        this.updateDaGoodsSellModel(daGoodsSell);
    }

    @Override
    public DaGoodsSell getDaGoodsSell(Integer goodsSellId) {
        if (null == goodsSellId) {
            return null;
        }
        return this.getDaGoodsSellModelById(goodsSellId);
    }

    @Override
    public void deleteDaGoodsSell(Integer goodsSellId) throws ApiException {
        if (null == goodsSellId) {
            return;
        }
        this.deleteDaGoodsSellModel(goodsSellId);
    }

    @Override
    public QueryResult<DaGoodsSell> queryDaGoodsSellPage(Map<String, Object> map) {
        List<DaGoodsSell> daGoodsSellList = this.queryDaGoodsSellModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDaGoodsSell(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daGoodsSellList);
        return queryResult;
    }

    @Override
    public DaGoodsSell getDaGoodsSellByCode(String tenantCode, String goodsSellCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsSellCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsSellCode", goodsSellCode);
        return this.getDaGoodsSellModelByCode(map);
    }

    @Override
    public void deleteDaGoodsSellByCode(String tenantCode, String goodsSellCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsSellCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsSellCode", goodsSellCode);
        this.delDaGoodsSellModelByCode(map);
    }
}

