/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mns.dao.MnsMnsconfigMapper;
import com.yqbsoft.laser.service.mns.domain.MnsMnsconfigDomainBean;
import com.yqbsoft.laser.service.mns.model.MnsMnsconfig;
import com.yqbsoft.laser.service.mns.service.MnsconfigService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class MnsconfigServiceImpl
extends BaseServiceImpl
implements MnsconfigService {
    public static final String SYS_CODE = "mns.MNS.MnsconfigServiceImpl";
    private MnsMnsconfigMapper mnsMnsconfigMapper;
    String cache = "Mnsconfig-mnsconfigBustype";

    public void setMnsMnsconfigMapper(MnsMnsconfigMapper mnsMnsconfigMapper) {
        this.mnsMnsconfigMapper = mnsMnsconfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.mnsMnsconfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsconfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMnsconfig(MnsMnsconfigDomainBean mnsMnsconfigDomainBean) {
        if (null == mnsMnsconfigDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setMnsconfigDefault(MnsMnsconfig mnsMnsconfig) {
        if (null == mnsMnsconfig) {
            return;
        }
        if (null == mnsMnsconfig.getDataState()) {
            mnsMnsconfig.setDataState(0);
        }
        if (null == mnsMnsconfig.getGmtCreate()) {
            mnsMnsconfig.setGmtCreate(this.getSysDate());
        }
        mnsMnsconfig.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)mnsMnsconfig.getMnsconfigCode())) {
            int code = this.getMaxCode();
            mnsMnsconfig.setMnsconfigCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.mnsMnsconfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsconfigServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMnsconfigUpdataDefault(MnsMnsconfig mnsMnsconfig) {
        if (null == mnsMnsconfig) {
            return;
        }
        mnsMnsconfig.setGmtModified(this.getSysDate());
    }

    private void saveMnsconfigModel(MnsMnsconfig mnsMnsconfig) throws ApiException {
        if (null == mnsMnsconfig) {
            return;
        }
        try {
            this.mnsMnsconfigMapper.insert(mnsMnsconfig);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsconfigServiceImpl.saveMnsconfigModel.ex", (Throwable)e);
        }
    }

    private MnsMnsconfig getMnsconfigModelById(Integer mnsconfigId) {
        if (null == mnsconfigId) {
            return null;
        }
        try {
            return this.mnsMnsconfigMapper.selectByPrimaryKey(mnsconfigId);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsconfigServiceImpl.getMnsconfigModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMnsconfigModel(Integer mnsconfigId) throws ApiException {
        if (null == mnsconfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnsconfigMapper.deleteByPrimaryKey(mnsconfigId);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsconfigServiceImpl.deleteMnsconfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mns.MNS.MnsconfigServiceImpl.deleteMnsconfigModel.num");
        }
    }

    private void updateMnsconfigModel(MnsMnsconfig mnsMnsconfig) throws ApiException {
        if (null == mnsMnsconfig) {
            return;
        }
        try {
            this.mnsMnsconfigMapper.updateByPrimaryKeySelective(mnsMnsconfig);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsconfigServiceImpl.updateMnsconfigModel.ex", (Throwable)e);
        }
    }

    private void updateStateMnsconfigModel(Integer mnsconfigId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == mnsconfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnsconfigId", mnsconfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mnsMnsconfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsconfigServiceImpl.updateStateMnsconfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mns.MNS.MnsconfigServiceImpl.updateStateMnsconfigModel.null");
        }
    }

    private MnsMnsconfig makeMnsconfig(MnsMnsconfigDomainBean mnsMnsconfigDomainBean, MnsMnsconfig mnsMnsconfig) {
        if (null == mnsMnsconfigDomainBean) {
            return null;
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = new MnsMnsconfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnsconfig, (Object)mnsMnsconfigDomainBean);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsconfigServiceImpl.makeMnsconfig", (Throwable)e);
        }
        return mnsMnsconfig;
    }

    private List<MnsMnsconfig> queryMnsconfigModelPage(Map<String, Object> parammap) {
        try {
            return this.mnsMnsconfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsconfigServiceImpl.queryMnsconfigModel", (Throwable)e);
            return null;
        }
    }

    private int countMnsconfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mnsMnsconfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsconfigServiceImpl.countMnsconfig", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMnsconfig(MnsMnsconfigDomainBean mnsMnsconfigDomainBean) throws ApiException {
        String msg = this.checkMnsconfig(mnsMnsconfigDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnsconfigServiceImpl.saveMnsconfig.checkMnsconfig", msg);
        }
        MnsMnsconfig mnsMnsconfig = this.makeMnsconfig(mnsMnsconfigDomainBean, null);
        this.setMnsconfigDefault(mnsMnsconfig);
        this.saveMnsconfigModel(mnsMnsconfig);
        this.updateCache(mnsMnsconfig);
    }

    @Override
    public void updateMnsconfigState(Integer mnsconfigId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMnsconfigModel(mnsconfigId, dataState, oldDataState);
    }

    @Override
    public void updateMnsconfig(MnsMnsconfigDomainBean mnsMnsconfigDomainBean) throws ApiException {
        String msg = this.checkMnsconfig(mnsMnsconfigDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnsconfigServiceImpl.updateMnsconfig.checkMnsconfig", msg);
        }
        MnsMnsconfig oldMnsMnsconfig = this.getMnsconfigModelById(mnsMnsconfigDomainBean.getMnsconfigId());
        if (null == oldMnsMnsconfig) {
            throw new ApiException("mns.MNS.MnsconfigServiceImpl.updateMnsconfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MnsMnsconfig mnsMnsconfig = this.makeMnsconfig(mnsMnsconfigDomainBean, oldMnsMnsconfig);
        this.setMnsconfigUpdataDefault(mnsMnsconfig);
        this.updateMnsconfigModel(mnsMnsconfig);
        this.updateCache(mnsMnsconfig);
    }

    @Override
    public MnsMnsconfig getMnsconfig(Integer mnsconfigId) {
        return this.getMnsconfigModelById(mnsconfigId);
    }

    @Override
    public void deleteMnsconfig(Integer mnsconfigId) throws ApiException {
        MnsMnsconfig mnsMnsconfig = this.getMnsconfigModelById(mnsconfigId);
        this.deleteMnsconfigModel(mnsconfigId);
        this.delCache(mnsMnsconfig);
    }

    @Override
    public QueryResult<MnsMnsconfig> queryMnsconfigPage(Map<String, Object> map) {
        List<MnsMnsconfig> mnsMnsconfigList = this.queryMnsconfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMnsconfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mnsMnsconfigList);
        return queryResult;
    }

    private int updateMemoModel(Map<String, Object> map) {
        int res = 0;
        try {
            this.mnsMnsconfigMapper.updateMemo(map);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsconfigServiceImpl.updateMemoModel", map);
        }
        return res;
    }

    @Override
    public void updateMemo(Map<String, Object> map) {
        this.updateMemoModel(map);
    }

    private void updateCache(MnsMnsconfig mnsMnsconfig) {
        if (null == mnsMnsconfig) {
            return;
        }
        HashMap<String, String> map = DisUtil.getMapAll((String)this.cache);
        if (null == map) {
            map = new HashMap<String, String>();
        }
        if (StringUtils.isNotBlank((String)mnsMnsconfig.getMnsconfigBustype())) {
            map.put(mnsMnsconfig.getMnsconfigBustype() + "-" + mnsMnsconfig.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)mnsMnsconfig));
        }
        DisUtil.setMap((String)this.cache, map);
    }

    private void delCache(MnsMnsconfig mnsMnsconfig) {
        if (null == mnsMnsconfig) {
            return;
        }
        DisUtil.delMap((String)this.cache, (String[])new String[]{mnsMnsconfig.getMnsconfigBustype() + "-" + mnsMnsconfig.getTenantCode()});
    }

    @Override
    public void queryMnsconfigCache() {
        this.info("mns.MNS.MnsconfigServiceImpl.queryMnsconfigCache.start", "=======queryMnsconfigCache\u8c03\u5ea6start=======");
        List<MnsMnsconfig> mnsMnsconfigList = this.queryMnsconfigModelPage(null);
        if (CollectionUtils.isEmpty(mnsMnsconfigList)) {
            DisUtil.delVer((String)this.cache);
            this.info("mns.MNS.MnsconfigServiceImpl.queryMnsconfigCache.null", "=======queryMnsconfigCache\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (MnsMnsconfig mnsMnsconfig : mnsMnsconfigList) {
            if (StringUtils.isNotBlank((String)mnsMnsconfig.getAppmanageIcode())) {
                map.put(mnsMnsconfig.getMnsconfigBustype() + "-" + mnsMnsconfig.getAppmanageIcode() + "-" + mnsMnsconfig.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)mnsMnsconfig));
                continue;
            }
            if (StringUtils.isBlank((String)mnsMnsconfig.getDataTenant())) {
                map.put(mnsMnsconfig.getMnsconfigBustype() + "-all-" + mnsMnsconfig.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)mnsMnsconfig));
            } else {
                map.put(mnsMnsconfig.getMnsconfigBustype() + "-" + mnsMnsconfig.getDataTenant() + "-" + mnsMnsconfig.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)mnsMnsconfig));
            }
            if (!StringUtils.isNotBlank((String)mnsMnsconfig.getMnsconfigBustype())) continue;
            map.put(mnsMnsconfig.getMnsconfigBustype() + "-" + mnsMnsconfig.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)mnsMnsconfig));
        }
        DisUtil.setMap((String)this.cache, map);
        this.info("mns.MNS.MnsconfigServiceImpl.queryMnsconfigCache.end", "=======queryMnsconfigCache\u8c03\u5ea6end=======");
    }

    @Override
    public String saveMnsconfiginit(String tenantCode) {
        if (null == tenantCode) {
            this.logger.error("mns.MNS.MnsconfigServiceImplsaveMnsconfiginit.tenantCode", (Object)"tenantCode is null");
            return "tenantCode is null";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "00000000");
        MnsMnsconfig mnsMnsconfig = null;
        List<MnsMnsconfig> mnsMnsconfigList = this.queryMnsconfigModelPage(map);
        if (ListUtil.isEmpty(mnsMnsconfigList)) {
            this.logger.error("mns.MNS.MnsconfigServiceImplsaveMnsconfiginit.mnsMnsconfigQueryResult", (Object)"mnsMnsconfigQueryResult is null");
            return "mnsMnsconfigQueryResult is null";
        }
        for (MnsMnsconfig mnsconfig : mnsMnsconfigList) {
            mnsMnsconfig = new MnsMnsconfig();
            try {
                BeanUtils.copyAllPropertys((Object)mnsMnsconfig, (Object)mnsconfig);
                mnsMnsconfig.setMnsconfigId(null);
                mnsMnsconfig.setTenantCode(tenantCode);
                this.saveMnsconfigModel(mnsMnsconfig);
            }
            catch (Exception e) {
                this.logger.error("mns.MNS.MnsconfigServiceImplmnsMnsconfig", (Object)("mnsconfig=" + JsonUtil.buildNormalBinder().toJson((Object)mnsconfig) + "|||" + e));
            }
        }
        return "success";
    }
}

