/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.risk.handler;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mns.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.mns.model.MnsMnsconfig;
import com.yqbsoft.laser.service.mns.risk.MnsRiskContext;
import com.yqbsoft.laser.service.mns.service.MnsconfigService;
import com.yqbsoft.laser.service.mns.service.MnslistService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseMnsRiskHandler
extends BaseServiceImpl {
    protected static final String DEF_TENANT = "00000000";
    @Autowired
    protected MnslistService mnslistService;
    @Autowired
    protected MnsconfigService mnsconfigService;

    public void sendWarningPhoneMsg(String tenantCode) {
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistSource(0);
        mnsMnslistDomainBean.setMnslistSubject("");
        mnsMnslistDomainBean.setMnslistBustype("risk");
        mnsMnslistDomainBean.setMnslistBusname("\u77ed\u4fe1\u98ce\u63a7");
        mnsMnslistDomainBean.setTenantCode(DEF_TENANT);
        mnsMnslistDomainBean.setMnslistExp(this.getMnslistExp(tenantCode));
        this.mnslistService.saveSendMnslist(mnsMnslistDomainBean);
    }

    private String getMnslistExp(String tenantCode) {
        String[] phones;
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        ArrayList listReceiver = new ArrayList();
        HashMap<String, String> mapReceiver = new HashMap<String, String>();
        String phone = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-risk-warningPhone");
        if (StringUtils.isEmpty((String)phone)) {
            this.logger.info("\u9884\u8b66\u624b\u673a\u53f7\u4e3a\u7a7a");
            return null;
        }
        for (String p : phones = phone.split(",")) {
            mapReceiver = new HashMap();
            mapReceiver.put("code", "");
            mapReceiver.put("name", "");
            mapReceiver.put("telphone", p);
            mapReceiver.put("email", p);
            listReceiver.add(mapReceiver);
        }
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
        map.put("theme", "");
        map.put("businessType", "0");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        map.put("paramMap", JsonUtil.buildNormalBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }

    protected boolean closeMnsconfig(String tenantCode, String mnsconfigBustype) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("mnsconfigBusType", mnsconfigBustype);
        map.put("mnschannelType", "0");
        QueryResult<MnsMnsconfig> result = this.mnsconfigService.queryMnsconfigPage(map);
        boolean needSendMsg = false;
        if (result != null && !ListUtil.isEmpty((Collection)result.getList())) {
            for (MnsMnsconfig mnsconfig : result.getList()) {
                if (mnsconfig.getDataState() == 0) continue;
                this.mnsconfigService.updateMnsconfigState(mnsconfig.getMnsconfigId(), 0, mnsconfig.getDataState());
                needSendMsg = true;
            }
        }
        return needSendMsg;
    }

    protected void handlerWarning(String mnsconfigBustype, MnsRiskContext context) {
        Map<String, Object> riskParam = context.getRiskAfterParam();
        if (MapUtil.isEmpty(riskParam)) {
            this.logger.error("MnsFullRiskHandler.riskAfterPolicy", (Object)"RiskAfterParam is null");
            return;
        }
        boolean needSend = false;
        String sendTenantCode = null;
        for (String tenantCode : riskParam.keySet()) {
            boolean flag = this.closeMnsconfig(tenantCode, mnsconfigBustype);
            if (!flag) continue;
            needSend = true;
            sendTenantCode = tenantCode;
        }
        if (needSend) {
            this.sendWarningPhoneMsg(sendTenantCode);
        }
    }
}

