/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmOfflineActivityTripMapper;
import com.yqbsoft.laser.service.pm.domain.PmOfflineActivityTripDomain;
import com.yqbsoft.laser.service.pm.domain.PmOfflineActivityTripReDomain;
import com.yqbsoft.laser.service.pm.model.PmOfflineActivityTrip;
import com.yqbsoft.laser.service.pm.service.PmOfflineActivityTripService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmOfflineActivityTripServiceImpl
extends BaseServiceImpl
implements PmOfflineActivityTripService {
    private static final String SYS_CODE = "pm.PROMOTION.PmOfflineActivityTripServiceImpl";
    private PmOfflineActivityTripMapper pmOfflineActivityTripMapper;

    public void setPmOfflineActivityTripMapper(PmOfflineActivityTripMapper pmOfflineActivityTripMapper) {
        this.pmOfflineActivityTripMapper = pmOfflineActivityTripMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmOfflineActivityTripMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityTripServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOfflineActivityTrip(PmOfflineActivityTripDomain pmOfflineActivityTripDomain) {
        if (null == pmOfflineActivityTripDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmOfflineActivityTripDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOfflineActivityTripDefault(PmOfflineActivityTrip pmOfflineActivityTrip) {
        if (null == pmOfflineActivityTrip) {
            return;
        }
        if (null == pmOfflineActivityTrip.getDataState()) {
            pmOfflineActivityTrip.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmOfflineActivityTrip.getGmtCreate()) {
            pmOfflineActivityTrip.setGmtCreate(date);
        }
        pmOfflineActivityTrip.setGmtModified(date);
        if (StringUtils.isBlank((String)pmOfflineActivityTrip.getTripCode())) {
            pmOfflineActivityTrip.setTripCode(this.getNo(null, "PmOfflineActivityTrip", "pmOfflineActivityTrip", pmOfflineActivityTrip.getTenantCode()));
        }
    }

    private int getOfflineActivityTripMaxCode() {
        int code = 0;
        try {
            return this.pmOfflineActivityTripMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityTripServiceImpl.getOfflineActivityTripMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOfflineActivityTripUpdataDefault(PmOfflineActivityTrip pmOfflineActivityTrip) {
        if (null == pmOfflineActivityTrip) {
            return;
        }
        pmOfflineActivityTrip.setGmtModified(this.getSysDate());
    }

    private void saveOfflineActivityTripModel(PmOfflineActivityTrip pmOfflineActivityTrip) throws ApiException {
        if (null == pmOfflineActivityTrip) {
            return;
        }
        try {
            this.pmOfflineActivityTripMapper.insert(pmOfflineActivityTrip);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.saveOfflineActivityTripModel.ex", (Throwable)e);
        }
    }

    private void saveOfflineActivityTripBatchModel(List<PmOfflineActivityTrip> pmOfflineActivityTripList) throws ApiException {
        if (null == pmOfflineActivityTripList || pmOfflineActivityTripList.isEmpty()) {
            return;
        }
        try {
            this.pmOfflineActivityTripMapper.insertBatch(pmOfflineActivityTripList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.saveOfflineActivityTripBatchModel.ex", (Throwable)e);
        }
    }

    private PmOfflineActivityTrip getOfflineActivityTripModelById(Integer tripId) {
        if (null == tripId) {
            return null;
        }
        try {
            return this.pmOfflineActivityTripMapper.selectByPrimaryKey(tripId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityTripServiceImpl.getOfflineActivityTripModelById", (Throwable)e);
            return null;
        }
    }

    private PmOfflineActivityTrip getOfflineActivityTripModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmOfflineActivityTripMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityTripServiceImpl.getOfflineActivityTripModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOfflineActivityTripModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmOfflineActivityTripMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.delOfflineActivityTripModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.delOfflineActivityTripModelByCode.num");
        }
    }

    private void deleteOfflineActivityTripModel(Integer tripId) throws ApiException {
        if (null == tripId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmOfflineActivityTripMapper.deleteByPrimaryKey(tripId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.deleteOfflineActivityTripModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.deleteOfflineActivityTripModel.num");
        }
    }

    private void updateOfflineActivityTripModel(PmOfflineActivityTrip pmOfflineActivityTrip) throws ApiException {
        if (null == pmOfflineActivityTrip) {
            return;
        }
        int i = 0;
        try {
            i = this.pmOfflineActivityTripMapper.updateByPrimaryKey(pmOfflineActivityTrip);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.updateOfflineActivityTripModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.updateOfflineActivityTripModel.num");
        }
    }

    private void updateStateOfflineActivityTripModel(Integer tripId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == tripId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tripId", tripId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmOfflineActivityTripMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.updateStateOfflineActivityTripModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.updateStateOfflineActivityTripModel.null");
        }
    }

    private void updateStateOfflineActivityTripModelByCode(String tenantCode, String tripCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)tripCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tripCode", tripCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmOfflineActivityTripMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.updateStateOfflineActivityTripModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.updateStateOfflineActivityTripModelByCode.null");
        }
    }

    private PmOfflineActivityTrip makeOfflineActivityTrip(PmOfflineActivityTripDomain pmOfflineActivityTripDomain, PmOfflineActivityTrip pmOfflineActivityTrip) {
        if (null == pmOfflineActivityTripDomain) {
            return null;
        }
        if (null == pmOfflineActivityTrip) {
            pmOfflineActivityTrip = new PmOfflineActivityTrip();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmOfflineActivityTrip, (Object)pmOfflineActivityTripDomain);
            return pmOfflineActivityTrip;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityTripServiceImpl.makeOfflineActivityTrip", (Throwable)e);
            return null;
        }
    }

    private PmOfflineActivityTripReDomain makePmOfflineActivityTripReDomain(PmOfflineActivityTrip pmOfflineActivityTrip) {
        if (null == pmOfflineActivityTrip) {
            return null;
        }
        PmOfflineActivityTripReDomain pmOfflineActivityTripReDomain = new PmOfflineActivityTripReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmOfflineActivityTripReDomain, (Object)pmOfflineActivityTrip);
            return pmOfflineActivityTripReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityTripServiceImpl.makePmOfflineActivityTripReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmOfflineActivityTrip> queryOfflineActivityTripModelPage(Map<String, Object> parammap) {
        try {
            return this.pmOfflineActivityTripMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityTripServiceImpl.queryOfflineActivityTripModel", (Throwable)e);
            return null;
        }
    }

    private int countOfflineActivityTrip(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmOfflineActivityTripMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityTripServiceImpl.countOfflineActivityTrip", (Throwable)e);
        }
        return i;
    }

    private PmOfflineActivityTrip createPmOfflineActivityTrip(PmOfflineActivityTripDomain pmOfflineActivityTripDomain) {
        String msg = this.checkOfflineActivityTrip(pmOfflineActivityTripDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.saveOfflineActivityTrip.checkOfflineActivityTrip", msg);
        }
        PmOfflineActivityTrip pmOfflineActivityTrip = this.makeOfflineActivityTrip(pmOfflineActivityTripDomain, null);
        this.setOfflineActivityTripDefault(pmOfflineActivityTrip);
        return pmOfflineActivityTrip;
    }

    @Override
    public String saveOfflineActivityTrip(PmOfflineActivityTripDomain pmOfflineActivityTripDomain) throws ApiException {
        PmOfflineActivityTrip pmOfflineActivityTrip = this.createPmOfflineActivityTrip(pmOfflineActivityTripDomain);
        this.saveOfflineActivityTripModel(pmOfflineActivityTrip);
        return pmOfflineActivityTrip.getTripCode();
    }

    @Override
    public String saveOfflineActivityTripBatch(List<PmOfflineActivityTripDomain> pmOfflineActivityTripDomainList) throws ApiException {
        if (null == pmOfflineActivityTripDomainList || pmOfflineActivityTripDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmOfflineActivityTrip> pmOfflineActivityTripList = new ArrayList<PmOfflineActivityTrip>();
        String code = "";
        for (PmOfflineActivityTripDomain pmOfflineActivityTripDomain : pmOfflineActivityTripDomainList) {
            PmOfflineActivityTrip pmOfflineActivityTrip = this.createPmOfflineActivityTrip(pmOfflineActivityTripDomain);
            code = pmOfflineActivityTrip.getTripCode();
            pmOfflineActivityTripList.add(pmOfflineActivityTrip);
        }
        this.saveOfflineActivityTripBatchModel(pmOfflineActivityTripList);
        return code;
    }

    @Override
    public void updateOfflineActivityTripState(Integer tripId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == tripId) {
            return;
        }
        this.updateStateOfflineActivityTripModel(tripId, dataState, oldDataState, map);
    }

    @Override
    public void updateOfflineActivityTripStateByCode(String tenantCode, String tripCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tripCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOfflineActivityTripModelByCode(tenantCode, tripCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOfflineActivityTrip(PmOfflineActivityTripDomain pmOfflineActivityTripDomain) throws ApiException {
        String msg = this.checkOfflineActivityTrip(pmOfflineActivityTripDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.updateOfflineActivityTrip.checkOfflineActivityTrip", msg);
        }
        PmOfflineActivityTrip oldPmOfflineActivityTrip = this.getOfflineActivityTripModelById(pmOfflineActivityTripDomain.getTripId());
        if (null == oldPmOfflineActivityTrip) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityTripServiceImpl.updateOfflineActivityTrip.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmOfflineActivityTrip pmOfflineActivityTrip = this.makeOfflineActivityTrip(pmOfflineActivityTripDomain, oldPmOfflineActivityTrip);
        this.setOfflineActivityTripUpdataDefault(pmOfflineActivityTrip);
        this.updateOfflineActivityTripModel(pmOfflineActivityTrip);
    }

    @Override
    public PmOfflineActivityTrip getOfflineActivityTrip(Integer tripId) {
        if (null == tripId) {
            return null;
        }
        return this.getOfflineActivityTripModelById(tripId);
    }

    @Override
    public void deleteOfflineActivityTrip(Integer tripId) throws ApiException {
        if (null == tripId) {
            return;
        }
        this.deleteOfflineActivityTripModel(tripId);
    }

    @Override
    public QueryResult<PmOfflineActivityTrip> queryOfflineActivityTripPage(Map<String, Object> map) {
        List<PmOfflineActivityTrip> pmOfflineActivityTripList = this.queryOfflineActivityTripModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOfflineActivityTrip(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmOfflineActivityTripList);
        return queryResult;
    }

    @Override
    public PmOfflineActivityTrip getOfflineActivityTripByCode(String tenantCode, String tripCode) throws ApiException {
        if (StringUtils.isBlank((String)tripCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tripCode", tripCode);
        return this.getOfflineActivityTripModelByCode(map);
    }

    @Override
    public void deleteOfflineActivityTripByCode(String tenantCode, String tripCode) throws ApiException {
        if (StringUtils.isBlank((String)tripCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tripCode", tripCode);
        this.delOfflineActivityTripModelByCode(map);
    }
}

