/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPromotionDisMapper;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDisDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDisReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotionDis;
import com.yqbsoft.laser.service.pm.service.PmPromotionDisService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionDisServiceImpl
extends BaseServiceImpl
implements PmPromotionDisService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionDisServiceImpl";
    private PmPromotionDisMapper pmPromotionDisMapper;

    public void setPmPromotionDisMapper(PmPromotionDisMapper pmPromotionDisMapper) {
        this.pmPromotionDisMapper = pmPromotionDisMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionDisMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionDisServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotionDis(PmPromotionDisDomain pmPromotionDisDomain) {
        if (null == pmPromotionDisDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionDisDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionDisDefault(PmPromotionDis pmPromotionDis) {
        if (null == pmPromotionDis) {
            return;
        }
        if (null == pmPromotionDis.getDataState()) {
            pmPromotionDis.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmPromotionDis.getGmtCreate()) {
            pmPromotionDis.setGmtCreate(date);
        }
        pmPromotionDis.setGmtModified(date);
        if (StringUtils.isBlank((String)pmPromotionDis.getPpdisCode())) {
            pmPromotionDis.setPpdisCode(this.getNo(null, "PmPromotionDis", "pmPromotionDis", pmPromotionDis.getTenantCode()));
        }
    }

    private int getPromotionDisMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionDisMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionDisServiceImpl.getPromotionDisMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionDisUpdataDefault(PmPromotionDis pmPromotionDis) {
        if (null == pmPromotionDis) {
            return;
        }
        pmPromotionDis.setGmtModified(this.getSysDate());
    }

    private void savePromotionDisModel(PmPromotionDis pmPromotionDis) throws ApiException {
        if (null == pmPromotionDis) {
            return;
        }
        try {
            this.pmPromotionDisMapper.insert(pmPromotionDis);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.savePromotionDisModel.ex", (Throwable)e);
        }
    }

    private void savePromotionDisBatchModel(List<PmPromotionDis> pmPromotionDisList) throws ApiException {
        if (null == pmPromotionDisList || pmPromotionDisList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionDisMapper.insertBatch(pmPromotionDisList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.savePromotionDisBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotionDis getPromotionDisModelById(Integer ppdisId) {
        if (null == ppdisId) {
            return null;
        }
        try {
            return this.pmPromotionDisMapper.selectByPrimaryKey(ppdisId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionDisServiceImpl.getPromotionDisModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotionDis getPromotionDisModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionDisMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionDisServiceImpl.getPromotionDisModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionDisModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionDisMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.delPromotionDisModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.delPromotionDisModelByCode.num");
        }
    }

    private void delPromotionDisModelByPromotionCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionDisMapper.delByPromotionCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.delPromotionDisModelByPromotionCode.ex", (Throwable)e);
        }
    }

    private void deletePromotionDisModel(Integer ppdisId) throws ApiException {
        if (null == ppdisId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionDisMapper.deleteByPrimaryKey(ppdisId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.deletePromotionDisModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.deletePromotionDisModel.num");
        }
    }

    private void updatePromotionDisModel(PmPromotionDis pmPromotionDis) throws ApiException {
        if (null == pmPromotionDis) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionDisMapper.updateByPrimaryKey(pmPromotionDis);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.updatePromotionDisModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.updatePromotionDisModel.num");
        }
    }

    private void updateStatePromotionDisModel(Integer ppdisId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ppdisId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ppdisId", ppdisId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPromotionDisMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.updateStatePromotionDisModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.updateStatePromotionDisModel.null");
        }
    }

    private void updateStatePromotionDisModelByCode(String tenantCode, String ppdisCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ppdisCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppdisCode", ppdisCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPromotionDisMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.updateStatePromotionDisModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.updateStatePromotionDisModelByCode.null");
        }
    }

    private PmPromotionDis makePromotionDis(PmPromotionDisDomain pmPromotionDisDomain, PmPromotionDis pmPromotionDis) {
        if (null == pmPromotionDisDomain) {
            return null;
        }
        if (null == pmPromotionDis) {
            pmPromotionDis = new PmPromotionDis();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionDis, (Object)pmPromotionDisDomain);
            return pmPromotionDis;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionDisServiceImpl.makePromotionDis", (Throwable)e);
            return null;
        }
    }

    private PmPromotionDisReDomain makePmPromotionDisReDomain(PmPromotionDis pmPromotionDis) {
        if (null == pmPromotionDis) {
            return null;
        }
        PmPromotionDisReDomain pmPromotionDisReDomain = new PmPromotionDisReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionDisReDomain, (Object)pmPromotionDis);
            return pmPromotionDisReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionDisServiceImpl.makePmPromotionDisReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotionDis> queryPromotionDisModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionDisMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionDisServiceImpl.queryPromotionDisModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionDis(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionDisMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionDisServiceImpl.countPromotionDis", (Throwable)e);
        }
        return i;
    }

    private PmPromotionDis createPmPromotionDis(PmPromotionDisDomain pmPromotionDisDomain) {
        String msg = this.checkPromotionDis(pmPromotionDisDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.savePromotionDis.checkPromotionDis", msg);
        }
        PmPromotionDis pmPromotionDis = this.makePromotionDis(pmPromotionDisDomain, null);
        this.setPromotionDisDefault(pmPromotionDis);
        return pmPromotionDis;
    }

    @Override
    public String savePromotionDis(PmPromotionDisDomain pmPromotionDisDomain) throws ApiException {
        PmPromotionDis pmPromotionDis = this.createPmPromotionDis(pmPromotionDisDomain);
        this.savePromotionDisModel(pmPromotionDis);
        return pmPromotionDis.getPpdisCode();
    }

    @Override
    public String savePromotionDisBatch(List<PmPromotionDisDomain> pmPromotionDisDomainList) throws ApiException {
        if (null == pmPromotionDisDomainList || pmPromotionDisDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotionDis> pmPromotionDisList = new ArrayList<PmPromotionDis>();
        String code = "";
        for (PmPromotionDisDomain pmPromotionDisDomain : pmPromotionDisDomainList) {
            PmPromotionDis pmPromotionDis = this.createPmPromotionDis(pmPromotionDisDomain);
            code = pmPromotionDis.getPpdisCode();
            pmPromotionDisList.add(pmPromotionDis);
        }
        this.savePromotionDisBatchModel(pmPromotionDisList);
        return code;
    }

    @Override
    public void updatePromotionDisState(Integer ppdisId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatePromotionDisModel(ppdisId, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionDisStateByCode(String tenantCode, String ppdisCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatePromotionDisModelByCode(tenantCode, ppdisCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePromotionDis(PmPromotionDisDomain pmPromotionDisDomain) throws ApiException {
        String msg = this.checkPromotionDis(pmPromotionDisDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.updatePromotionDis.checkPromotionDis", msg);
        }
        PmPromotionDis oldPmPromotionDis = this.getPromotionDisModelById(pmPromotionDisDomain.getPpdisId());
        if (null == oldPmPromotionDis) {
            throw new ApiException("pm.PROMOTION.PmPromotionDisServiceImpl.updatePromotionDis.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotionDis pmPromotionDis = this.makePromotionDis(pmPromotionDisDomain, oldPmPromotionDis);
        this.setPromotionDisUpdataDefault(pmPromotionDis);
        this.updatePromotionDisModel(pmPromotionDis);
    }

    @Override
    public PmPromotionDis getPromotionDis(Integer ppdisId) {
        return this.getPromotionDisModelById(ppdisId);
    }

    @Override
    public void deletePromotionDis(Integer ppdisId) throws ApiException {
        this.deletePromotionDisModel(ppdisId);
    }

    @Override
    public QueryResult<PmPromotionDis> queryPromotionDisPage(Map<String, Object> map) {
        List<PmPromotionDis> pmPromotionDisList = this.queryPromotionDisModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionDis(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionDisList);
        return queryResult;
    }

    @Override
    public PmPromotionDis getPromotionDisByCode(String tenantCode, String ppdisCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppdisCode", ppdisCode);
        return this.getPromotionDisModelByCode(map);
    }

    @Override
    public void deletePromotionDisByCode(String tenantCode, String ppdisCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppdisCode", ppdisCode);
        this.delPromotionDisModelByCode(map);
    }

    @Override
    public void deletePromotionDisByPromotionCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.delPromotionDisModelByPromotionCode(map);
    }
}

