/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmUserOrderMapper;
import com.yqbsoft.laser.service.pm.domain.PmUserOrderDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserOrderReDomain;
import com.yqbsoft.laser.service.pm.model.PmUserOrder;
import com.yqbsoft.laser.service.pm.service.PmUserOrderService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmUserOrderServiceImpl
extends BaseServiceImpl
implements PmUserOrderService {
    private static final String SYS_CODE = "pm.PROMOTION.PmUserOrderServiceImpl";
    private PmUserOrderMapper pmUserOrderMapper;

    public void setPmUserOrderMapper(PmUserOrderMapper pmUserOrderMapper) {
        this.pmUserOrderMapper = pmUserOrderMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmUserOrderMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserOrderServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserOrder(PmUserOrderDomain pmUserOrderDomain) {
        if (null == pmUserOrderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmUserOrderDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserOrderDefault(PmUserOrder pmUserOrder) {
        if (null == pmUserOrder) {
            return;
        }
        if (null == pmUserOrder.getDataState()) {
            pmUserOrder.setDataState(0);
        }
        if (null == pmUserOrder.getGmtCreate()) {
            pmUserOrder.setGmtCreate(this.getSysDate());
        }
        pmUserOrder.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmUserOrder.getUserorderCode())) {
            pmUserOrder.setUserorderCode(this.createUUIDString());
        }
    }

    private int getUserOrderMaxCode() {
        int code = 0;
        try {
            return this.pmUserOrderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserOrderServiceImpl.getUserOrderMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserOrderUpdataDefault(PmUserOrder pmUserOrder) {
        if (null == pmUserOrder) {
            return;
        }
        pmUserOrder.setGmtModified(this.getSysDate());
    }

    private void saveUserOrderModel(PmUserOrder pmUserOrder) throws ApiException {
        if (null == pmUserOrder) {
            return;
        }
        try {
            this.pmUserOrderMapper.insert(pmUserOrder);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.saveUserOrderModel.ex", (Throwable)e);
        }
    }

    private void saveUserOrderBatchModel(List<PmUserOrder> pmUserOrderList) throws ApiException {
        if (null == pmUserOrderList || pmUserOrderList.isEmpty()) {
            return;
        }
        try {
            this.pmUserOrderMapper.insertBatch(pmUserOrderList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.saveUserOrderBatchModel.ex", (Throwable)e);
        }
    }

    private PmUserOrder getUserOrderModelById(Integer userorderId) {
        if (null == userorderId) {
            return null;
        }
        try {
            return this.pmUserOrderMapper.selectByPrimaryKey(userorderId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserOrderServiceImpl.getUserOrderModelById", (Throwable)e);
            return null;
        }
    }

    private PmUserOrder getUserOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmUserOrderMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserOrderServiceImpl.getUserOrderModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserOrderMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.delUserOrderModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.delUserOrderModelByCode.num");
        }
    }

    private void deleteUserOrderModel(Integer userorderId) throws ApiException {
        if (null == userorderId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserOrderMapper.deleteByPrimaryKey(userorderId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.deleteUserOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.deleteUserOrderModel.num");
        }
    }

    private void updateUserOrderModel(PmUserOrder pmUserOrder) throws ApiException {
        if (null == pmUserOrder) {
            return;
        }
        int i = 0;
        try {
            i = this.pmUserOrderMapper.updateByPrimaryKeySelective(pmUserOrder);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.updateUserOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.updateUserOrderModel.num");
        }
    }

    private void updateStateUserOrderModel(Integer userorderId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userorderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userorderId", userorderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmUserOrderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.updateStateUserOrderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.updateStateUserOrderModel.null");
        }
    }

    private void updateStateUserOrderModelByCode(String tenantCode, String userorderCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)userorderCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userorderCode", userorderCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmUserOrderMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.updateStateUserOrderModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.updateStateUserOrderModelByCode.null");
        }
    }

    private PmUserOrder makeUserOrder(PmUserOrderDomain pmUserOrderDomain, PmUserOrder pmUserOrder) {
        if (null == pmUserOrderDomain) {
            return null;
        }
        if (null == pmUserOrder) {
            pmUserOrder = new PmUserOrder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmUserOrder, (Object)pmUserOrderDomain);
            return pmUserOrder;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserOrderServiceImpl.makeUserOrder", (Throwable)e);
            return null;
        }
    }

    private PmUserOrderReDomain makePmUserOrderReDomain(PmUserOrder pmUserOrder) {
        if (null == pmUserOrder) {
            return null;
        }
        PmUserOrderReDomain pmUserOrderReDomain = new PmUserOrderReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmUserOrderReDomain, (Object)pmUserOrder);
            return pmUserOrderReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserOrderServiceImpl.makePmUserOrderReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmUserOrder> queryUserOrderModelPage(Map<String, Object> parammap) {
        try {
            return this.pmUserOrderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserOrderServiceImpl.queryUserOrderModel", (Throwable)e);
            return null;
        }
    }

    private int countUserOrder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmUserOrderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmUserOrderServiceImpl.countUserOrder", (Throwable)e);
        }
        return i;
    }

    private PmUserOrder createPmUserOrder(PmUserOrderDomain pmUserOrderDomain) {
        String msg = this.checkUserOrder(pmUserOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.saveUserOrder.checkUserOrder", msg);
        }
        PmUserOrder pmUserOrder = this.makeUserOrder(pmUserOrderDomain, null);
        this.setUserOrderDefault(pmUserOrder);
        return pmUserOrder;
    }

    @Override
    public String saveUserOrder(PmUserOrderDomain pmUserOrderDomain) throws ApiException {
        PmUserOrder pmUserOrder = this.createPmUserOrder(pmUserOrderDomain);
        this.saveUserOrderModel(pmUserOrder);
        return pmUserOrder.getUserorderCode();
    }

    @Override
    public String saveUserOrderBatch(List<PmUserOrderDomain> pmUserOrderDomainList) throws ApiException {
        if (null == pmUserOrderDomainList || pmUserOrderDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmUserOrder> pmUserOrderList = new ArrayList<PmUserOrder>();
        String code = "";
        for (PmUserOrderDomain pmUserOrderDomain : pmUserOrderDomainList) {
            PmUserOrder pmUserOrder = this.createPmUserOrder(pmUserOrderDomain);
            code = pmUserOrder.getUserorderCode();
            pmUserOrderList.add(pmUserOrder);
        }
        this.saveUserOrderBatchModel(pmUserOrderList);
        return code;
    }

    @Override
    public void updateUserOrderState(Integer userorderId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserOrderModel(userorderId, dataState, oldDataState);
    }

    @Override
    public void updateUserOrderStateByCode(String tenantCode, String userorderCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserOrderModelByCode(tenantCode, userorderCode, dataState, oldDataState);
    }

    @Override
    public void updateUserOrder(PmUserOrderDomain pmUserOrderDomain) throws ApiException {
        String msg = this.checkUserOrder(pmUserOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.updateUserOrder.checkUserOrder", msg);
        }
        PmUserOrder oldPmUserOrder = this.getUserOrderModelById(pmUserOrderDomain.getUserorderId());
        if (null == oldPmUserOrder) {
            throw new ApiException("pm.PROMOTION.PmUserOrderServiceImpl.updateUserOrder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmUserOrder pmUserOrder = this.makeUserOrder(pmUserOrderDomain, oldPmUserOrder);
        this.setUserOrderUpdataDefault(pmUserOrder);
        this.updateUserOrderModel(pmUserOrder);
    }

    @Override
    public PmUserOrder getUserOrder(Integer userorderId) {
        return this.getUserOrderModelById(userorderId);
    }

    @Override
    public void deleteUserOrder(Integer userorderId) throws ApiException {
        this.deleteUserOrderModel(userorderId);
    }

    @Override
    public QueryResult<PmUserOrder> queryUserOrderPage(Map<String, Object> map) {
        List<PmUserOrder> pmUserOrderList = this.queryUserOrderModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserOrder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmUserOrderList);
        return queryResult;
    }

    @Override
    public PmUserOrder getUserOrderByCode(String tenantCode, String userorderCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userorderCode", userorderCode);
        return this.getUserOrderModelByCode(map);
    }

    @Override
    public void deleteUserOrderByCode(String tenantCode, String userorderCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userorderCode", userorderCode);
        this.delUserOrderModelByCode(map);
    }
}

