/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmOfflineActivityMapper;
import com.yqbsoft.laser.service.pm.domain.PmOfflineActivityDomain;
import com.yqbsoft.laser.service.pm.domain.PmOfflineActivityReDomain;
import com.yqbsoft.laser.service.pm.model.PmOfflineActivity;
import com.yqbsoft.laser.service.pm.service.PmOfflineActivityService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmOfflineActivityServiceImpl
extends BaseServiceImpl
implements PmOfflineActivityService {
    private static final String SYS_CODE = "pm.PROMOTION.PmOfflineActivityServiceImpl";
    private PmOfflineActivityMapper pmOfflineActivityMapper;

    public void setPmOfflineActivityMapper(PmOfflineActivityMapper pmOfflineActivityMapper) {
        this.pmOfflineActivityMapper = pmOfflineActivityMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmOfflineActivityMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOfflineActivity(PmOfflineActivityDomain pmOfflineActivityDomain) {
        if (null == pmOfflineActivityDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmOfflineActivityDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOfflineActivityDefault(PmOfflineActivity pmOfflineActivity) {
        if (null == pmOfflineActivity) {
            return;
        }
        if (null == pmOfflineActivity.getDataState()) {
            pmOfflineActivity.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmOfflineActivity.getGmtCreate()) {
            pmOfflineActivity.setGmtCreate(date);
        }
        pmOfflineActivity.setGmtModified(date);
        if (StringUtils.isBlank((String)pmOfflineActivity.getOfflineActivityCode())) {
            pmOfflineActivity.setOfflineActivityCode(this.getNo(null, "PmOfflineActivity", "pmOfflineActivity", pmOfflineActivity.getTenantCode()));
        }
    }

    private int getOfflineActivityMaxCode() {
        int code = 0;
        try {
            return this.pmOfflineActivityMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityServiceImpl.getOfflineActivityMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOfflineActivityUpdataDefault(PmOfflineActivity pmOfflineActivity) {
        if (null == pmOfflineActivity) {
            return;
        }
        pmOfflineActivity.setGmtModified(this.getSysDate());
    }

    private void saveOfflineActivityModel(PmOfflineActivity pmOfflineActivity) throws ApiException {
        if (null == pmOfflineActivity) {
            return;
        }
        try {
            this.pmOfflineActivityMapper.insert(pmOfflineActivity);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.saveOfflineActivityModel.ex", (Throwable)e);
        }
    }

    private void saveOfflineActivityBatchModel(List<PmOfflineActivity> pmOfflineActivityList) throws ApiException {
        if (null == pmOfflineActivityList || pmOfflineActivityList.isEmpty()) {
            return;
        }
        try {
            this.pmOfflineActivityMapper.insertBatch(pmOfflineActivityList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.saveOfflineActivityBatchModel.ex", (Throwable)e);
        }
    }

    private PmOfflineActivity getOfflineActivityModelById(Integer offlineActivityId) {
        if (null == offlineActivityId) {
            return null;
        }
        try {
            return this.pmOfflineActivityMapper.selectByPrimaryKey(offlineActivityId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityServiceImpl.getOfflineActivityModelById", (Throwable)e);
            return null;
        }
    }

    private PmOfflineActivity getOfflineActivityModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmOfflineActivityMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityServiceImpl.getOfflineActivityModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOfflineActivityModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmOfflineActivityMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.delOfflineActivityModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.delOfflineActivityModelByCode.num");
        }
    }

    private void deleteOfflineActivityModel(Integer offlineActivityId) throws ApiException {
        if (null == offlineActivityId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmOfflineActivityMapper.deleteByPrimaryKey(offlineActivityId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.deleteOfflineActivityModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.deleteOfflineActivityModel.num");
        }
    }

    private void updateOfflineActivityModel(PmOfflineActivity pmOfflineActivity) throws ApiException {
        if (null == pmOfflineActivity) {
            return;
        }
        int i = 0;
        try {
            i = this.pmOfflineActivityMapper.updateByPrimaryKey(pmOfflineActivity);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.updateOfflineActivityModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.updateOfflineActivityModel.num");
        }
    }

    private void updateStateOfflineActivityModel(Integer offlineActivityId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == offlineActivityId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("offlineActivityId", offlineActivityId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmOfflineActivityMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.updateStateOfflineActivityModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.updateStateOfflineActivityModel.null");
        }
    }

    private void updateStateOfflineActivityModelByCode(String tenantCode, String offlineActivityCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)offlineActivityCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("offlineActivityCode", offlineActivityCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmOfflineActivityMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.updateStateOfflineActivityModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.updateStateOfflineActivityModelByCode.null");
        }
    }

    private PmOfflineActivity makeOfflineActivity(PmOfflineActivityDomain pmOfflineActivityDomain, PmOfflineActivity pmOfflineActivity) {
        if (null == pmOfflineActivityDomain) {
            return null;
        }
        if (null == pmOfflineActivity) {
            pmOfflineActivity = new PmOfflineActivity();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmOfflineActivity, (Object)pmOfflineActivityDomain);
            return pmOfflineActivity;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityServiceImpl.makeOfflineActivity", (Throwable)e);
            return null;
        }
    }

    private PmOfflineActivityReDomain makePmOfflineActivityReDomain(PmOfflineActivity pmOfflineActivity) {
        if (null == pmOfflineActivity) {
            return null;
        }
        PmOfflineActivityReDomain pmOfflineActivityReDomain = new PmOfflineActivityReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmOfflineActivityReDomain, (Object)pmOfflineActivity);
            return pmOfflineActivityReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityServiceImpl.makePmOfflineActivityReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmOfflineActivity> queryOfflineActivityModelPage(Map<String, Object> parammap) {
        try {
            return this.pmOfflineActivityMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityServiceImpl.queryOfflineActivityModel", (Throwable)e);
            return null;
        }
    }

    private int countOfflineActivity(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmOfflineActivityMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmOfflineActivityServiceImpl.countOfflineActivity", (Throwable)e);
        }
        return i;
    }

    private PmOfflineActivity createPmOfflineActivity(PmOfflineActivityDomain pmOfflineActivityDomain) {
        String msg = this.checkOfflineActivity(pmOfflineActivityDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.saveOfflineActivity.checkOfflineActivity", msg);
        }
        PmOfflineActivity pmOfflineActivity = this.makeOfflineActivity(pmOfflineActivityDomain, null);
        this.setOfflineActivityDefault(pmOfflineActivity);
        return pmOfflineActivity;
    }

    @Override
    public String saveOfflineActivity(PmOfflineActivityDomain pmOfflineActivityDomain) throws ApiException {
        PmOfflineActivity pmOfflineActivity = this.createPmOfflineActivity(pmOfflineActivityDomain);
        this.saveOfflineActivityModel(pmOfflineActivity);
        return pmOfflineActivity.getOfflineActivityCode();
    }

    @Override
    public String saveOfflineActivityBatch(List<PmOfflineActivityDomain> pmOfflineActivityDomainList) throws ApiException {
        if (null == pmOfflineActivityDomainList || pmOfflineActivityDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmOfflineActivity> pmOfflineActivityList = new ArrayList<PmOfflineActivity>();
        String code = "";
        for (PmOfflineActivityDomain pmOfflineActivityDomain : pmOfflineActivityDomainList) {
            PmOfflineActivity pmOfflineActivity = this.createPmOfflineActivity(pmOfflineActivityDomain);
            code = pmOfflineActivity.getOfflineActivityCode();
            pmOfflineActivityList.add(pmOfflineActivity);
        }
        this.saveOfflineActivityBatchModel(pmOfflineActivityList);
        return code;
    }

    @Override
    public void updateOfflineActivityState(Integer offlineActivityId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == offlineActivityId) {
            return;
        }
        this.updateStateOfflineActivityModel(offlineActivityId, dataState, oldDataState, map);
    }

    @Override
    public void updateOfflineActivityStateByCode(String tenantCode, String offlineActivityCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)offlineActivityCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOfflineActivityModelByCode(tenantCode, offlineActivityCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOfflineActivity(PmOfflineActivityDomain pmOfflineActivityDomain) throws ApiException {
        String msg = this.checkOfflineActivity(pmOfflineActivityDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.updateOfflineActivity.checkOfflineActivity", msg);
        }
        PmOfflineActivity oldPmOfflineActivity = this.getOfflineActivityModelById(pmOfflineActivityDomain.getOfflineActivityId());
        if (null == oldPmOfflineActivity) {
            throw new ApiException("pm.PROMOTION.PmOfflineActivityServiceImpl.updateOfflineActivity.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmOfflineActivity pmOfflineActivity = this.makeOfflineActivity(pmOfflineActivityDomain, oldPmOfflineActivity);
        this.setOfflineActivityUpdataDefault(pmOfflineActivity);
        this.updateOfflineActivityModel(pmOfflineActivity);
    }

    @Override
    public PmOfflineActivity getOfflineActivity(Integer offlineActivityId) {
        if (null == offlineActivityId) {
            return null;
        }
        return this.getOfflineActivityModelById(offlineActivityId);
    }

    @Override
    public void deleteOfflineActivity(Integer offlineActivityId) throws ApiException {
        if (null == offlineActivityId) {
            return;
        }
        this.deleteOfflineActivityModel(offlineActivityId);
    }

    @Override
    public QueryResult<PmOfflineActivity> queryOfflineActivityPage(Map<String, Object> map) {
        List<PmOfflineActivity> pmOfflineActivityList = this.queryOfflineActivityModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOfflineActivity(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmOfflineActivityList);
        return queryResult;
    }

    @Override
    public PmOfflineActivity getOfflineActivityByCode(String tenantCode, String offlineActivityCode) throws ApiException {
        if (StringUtils.isBlank((String)offlineActivityCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("offlineActivityCode", offlineActivityCode);
        return this.getOfflineActivityModelByCode(map);
    }

    @Override
    public void deleteOfflineActivityByCode(String tenantCode, String offlineActivityCode) throws ApiException {
        if (StringUtils.isBlank((String)offlineActivityCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("offlineActivityCode", offlineActivityCode);
        this.delOfflineActivityModelByCode(map);
    }
}

