/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPtaskGroupMapper;
import com.yqbsoft.laser.service.pm.domain.PmPtaskGroupDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskGroupReDomain;
import com.yqbsoft.laser.service.pm.model.PmPtaskGroup;
import com.yqbsoft.laser.service.pm.service.PmPtaskGroupService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPtaskGroupServiceImpl
extends BaseServiceImpl
implements PmPtaskGroupService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPtaskGroupServiceImpl";
    private PmPtaskGroupMapper pmPtaskGroupMapper;

    public void setPmPtaskGroupMapper(PmPtaskGroupMapper pmPtaskGroupMapper) {
        this.pmPtaskGroupMapper = pmPtaskGroupMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPtaskGroupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskGroupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtaskGroup(PmPtaskGroupDomain pmPtaskGroupDomain) {
        if (null == pmPtaskGroupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPtaskGroupDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtaskGroupDefault(PmPtaskGroup pmPtaskGroup) {
        if (null == pmPtaskGroup) {
            return;
        }
        if (null == pmPtaskGroup.getDataState()) {
            pmPtaskGroup.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmPtaskGroup.getGmtCreate()) {
            pmPtaskGroup.setGmtCreate(date);
        }
        pmPtaskGroup.setGmtModified(date);
        if (StringUtils.isBlank((String)pmPtaskGroup.getPtaskCode())) {
            pmPtaskGroup.setPtaskCode(this.getNo(null, "PmPtaskGroup", "pmPtaskGroup", pmPtaskGroup.getTenantCode()));
        }
    }

    private int getPtaskGroupMaxCode() {
        int code = 0;
        try {
            return this.pmPtaskGroupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskGroupServiceImpl.getPtaskGroupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtaskGroupUpdataDefault(PmPtaskGroup pmPtaskGroup) {
        if (null == pmPtaskGroup) {
            return;
        }
        pmPtaskGroup.setGmtModified(this.getSysDate());
    }

    private void savePtaskGroupModel(PmPtaskGroup pmPtaskGroup) throws ApiException {
        if (null == pmPtaskGroup) {
            return;
        }
        try {
            this.pmPtaskGroupMapper.insert(pmPtaskGroup);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.savePtaskGroupModel.ex", (Throwable)e);
        }
    }

    private void savePtaskGroupBatchModel(List<PmPtaskGroup> pmPtaskGroupList) throws ApiException {
        if (null == pmPtaskGroupList || pmPtaskGroupList.isEmpty()) {
            return;
        }
        try {
            this.pmPtaskGroupMapper.insertBatch(pmPtaskGroupList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.savePtaskGroupBatchModel.ex", (Throwable)e);
        }
    }

    private PmPtaskGroup getPtaskGroupModelById(Integer ptaskId) {
        if (null == ptaskId) {
            return null;
        }
        try {
            return this.pmPtaskGroupMapper.selectByPrimaryKey(ptaskId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskGroupServiceImpl.getPtaskGroupModelById", (Throwable)e);
            return null;
        }
    }

    private PmPtaskGroup getPtaskGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPtaskGroupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskGroupServiceImpl.getPtaskGroupModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtaskGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskGroupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.delPtaskGroupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.delPtaskGroupModelByCode.num");
        }
    }

    private void deletePtaskGroupModel(Integer ptaskId) throws ApiException {
        if (null == ptaskId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskGroupMapper.deleteByPrimaryKey(ptaskId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.deletePtaskGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.deletePtaskGroupModel.num");
        }
    }

    private void updatePtaskGroupModel(PmPtaskGroup pmPtaskGroup) throws ApiException {
        if (null == pmPtaskGroup) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskGroupMapper.updateByPrimaryKey(pmPtaskGroup);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.updatePtaskGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.updatePtaskGroupModel.num");
        }
    }

    private void updateStatePtaskGroupModel(Integer ptaskId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ptaskId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptaskId", ptaskId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskGroupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.updateStatePtaskGroupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.updateStatePtaskGroupModel.null");
        }
    }

    private void updateStatePtaskGroupModelByCode(String tenantCode, String ptaskCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskCode", ptaskCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskGroupMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.updateStatePtaskGroupModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.updateStatePtaskGroupModelByCode.null");
        }
    }

    private PmPtaskGroup makePtaskGroup(PmPtaskGroupDomain pmPtaskGroupDomain, PmPtaskGroup pmPtaskGroup) {
        if (null == pmPtaskGroupDomain) {
            return null;
        }
        if (null == pmPtaskGroup) {
            pmPtaskGroup = new PmPtaskGroup();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskGroup, (Object)pmPtaskGroupDomain);
            return pmPtaskGroup;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskGroupServiceImpl.makePtaskGroup", (Throwable)e);
            return null;
        }
    }

    private PmPtaskGroupReDomain makePmPtaskGroupReDomain(PmPtaskGroup pmPtaskGroup) {
        if (null == pmPtaskGroup) {
            return null;
        }
        PmPtaskGroupReDomain pmPtaskGroupReDomain = new PmPtaskGroupReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskGroupReDomain, (Object)pmPtaskGroup);
            return pmPtaskGroupReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskGroupServiceImpl.makePmPtaskGroupReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPtaskGroup> queryPtaskGroupModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPtaskGroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskGroupServiceImpl.queryPtaskGroupModel", (Throwable)e);
            return null;
        }
    }

    private int countPtaskGroup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPtaskGroupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskGroupServiceImpl.countPtaskGroup", (Throwable)e);
        }
        return i;
    }

    private PmPtaskGroup createPmPtaskGroup(PmPtaskGroupDomain pmPtaskGroupDomain) {
        String msg = this.checkPtaskGroup(pmPtaskGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.savePtaskGroup.checkPtaskGroup", msg);
        }
        PmPtaskGroup pmPtaskGroup = this.makePtaskGroup(pmPtaskGroupDomain, null);
        this.setPtaskGroupDefault(pmPtaskGroup);
        return pmPtaskGroup;
    }

    @Override
    public String savePtaskGroup(PmPtaskGroupDomain pmPtaskGroupDomain) throws ApiException {
        PmPtaskGroup pmPtaskGroup = this.createPmPtaskGroup(pmPtaskGroupDomain);
        this.savePtaskGroupModel(pmPtaskGroup);
        return pmPtaskGroup.getPtaskCode();
    }

    @Override
    public String savePtaskGroupBatch(List<PmPtaskGroupDomain> pmPtaskGroupDomainList) throws ApiException {
        if (null == pmPtaskGroupDomainList || pmPtaskGroupDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPtaskGroup> pmPtaskGroupList = new ArrayList<PmPtaskGroup>();
        String code = "";
        for (PmPtaskGroupDomain pmPtaskGroupDomain : pmPtaskGroupDomainList) {
            PmPtaskGroup pmPtaskGroup = this.createPmPtaskGroup(pmPtaskGroupDomain);
            code = pmPtaskGroup.getPtaskCode();
            pmPtaskGroupList.add(pmPtaskGroup);
        }
        this.savePtaskGroupBatchModel(pmPtaskGroupList);
        return code;
    }

    @Override
    public void updatePtaskGroupState(Integer ptaskId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ptaskId) {
            return;
        }
        this.updateStatePtaskGroupModel(ptaskId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtaskGroupStateByCode(String tenantCode, String ptaskCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtaskGroupModelByCode(tenantCode, ptaskCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtaskGroup(PmPtaskGroupDomain pmPtaskGroupDomain) throws ApiException {
        String msg = this.checkPtaskGroup(pmPtaskGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.updatePtaskGroup.checkPtaskGroup", msg);
        }
        PmPtaskGroup oldPmPtaskGroup = this.getPtaskGroupModelById(pmPtaskGroupDomain.getPtaskGroupId());
        if (null == oldPmPtaskGroup) {
            throw new ApiException("pm.PROMOTION.PmPtaskGroupServiceImpl.updatePtaskGroup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPtaskGroup pmPtaskGroup = this.makePtaskGroup(pmPtaskGroupDomain, oldPmPtaskGroup);
        this.setPtaskGroupUpdataDefault(pmPtaskGroup);
        this.updatePtaskGroupModel(pmPtaskGroup);
    }

    @Override
    public PmPtaskGroup getPtaskGroup(Integer ptaskId) {
        if (null == ptaskId) {
            return null;
        }
        return this.getPtaskGroupModelById(ptaskId);
    }

    @Override
    public void deletePtaskGroup(Integer ptaskId) throws ApiException {
        if (null == ptaskId) {
            return;
        }
        this.deletePtaskGroupModel(ptaskId);
    }

    @Override
    public QueryResult<PmPtaskGroup> queryPtaskGroupPage(Map<String, Object> map) {
        List<PmPtaskGroup> pmPtaskGroupList = this.queryPtaskGroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtaskGroup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPtaskGroupList);
        return queryResult;
    }

    @Override
    public PmPtaskGroup getPtaskGroupByCode(String tenantCode, String ptaskCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskCode", ptaskCode);
        return this.getPtaskGroupModelByCode(map);
    }

    @Override
    public void deletePtaskGroupByCode(String tenantCode, String ptaskCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskCode", ptaskCode);
        this.delPtaskGroupModelByCode(map);
    }
}

