/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPromotionJobMapper;
import com.yqbsoft.laser.service.pm.domain.PmPromotionJobDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionJobReDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotionJob;
import com.yqbsoft.laser.service.pm.service.PmPromotionJobService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionJobServiceImpl
extends BaseServiceImpl
implements PmPromotionJobService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPromotionJobServiceImpl";
    private PmPromotionJobMapper pmPromotionJobMapper;

    public void setPmPromotionJobMapper(PmPromotionJobMapper pmPromotionJobMapper) {
        this.pmPromotionJobMapper = pmPromotionJobMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionJobMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionJobServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotionJob(PmPromotionJobDomain pmPromotionJobDomain) {
        if (null == pmPromotionJobDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionJobDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionJobDefault(PmPromotionJob pmPromotionJob) {
        if (null == pmPromotionJob) {
            return;
        }
        if (null == pmPromotionJob.getDataState()) {
            pmPromotionJob.setDataState(0);
        }
        if (null == pmPromotionJob.getGmtCreate()) {
            pmPromotionJob.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)pmPromotionJob.getPjobCode())) {
            pmPromotionJob.setPjobCode(this.createUUIDString());
        }
    }

    private int getPromotionJobMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionJobMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionJobServiceImpl.getPromotionJobMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionJobUpdataDefault(PmPromotionJob pmPromotionJob) {
        if (null == pmPromotionJob) {
            return;
        }
    }

    private void savePromotionJobModel(PmPromotionJob pmPromotionJob) throws ApiException {
        if (null == pmPromotionJob) {
            return;
        }
        try {
            this.pmPromotionJobMapper.insert(pmPromotionJob);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.savePromotionJobModel.ex", (Throwable)e);
        }
    }

    private void savePromotionJobBatchModel(List<PmPromotionJob> pmPromotionJobList) throws ApiException {
        if (null == pmPromotionJobList || pmPromotionJobList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionJobMapper.insertBatch(pmPromotionJobList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.savePromotionJobBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotionJob getPromotionJobModelById(Integer pjobId) {
        if (null == pjobId) {
            return null;
        }
        try {
            return this.pmPromotionJobMapper.selectByPrimaryKey(pjobId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionJobServiceImpl.getPromotionJobModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotionJob getPromotionJobModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionJobMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionJobServiceImpl.getPromotionJobModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionJobModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionJobMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.delPromotionJobModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.delPromotionJobModelByCode.num");
        }
    }

    private void deletePromotionJobModel(Integer pjobId) throws ApiException {
        if (null == pjobId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionJobMapper.deleteByPrimaryKey(pjobId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.deletePromotionJobModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.deletePromotionJobModel.num");
        }
    }

    private void updatePromotionJobModel(PmPromotionJob pmPromotionJob) throws ApiException {
        if (null == pmPromotionJob) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionJobMapper.updateByPrimaryKeySelective(pmPromotionJob);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.updatePromotionJobModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.updatePromotionJobModel.num");
        }
    }

    private void updateStatePromotionJobModel(Integer pjobId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == pjobId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pjobId", pjobId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionJobMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.updateStatePromotionJobModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.updateStatePromotionJobModel.null");
        }
    }

    private void updateStatePromotionJobModelByCode(String tenantCode, String pjobCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)pjobCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pjobCode", pjobCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionJobMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.updateStatePromotionJobModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.updateStatePromotionJobModelByCode.null");
        }
    }

    private PmPromotionJob makePromotionJob(PmPromotionJobDomain pmPromotionJobDomain, PmPromotionJob pmPromotionJob) {
        if (null == pmPromotionJobDomain) {
            return null;
        }
        if (null == pmPromotionJob) {
            pmPromotionJob = new PmPromotionJob();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionJob, (Object)pmPromotionJobDomain);
            return pmPromotionJob;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionJobServiceImpl.makePromotionJob", (Throwable)e);
            return null;
        }
    }

    private PmPromotionJobReDomain makePmPromotionJobReDomain(PmPromotionJob pmPromotionJob) {
        if (null == pmPromotionJob) {
            return null;
        }
        PmPromotionJobReDomain pmPromotionJobReDomain = new PmPromotionJobReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionJobReDomain, (Object)pmPromotionJob);
            return pmPromotionJobReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionJobServiceImpl.makePmPromotionJobReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotionJob> queryPromotionJobModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionJobMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionJobServiceImpl.queryPromotionJobModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionJob(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionJobMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPromotionJobServiceImpl.countPromotionJob", (Throwable)e);
        }
        return i;
    }

    private PmPromotionJob createPmPromotionJob(PmPromotionJobDomain pmPromotionJobDomain) {
        String msg = this.checkPromotionJob(pmPromotionJobDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.savePromotionJob.checkPromotionJob", msg);
        }
        PmPromotionJob pmPromotionJob = this.makePromotionJob(pmPromotionJobDomain, null);
        this.setPromotionJobDefault(pmPromotionJob);
        return pmPromotionJob;
    }

    @Override
    public String savePromotionJob(PmPromotionJobDomain pmPromotionJobDomain) throws ApiException {
        PmPromotionJob pmPromotionJob = this.createPmPromotionJob(pmPromotionJobDomain);
        this.savePromotionJobModel(pmPromotionJob);
        return pmPromotionJob.getPjobCode();
    }

    @Override
    public String savePromotionJobBatch(List<PmPromotionJobDomain> pmPromotionJobDomainList) throws ApiException {
        if (null == pmPromotionJobDomainList || pmPromotionJobDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotionJob> pmPromotionJobList = new ArrayList<PmPromotionJob>();
        String code = "";
        for (PmPromotionJobDomain pmPromotionJobDomain : pmPromotionJobDomainList) {
            PmPromotionJob pmPromotionJob = this.createPmPromotionJob(pmPromotionJobDomain);
            code = pmPromotionJob.getPjobCode();
            pmPromotionJobList.add(pmPromotionJob);
        }
        this.savePromotionJobBatchModel(pmPromotionJobList);
        return code;
    }

    @Override
    public void updatePromotionJobState(Integer pjobId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionJobModel(pjobId, dataState, oldDataState);
    }

    @Override
    public void updatePromotionJobStateByCode(String tenantCode, String pjobCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionJobModelByCode(tenantCode, pjobCode, dataState, oldDataState);
    }

    @Override
    public void updatePromotionJob(PmPromotionJobDomain pmPromotionJobDomain) throws ApiException {
        String msg = this.checkPromotionJob(pmPromotionJobDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.updatePromotionJob.checkPromotionJob", msg);
        }
        PmPromotionJob oldPmPromotionJob = this.getPromotionJobModelById(pmPromotionJobDomain.getPjobId());
        if (null == oldPmPromotionJob) {
            throw new ApiException("pm.PROMOTION.PmPromotionJobServiceImpl.updatePromotionJob.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotionJob pmPromotionJob = this.makePromotionJob(pmPromotionJobDomain, oldPmPromotionJob);
        this.setPromotionJobUpdataDefault(pmPromotionJob);
        this.updatePromotionJobModel(pmPromotionJob);
    }

    @Override
    public PmPromotionJob getPromotionJob(Integer pjobId) {
        return this.getPromotionJobModelById(pjobId);
    }

    @Override
    public void deletePromotionJob(Integer pjobId) throws ApiException {
        this.deletePromotionJobModel(pjobId);
    }

    @Override
    public QueryResult<PmPromotionJob> queryPromotionJobPage(Map<String, Object> map) {
        List<PmPromotionJob> pmPromotionJobList = this.queryPromotionJobModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPromotionJob(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionJobList);
        return queryResult;
    }

    @Override
    public PmPromotionJob getPromotionJobByCode(String tenantCode, String pjobCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pjobCode", pjobCode);
        return this.getPromotionJobModelByCode(map);
    }

    @Override
    public void deletePromotionJobByCode(String tenantCode, String pjobCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pjobCode", pjobCode);
        this.delPromotionJobModelByCode(map);
    }
}

